/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.mm.planning.RequirementTypeFactory;
import com.kingdee.eas.mm.planning.client.AbstractRequirementPlanHisFilterUI;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class RequirementPlanHisFilterUI
extends AbstractRequirementPlanHisFilterUI {
    private static final String REQPLAN_RESOURCE_FULLNAME = "com.kingdee.eas.mm.planning.client.RequirementPlanResource";
    private static final Logger logger = CoreUIObject.getLogger(RequirementPlanHisFilterUI.class);
    private boolean isLoadingData = false;
    private SelectorItemCollection numberSelector = new SelectorItemCollection();

    public void onLoad() throws Exception {
        super.onLoad();
        UISettingFactory uiSetting = UISettingFactory.getInstance();
        uiSetting.displayTrackName((CoreUIObject)this);
        this.prmtPlannerFrom.setEnabledMultiSelection(true);
    }

    public RequirementPlanHisFilterUI() throws Exception {
        MMUtils.filterRangF7Helper((Component)this.fldMStart, (Component)this.fldMEnd);
        MMUtils.filterRangF7Helper((Component)this.prmtProductionDeptFrom, (Component)this.prmtProductionDeptTo);
        this.numberSelector.add(new SelectorItemInfo("number"));
        this.numberSelector.add(new SelectorItemInfo("name"));
        this.fldSU.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageItemQuery");
        this.fldSU.setDisplayFormat("$name$");
        this.fldSU.setEditFormat("$number$");
        this.fldSU.setCommitFormat("$number$");
        this.fldSU.setEnabledMultiSelection(false);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.fldSU, (OrgType)OrgType.Storage, (String)"mm_reqplanhis_view");
        this.fldReqType.setQueryInfo("com.kingdee.eas.mm.planning.app.F7RequirementTypeQuery");
        this.fldReqType.setDisplayFormat("$number$");
        this.fldReqType.setEditFormat("$number$");
        this.fldReqType.setCommitFormat("$number$");
        this.fldMGroup.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
        this.fldMGroup.setDisplayFormat("$name$");
        this.fldMGroup.setEditFormat("$number$");
        this.fldMGroup.setCommitFormat("$number$");
        this.fldMStart.setQueryInfo("com.kingdee.eas.mm.planning.app.F7MaterialQuery");
        this.fldMStart.setDisplayFormat("$name$");
        this.fldMStart.setEditFormat("$number$");
        this.fldMStart.setCommitFormat("$number$");
        this.fldMEnd.setQueryInfo("com.kingdee.eas.mm.planning.app.F7MaterialQuery");
        this.fldMEnd.setDisplayFormat("$name$");
        this.fldMEnd.setEditFormat("$number$");
        this.fldMEnd.setCommitFormat("$number$");
        this.initDefaultQuerySolution();
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.fldSU, (KDBizPromptBox)this.prmtTrackNumber);
        this.prmtProjectNumber.setEnabledMultiSelection(true);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumber);
        this.prmtProjectNumber.setEditFormat("$number$");
        this.prmtProjectNumber.setDisplayFormat("$number$");
        this.prmtProjectNumber.setCommitFormat("$number$");
        this.prmtTrackNumber.setEnabledMultiSelection(true);
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cu.getId().toString(), CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        this.prmtPlannerFrom.setEntityViewInfo(viewInfo);
        this.prmtPlannerFrom.setEditFormat("$number$");
        this.prmtPlannerFrom.setDisplayFormat("$name$");
        this.prmtPlannerFrom.setCommitFormat("$number$");
        this.prmtProductionDeptFrom.setEditFormat("$number$");
        this.prmtProductionDeptFrom.setDisplayFormat("$name$");
        this.prmtProductionDeptFrom.setCommitFormat("$number$");
        this.prmtProductionDeptTo.setEditFormat("$number$");
        this.prmtProductionDeptTo.setDisplayFormat("$name$");
        this.prmtProductionDeptTo.setCommitFormat("$number$");
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.isLoadingData = true;
        this.fldSU.setValue(null);
        this.fldReqType.setValue(null);
        this.fldMGroup.setValue(null);
        this.fldMStart.setValue(null);
        this.fldMEnd.setValue(null);
        this.fldDateStart.setValue(null);
        this.fldDateEnd.setValue(null);
        this.prmtPlannerFrom.setValue(null);
        this.prmtProductionDeptFrom.setValue(null);
        this.prmtProductionDeptTo.setValue(null);
        this.prmtProjectNumber.setValue(null);
        if (entityViewInfo.getFilter() == null) {
            this.isLoadingData = false;
            return;
        }
        FilterItemCollection filter = entityViewInfo.getFilter().getFilterItems();
        try {
            for (int i = 0; i < filter.size(); ++i) {
                IMaterial svc;
                FilterItemInfo item = filter.get(i);
                String itemKey = item.getPropertyName();
                if (itemKey.equalsIgnoreCase("storageOrgUnit.id")) {
                    this.loadControlFromFilter(this.fldSU, (IDataBase)StorageOrgUnitFactory.getRemoteInstance(), item.getString("compareValue"));
                    continue;
                }
                if (itemKey.equalsIgnoreCase("reqType.id")) {
                    this.loadControlFromFilter(this.fldReqType, RequirementTypeFactory.getRemoteInstance(), item.getString("compareValue"));
                    continue;
                }
                if (itemKey.equalsIgnoreCase("materialGroup.id")) {
                    this.loadControlFromFilter(this.fldMGroup, (IDataBase)MaterialGroupFactory.getRemoteInstance(), item.getString("compareValue"));
                    continue;
                }
                if (itemKey.equalsIgnoreCase("trackNumber.id")) {
                    this.loadControlFromFilter(this.prmtTrackNumber, (IDataBase)TrackNumberFactory.getRemoteInstance(), item.getString("compareValue"));
                    continue;
                }
                if (itemKey.equalsIgnoreCase("material.number")) {
                    svc = MaterialFactory.getRemoteInstance();
                    String mId = item.getString("compareValue");
                    mId = mId.split("\\|")[1];
                    if (item.getString("compareType").equals(CompareType.GREATER_EQUALS.getName())) {
                        this.fldMStart.setValue((Object)svc.getValue((IObjectPK)new ObjectUuidPK(mId), this.numberSelector));
                        continue;
                    }
                    this.fldMEnd.setValue((Object)svc.getValue((IObjectPK)new ObjectUuidPK(mId), this.numberSelector));
                    continue;
                }
                if (itemKey.equalsIgnoreCase("requireDate")) {
                    if (item.getString("compareType").equals(CompareType.GREATER_EQUALS.getName())) {
                        this.fldDateStart.setValue((Object)((Date)item.get("compareValue")));
                        continue;
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)item.get("compareValue"));
                    calendar.add(5, -1);
                    this.fldDateEnd.setValue((Object)calendar.getTime());
                    continue;
                }
                if (itemKey.equalsIgnoreCase("planner.id")) {
                    this.loadControlFromFilter(this.prmtPlannerFrom, (IDataBase)PersonFactory.getRemoteInstance(), item.getString("compareValue"));
                    continue;
                }
                if (itemKey.equalsIgnoreCase("productionDept.number")) {
                    svc = AdminOrgUnitFactory.getRemoteInstance();
                    String sId = item.getString("compareValue");
                    sId = sId.split("\\|")[1];
                    if (item.getString("compareType").equals(CompareType.GREATER_EQUALS.getName())) {
                        this.prmtProductionDeptFrom.setValue((Object)svc.getValue((IObjectPK)new ObjectUuidPK(sId), this.numberSelector));
                        continue;
                    }
                    this.prmtProductionDeptTo.setValue((Object)svc.getValue((IObjectPK)new ObjectUuidPK(sId), this.numberSelector));
                    continue;
                }
                if (!itemKey.equalsIgnoreCase("project.id")) continue;
                this.loadControlFromFilter(this.prmtProjectNumber, (IDataBase)ProjectFactory.getRemoteInstance(), item.getString("compareValue"));
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        this.isLoadingData = false;
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo.getFilterItems().clear();
        try {
            FilterInfo filter = this.getFilterInfoFromControl(this.fldSU, "storageOrgUnit.id");
            this.filterInfo.mergeFilter(filter, "AND");
            filter = this.getFilterInfoFromControl(this.fldReqType, "reqType.id");
            this.filterInfo.mergeFilter(filter, "AND");
            filter = this.getFilterInfoFromControl(this.fldMGroup, "materialGroup.id");
            this.filterInfo.mergeFilter(filter, "AND");
            filter = this.getFilterInfoFromControl(this.prmtTrackNumber, "trackNumber.id");
            this.filterInfo.mergeFilter(filter, "AND");
            filter = this.getFilterInfoFromControl(this.prmtProjectNumber, "project.id");
            this.filterInfo.mergeFilter(filter, "AND");
            filter = this.getFilterInfoFromControl(this.prmtPlannerFrom, "planner.id");
            this.filterInfo.mergeFilter(filter, "AND");
            Object value = this.fldMStart.getValue();
            if (value != null) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)(((DataBaseInfo)value).getNumber() + "|" + ((DataBaseInfo)value).getId().toString()), CompareType.GREATER_EQUALS));
                this.filterInfo.mergeFilter(filter, "AND");
            }
            if ((value = this.fldMEnd.getValue()) != null) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)(((DataBaseInfo)value).getNumber() + "|" + ((DataBaseInfo)value).getId().toString()), CompareType.LESS_EQUALS));
                this.filterInfo.mergeFilter(filter, "AND");
            }
            if ((value = this.prmtProductionDeptFrom.getValue()) != null) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("productionDept.number", (Object)(((DataBaseInfo)value).getNumber() + "|" + ((DataBaseInfo)value).getId().toString()), CompareType.GREATER_EQUALS));
                this.filterInfo.mergeFilter(filter, "AND");
            }
            if ((value = this.prmtProductionDeptTo.getValue()) != null) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("productionDept.number", (Object)(((DataBaseInfo)value).getNumber() + "|" + ((DataBaseInfo)value).getId().toString()), CompareType.LESS_EQUALS));
                this.filterInfo.mergeFilter(filter, "AND");
            }
            if ((value = this.fldDateStart.getValue()) != null) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("requireDate", value, CompareType.GREATER_EQUALS));
                this.filterInfo.mergeFilter(filter, "AND");
            }
            if ((value = this.fldDateEnd.getValue()) != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)value);
                calendar.add(5, 1);
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("requireDate", (Object)calendar.getTime(), CompareType.LESS));
                this.filterInfo.mergeFilter(filter, "AND");
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        return this.filterInfo;
    }

    public void initDefaultQuerySolution() {
        this.isLoadingData = true;
        this.fldSU.setValue(null);
        this.fldReqType.setValue(null);
        this.fldMGroup.setValue(null);
        this.fldMStart.setValue(null);
        this.fldMEnd.setValue(null);
        this.fldDateStart.setValue(null);
        this.fldDateEnd.setValue(null);
        this.prmtTrackNumber.setValue(null);
        this.prmtPlannerFrom.setValue(null);
        this.prmtProductionDeptFrom.setValue(null);
        this.prmtProductionDeptTo.setValue(null);
        this.prmtProjectNumber.setValue(null);
        this.fldSU.setValue((Object)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_reqplanhis_view"));
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        this.fldDateEnd.setValue((Object)calendar.getTime());
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        this.fldDateStart.setValue((Object)calendar.getTime());
        this.isLoadingData = false;
    }

    public void clear() {
        this.initDefaultQuerySolution();
    }

    @Override
    protected void fldMGroup_dataChanged(DataChangeEvent e) throws Exception {
        this.initFilters();
    }

    @Override
    protected void fldSU_dataChanged(DataChangeEvent e) throws Exception {
        this.initFilters();
    }

    @Override
    protected void fldMEnd_willShow(SelectorEvent e) throws Exception {
        this.forceInitFilters();
    }

    @Override
    protected void fldMStart_willShow(SelectorEvent e) throws Exception {
        this.forceInitFilters();
    }

    private void loadControlFromFilter(KDBizPromptBox control, IDataBase svc, String ids) throws Exception {
        ids = ids.substring(1, ids.length() - 1).replaceAll(" ", "").replaceAll(",", "','");
        control.setValue((Object)svc.getCollection("select id,name,number where id in ('" + ids + "')").toArray());
    }

    private FilterInfo getFilterInfoFromControl(KDBizPromptBox control, String fieldName) {
        Object value = control.getValue();
        FilterInfo filter = new FilterInfo();
        if (value != null) {
            Object[] objectArray;
            if (value instanceof DataBaseInfo) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = value;
            } else {
                objectArray = (Object[])value;
            }
            Object[] arrValues = objectArray;
            StringBuffer arr = new StringBuffer();
            for (int i = 0; i < arrValues.length; ++i) {
                if (arrValues[i] == null) continue;
                if (arr.length() > 0) {
                    arr.append(", ");
                }
                arr.append("'").append(((DataBaseInfo)arrValues[i]).getId().toString()).append("'");
            }
            if (arr.length() > 0) {
                filter.getFilterItems().add(new FilterItemInfo(fieldName, (Object)arr.toString(), CompareType.INNER));
            }
        }
        return filter;
    }

    public boolean verify() {
        Date d1 = (Date)this.fldDateStart.getValue();
        Date d2 = (Date)this.fldDateEnd.getValue();
        if (this.fldSU.getText() == null || this.fldSU.getText().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"StorageOrgUnit_NotNull"));
            return false;
        }
        if (d1 != null && d2 != null && d1.after(d2)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"ReqDateRangeError"));
            return false;
        }
        return true;
    }

    private void forceInitFilters() throws Exception {
        this.isLoadingData = true;
        this.fldMGroup.commitEdit();
        this.fldSU.commitEdit();
        this.initFilters();
        this.isLoadingData = false;
    }

    private void initFilters() {
        FilterInfo fiSU = null;
        fiSU = this.getFilterInfoFromControl(this.fldSU, "storageOrgUnit.id");
        FilterInfo fiMG = this.getFilterInfoFromControl(this.fldMGroup, "MaterialGroup.id");
        EntityViewInfo vi = new EntityViewInfo();
        try {
            FilterInfo fi = new FilterInfo();
            fi.mergeFilter(fiSU, "AND");
            fi.mergeFilter(fiMG, "AND");
            vi.setFilter(fi);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        this.fldMStart.setEntityViewInfo(vi);
        this.fldMEnd.setEntityViewInfo(vi);
        if (this.isLoadingData) {
            return;
        }
        this.fldMStart.setValue(null);
        this.fldMEnd.setValue(null);
    }
}

