/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.mm.planning.IRequirementPlanHis;
import com.kingdee.eas.mm.planning.RequirementPlanHisFactory;
import com.kingdee.eas.mm.planning.client.AbstractRequirementPlanHisRemoveUI;
import com.kingdee.eas.mm.planning.client.RequirementPlanHisFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class RequirementPlanHisRemoveUI
extends AbstractRequirementPlanHisRemoveUI {
    private static final String REQPLAN_RESOURCE_FULLNAME = "com.kingdee.eas.mm.planning.client.RequirementPlanResource";
    private static final Logger logger = CoreUIObject.getLogger(RequirementPlanHisRemoveUI.class);
    private int numOfMonthsAgoAllowedRemoving = 6;
    private RequirementPlanHisFilterUI filterUI = null;

    public RequirementPlanHisRemoveUI() throws Exception {
        try {
            this.filterUI = new RequirementPlanHisFilterUI();
            this.filterUI.fldSU.setEnabledMultiSelection(false);
            this.add((Component)((Object)this.filterUI), null);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public String getUITitle() {
        return EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"RmvReqHisWndTitle");
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.filterUI.initUIContentLayout();
        this.filterUI.setBounds(new Rectangle(0, 0, 480, 235));
        this.filterUI.fldDateStart.setValue(null);
        Date d = new Date();
        d.setHours(0);
        d.setMinutes(0);
        d.setSeconds(0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(2, -this.numOfMonthsAgoAllowedRemoving);
        this.filterUI.fldDateEnd.setValue((Object)calendar.getTime());
        this.filterUI.fldSU.setEnabledMultiSelection(false);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.filterUI.fldSU, (OrgType)OrgType.Storage, (String)"mm_reqplanhis_remove");
        this.filterUI.fldSU.setEnabledMultiSelection(false);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        String[] suIDs = null;
        String[] reqTypeIDs = null;
        String[] mGroupIDs = null;
        String mStartID = null;
        String mEndID = null;
        Date dateStart = null;
        Date dateEnd = null;
        Object fromPlannerNumber = null;
        Object toPlannerNumber = null;
        String fromDeptNumber = null;
        String toDeptNumber = null;
        String[] traceNumber = null;
        String[] planner = null;
        if (this.filterUI.fldSU.getValue() == null) {
            MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}{1}");
            MsgBox.showInfo((String)format.format(new Object[]{this.filterUI.kDLabelContainer1.getBoundLabelText(), EASResource.getString((String)"com.kingdee.eas.mm.planning.CentralPurReqPlanResource.NOT_NULL")}));
            return;
        }
        suIDs = this.getIDsFromControl(this.filterUI.fldSU);
        if (suIDs == null) {
            FilterInfo storageOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"storageOrgUnit.id", (String)"mm_reqplanhis_remove");
            Object[] ids = ((HashSet)storageOrgFilter.getFilterItems().get(0).getCompareValue()).toArray();
            suIDs = new String[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                suIDs[i] = (String)ids[i];
            }
        }
        reqTypeIDs = this.getIDsFromControl(this.filterUI.fldReqType);
        mGroupIDs = this.getIDsFromControl(this.filterUI.fldMGroup);
        Object v = this.filterUI.fldMStart.getValue();
        if (v != null) {
            mStartID = ((DataBaseInfo)v).getNumber();
        }
        if ((v = this.filterUI.fldMEnd.getValue()) != null) {
            mEndID = ((DataBaseInfo)v).getNumber();
        }
        if ((v = this.filterUI.fldDateStart.getValue()) != null) {
            dateStart = (Date)v;
        }
        if ((v = this.filterUI.fldDateEnd.getValue()) != null) {
            dateEnd = (Date)v;
        }
        Object plannerFrom = this.filterUI.prmtPlannerFrom.getValue();
        Object deptFrom = this.filterUI.prmtProductionDeptFrom.getValue();
        Object deptTo = this.filterUI.prmtProductionDeptTo.getValue();
        Object trackNumber = this.filterUI.prmtTrackNumber.getValue();
        if (plannerFrom != null) {
            planner = this.getIDsFromControl(this.filterUI.prmtPlannerFrom);
        }
        if (deptFrom != null) {
            fromDeptNumber = ((DataBaseInfo)deptFrom).getNumber();
        }
        if (deptTo != null) {
            toDeptNumber = ((DataBaseInfo)deptTo).getNumber();
        }
        if (trackNumber != null) {
            traceNumber = this.getIDsFromControl(this.filterUI.prmtTrackNumber);
        }
        int numOfDaysAgoAllowedRemoving = 0;
        IParamControl svc = ParamControlFactory.getRemoteInstance();
        for (int i = 0; i < suIDs.length; ++i) {
            try {
                int tmp;
                ParamItemInfo pm = svc.getParamItemByNumberAndOrg("MinReqPlanHisLen", suIDs[i]);
                if (pm == null || pm.getValue() == null || (tmp = new Integer(pm.getValue()).intValue()) <= numOfDaysAgoAllowedRemoving) continue;
                numOfDaysAgoAllowedRemoving = tmp;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -numOfDaysAgoAllowedRemoving);
        Date dLatest = calendar.getTime();
        if (dateEnd == null || dateEnd.after(dLatest)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"RmvReqHisErrorPrompt").replaceAll("%1", "" + numOfDaysAgoAllowedRemoving));
            return;
        }
        Date d1 = (Date)this.filterUI.fldDateStart.getValue();
        Date d2 = (Date)this.filterUI.fldDateEnd.getValue();
        if (d1 != null && d2 != null && d1.after(d2)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"ReqDateRangeError"));
            return;
        }
        try {
            IRequirementPlanHis svc2 = RequirementPlanHisFactory.getRemoteInstance();
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put("storageOrgUnitIds", suIDs);
            filterMap.put("reqTypeIds", reqTypeIDs);
            filterMap.put("planner", planner);
            filterMap.put("fromDeptNumber", fromDeptNumber);
            filterMap.put("toDeptNumber", toDeptNumber);
            filterMap.put("traceNumber", traceNumber);
            filterMap.put("mGroupIds", mGroupIDs);
            filterMap.put("mStartId", mStartID);
            filterMap.put("mEndId", mEndID);
            filterMap.put("dateStart", dateStart);
            filterMap.put("dateEnd", dateEnd);
            int count = svc2.removeHistory(filterMap);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"RmvReqHisSuccessPrompt").replaceAll("%1", "" + count));
            this.setUserObject(Boolean.TRUE);
            this.destroyWindow();
        }
        catch (Exception t) {
            this.handleException(t);
        }
    }

    private String[] getIDsFromControl(KDBizPromptBox control) {
        Object v = control.getValue();
        if (v == null) {
            return null;
        }
        if (v instanceof DataBaseInfo) {
            return new String[]{((DataBaseInfo)v).getId().toString()};
        }
        Object[] vs = (Object[])v;
        if (vs.length == 0) {
            return null;
        }
        String[] ids = new String[vs.length];
        if (vs[0] == null) {
            return null;
        }
        for (int i = 0; i < vs.length; ++i) {
            if (vs[i] == null) continue;
            ids[i] = ((DataBaseInfo)vs[i]).getId().toString();
        }
        return ids;
    }
}

