/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.mm.planning.ReqPlanStatusEnum;
import com.kingdee.eas.mm.planning.ReqplanTotalFacadeFactory;
import com.kingdee.eas.mm.planning.RequireSourceEnum;
import com.kingdee.eas.mm.planning.client.AbstractRequirementPlanQueryUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class RequirementPlanQueryUI
extends AbstractRequirementPlanQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(RequirementPlanQueryUI.class);
    private static final String REQPLAN_RESOURCE_FULLNAME = "com.kingdee.eas.mm.planning.client.RequirementPlanResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmptMaterial.setEnabledMultiSelection(true);
        this.kdsWeekShowDays.setNullable(false);
        this.kdsDayShowDays.setNullable(false);
        this.SetSpinnerMaxMin((JSpinner)this.kdsWeekShowDays, 0, 1000);
        this.SetSpinnerMaxMin((JSpinner)this.kdsDayShowDays, 0, 1000);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.promptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_reqplan_view");
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.promptStorageOrgUnit);
        elements.add((FilterElement)mainOrgElement);
        MMRangeFilterElement reqDateElement = new MMRangeFilterElement("requireDate", (Component)this.pkrequireDateFrom, (Component)this.pkrequireDateTo);
        elements.add((FilterElement)reqDateElement);
        elements.add((FilterElement)new SingleFilterElement("dayShowDays", (Component)this.kdsDayShowDays));
        elements.add((FilterElement)new SingleFilterElement("weekShowDays", (Component)this.kdsWeekShowDays));
        SingleFilterElement element = new SingleFilterElement("IsOnlyShowTotal", (Component)this.kdcIsOnlyShowTotal);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("reqType.number", (Component)this.prmtreqType));
        elements.add((FilterElement)new SingleFilterElement("material.materialGroup.number", (Component)this.prmptMaterialGroup));
        elements.add((FilterElement)new SingleFilterElement("material.number", (Component)this.prmptMaterial));
        this.cmbStatus.removeAllItems();
        this.cmbStatus.addItems(new Object[]{BillBaseStatusEnum.NULL, ReqPlanStatusEnum.ACTIVE, ReqPlanStatusEnum.CLOSED});
        elements.add((FilterElement)new SingleFilterElement("status", (Component)this.cmbStatus, (Object)BillBaseStatusEnum.NULL));
        SingleFilterElement trackNumberElement = new SingleFilterElement("trackNumber.number", (Component)this.prmtTrackNumber);
        SingleFilterElement projectNumberElement = new SingleFilterElement("project.number", (Component)this.prmtProjectNumber);
        elements.add((FilterElement)trackNumberElement);
        elements.add((FilterElement)projectNumberElement);
        elements.add((FilterElement)new SingleFilterElement("planner.number", (Component)this.prmtPlannerFrom));
        elements.add((FilterElement)new MMRangeFilterElement("productionDept.number", (Component)this.prmtProductionDeptFrom, (Component)this.prmtProductionDeptTo));
        elements.add((FilterElement)new SingleFilterElement("reqSource", (Component)this.comboSourceBillType, (Object)RequireSourceEnum.NULL));
        elements.add((FilterElement)new MMRangeFilterElement("sourceBillNum", (Component)this.prmtSourceNumberFrom, (Component)this.prmtSourceNumberTo));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.prmtSourceNumberFrom.setEditable(true);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.promptStorageOrgUnit, (KDBizPromptBox)this.prmtTrackNumber);
        UISettingFactory uiSetting = UISettingFactory.getInstance();
        uiSetting.displayTrackName((CoreUIObject)this);
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cu.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtPlannerFrom.setEntityViewInfo(viewInfo);
        this.prmtPlannerFrom.setEditFormat("$number$");
        this.prmtPlannerFrom.setDisplayFormat("$name$");
        this.prmtPlannerFrom.setCommitFormat("$number$");
        this.prmtProductionDeptFrom.setEditFormat("$number$");
        this.prmtProductionDeptFrom.setDisplayFormat("$name$");
        this.prmtProductionDeptFrom.setCommitFormat("$number$");
        this.prmtProductionDeptTo.setEditFormat("$number$");
        this.prmtProductionDeptTo.setDisplayFormat("$name$");
        this.prmtProductionDeptTo.setCommitFormat("$number$");
        this.prmtProjectNumber.setEnabledMultiSelection(true);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumber);
        this.prmtProjectNumber.setEditFormat("$number$");
        this.prmtProjectNumber.setDisplayFormat("$number$");
        this.prmtProjectNumber.setCommitFormat("$number$");
        this.prmtTrackNumber.setEnabledMultiSelection(true);
        this.prmtPlannerFrom.setEnabledMultiSelection(true);
        this.comboSourceBillType.removeItem((Object)RequireSourceEnum.NULL);
        this.comboSourceBillType.insertItemAt((Object)RequireSourceEnum.NULL, 0);
        this.comboSourceBillType.setSelectedItem((Object)RequireSourceEnum.NULL);
        this.comboSourceBillType.removeItem((Object)RequireSourceEnum.REQREQUEST);
        this.comboSourceBillType.removeItem((Object)RequireSourceEnum.CENTRALPURREQ);
        this.comboSourceBillType.removeItem((Object)RequireSourceEnum.GCCD);
        this.prmtSourceNumberFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                RequirementPlanQueryUI.this.setSourceNumberFromF7(RequirementPlanQueryUI.this.prmtSourceNumberFrom);
            }
        });
        this.prmtSourceNumberFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                RequirementPlanQueryUI.this.setSourceNumberFromF7(RequirementPlanQueryUI.this.prmtSourceNumberFrom);
            }
        });
        this.prmtSourceNumberTo.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                RequirementPlanQueryUI.this.setSourceNumberFromF7(RequirementPlanQueryUI.this.prmtSourceNumberTo);
            }
        });
        this.prmtSourceNumberTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                RequirementPlanQueryUI.this.setSourceNumberFromF7(RequirementPlanQueryUI.this.prmtSourceNumberTo);
            }
        });
        this.setMaterialFilter();
        this.addListeners();
    }

    private void SetSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
            ((SpinnerNumberModel)model).setMaximum(new Integer(max));
        }
    }

    private void addListeners() {
        this.kdcIsOnlyShowTotal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                RequirementPlanQueryUI.this.showTotalChanged();
            }
        });
    }

    private void showTotalChanged() {
        if (this.kdcIsOnlyShowTotal.isSelected()) {
            this.prmtreqType.setValue(null);
            this.prmtreqType.setEnabled(false);
        } else {
            this.prmtreqType.setEnabled(true);
        }
    }

    private void setSourceNumberFromF7(KDBizPromptBox prmtSourceNumber) {
        String orgId = null;
        int requireSource = 0;
        if (this.promptStorageOrgUnit.getValue() != null) {
            orgId = ((OrgUnitInfo)this.promptStorageOrgUnit.getValue()).getId().toString();
            prmtSourceNumber.setCurrentCtrlUnit(((OrgUnitInfo)this.promptStorageOrgUnit.getValue()).getCU());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object obj = this.comboSourceBillType.getSelectedItem();
        RequireSourceEnum requireSourceType = (RequireSourceEnum)((Object)obj);
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(10));
        set.add(new Integer(30));
        if (obj instanceof RequireSourceEnum) {
            if (10 != requireSourceType.getValue() && 30 != requireSourceType.getValue()) {
                requireSource = requireSourceType.getValue();
            }
            if (-1 == requireSourceType.getValue()) {
                filter.getFilterItems().add(new FilterItemInfo("reqSource", set, CompareType.NOTINCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("reqSource", (Object)new Integer(requireSource), CompareType.EQUALS));
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("reqSource", set, CompareType.NOTINCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId, CompareType.EQUALS));
        view.setFilter(filter);
        prmtSourceNumber.setEntityViewInfo(view);
        prmtSourceNumber.getQueryAgent().resetRuntimeEntityView();
    }

    public boolean verify() {
        Timestamp dateTo;
        boolean verify = super.verify();
        if (this.promptStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)RequirementPlanQueryUI.getResource("STORAGEORG_ISNULL"));
            return false;
        }
        String orgId = ((OrgUnitInfo)this.promptStorageOrgUnit.getValue()).getId().toString();
        int dayShowDays = (Integer)this.kdsDayShowDays.getValue();
        int weekShowDays = (Integer)this.kdsWeekShowDays.getValue();
        int periodNumber = 0;
        if (this.pkrequireDateTo.getValue() == null || this.pkrequireDateFrom.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"CollectFilterDateErrorPrompt"));
            return false;
        }
        Timestamp dateFrom = this.pkrequireDateFrom.getTimestamp();
        if (dateFrom.after((Date)(dateTo = this.pkrequireDateTo.getTimestamp()))) {
            MsgBox.showInfo((String)EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"CollectFilterDateErrorPrompt"));
            return false;
        }
        try {
            periodNumber = ReqplanTotalFacadeFactory.getRemoteInstance().periodNumber(orgId, dateFrom, dateTo, dayShowDays, weekShowDays);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (periodNumber > 180) {
            verify = false;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.planning.ReqPlanTotalResource", (String)"periodNumberError"));
        }
        return verify;
    }

    private void setMaterialFilter() {
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.prmptMaterial, true, queryInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmptMaterial.setEntityViewInfo(view);
        this.prmptMaterial.getQueryAgent().resetRuntimeEntityView();
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmptMaterial});
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.promptStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected void setDefaultValue() {
        this.promptStorageOrgUnit.setValue((Object)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_reqplan_view"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        calendar.add(2, 1);
        this.pkrequireDateFrom.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
        calendar.setTime(SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        calendar.add(2, 1);
        this.pkrequireDateTo.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.client.BasedataResource", (String)strKey);
    }

    public void clear() {
        super.clear();
        this.kdsDayShowDays.setValue((Object)new Integer(0));
        this.kdsWeekShowDays.setValue((Object)new Integer(0));
        this.kdcIsOnlyShowTotal.setSelected(false);
    }

    protected String getViewPermission() {
        return "mm_reqplan_view";
    }
}

