/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.mm.basedata.BasedataException;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.planning.IRequirementUniteRule;
import com.kingdee.eas.mm.planning.RequirementUniteRuleCollection;
import com.kingdee.eas.mm.planning.RequirementUniteRuleFactory;
import com.kingdee.eas.mm.planning.RequirementUniteRuleInfo;
import com.kingdee.eas.mm.planning.client.AbstractRequirementUniteRuleUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.STConverter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class RequirementUniteRuleUI
extends AbstractRequirementUniteRuleUI {
    private static final Logger logger = CoreUIObject.getLogger(RequirementUniteRuleUI.class);
    private static final String TB_ID = "id";
    private static final String TB_RULENUMBER = "ruleNumber";
    private static final String TB_RULENAME = "ruleName";
    private static final String TB_RULEDESCRIBLE = "ruleDescrible";
    private static final String TB_STATUS = "status";
    private static final String TB_PICTYPE = "PICType";
    private static final String TB_PIDTYPE = "PIDType";
    private static final String TB_SIDTYPE = "SIDType";
    private static final String TB_PIOTYPE = "PIOType";
    private static final String TB_MTDTYPE = "MTDType";
    private static final String TB_MIDTYPE = "MIDType";
    private static final String TB_GCCDTYPE = "GCCDType";
    private static final String TB_PRDTYPE = "PRDType";
    private static final String TB_CORRELETIVETYPE = "correlativeType";
    private static final String TB_CREATOR = "creator";
    private static final String TB_CREATEDDATE = "createdDate";
    private static final String TB_MENDER = "mender";
    private static final String TB_MENDERDATE = "menderDate";
    private static final String TB_CREATORID = "creatorId";
    private static final Integer oneInteger = new Integer(1);
    private static final Integer MaxInteger = new Integer(99);
    private boolean isChanged = false;
    private List editRowList = new ArrayList();
    private List newAddRowList = new ArrayList();
    private String[] addColumns = new String[]{"PICType", "PIDType", "SIDType", "PIOType", "MTDType", "MIDType", "GCCDType", "PRDType", "correlativeType"};
    private String[] copyColumns = new String[]{"ruleName", "ruleDescrible", "PICType", "PIDType", "SIDType", "PIOType", "MTDType", "MIDType", "PRDType", "GCCDType", "correlativeType"};
    private static final String[] KDT_DATES = new String[]{"createdDate", "menderDate"};
    private UserInfo currentUser = null;
    private KDTEditAdapter tableChangeListener = null;
    private DataChangeListener storageDataChangeListener = null;
    private SelectorListener storageSelectListener = null;
    private List mutexLineIds = new ArrayList();
    private boolean isMutex = false;

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.tblMain.checkParsed();
        this.initTableColumns();
        this.initStorageUnitOrgF7();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.currentUser = SysContext.getSysContext().getCurrentUserInfo();
        Map uiContext = this.getUIContext();
        if (uiContext.get("sourceID") != null && uiContext.get("sourceID").equals("InitMmParamsUI")) {
            this.prmtStorageOrgUnit.setValue(uiContext.get("storageOrgUnitInfo"));
            this.currentUser = (UserInfo)uiContext.get("userInfo");
        }
        this.dataBinding();
        this.addListener();
        this.setMultiLangBox();
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
    }

    private void setMultiLangBox() {
        KDBizMultiLangBox namebox = new KDBizMultiLangBox();
        KDBizMultiLangBox describleBox = new KDBizMultiLangBox();
        describleBox.setMaxLength(255);
        namebox.setMaxLength(80);
        String lan = LocaleUtils.getDefaultLocale().getLanguage();
        if (lan.equals("l1")) {
            namebox.setSelectedIndex(2);
            describleBox.setSelectedIndex(2);
        } else if (lan.equals("l2")) {
            namebox.setSelectedIndex(0);
            describleBox.setSelectedIndex(0);
        } else if (lan.equals("l3")) {
            namebox.setSelectedIndex(1);
            describleBox.setSelectedIndex(1);
        }
        this.tblMain.getColumn(TB_RULENAME).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)namebox));
        this.tblMain.getColumn(TB_RULEDESCRIBLE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)namebox));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RequirementUniteRuleFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    private void addListener() {
        this.tableChangeListener = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    RequirementUniteRuleUI.this.tblMain_Changed(e);
                }
                catch (Exception exc) {
                    RequirementUniteRuleUI.this.handUIException(exc);
                }
            }
        };
        this.tblMain.addKDTEditListener((KDTEditListener)this.tableChangeListener);
        this.storageSelectListener = new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    RequirementUniteRuleUI.this.beforeStorageChange();
                }
                catch (Exception e1) {
                    e.setCanceled(true);
                    RequirementUniteRuleUI.this.handUIException(e1);
                }
            }
        };
        this.prmtStorageOrgUnit.addSelectorListener(this.storageSelectListener);
        this.storageDataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    RequirementUniteRuleUI.this.handleStorageChanged(e);
                }
                catch (Exception exc) {
                    RequirementUniteRuleUI.this.handUIException(exc);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageDataChangeListener);
    }

    private void removeListener() {
        if (this.tableChangeListener != null) {
            this.tblMain.removeKDTEditListener((KDTEditListener)this.tableChangeListener);
        }
        if (this.storageSelectListener != null) {
            this.prmtStorageOrgUnit.removeSelectorListener(this.storageSelectListener);
        }
        if (this.storageDataChangeListener != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.storageDataChangeListener);
        }
    }

    private void tblMain_Changed(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fid = null;
        if (isDiffrent) {
            IRow row = this.tblMain.getRow(rowIndex);
            MMBasedataStatusEnum status = (MMBasedataStatusEnum)row.getCell(TB_STATUS).getValue();
            if (status.getValue() != 40) {
                this.editRowList.add(row);
                fid = row.getCell(TB_ID).getValue().toString();
                try {
                    this.setOprtState("EDIT");
                    this.pubFireVOChangeListener(fid);
                    this.isMutex = true;
                }
                catch (Throwable ex) {
                    this.handUIException(ex);
                    row.getCell(colIndex).setValue(oldValue);
                    return;
                }
                this.mutexLineIds.add(fid);
            }
            this.isChanged = true;
        }
    }

    private void beforeStorageChange() throws Exception {
        int result;
        if (this.isChanged && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)ResourceManage.getResource((String)"cs_dataCHG"))) == 0) {
            this.actionSave_actionPerformed(null);
        }
    }

    private void handleStorageChanged(DataChangeEvent e) throws Exception {
        Object newValue = e.getNewValue();
        Object oldValue = e.getOldValue();
        if (newValue == null) {
            MsgBox.showError((String)this.getRequirementUniteRuleResource("RequirementUniteRuleStorageOrg_IsNotNull"));
            this.prmtStorageOrgUnit.setValue(oldValue);
            return;
        }
        if (newValue.equals(oldValue)) {
            return;
        }
        this.cancelRequestMutex();
        this.initWorkButton();
        this.isChanged = false;
        this.newAddRowList.clear();
        this.editRowList.clear();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.dataBinding();
    }

    private void initTableColumns() {
        for (int i = 0; i < this.addColumns.length; ++i) {
            this.setTableFormattedTextField(this.addColumns[i]);
        }
        KDTextField field = new KDTextField();
        field.setMaxLength(255);
        this.tblMain.getColumn(TB_RULENAME).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)field));
        this.tblMain.getColumn(TB_RULEDESCRIBLE).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)field));
        KDTextField text = new KDTextField();
        text.setMaxLength(80);
        this.tblMain.getColumn(TB_RULENUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)text));
    }

    private void setTableFormattedTextField(String columnName) {
        IColumn column = this.tblMain.getColumn(columnName);
        KDFormattedTextField field = new KDFormattedTextField();
        field.setNegatived(false);
        field.setMinimumValue((Comparable)oneInteger);
        field.setMaximumValue((Comparable)MaxInteger);
        field.setPrecision(0);
        column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)field));
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public OrgType getMainType() {
        return OrgType.Storage;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.menuItemEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.actionEdit.setEnabled(true);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.actionSave.setEnabled(false);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.menuItemAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionAddLine.setEnabled(false);
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.menuItemInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.actionInsertLine.setEnabled(false);
        this.btnCopyLine.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.menuItemCopyLine.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.actionCopyLine.setEnabled(false);
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.menuItemRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionRemoveLine.setEnabled(false);
        this.btnCancelCancel.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuItemCancelCancel.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnCancel.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemCancel.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
    }

    private void initStorageUnitOrgF7() {
        OrgUnitInfo orgInfo = null;
        orgInfo = this.getUIContext().get("ORG.INFO") != null ? (OrgUnitInfo)this.getUIContext().get("ORG.INFO") : MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_RequirementUniteRule_view");
        this.prmtStorageOrgUnit.setValue((Object)orgInfo);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_RequirementUniteRule_view");
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setEditWorkButton();
        this.setEditTableCell();
    }

    private void setEditTableCell() {
        IRow row = null;
        MMBasedataStatusEnum status = MMBasedataStatusEnum.ADDNEW;
        for (int j = 0; j < this.tblMain.getRowCount(); ++j) {
            status = (MMBasedataStatusEnum)this.tblMain.getCell(j, TB_STATUS).getValue();
            row = this.tblMain.getRow(j);
            if (status.getValue() != 20) {
                for (int i = 0; i < this.copyColumns.length; ++i) {
                    row.getCell(this.copyColumns[i]).getStyleAttributes().setLocked(false);
                }
                continue;
            }
            row.getStyleAttributes().setLocked(true);
        }
    }

    private void setEditWorkButton() {
        this.actionEdit.setEnabled(false);
        this.actionSave.setEnabled(true);
        this.actionAddLine.setEnabled(true);
        this.actionInsertLine.setEnabled(true);
        this.actionCopyLine.setEnabled(true);
        this.actionRemoveLine.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        CoreBaseCollection saveCollection = new CoreBaseCollection();
        IRow row = null;
        for (int j = 0; j < this.newAddRowList.size(); ++j) {
            row = (IRow)this.newAddRowList.get(j);
            saveCollection.add((CoreBaseInfo)this.setInfoByRow(row));
        }
        for (int i = 0; i < this.editRowList.size(); ++i) {
            saveCollection.add((CoreBaseInfo)this.setInfoByRow((IRow)this.editRowList.get(i)));
        }
        ArrayList<List> saveList = new ArrayList<List>();
        saveList.add(this.newAddRowList);
        saveList.add(this.editRowList);
        if (saveCollection.size() > 0) {
            try {
                ((IRequirementUniteRule)this.getBizInterface()).save(saveCollection);
                this.newAddRowList.clear();
                this.editRowList.clear();
                this.isChanged = false;
                this.dataBinding();
                this.setEditTableCell();
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
                this.setNextMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
                this.setShowMessagePolicy(2);
                this.setIsShowTextOnly(false);
                this.showMessage();
            }
            catch (EASBizException exc) {
                this.handleNumberDupErr(exc, saveList);
            }
            finally {
                this.cancelRequestMutex();
            }
        }
    }

    private void handleNumberDupErr(EASBizException e, List rows) throws EASBizException {
        String excMsg = e.getMessage();
        if (excMsg.startsWith("NAME")) {
            throw new BasedataException(BasedataException.NAMEDUP, new Object[]{excMsg.substring(4)});
        }
        if (excMsg.startsWith("NUMBER")) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{excMsg.substring(6)});
        }
        throw e;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblMain.addRow();
        this.initNewAddLineData(row);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        if (this.tblMain.getSelectManager().size() > 0) {
            int top = this.tblMain.getSelectManager().get().getTop();
            row = this.tblMain.addRow(top);
        } else {
            row = this.tblMain.addRow();
        }
        this.initNewAddLineData(row);
    }

    private void initNewAddLineData(IRow row) {
        for (int i = 0; i < this.copyColumns.length; ++i) {
            row.getCell(this.copyColumns[i]).getStyleAttributes().setLocked(false);
        }
        StorageOrgUnitInfo storageUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        try {
            RequirementUniteRuleInfo ruleInfo = ((IRequirementUniteRule)this.getBizInterface()).initLineNumberAndDate(storageUnitInfo);
            if (ruleInfo.getNumber() == null) {
                row.getCell(TB_RULENUMBER).getStyleAttributes().setLocked(false);
            } else {
                if (!ruleInfo.getNumber().equals("NewAddWhenSave")) {
                    row.getCell(TB_RULENUMBER).setValue((Object)ruleInfo.getNumber());
                }
                row.getCell(TB_RULENUMBER).getStyleAttributes().setLocked(true);
            }
            row.getCell(TB_STATUS).setValue((Object)MMBasedataStatusEnum.ADDNEW);
            for (int i = 0; i < this.addColumns.length; ++i) {
                row.getCell(this.addColumns[i]).setValue((Object)oneInteger);
            }
            row.getCell(TB_CREATOR).setValue((Object)this.currentUser.getName());
            row.getCell(TB_CREATORID).setValue((Object)this.currentUser.getId().toString());
            row.getCell(TB_CREATEDDATE).setValue((Object)ruleInfo.getCreateTime());
            this.newAddRowList.add(row);
            this.isChanged = true;
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length != 1) {
            MsgBox.showInfo((String)this.getRequirementUniteRuleResource("ChooseOneRow"));
            SysUtil.abort();
        }
        IRow selectRow = this.tblMain.getRow(selectRows[0]);
        IRow row = this.tblMain.addRow(selectRows[0] + 1);
        this.initCopyLineData(row, selectRow);
    }

    private String getRequirementUniteRuleResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.RequirementUniteRuleResource", (String)sKey);
    }

    private void initCopyLineData(IRow row, IRow selectRow) {
        for (int i = 0; i < this.copyColumns.length; ++i) {
            row.getCell(this.copyColumns[i]).getStyleAttributes().setLocked(false);
        }
        StorageOrgUnitInfo storageUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        try {
            RequirementUniteRuleInfo ruleInfo = ((IRequirementUniteRule)this.getBizInterface()).initLineNumberAndDate(storageUnitInfo);
            if (ruleInfo.getNumber() == null) {
                row.getCell(TB_RULENUMBER).getStyleAttributes().setLocked(false);
            } else {
                if (!ruleInfo.getNumber().equals("NewAddWhenSave")) {
                    row.getCell(TB_RULENUMBER).setValue((Object)ruleInfo.getNumber());
                }
                row.getCell(TB_RULENUMBER).getStyleAttributes().setLocked(true);
            }
            row.getCell(TB_STATUS).setValue((Object)MMBasedataStatusEnum.ADDNEW);
            row.getCell(TB_CREATOR).setValue((Object)this.currentUser.getName());
            row.getCell(TB_CREATORID).setValue((Object)this.currentUser.getId().toString());
            row.getCell(TB_CREATEDDATE).setValue((Object)ruleInfo.getCreateTime());
            for (int i = 0; i < this.copyColumns.length; ++i) {
                if (selectRow.getCell(this.copyColumns[i]).getValue() == null) continue;
                row.getCell(this.copyColumns[i]).setValue(selectRow.getCell(this.copyColumns[i]).getValue());
            }
            this.newAddRowList.add(row);
            this.isChanged = true;
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        boolean isYes;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length != 1) {
            MsgBox.showInfo((String)this.getRequirementUniteRuleResource("ChooseOneRow"));
            SysUtil.abort();
        }
        if (!(isYes = MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete"))))) {
            return;
        }
        IRow selectRow = this.tblMain.getRow(selectRows[0]);
        MMBasedataStatusEnum status = (MMBasedataStatusEnum)selectRow.getCell(TB_STATUS).getValue();
        IRow currRow = null;
        if (status.getValue() == 40) {
            for (int i = 0; i < this.newAddRowList.size(); ++i) {
                currRow = (IRow)this.newAddRowList.get(i);
                if (currRow.getCell(TB_ID).getValue() != this.tblMain.getRow(selectRows[0]).getCell(TB_ID).getValue()) continue;
                this.newAddRowList.remove(currRow);
            }
            this.tblMain.removeRow(selectRows[0]);
        } else {
            String fid = selectRow.getCell(TB_ID).getValue().toString();
            try {
                this.setOprtState("REMOVE");
                this.pubFireVOChangeListener(fid);
                this.isMutex = true;
            }
            catch (Throwable ex) {
                this.handUIException(ex);
                return;
            }
            ObjectUuidPK uuidPk = new ObjectUuidPK(fid);
            try {
                this.getBizInterface().delete((IObjectPK)uuidPk);
                this.tblMain.removeRow(selectRows[0]);
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            finally {
                try {
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(fid);
                }
                catch (Throwable e1) {
                    logger.error((Object)e1);
                }
            }
        }
        if (this.newAddRowList.size() == 0 && this.editRowList.size() == 0) {
            this.isChanged = false;
        }
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)cancelMsg))) {
            if (this.isChanged) {
                MsgBox.showInfo((String)this.getRequirementUniteRuleResource("Save_bef_Cancel"));
                SysUtil.abort();
            }
            this.doCancelOrCancelCancel(false);
            this.dataBinding();
            this.setEditTableCell();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)cancelMsg))) {
            if (this.isChanged) {
                MsgBox.showInfo((String)this.getRequirementUniteRuleResource("Save_bef_Cancel"));
                SysUtil.abort();
            }
            this.doCancelOrCancelCancel(true);
            this.dataBinding();
            this.actionEdit.setEnabled(true);
        }
    }

    private void doCancelOrCancelCancel(boolean isCancel) throws Exception {
        IRequirementUniteRule iRequirementUniteRule = (IRequirementUniteRule)this.getBizInterface();
        ArrayList ids = this.getSelectedIdValues();
        String message = null;
        StringBuffer errors = new StringBuffer();
        String forbidError = null;
        if (!isCancel) {
            errors = iRequirementUniteRule.setCancelCancel(ids);
            message = this.getRequirementUniteRuleResource("rule_cancelCancel_succ");
            forbidError = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Msg_Start_Error");
        } else {
            errors = iRequirementUniteRule.setCancel(ids);
            message = this.getRequirementUniteRuleResource("rule_cancel_succ");
            forbidError = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Msg_Forbid_Error");
        }
        if (errors.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)forbidError, (String)errors.toString(), (int)8188);
        } else {
            this.setMessageText(message);
            this.showMessage();
        }
    }

    private RequirementUniteRuleInfo setInfoByRow(IRow row) {
        RequirementUniteRuleInfo ruleInfo = new RequirementUniteRuleInfo();
        ruleInfo.setStorageOrgUnit((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        String ruleNumber = (String)row.getCell(TB_RULENUMBER).getValue();
        String ruleName = (String)row.getCell(TB_RULENAME).getValue();
        if (ruleName == null || StringUtil.isEmpty((String)ruleName)) {
            String msg = this.getRequirementUniteRuleResource("RuleName_IsNotNull");
            MsgBox.showInfo((String)msg);
            this.tblMain.getEditManager().editCellAt(row.getRowIndex(), this.tblMain.getColumnIndex(TB_RULENAME));
            SysUtil.abort();
        }
        ruleInfo.setName(ruleName);
        if (ruleNumber != null && !StringUtil.isEmpty((String)ruleNumber)) {
            ruleInfo.setNumber(ruleNumber);
        }
        if (row.getCell(TB_RULEDESCRIBLE).getValue() != null) {
            ruleInfo.setDescription(row.getCell(TB_RULEDESCRIBLE).getValue().toString());
        } else {
            ruleInfo.setDescription(null);
        }
        ruleInfo.setPICReqType((Integer)row.getCell(TB_PICTYPE).getValue());
        ruleInfo.setPIDReqType((Integer)row.getCell(TB_PIDTYPE).getValue());
        ruleInfo.setPIOReqType((Integer)row.getCell(TB_PIOTYPE).getValue());
        ruleInfo.setMIDReqType((Integer)row.getCell(TB_MIDTYPE).getValue());
        ruleInfo.setMTDReqType((Integer)row.getCell(TB_MTDTYPE).getValue());
        ruleInfo.setSIDReqType((Integer)row.getCell(TB_SIDTYPE).getValue());
        ruleInfo.setGCCDReqType((Integer)row.getCell(TB_GCCDTYPE).getValue());
        ruleInfo.setPRDReqType((Integer)row.getCell(TB_PRDTYPE).getValue());
        ruleInfo.setCorrelativeReqType((Integer)row.getCell(TB_CORRELETIVETYPE).getValue());
        UserInfo creator = new UserInfo();
        creator.setId(BOSUuid.read((String)row.getCell(TB_CREATORID).getValue().toString()));
        creator.setName(row.getCell(TB_CREATOR).getValue().toString());
        ruleInfo.setCreator(creator);
        ruleInfo.setStatus((MMBasedataStatusEnum)row.getCell(TB_STATUS).getValue());
        Date date = (Date)row.getCell(TB_CREATEDDATE).getValue();
        ruleInfo.setCreateTime(new Timestamp(date.getTime()));
        ruleInfo.setLastUpdateUser(this.currentUser);
        Object fid = row.getCell(TB_ID).getValue();
        if (fid != null) {
            ruleInfo.setId(BOSUuid.read((String)fid.toString()));
        }
        if (SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("L2")) {
            ruleInfo.setName(STConverter.sc2tc((String)ruleInfo.getName(new Locale("L2"))), new Locale("L3"));
            if (row.getCell(TB_RULEDESCRIBLE).getValue() != null) {
                ruleInfo.setDescription(STConverter.sc2tc((String)ruleInfo.getDescription(new Locale("L2"))), new Locale("L3"));
            }
        }
        if (SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("L3")) {
            ruleInfo.setName(STConverter.sc2tc((String)ruleInfo.getName(new Locale("L3"))), new Locale("L2"));
            if (row.getCell(TB_RULEDESCRIBLE).getValue() != null) {
                ruleInfo.setDescription(STConverter.sc2tc((String)ruleInfo.getDescription(new Locale("L3"))), new Locale("L2"));
            }
        }
        return ruleInfo;
    }

    private void dataBinding() throws BOSException, Exception {
        this.tblMain.repaint();
        this.tblMain.removeRows();
        RequirementUniteRuleCollection ruleColls = this.queryRequirementUniteRule();
        if (ruleColls == null || ruleColls.size() == 0) {
            if (this.prmtStorageOrgUnit.getValue() == null) {
                this.actionEdit.setEnabled(false);
            }
            return;
        }
        for (int i = 0; i < ruleColls.size(); ++i) {
            RequirementUniteRuleInfo info = ruleColls.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell(TB_ID).setValue((Object)info.getId());
            row.getCell(TB_RULENUMBER).setValue((Object)info.getNumber());
            row.getCell(TB_RULENAME).setValue((Object)info.getName());
            row.getCell(TB_RULEDESCRIBLE).setValue((Object)info.getDescription());
            row.getCell(TB_STATUS).setValue((Object)info.getStatus());
            row.getCell(TB_PICTYPE).setValue((Object)new Integer(info.getPICReqType()));
            row.getCell(TB_PIDTYPE).setValue((Object)new Integer(info.getPIDReqType()));
            row.getCell(TB_PIOTYPE).setValue((Object)new Integer(info.getPIOReqType()));
            row.getCell(TB_MIDTYPE).setValue((Object)new Integer(info.getMIDReqType()));
            row.getCell(TB_MTDTYPE).setValue((Object)new Integer(info.getMTDReqType()));
            row.getCell(TB_SIDTYPE).setValue((Object)new Integer(info.getSIDReqType()));
            row.getCell(TB_GCCDTYPE).setValue((Object)new Integer(info.getGCCDReqType()));
            row.getCell(TB_PRDTYPE).setValue((Object)new Integer(info.getPRDReqType()));
            row.getCell(TB_CORRELETIVETYPE).setValue((Object)new Integer(info.getCorrelativeReqType()));
            row.getCell(TB_CREATOR).setValue((Object)info.getCreator().getName());
            row.getCell(TB_CREATORID).setValue((Object)info.getCreator().getId().toString());
            row.getCell(TB_CREATEDDATE).setValue((Object)info.getCreateTime());
            row.getCell(TB_MENDER).setValue((Object)info.getLastUpdateUser().getName());
            row.getCell(TB_MENDERDATE).setValue((Object)info.getLastUpdateTime());
        }
    }

    private RequirementUniteRuleCollection queryRequirementUniteRule() throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (storageOrgUnit == null) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnit.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo(TB_STATUS));
        view.getSelector().add(new SelectorItemInfo("creator.id"));
        view.getSelector().add(new SelectorItemInfo("creator.name"));
        view.getSelector().add(new SelectorItemInfo("lastUpdateUser.id"));
        view.getSelector().add(new SelectorItemInfo("lastUpdateUser.number"));
        view.getSelector().add(new SelectorItemInfo("lastUpdateUser.name"));
        SorterItemInfo aSorterItemInfo = new SorterItemInfo("number");
        aSorterItemInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(aSorterItemInfo);
        return ((IRequirementUniteRule)this.getBizInterface()).getRequirementUniteRuleCollection(view);
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected ArrayList getSelectedIdValues() {
        int[] selectRows = KDTableUtils.getSelectedRows((KDTable)this.tblMain);
        ArrayList<String> selectIds = new ArrayList<String>();
        for (int i = 0; i < selectRows.length; ++i) {
            selectIds.add(this.tblMain.getCell(selectRows[i], TB_ID).getValue().toString());
        }
        return selectIds;
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isChanged) {
            b = true;
            b = this.checkSaveChange();
        }
        return b;
    }

    private boolean checkSaveChange() {
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)ResourceManage.getResource((String)"Confirm_Save_Exit"));
        if (result == 0) {
            try {
                this.actionSave_actionPerformed(null);
                return true;
            }
            catch (Exception e) {
                this.handUIException(e);
                return false;
            }
        }
        return result != 2;
    }

    private void cancelRequestMutex() {
        if (this.isMutex) {
            try {
                String fid = null;
                for (int i = 0; i < this.mutexLineIds.size(); ++i) {
                    fid = this.mutexLineIds.get(i).toString();
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(fid);
                }
                this.mutexLineIds.clear();
                this.isMutex = false;
            }
            catch (Throwable ex) {
                this.handUIException(ex);
            }
        }
    }
}

