/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.common.client.CodingRulerUIHelper;
import com.kingdee.eas.mm.common.client.MMF7ContextManager;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.CheckTypeEnum;
import com.kingdee.eas.mm.planning.ISOPCheckFormula;
import com.kingdee.eas.mm.planning.SOPCheckFormulaFactory;
import com.kingdee.eas.mm.planning.SOPCheckFormulaInfo;
import com.kingdee.eas.mm.planning.client.AbstractSOPCheckFormulaEditUI;
import com.kingdee.eas.mm.planning.util.FormulaParserUtil;
import com.kingdee.eas.scm.common.action.ISupportObjContext;
import com.kingdee.eas.scm.common.client.GeneralF7TreeListUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Logger;

public class SOPCheckFormulaEditUI
extends AbstractSOPCheckFormulaEditUI
implements IMultiOrgSupport,
ISupportObjContext {
    private static final Logger logger = CoreUIObject.getLogger(SOPCheckFormulaEditUI.class);
    public static final String RESOURCE = "com.kingdee.eas.mm.planning.SOPCheckFormulaResource";
    private static String[] filterDisplayName;
    private CodingRulerUIHelper codingRulerUIHelper;
    private static String[] filterName;
    private Map materialMap = null;
    private KeyListener keyLinListener = null;
    private ItemListener itemListener = null;
    private String[] materialFlag = new String[2];
    private MMF7ContextManager F7ContextManager = null;

    public SOPCheckFormulaEditUI() throws Exception {
        this.codingRulerUIHelper = new CodingRulerUIHelper((EditUI)this, this.txtNumber);
        this.materialFlag[0] = "[";
        this.materialFlag[1] = "]";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getOprtState() == "ADDNEW" || this.getOprtState() == "VIEW") {
            SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_sopcheckformula_addnew");
        }
        this.txtTolerances.setDataType(1);
        this.txtTolerances.setPrecision(2);
        this.txtTolerances.setRemoveingZeroInDispaly(true);
        this.txtTolerances.setNegatived(false);
        this.txtTolerances.setSupportedEmpty(false);
        this.txtTolerances.setHorizontalAlignment(4);
        this.txtTolerances.setMaximumValue((Comparable)new BigDecimal("100.00"));
        this.txtTolerances.setMinimumValue((Comparable)new BigDecimal("0.00"));
        this.txtCheckValue.setDataType(1);
        this.txtCheckValue.setPrecision(6);
        this.txtCheckValue.setRemoveingZeroInDispaly(true);
        this.txtCheckValue.setNegatived(false);
        this.txtCheckValue.setHorizontalAlignment(4);
        this.txtCheckValue.setSupportedEmpty(false);
        this.txtCheckValue.setMaximumValue((Comparable)new BigDecimal("1.0E13"));
        this.txtCheckValue.setMinimumValue((Comparable)new BigDecimal("0.00"));
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        if (this.editData.getStorageOrgUnit() != null) {
            this.getMaterials(this.editData.getStorageOrgUnit().getId().toString());
            this.codingRulerUIHelper.setNumAfterOrgChg(this.editData.getStorageOrgUnit().getId().toString());
        }
        this.addListener();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnSave.setVisible(false);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
        this.menuItemSave.setVisible(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        SOPCheckFormulaInfo info = (SOPCheckFormulaInfo)this.dataBinder.getValueObject();
        if (info != null) {
            if (this.getOprtState() == "VIEW") {
                if (info.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
                    this.btnApprove.setVisible(false);
                    this.btnUnApprove.setVisible(true);
                    this.btnEdit.setEnabled(false);
                    this.btnRemove.setEnabled(false);
                    this.btnMaterial.setEnabled(false);
                } else {
                    this.btnApprove.setVisible(true);
                    this.btnUnApprove.setVisible(false);
                    this.btnEdit.setEnabled(true);
                    this.btnRemove.setEnabled(true);
                    this.btnMaterial.setEnabled(true);
                }
                this.txtPaneFormula.setEditable(false);
                this.btnMaterial.setEnabled(false);
                this.btnApprove.setEnabled(true);
                this.btnUnApprove.setEnabled(true);
            } else if (this.getOprtState() == "EDIT") {
                if (info.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
                    MsgBox.showWarning((String)ResourceUtils.getMessageForClient((String)RESOURCE, (String)"EDITFAIL_APPROVE"));
                    this.abort();
                } else {
                    this.btnApprove.setVisible(true);
                    this.btnApprove.setEnabled(true);
                    this.btnUnApprove.setVisible(false);
                    this.btnUnApprove.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.btnMaterial.setEnabled(true);
                }
            } else if (this.getOprtState() == "ADDNEW") {
                this.btnCopy.setEnabled(false);
                this.actionCopy.setEnabled(false);
                this.btnApprove.setEnabled(false);
                this.btnApprove.setVisible(true);
                this.btnUnApprove.setVisible(false);
                this.btnMaterial.setEnabled(true);
            }
            if (info.getCheckType().equals((Object)CheckTypeEnum.LESSEQUALS)) {
                this.txtTolerances.setEnabled(false);
            } else {
                this.txtTolerances.setEnabled(true);
            }
            this.txtPaneFormula.setEditable(true);
        }
    }

    protected void initListener() {
        super.initListener();
        if (this.keyLinListener == null) {
            this.keyLinListener = new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32 || e.getKeyCode() == 9) {
                        e.consume();
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    char ch = e.getKeyChar();
                    Character c = new Character(ch);
                    if (!(c.hashCode() == 8 || c.hashCode() >= 40 && c.hashCode() <= 43 || c.hashCode() >= 45 && c.hashCode() <= 57 || c.hashCode() >= 65 && c.hashCode() <= 91 || c.hashCode() == 93 || c.hashCode() >= 97 && c.hashCode() <= 122)) {
                        e.consume();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            };
        }
        this.txtPaneFormula.addKeyListener(this.keyLinListener);
        if (this.itemListener == null) {
            this.itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (SOPCheckFormulaEditUI.this.cmbCheckType.getSelectedItem().equals((Object)CheckTypeEnum.LESSEQUALS)) {
                        SOPCheckFormulaEditUI.this.txtTolerances.setValue((Object)new BigDecimal("0.0"));
                        SOPCheckFormulaEditUI.this.txtTolerances.setEnabled(false);
                    } else {
                        SOPCheckFormulaEditUI.this.txtTolerances.setEnabled(true);
                    }
                }
            };
        }
        this.cmbCheckType.addItemListener(this.itemListener);
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        if (newOrgId != null) {
            this.getMaterials(newOrgId);
            if (this.getOprtState().equals("ADDNEW")) {
                this.codingRulerUIHelper.setNumAfterOrgChg(newOrgId);
            }
        } else {
            MsgBox.showWarning((String)ResourceUtils.getMessageForClient((String)RESOURCE, (String)"EDITUI_NOORGUNIT"));
            this.getMainBizOrg().setData((Object)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType()));
            this.abort();
        }
    }

    private void addListener() {
        this.txtPaneFormula.addKeyListener(this.keyLinListener);
        this.cmbCheckType.addItemListener(this.itemListener);
    }

    private void removeListener() {
        this.txtPaneFormula.removeKeyListener(this.keyLinListener);
        this.cmbCheckType.removeItemListener(this.itemListener);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SOPCheckFormulaFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        SOPCheckFormulaInfo info = new SOPCheckFormulaInfo();
        info.setStatus(BDStatusEnum.UNAPPROVE);
        info.setStorageOrgUnit((StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainOrgType(), (String)this.getPermissionItem()));
        info.setCheckType(CheckTypeEnum.LESSEQUALS);
        info.setTolerances(new BigDecimal("0.0"));
        info.setCheckValue(new BigDecimal("0.0"));
        return info;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.editData.getCheckType().equals((Object)CheckTypeEnum.LESSEQUALS)) {
            this.txtTolerances.setEnabled(false);
        } else {
            this.txtTolerances.setEnabled(true);
        }
    }

    @Override
    public void actionQueryMaterial_actionPerformed(ActionEvent e) throws Exception {
        Object o;
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.getMainBizOrg().getValue();
        String listQueryInfo = "com.kingdee.eas.basedata.master.material.app.F7MaterialPlanGroupQuery";
        String className = "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI";
        F7MaterialTreeListUI comp = null;
        try {
            comp = (F7MaterialTreeListUI)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException e1) {
            this.handUIException(e1);
        }
        MetaDataPK pk = new MetaDataPK(listQueryInfo);
        QueryInfo info = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
        KDTable kdTable = comp.getMainTable();
        comp.setQueryPK((IMetaDataPK)pk);
        kdTable.removeColumns();
        SOPCheckFormulaEditUI.fillKDTable(info, kdTable);
        comp.setTreeBaseBOSType(MaterialGroupInfo.getBosType());
        comp.setAssociatePropertyName("materialGroup.id");
        comp.setMultiSelect(false);
        FilterInfo bizFilterInfo = new FilterInfo();
        bizFilterInfo.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageOrgUnit.getId().toString(), CompareType.EQUALS));
        bizFilterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        bizFilterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1), CompareType.EQUALS));
        bizFilterInfo.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)new Integer(10030), CompareType.EQUALS));
        bizFilterInfo.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)new Integer(10040), CompareType.EQUALS));
        bizFilterInfo.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)new Integer(10050), CompareType.EQUALS));
        bizFilterInfo.setMaskString("#0 and #1 and #2 and (#3 or #4 or #5)");
        UIContext uic = new UIContext((Object)this);
        uic.put((Object)"CustomerFilterInfo", (Object)bizFilterInfo);
        uic.put((Object)"InnerWindow", (Object)comp);
        uic.put((Object)"FilterDisplayName", (Object)filterDisplayName);
        uic.put((Object)"FilterName", (Object)filterName);
        uic.put((Object)"QueryName", (Object)listQueryInfo);
        uic.put((Object)"value", (Object)"");
        uic.put((Object)"queryProperty", null);
        uic.put((Object)"compareType", null);
        uic.put((Object)"isShowUnUsed", (Object)false);
        uic.put((Object)"promptBox", (Object)this.prmtMaterial);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow ui = uiFactory.create(GeneralF7TreeListUI.class.getName(), (Map)uic);
        ((GeneralF7TreeListUI)ui.getUIObject()).setSearchValue("");
        ((GeneralF7TreeListUI)ui.getUIObject()).setSearchProperty(null, null);
        ui.show();
        if (((GeneralF7TreeListUI)ui.getUIObject()).getRetVal() == 1 && (o = ((GeneralF7TreeListUI)ui.getUIObject()).getData()) != null) {
            MaterialInfo material = (MaterialInfo)o;
            StringBuffer sb = new StringBuffer();
            sb.append(this.materialFlag[0]).append(material.getNumber()).append(this.materialFlag[1]);
            int index = this.txtPaneFormula.getText().length();
            this.insertText(index, sb.toString(), Color.BLACK);
        }
    }

    @Override
    public void actionVerify_actionPerformed(ActionEvent e) {
        try {
            this.verifyFormula();
        }
        catch (Exception exc) {
            this.abort();
        }
    }

    private void verifyFormula() throws Exception {
        String str = this.txtPaneFormula.getText();
        FormulaParserUtil fp = new FormulaParserUtil(str);
        if (!fp.checkValidForClient()) {
            MsgBox.showError((Component)((Object)this), (String)fp.getMsg());
            if (fp.getErrorIndex() >= 0 && fp.getErrorLength() > 0) {
                String error = this.txtPaneFormula.getText(fp.getErrorIndex(), fp.getErrorLength());
                this.removeText(fp.getErrorIndex(), fp.getErrorLength());
                this.insertText(fp.getErrorIndex(), error, Color.RED);
            }
            SysUtil.abort();
        } else {
            if (str.length() >= 1024) {
                MsgBox.showError((Component)((Object)this), (String)ResourceUtils.getMessageForClient((String)RESOURCE, (String)"FORMULA_TOO_LONG", (String[])new String[]{"0"}));
                this.abort();
            }
            this.removeText(0, str.length());
            this.insertText(0, str, Color.BLACK);
            this.checkMaterial(str);
            double d = this.checkFormulaCalc(str);
        }
    }

    private void verifyNameNumber() {
        if (this.txtName.getEditor().getItem().toString().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessageForClient((String)RESOURCE, (String)"NAME_NOT_NULL", (String[])new String[]{"0"}));
            this.abort();
        }
    }

    protected void insertText(int index, String str, Color color) throws BOSException {
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setForeground(set, color);
        StyledDocument doc = this.txtPaneFormula.getStyledDocument();
        try {
            doc.insertString(index, str, set);
        }
        catch (BadLocationException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void removeText(int index, int length) throws BOSException {
        StyledDocument doc = this.txtPaneFormula.getStyledDocument();
        try {
            doc.remove(index, length);
        }
        catch (BadLocationException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void fillKDTable(QueryInfo queryInfo, KDTable tbl) {
        SelectorInfo selectorInfo = queryInfo.getSelector();
        int fieldsCount = selectorInfo.getFields().size();
        String[] bindFieldNames = new String[fieldsCount];
        StringBuffer filterDisplayNameBuffer = new StringBuffer();
        StringBuffer filterNameBuffer = new StringBuffer();
        String f7WindowTitle = null;
        Map extendProps = queryInfo.getExtendedProperties();
        if (extendProps != null) {
            Object title = extendProps.get("F7WindowTitle");
            if (title != null) {
                title = extendProps.get("f7WindowTitle");
            }
            if (title instanceof String) {
                f7WindowTitle = EASResource.getString((String)((String)title));
            }
        }
        QueryFieldInfo fieldInfo = null;
        for (int i = 0; i < fieldsCount; ++i) {
            Object queryFilter;
            String format;
            fieldInfo = (QueryFieldInfo)selectorInfo.getFields().get(i);
            extendProps = fieldInfo.getExtendedProperties();
            bindFieldNames[i] = fieldInfo.getName();
            IColumn column = tbl.addColumn(i);
            column.setKey(bindFieldNames[i]);
            if (extendProps == null) continue;
            Object visible = extendProps.get("isVisibleForKDTable");
            if (visible instanceof Boolean) {
                column.getStyleAttributes().setHided((Boolean)visible == false);
            } else if (visible instanceof String) {
                column.getStyleAttributes().setHided(!SOPCheckFormulaEditUI.stringToBoolean((String)visible));
            }
            Object colWidth = extendProps.get("ColWidthInKDTable");
            if (colWidth == null) {
                colWidth = extendProps.get("colWidthInKDTable");
            }
            if (colWidth instanceof Integer) {
                column.setWidth(((Integer)colWidth).intValue());
            } else if (colWidth instanceof String) {
                column.setWidth(Integer.parseInt((String)colWidth));
            }
            Object colFormat = extendProps.get("displayFormat");
            if (colFormat != null && colFormat instanceof String && !StringUtil.isEmptyString((String)(format = (String)colFormat))) {
                column.getStyleAttributes().setNumberFormat(format);
            }
            if ((queryFilter = extendProps.get("isCommonQueryFilter")) == null) continue;
            String filter = (String)queryFilter;
            ConstDataType returnType = null;
            try {
                returnType = fieldInfo.getReturnType();
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            if (StringUtil.isEmptyString((String)filter) || !SOPCheckFormulaEditUI.stringToBoolean(filter) || returnType != ConstDataType.STRING) continue;
            filterDisplayNameBuffer.append(fieldInfo.getDisplayName() + ",");
            filterNameBuffer.append(fieldInfo.getName() + ",");
        }
        tbl.putBindContents("query", bindFieldNames);
        tbl.setFormatXml("");
        tbl.checkParsed(true);
        filterDisplayName = filterDisplayNameBuffer.toString().split(",");
        filterName = filterNameBuffer.toString().split(",");
        IRow row = tbl.addHeadRow();
        for (int i = 0; i < fieldsCount; ++i) {
            fieldInfo = (QueryFieldInfo)selectorInfo.getFields().get(i);
            String displayName = fieldInfo.getDisplayName(SysContext.getSysContext().getOriginLocale());
            row.getCell(i).setValue((Object)displayName);
        }
    }

    private static boolean stringToBoolean(String value) {
        return value == null || !value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("0");
    }

    private void getMaterials(String orgUnitId) {
        this.materialMap = new HashMap();
        String number = new String();
        String name = new String();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        MetaDataPK query = new MetaDataPK("com.kingdee.eas.basedata.master.material.app.F7MaterialPlanGroupQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)query);
        exec.setObjectView(viewInfo);
        try {
            IRowSet rows = exec.executeQuery();
            while (rows.next()) {
                number = rows.getString("number");
                name = rows.getString("name");
                if (this.materialMap == null || this.materialMap.containsKey(number)) continue;
                this.materialMap.put(number, name);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private void checkMaterial(String formula) throws BOSException {
        String formulaDesc = formula;
        int n = formula.length();
        for (int i = 0; i < n; ++i) {
            String s;
            int begin = formula.indexOf(this.materialFlag[0], i);
            int end = formula.indexOf(this.materialFlag[1], i);
            if (begin < 0 || end < 0) {
                if (i > 0) break;
                MsgBox.showError((Component)((Object)this), (String)ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_NOMATERIAL"));
                this.abort();
            }
            if (this.materialMap.containsKey(s = formula.substring(begin + 1, end))) {
                this.removeText(begin + 1, s.length());
                this.insertText(begin + 1, s, Color.BLUE);
                i = end;
                continue;
            }
            this.removeText(begin + 1, s.length());
            this.insertText(begin + 1, s, Color.RED);
            MsgBox.showError((Component)((Object)this), (String)ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_ISNOTMATERIAL", (String[])new String[]{s}));
            this.abort();
        }
        this.editData.setCalcFormulaDesc(formulaDesc);
        formulaDesc = this.cmbCheckType.getSelectedItem().equals((Object)CheckTypeEnum.LESSEQUALS) ? formulaDesc + CheckTypeEnum.LESSEQUALS.getAlias() + this.txtCheckValue.getBigDecimalValue().setScale(6, 4).toString() : formulaDesc + ResourceUtils.getMessageForClient((String)RESOURCE, (String)"FORMULADESC_ROUND", (String[])new String[]{this.txtCheckValue.getBigDecimalValue().toString()});
        if (formulaDesc.length() >= 1024) {
            MsgBox.showError((Component)((Object)this), (String)ResourceUtils.getMessageForClient((String)RESOURCE, (String)"FORMULADESC_TOO_LONG", (String[])new String[]{"0"}));
            this.abort();
        }
        this.txtformulaDesc.setText(formulaDesc);
        this.editData.setFormulaDesc(formulaDesc);
    }

    private void checkValue(BigDecimal value) {
        if (value.compareTo(new BigDecimal(0)) <= 0) {
            MsgBox.showInfo((String)ResourceUtils.getMessageForClient((String)RESOURCE, (String)"VALUE_SHOULD_GREATER_ZERO", (String[])new String[]{this.txtCheckValue.getBigDecimalValue().toString()}));
            this.abort();
        }
    }

    private double checkFormulaCalc(String formula) {
        StringBuffer sb = new StringBuffer(formula);
        int qty = 1;
        while (sb.length() > 0) {
            int begin = sb.indexOf(this.materialFlag[0]);
            int end = sb.indexOf(this.materialFlag[1]);
            if (begin < 0 || end < 0) break;
            sb = sb.replace(begin, end + 1, String.valueOf(qty++));
        }
        FormulaParserUtil fp = new FormulaParserUtil(sb.toString());
        try {
            return fp.getResult(true);
        }
        catch (BOSException e) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_UNKNOWN"), (String)e.getMessage(), (int)0);
            this.abort();
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        boolean isSuccess = false;
        try {
            this.pubFireVOChangeListener(this.editData.getId().toString());
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
            ((ISOPCheckFormula)this.getBizInterface()).approve((IObjectPK)pk);
            this.setOprtState("VIEW");
            CacheServiceFactory.getInstance().discardType(this.editData.getBOSType());
            this.setDataObject(this.getValue((IObjectPK)pk));
            this.setSave(true);
            this.setSaved(true);
            isSuccess = true;
        }
        catch (EASBizException ex) {
            MsgBox.showError((String)ex.getMessage());
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(this.editData.getId().toString());
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        this.setOprtState("VIEW");
        if (isSuccess) {
            this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.mm.basedata.TransactionTypeResource.AuditSuccess"));
            this.editData.setStatus(BDStatusEnum.APPROVE);
            this.loadFields();
            this.initDataStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnapprove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        String id = null;
        if (this.editData.getId() == null) {
            MsgBox.showError((String)SaleUtil.getUIResource((String)"ORDER_ADDNEWCANNOT_OPERATOR"));
            return;
        }
        id = this.editData.getId().toString();
        boolean isSuccess = false;
        try {
            this.pubFireVOChangeListener(id);
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
            ((ISOPCheckFormula)this.getBizInterface()).unapprove((IObjectPK)pk);
            this.setOprtState("VIEW");
            CacheServiceFactory.getInstance().discardType(this.editData.getBOSType());
            this.setDataObject(this.getValue((IObjectPK)pk));
            this.setSave(true);
            this.setSaved(true);
            isSuccess = true;
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        this.setOprtState("VIEW");
        if (isSuccess) {
            this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.mm.basedata.TransactionTypeResource.UnAuditSuccess"));
            this.editData.setStatus(BDStatusEnum.UNAPPROVE);
            this.loadFields();
            this.initDataStatus();
        }
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(msgResource);
        this.showMessage();
    }

    protected void verifyInput(ActionEvent e) {
        this.verifyNameNumber();
        try {
            this.verifyFormula();
        }
        catch (Exception exc) {
            this.abort();
        }
        this.checkValue(this.txtCheckValue.getBigDecimalValue());
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue model) {
        SOPCheckFormulaInfo info = (SOPCheckFormulaInfo)model;
        super.setFieldsNull((AbstractObjectValue)info);
        info.setStatus(BDStatusEnum.UNAPPROVE);
        info.setName(null);
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
    }

    public IF7ContextChange getF7ContextManager() {
        return (MMF7ContextManager)this.getF7Register();
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtStorageOrgUnit;
    }

    public String getMainOrgKeyForCustomerParams(OrgType orgType) {
        return "storageOrgUnit.id";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    public String getPermissionItem() {
        String status = this.getOprtState();
        if ("ADDNEW".equals(status)) {
            return "mm_operation_addnew";
        }
        if ("EDIT".equals(status)) {
            return "mm_operation_update";
        }
        if ("VIEW".equals(status)) {
            return "mm_operation_view";
        }
        return null;
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    public Context getMainContext() {
        return this.getMainOrgContext();
    }

    public IF7Register getF7Register() {
        return null;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if (this.idList.size() == 0) {
            this.unLockUI();
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
    }

    protected void doBeforeSave(ActionEvent e) throws Exception {
        super.doBeforeSave(e);
    }
}

