/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.planning.CheckTypeEnum;
import com.kingdee.eas.mm.planning.SOPCheckFormulaException;
import com.kingdee.eas.mm.planning.SOPCheckFormulaFactory;
import com.kingdee.eas.mm.planning.SOPCheckFormulaInfo;
import com.kingdee.eas.mm.planning.client.AbstractSOPCheckFormulaListUI;
import com.kingdee.eas.mm.planning.client.SOPCheckFormulaEditUI;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.action.ISupportObjContext;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SOPCheckFormulaListUI
extends AbstractSOPCheckFormulaListUI
implements ISupportObjContext,
IMultiOrgSupport,
ISupportBatchAction {
    private static final Logger logger = CoreUIObject.getLogger(SOPCheckFormulaListUI.class);
    public static final String RESOURCE = "com.kingdee.eas.mm.planning.SOPCheckFormulaResource";
    private static final String[] KDT_DATES = new String[]{"createTime", "lastUpdateTime"};

    public void onShow() throws Exception {
        super.onShow();
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SOPCheckFormulaFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        SOPCheckFormulaInfo info = new SOPCheckFormulaInfo();
        info.setStatus(BDStatusEnum.UNAPPROVE);
        info.setStorageOrgUnit((StorageOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType()));
        info.setCheckType(CheckTypeEnum.LESSEQUALS);
        info.setTolerances(new BigDecimal("0.0"));
        info.setCheckValue(new BigDecimal("0.0"));
        return info;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        String actionName = (String)this.actionApprove.getValue("Name");
        this.bacthExecute(e, "approve", actionName);
    }

    @Override
    public void actionUnapprove_actionPerformed(ActionEvent e) throws Exception {
        String actionName = (String)this.actionUnapprove.getValue("Name");
        this.bacthExecute(e, "unapprove", actionName);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String actionName = (String)this.actionRemove.getValue("Name");
        this.batchRemove(e, "delete", actionName);
    }

    private void batchRemove(ActionEvent e, String action, String actionName) throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        ArrayList<String> deleteIDs = new ArrayList<String>();
        HashSet<String> storageIDS = new HashSet<String>();
        StringBuffer storageNumber = new StringBuffer("");
        StorageOrgUnitInfo storageInfo = null;
        StringBuffer buffer = new StringBuffer("");
        ObjectUuidPK orgPK = null;
        ObjectStringPK storagePK = null;
        ArrayList<BatchExecuteParamsEntry> paramEntry = new ArrayList<BatchExecuteParamsEntry>();
        Map NumberOrg = this.getSelectColumnValue(this.tblMain, "id", this.getNumberColumn());
        Map orgId = this.getSelectColumnValue(this.tblMain, "id", "storageOrgUnit.id");
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        IObjectPK[] orgPKs = new IObjectPK[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            orgPK = new ObjectUuidPK(orgId.get(ids.get(i)).toString());
            orgPKs[i] = orgPK;
        }
        try {
            Set permission = PermissionFactory.getRemoteInstance().checkBatchPermission((IObjectPK)userPK, orgPKs, "mm_sopcheckformula_delete");
            for (int i = 0; i < ids.size(); ++i) {
                if (permission.contains(orgId.get(ids.get(i)))) {
                    deleteIDs.add(ids.get(i).toString());
                    ObjectStringPK pk = new ObjectStringPK(ids.get(i).toString());
                    BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
                    paramEntry.add(entry);
                    continue;
                }
                buffer.append(NumberOrg.get(ids.get(i).toString()));
                buffer.append(",");
                if (storageIDS.contains(orgId.get(ids.get(i)).toString())) continue;
                storagePK = new ObjectStringPK(orgId.get(ids.get(i)).toString());
                storageInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)storagePK);
                storageNumber.append(storageInfo.getNumber());
                storageNumber.append(",");
                storageIDS.add(orgId.get(ids.get(i)).toString());
            }
            if (buffer.length() >= 1) {
                buffer.deleteCharAt(buffer.length() - 1);
                storageNumber.deleteCharAt(storageNumber.length() - 1);
                String errorMessenge = buffer.toString();
                buffer.delete(0, buffer.length());
                buffer.append(this.getResource("HAS_NOT_DELETE_FUCTION", new String[]{errorMessenge, storageNumber.toString()}));
            }
            BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[paramEntry.size()];
            for (int i = 0; i < paramEntry.size(); ++i) {
                paramEntries[i] = (BatchExecuteParamsEntry)paramEntry.get(i);
            }
            try {
                if (paramEntry.size() > 0) {
                    BatchExecuteResult result = this.getBizInterface().batchExecute(action, new Class[]{IObjectPK.class}, paramEntries);
                    Throwable[] ex = result.getExceptions();
                    for (int i = 0; i < ex.length; ++i) {
                        if (ex[i] == null) continue;
                        if (buffer.length() > 0) {
                            buffer.append(" \n ");
                            buffer.append(NumberOrg.get(deleteIDs.get(i)));
                            buffer.append(ex[i].getMessage());
                            continue;
                        }
                        buffer.append(NumberOrg.get(deleteIDs.get(i)));
                        buffer.append(ex[i].getMessage());
                    }
                }
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        if (buffer.length() > 0) {
            String deleteError = ResourceUtils.getMessage((String)RESOURCE, (String)"LISTUI_OPRFAIL", (String[])new String[]{actionName});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)buffer.toString(), (int)8188);
        }
        this.refresh(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bacthExecute(ActionEvent e, String action, String actionName) throws Exception {
        this.checkSelected();
        Throwable[] ex = null;
        HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
        ArrayList ids = this.getSelectedIdValues();
        ArrayList<String> exceptionIds = new ArrayList<String>();
        Map mapNumber = this.getSelectColumnValue(this.tblMain, this.getKeyFieldName(), this.getNumberColumn());
        Map rowNumberMap = null;
        if (mapNumber.isEmpty()) {
            rowNumberMap = this.getSelectRowNumberMap(this.tblMain, this.getKeyFieldName());
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)ids);
            Iterator lt = ids.iterator();
            while (lt.hasNext()) {
                String id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
                exceptionMap.put(id, mutexException);
                exceptionIds.add(id);
                lt.remove();
            }
            if (ids.size() > 0) {
                BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[ids.size()];
                for (int i = 0; i < ids.size(); ++i) {
                    BatchExecuteParamsEntry entry;
                    if (ids.get(i) == null) continue;
                    ObjectStringPK pk = new ObjectStringPK(ids.get(i).toString());
                    paramEntries[i] = entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
                }
                BatchExecuteResult result = this.getBizInterface().batchExecute(action, new Class[]{IObjectPK.class}, paramEntries);
                ex = result.getExceptions();
                for (int i = 0; i < ex.length; ++i) {
                    if (ex[i] == null) continue;
                    if (ex[i] instanceof ObjectNotFoundException) {
                        exceptionMap.put((String)ids.get(i), (Throwable)((Object)new SOPCheckFormulaException(SOPCheckFormulaException.DATANOTEXIST)));
                    } else {
                        exceptionMap.put((String)ids.get(i), ex[i]);
                    }
                    exceptionIds.add((String)ids.get(i));
                }
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
        }
        StringBuffer errorMsg = new StringBuffer();
        for (String id : exceptionIds) {
            if (mapNumber.isEmpty()) {
                errorMsg.append(ResourceUtils.getMessage((String)RESOURCE, (String)"ERROR_MESSANGE", (String[])new String[]{rowNumberMap.get(id).toString(), actionName}));
            } else {
                errorMsg.append(ResourceUtils.getMessage((String)RESOURCE, (String)"ERROR_MESSANGE", (String[])new String[]{mapNumber.get(id).toString(), actionName}));
            }
            if (ex != null) {
                errorMsg.append(ExceptionMessageUtility.getMessage((Throwable)((Throwable)exceptionMap.get(id))) + "\n");
                continue;
            }
            errorMsg.append("\n");
        }
        if (exceptionIds.size() > 0) {
            String deleteError = ResourceUtils.getMessage((String)RESOURCE, (String)"LISTUI_OPRFAIL", (String[])new String[]{actionName});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)errorMsg.toString(), (int)8188);
        }
        this.refresh(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setVisible(true);
        this.btnAddNew.setEnabled(true);
        this.btnEdit.setVisible(true);
        this.btnEdit.setEnabled(true);
        this.btnRemove.setVisible(true);
        this.btnRemove.setEnabled(true);
    }

    @Override
    protected String getEditUIName() {
        return SOPCheckFormulaEditUI.class.getName();
    }

    protected String getNumberColumn() {
        return "number";
    }

    public Map getSelectColumnValue(KDTable table, String keyColumnName, String valueColumnName) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (valueColumnName == null || valueColumnName.equals("")) {
            return map;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = table.getRow(selectRows[i]);
            ICell keyCell = null;
            ICell valueCell = null;
            if (row != null) {
                keyCell = row.getCell(keyColumnName);
                valueCell = row.getCell(valueColumnName);
            }
            if (keyCell == null || keyCell.getValue() == null || valueCell == null || valueCell.getValue() == null || map.containsKey(keyCell.getValue().toString())) continue;
            map.put(keyCell.getValue().toString(), valueCell.getValue().toString());
        }
        return map;
    }

    public Map getSelectRowNumberMap(KDTable table, String fieldName) {
        HashMap<String, Integer> rowNumberMap = new HashMap<String, Integer>();
        if (table != null) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
            IRow row = null;
            ICell keyCell = null;
            if (selectRows != null) {
                for (int i = 0; i < selectRows.length; ++i) {
                    row = table.getRow(selectRows[i]);
                    if (row != null) {
                        keyCell = row.getCell(fieldName);
                    }
                    if (keyCell == null) continue;
                    rowNumberMap.put(keyCell.getValue().toString(), new Integer(selectRows[i] + 1));
                }
            }
        }
        return rowNumberMap;
    }

    public Context getMainContext() {
        return this.getMainOrgContext();
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
    }

    public IF7ContextChange getF7ContextManager() {
        return null;
    }

    public IF7Register getF7Register() {
        return null;
    }

    public KDBizPromptBox getMainOrg() {
        return null;
    }

    public String getMainOrgKeyForCustomerParams(OrgType orgType) {
        return "storageOrgUnit.id";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    public String getPermissionItem() {
        return "mm_sopcheckformula_view";
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    protected String getOrgFieldName() {
        return "storageOrgUnit.id";
    }

    public void afterAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) {
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        return false;
    }

    public void doActionPerformed(BatchActionEnum bizAction, BatchSelectionEntries selectionEntry) {
    }

    public void handleBatchException(ActionProxy actionProxy, BatchSelectionEntries selectionEntry) throws Exception {
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void refresh(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) throws Exception {
    }

    private String getResource(String key, String[] params) {
        return ResourceUtils.getMessage((String)RESOURCE, (String)key, (String[])params);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        FilterInfo storageOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"storageOrgUnit.id", (String)"mm_sopcheckformula_view");
        try {
            filter.mergeFilter(storageOrgFilter, "AND");
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return filter;
    }
}

