/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.ISOPPermissionFacade;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPPermissionFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPlanVersionFactory;
import com.kingdee.eas.mm.planning.SOPPlanVersionInfo;
import com.kingdee.eas.mm.planning.SOPSysParams;
import com.kingdee.eas.mm.planning.client.AbstractSOPFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class SOPFilterUI
extends AbstractSOPFilterUI {
    DataChangeListener storageOrgUnitDataChanged = null;
    private static final long serialVersionUID = 18646546464L;
    private static final Logger logger = CoreUIObject.getLogger(SOPFilterUI.class);
    private HashMap contextHashMap = null;
    private static final String SALE_PERMISSION = "mm_sopsaleplan_view";
    private static final String PRODUCT_PERMISSION = "mm_sopprodplan_view";
    private static boolean isPermissionSale = false;
    private static boolean isPermissionProduct = false;
    private SOPPeriod curPeriod;
    private SOPSysParams SOPParams;
    private SOPPeriod[] periods;
    private CustomerParams cp = null;
    private int horizon = 0;
    private ISOPFacade sopFacade = null;

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.prmtPlannedVersion.setValue(this.getDefaultPlanVersion());
    }

    private Object getDefaultPlanVersion() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        viewInfo.setSelector(selectors);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"000", CompareType.EQUALS));
        filterInfo.setMaskString("#0");
        viewInfo.setFilter(filterInfo);
        Object[] reqTypes = null;
        try {
            CoreBaseCollection c = SOPPlanVersionFactory.getRemoteInstance().getCollection(viewInfo);
            reqTypes = c.toArray();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return reqTypes[0];
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtstorageOrgUnit;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)strKey);
    }

    public final void setContextHashMap(HashMap value) {
        this.contextHashMap = value;
    }

    public final HashMap getContextHashMap() {
        return this.contextHashMap;
    }

    public void clear() {
        super.clear();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtstorageOrgUnit.removeDataChangeListener(this.storageOrgUnitDataChanged);
        OrgUnitInfo[] sop = this.getMainOrgs();
        HashSet<String> filterSet = new HashSet<String>();
        String[] str = new String[]{SALE_PERMISSION, PRODUCT_PERMISSION};
        for (int i = 0; i < sop.length; ++i) {
            OrgUnitInfo info = sop[i];
            Map filterMap = this.isFilterPermission(str, info);
            Boolean str1 = (Boolean)filterMap.get(str[0]);
            Boolean str2 = (Boolean)filterMap.get(str[1]);
            if (!str1.booleanValue() && !str2.booleanValue()) continue;
            filterSet.add(info.getId().toString());
        }
        this.prmtstorageOrgUnit.setEntityViewInfo(this.getMainOrgUnitFilter(filterSet));
        this.prmtstorageOrgUnit.addDataChangeListener(this.storageOrgUnitDataChanged);
        this.sopFacade = SOPFacadeFactory.getRemoteInstance();
        this.storageOrgUnitDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                SOPFilterUI.this.prmtProductionOrgUnit_dataChanged(e);
            }
        };
        this.prmtstorageOrgUnit.addDataChangeListener(this.storageOrgUnitDataChanged);
        this.cmbEditMode.removeAllItems();
        this.cmbEditMode.addItems(new Object[]{SOPEditModeEnum.MONTHLY, SOPEditModeEnum.WEEKLY});
        this.cmbEditMode.setSelectedItem((Object)SOPEditModeEnum.MONTHLY);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("org", (Component)this.prmtstorageOrgUnit);
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("executStorageOrg", (Component)this.prmtSupplyOrgUnit));
        elements.add((FilterElement)new SingleFilterElement("matFrom", (Component)this.prmtmaterialNumFrom));
        elements.add((FilterElement)new SingleFilterElement("matTo", (Component)this.prmtmaterialNumTo));
        MMUtils.filterRangF7Helper((Component)this.prmtmaterialNumFrom, (Component)this.prmtmaterialNumTo);
        elements.add((FilterElement)new SingleFilterElement("planVersion", (Component)this.prmtPlannedVersion));
        elements.add((FilterElement)new SingleFilterElement("numOfPeriod", (Component)this.sprNumberOfTerm));
        SingleFilterElement editMode = new SingleFilterElement("sopeditmode", (Component)this.cmbEditMode);
        editMode.setDefaultValue((Object)SOPEditModeEnum.MONTHLY);
        elements.add((FilterElement)editMode);
        this.setMaterialFilter();
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtmaterialNumFrom, this.prmtmaterialNumTo, this.prmtPlannedVersion});
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstorageOrgUnit, (OrgType)OrgType.Storage, null);
        this.prmtmaterialNumFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (SOPFilterUI.this.prmtstorageOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)SOPFilterUI.this.getResource("PLEASE_INPUT_ORGUNIT"));
                    SOPFilterUI.this.prmtstorageOrgUnit.requestFocus();
                    e.setCanceled(true);
                }
            }
        });
        this.prmtmaterialNumTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (SOPFilterUI.this.prmtstorageOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)SOPFilterUI.this.getResource("PLEASE_INPUT_ORGUNIT"));
                    SOPFilterUI.this.prmtstorageOrgUnit.requestFocus();
                    e.setCanceled(true);
                }
            }
        });
        this.prmtSupplyOrgUnit.setEnabledMultiSelection(true);
        this.setSupplyOrgUnitFilter();
    }

    private void setMaterialFilter() {
        String queryInfo = UIHelper.getMaterialPlanQueryForSopFilter((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.prmtmaterialNumFrom, false, queryInfo);
        this.setBizMaterialF7(this.prmtmaterialNumTo, false, queryInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        if (storageOrgUnitInfo == null) {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)" ", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageOrgUnitInfo.getId(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("plan.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtmaterialNumTo.setEntityViewInfo(view);
        this.prmtmaterialNumFrom.setEntityViewInfo(view);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        Object stotageInfo = null;
        stotageInfo = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        pp.addCustomerParam("storageOrgUnit.id", stotageInfo.getId().toString());
        pp.addCustomerParam("storageOrgUnit.name", stotageInfo.getName().toString());
        String supplyOrgUnit = null;
        if (this.prmtSupplyOrgUnit.getText() != null && !this.prmtSupplyOrgUnit.getText().equals("")) {
            supplyOrgUnit = ((OrgUnitInfo)this.prmtSupplyOrgUnit.getValue()).getNumber();
        }
        pp.addCustomerParam("supplyOrgUnit.number", supplyOrgUnit);
        SOPPlanVersionInfo planVersionInfo = (SOPPlanVersionInfo)this.prmtPlannedVersion.getValue();
        pp.addCustomerParam("planVersion.id", planVersionInfo.getId().toString());
        if (planVersionInfo.getName() == null) {
            planVersionInfo.setName("");
        }
        pp.addCustomerParam("planVersion.name", planVersionInfo.getName().toString());
        pp.addCustomerParam("planVersion.isActivation", String.valueOf(planVersionInfo.isActivation()));
        SOPPeriod selectePeriod = (SOPPeriod)this.cmbSOPPlanTerm.getSelectedItem();
        pp.putDate("selectePeriod.beginDate", selectePeriod.getBeginDate().getTime());
        pp.putDate("selectePeriod.endDate", selectePeriod.getEndDate().getTime());
        pp.putInt("selectePeriod.year", selectePeriod.getYear());
        pp.putInt("selectePeriod.number", selectePeriod.getNumber());
        pp.putInt("selectePeriod.paramMonthStartDay", selectePeriod.getParamMonthStartDay());
        int editMode = 0;
        if (this.cmbEditMode.getSelectedItem().equals((Object)SOPEditModeEnum.WEEKLY)) {
            editMode = 10;
        }
        if (this.cmbEditMode.getSelectedItem().equals((Object)SOPEditModeEnum.MONTHLY)) {
            editMode = 20;
        }
        pp.putInt("cmbEditMode", editMode);
        pp.putInt("numOfPeriod", Integer.parseInt(this.sprNumberOfTerm.getValue().toString()));
        int planType = 0;
        if (this.productType.isSelected()) {
            planType = 2;
        }
        if (this.saleType.isSelected()) {
            planType = 1;
        }
        if (this.saleAndProductType.isSelected()) {
            planType = 3;
        }
        pp.addCustomerParam("currentPlanType", new Integer(planType).toString());
        return pp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        if (this.cp.getCustomerParam("prmtSupplyOrgUnit") != null && this.cp.getCustomerParam("prmtSupplyOrgUnit").length() != 0) {
            String supplyOrgUnit = this.cp.getCustomerParam("prmtSupplyOrgUnit");
            this.prmtSupplyOrgUnit.setText(supplyOrgUnit);
        }
        if (this.cp.getCustomerParam("prmtPlannedVersion") != null) {
            SOPPlanVersionInfo planVersionInfo = new SOPPlanVersionInfo();
            planVersionInfo.setActivation(this.cp.getBoolean("planVersion.isActivation"));
            planVersionInfo.setName(this.cp.getCustomerParam("planVersion.name"));
            planVersionInfo.setNumber(this.cp.getCustomerParam("prmtPlannedVersion"));
            planVersionInfo.setId(BOSUuid.read((String)this.cp.getCustomerParam("planVersion.id")));
            this.prmtPlannedVersion.setValue((Object)planVersionInfo);
            StorageOrgUnitInfo storageInfo = new StorageOrgUnitInfo();
            storageInfo.setId(BOSUuid.read((String)this.cp.getCustomerParam("storageOrgUnit.id")));
            storageInfo.setName(this.cp.getCustomerParam("storageOrgUnit.name"));
            storageInfo.setNumber(this.cp.getCustomerParam("prmtstorageOrgUnit"));
            this.prmtstorageOrgUnit.setValue((Object)storageInfo);
            if (this.SOPParams == null) {
                try {
                    if (this.sopFacade == null) {
                        this.sopFacade = SOPFacadeFactory.getRemoteInstance();
                    }
                    this.SOPParams = this.sopFacade.getSOPSysParams(storageInfo.getId().toString());
                    if (this.SOPParams == null) {
                        MsgBox.showInfo((String)this.getResource("THE_OQG_HAS_NOT_PAREMS"));
                        SysUtil.abort();
                    }
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
            SOPEditModeEnum editmode = null;
            if (Integer.parseInt(this.cp.getCustomerParam("cmbEditMode").toString()) == 20) {
                editmode = SOPEditModeEnum.MONTHLY;
                this.horizon = this.SOPParams.getSOPMonthHorizon();
            }
            if (Integer.parseInt(this.cp.getCustomerParam("cmbEditMode").toString()) == 10) {
                editmode = SOPEditModeEnum.WEEKLY;
                this.horizon = this.SOPParams.getSOPMonthHorizon();
            }
            if (this.curPeriod == null) {
                try {
                    if (this.sopFacade == null) {
                        this.sopFacade = SOPFacadeFactory.getRemoteInstance();
                    }
                    this.curPeriod = this.sopFacade.getCurrentPeriod(editmode, storageInfo.getId().toString());
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
            Object selectePeriod = new SOPPeriod();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.cp.getDate("selectePeriod.beginDate"));
            ((SOPPeriod)selectePeriod).setBeginDate(calendar);
            calendar.setTime(this.cp.getDate("selectePeriod.endDate"));
            ((SOPPeriod)selectePeriod).setEndDate(calendar);
            ((SOPPeriod)selectePeriod).setNumber(this.cp.getInt("selectePeriod.number"));
            ((SOPPeriod)selectePeriod).setYear(this.cp.getInt("selectePeriod.year"));
            ((SOPPeriod)selectePeriod).setParamMonthStartDay(this.cp.getInt("selectePeriod.paramMonthStartDay"));
            ((SOPPeriod)selectePeriod).setType(editmode);
            this.cmbEditMode.removeAllItems();
            this.cmbEditMode.addItems(new Object[]{SOPEditModeEnum.MONTHLY, SOPEditModeEnum.WEEKLY});
            if (this.cp.getCustomerParam("cmbEditMode").toString().equals(new Integer(20).toString())) {
                this.cmbEditMode.setSelectedItem((Object)SOPEditModeEnum.MONTHLY);
            } else {
                this.cmbEditMode.setSelectedItem((Object)SOPEditModeEnum.WEEKLY);
            }
            Object[] periods = null;
            try {
                periods = this.curPeriod.periodRange(this.horizon);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.cmbSOPPlanTerm.removeAllItems();
            this.cmbSOPPlanTerm.addItems(periods);
            Object minPeriod = periods[0];
            Object maxPeriod = periods[this.horizon + this.horizon - 2];
            if (((SOPPeriod)maxPeriod).toNumber() < ((SOPPeriod)selectePeriod).toNumber()) {
                selectePeriod = maxPeriod;
            }
            if (((SOPPeriod)minPeriod).toNumber() > ((SOPPeriod)selectePeriod).toNumber()) {
                selectePeriod = minPeriod;
            }
            this.cmbSOPPlanTerm.setSelectedItem(selectePeriod);
            this.SetSpinnerMaxMin((JSpinner)this.sprNumberOfTerm, 1, this.horizon);
            int numOfPeriod = this.cp.getInt("numOfPeriod");
            if (numOfPeriod > this.horizon) {
                numOfPeriod = this.horizon;
            }
            this.sprNumberOfTerm.setValue((Object)new Integer(numOfPeriod));
            this.prmtmaterialNumFrom.setText(this.cp.getCustomerParam("prmtmaterialNumFrom"));
            this.prmtmaterialNumTo.setText(this.cp.getCustomerParam("prmtmaterialNumTo"));
            int planType = Integer.parseInt(this.cp.getCustomerParam("currentPlanType"));
            if (planType == 2) {
                this.productType.setSelected(true);
            }
            if (planType == 1) {
                this.saleType.setSelected(true);
            }
            if (planType == 3) {
                this.saleAndProductType.setSelected(true);
            }
        }
    }

    public RptParams getCustomCondition() {
        int selectNum;
        SOPPlanVersionInfo planVersionInfo;
        RptParams pp = super.getCustomCondition();
        Object stotageInfo = null;
        Object[] supplyOrgUnit = null;
        ArrayList<String> supplyOrgUnitNumList = new ArrayList<String>();
        stotageInfo = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        if (stotageInfo != null) {
            pp.setString("storageOrgUnit.id", stotageInfo.getId().toString());
            pp.setString("storageOrgUnit.name", stotageInfo.getName().toString());
            pp.setString("org", stotageInfo.getNumber());
        }
        if (!(this.prmtSupplyOrgUnit.getValue() instanceof String) && this.prmtSupplyOrgUnit.getValue() != null && ((Object[])this.prmtSupplyOrgUnit.getValue()).length != 0 && ((Object[])this.prmtSupplyOrgUnit.getValue())[0] != null) {
            supplyOrgUnit = (Object[])this.prmtSupplyOrgUnit.getValue();
            if (supplyOrgUnit != null) {
                for (int i = 0; i < supplyOrgUnit.length; ++i) {
                    supplyOrgUnitNumList.add(((OrgUnitInfo)supplyOrgUnit[i]).getNumber());
                }
            }
            pp.setObject("supplyOrgUnit.number", supplyOrgUnitNumList);
        }
        if ((this.prmtSupplyOrgUnit.getValue() == null || this.prmtSupplyOrgUnit.getValue() instanceof String) && this.prmtSupplyOrgUnit.getText().length() > 0) {
            String[] supplyOrgNumber = this.prmtSupplyOrgUnit.getText().trim().split(";");
            if (supplyOrgNumber.length > 0) {
                for (int i = 0; i < supplyOrgNumber.length; ++i) {
                    supplyOrgUnitNumList.add(supplyOrgNumber[i].trim());
                }
            }
            pp.setObject("supplyOrgUnit.number", supplyOrgUnitNumList);
        }
        if ((planVersionInfo = (SOPPlanVersionInfo)this.prmtPlannedVersion.getValue()) != null) {
            pp.setObject("planVersion.id", (Object)planVersionInfo.getId().toString());
            if (planVersionInfo.getName() == null) {
                planVersionInfo.setName("");
            }
            pp.setString("planVersion.name", planVersionInfo.getName().toString());
            pp.setBoolean("planVersion.isActivation", planVersionInfo.isActivation());
            pp.setString("planVersion", planVersionInfo.getNumber());
        }
        pp.setObject("curPeriod.beginDate", (Object)this.curPeriod.getBeginDate());
        pp.setObject("curPeriod.endDate", (Object)this.curPeriod.getEndDate());
        pp.setInt("curPeriod.year", this.curPeriod.getYear());
        pp.setInt("curPeriod.number", this.curPeriod.getNumber());
        pp.setInt("curPeriod.paramMonthStartDay", this.curPeriod.getParamMonthStartDay());
        pp.setObject("curSOPPeriod", (Object)this.curPeriod);
        SOPPeriod selectePeriod = (SOPPeriod)this.cmbSOPPlanTerm.getSelectedItem();
        pp.setObject("selectePeriod.beginDate", (Object)selectePeriod.getBeginDate());
        pp.setObject("selectePeriod.endDate", (Object)selectePeriod.getEndDate());
        pp.setInt("selectePeriod.year", selectePeriod.getYear());
        pp.setInt("selectePeriod.number", selectePeriod.getNumber());
        pp.setInt("selectePeriod.paramMonthStartDay", selectePeriod.getParamMonthStartDay());
        pp.setObject("StartSOPPeriod", (Object)selectePeriod);
        int editMode = 0;
        if (this.cmbEditMode.getSelectedItem().toString().equals(SOPEditModeEnum.MONTHLY.getAlias())) {
            editMode = 20;
        }
        if (this.cmbEditMode.getSelectedItem().toString().equals(SOPEditModeEnum.WEEKLY.getAlias())) {
            editMode = 10;
        }
        pp.setString("sopeditmode", new Integer(editMode).toString());
        int planType = 0;
        if (this.productType.isSelected()) {
            planType = 2;
        }
        if (this.saleType.isSelected()) {
            planType = 1;
        }
        if (this.saleAndProductType.isSelected()) {
            planType = 3;
        }
        pp.setString("currentPlanType", new Integer(planType).toString());
        int numOfPeriod = Integer.parseInt(this.sprNumberOfTerm.getValue().toString());
        int select = this.cmbSOPPlanTerm.getSelectedIndex();
        if (select > this.horizon - 1 && this.horizon != 0 && (selectNum = this.horizon - (select - this.horizon + 1)) < numOfPeriod) {
            numOfPeriod = selectNum;
        }
        pp.setInt("numOfPeriod", numOfPeriod);
        MaterialInfo matFromInfo = (MaterialInfo)this.prmtmaterialNumFrom.getValue();
        if (matFromInfo != null) {
            pp.setString("matFrom", matFromInfo.getNumber());
        } else {
            pp.setString("matFrom", this.prmtmaterialNumFrom.getText().trim());
        }
        MaterialInfo matToInfo = (MaterialInfo)this.prmtmaterialNumTo.getValue();
        if (matToInfo != null) {
            pp.setString("matTo", matToInfo.getNumber());
        } else {
            pp.setString("matTo", this.prmtmaterialNumTo.getText().trim());
        }
        pp.setBoolean("isPermissionSale", isPermissionSale);
        pp.setBoolean("isPermissionProduct", isPermissionProduct);
        this.cp = null;
        return pp;
    }

    protected void initListener() {
        super.initListener();
        this.cmbEditMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SOPFilterUI.this.cmbEditMode.getSelectedItem() == null) {
                    return;
                }
                SOPFilterUI.this.loadPlanPeriod();
            }
        });
        this.cmbSOPPlanTerm.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SOPFilterUI.this.cmbEditMode.getSelectedItem() == null) {
                    return;
                }
                if (SOPFilterUI.this.cmbSOPPlanTerm.getSelectedItem() == null) {
                    return;
                }
                int selectIndex = SOPFilterUI.this.cmbSOPPlanTerm.getSelectedIndex();
                SOPFilterUI.this.sprNumberOfTerm.setValue((Object)new Integer(SOPFilterUI.this.horizon * 2 - 1 - selectIndex));
                SOPFilterUI.this.setSpinnerMaxMin((JSpinner)SOPFilterUI.this.sprNumberOfTerm, 1, SOPFilterUI.this.horizon * 2 - 1 - selectIndex);
            }
        });
    }

    private void setSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel && max >= min) {
            ((SpinnerNumberModel)model).setValue(new Integer(1));
            ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }

    private void prmtProductionOrgUnit_dataChanged(DataChangeEvent e) {
        Object newValue = e.getNewValue();
        if (!(newValue instanceof StorageOrgUnitInfo) && !(newValue instanceof FullOrgUnitInfo)) {
            return;
        }
        if (newValue == null || e.getOldValue() == e.getNewValue()) {
            if (newValue == null) {
                this.prmtmaterialNumFrom.setValue(null);
                this.prmtmaterialNumTo.setValue(null);
            }
            return;
        }
        Object orgInfo = null;
        orgInfo = newValue instanceof FullOrgUnitInfo ? (FullOrgUnitInfo)newValue : (StorageOrgUnitInfo)newValue;
        if (orgInfo != null) {
            this.setPlannedType();
            try {
                if (this.sopFacade == null) {
                    this.sopFacade = SOPFacadeFactory.getRemoteInstance();
                }
                this.SOPParams = this.sopFacade.getSOPSysParams(orgInfo.getId().toString());
                if (this.SOPParams == null) {
                    MsgBox.showInfo((String)this.getResource("THE_OQG_HAS_NOT_PAREMS"));
                    this.prmtstorageOrgUnit.setValue(e.getOldValue());
                    return;
                }
            }
            catch (EASBizException e1) {
                this.handUIException(e1);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
            this.prmtmaterialNumFrom.setValue(null);
            this.prmtmaterialNumTo.setValue(null);
            this.loadPlanPeriod();
        }
    }

    private void loadPlanPeriod() {
        if (this.cmbEditMode.getSelectedItem() == null || this.SOPParams == null) {
            return;
        }
        Object info = null;
        info = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        if (info != null) {
            this.horizon = this.cmbEditMode.getSelectedItem().equals((Object)SOPEditModeEnum.MONTHLY) ? this.SOPParams.getSOPMonthHorizon() : this.SOPParams.getSOPWeekHorizon();
            try {
                if (this.sopFacade == null) {
                    this.sopFacade = SOPFacadeFactory.getRemoteInstance();
                }
                this.curPeriod = this.sopFacade.getCurrentPeriod((SOPEditModeEnum)((Object)this.cmbEditMode.getSelectedItem()), info.getId().toString());
                this.periods = this.curPeriod.periodRange(this.horizon);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.cmbSOPPlanTerm.removeAllItems();
            this.cmbSOPPlanTerm.addItems((Object[])this.periods);
            this.cmbSOPPlanTerm.setSelectedItem((Object)this.periods[this.horizon - 1]);
            this.SetSpinnerMaxMin((JSpinner)this.sprNumberOfTerm, 1, this.horizon);
            this.sprNumberOfTerm.setValue((Object)new Integer(this.horizon));
        }
    }

    private void SetSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max >= min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }

    public boolean verify() {
        boolean bRet = true;
        if (this.prmtstorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("STORAGE_ORG_CAN_NOT_BE_NULL"));
            this.prmtstorageOrgUnit.requestFocus();
            return false;
        }
        if (this.prmtPlannedVersion.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("PLANNED_VERSION_CAN_NOT_BE_NULL"));
            this.prmtPlannedVersion.requestFocus();
            return false;
        }
        Object stotageInfo = null;
        stotageInfo = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (FullOrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        if (!this.prmtstorageOrgUnit.getText().equals(stotageInfo.getName())) {
            MsgBox.showError((String)this.getResource("NO_SUCH_ORGUNIT"));
            return false;
        }
        SOPPlanVersionInfo planVersionInfo = (SOPPlanVersionInfo)this.prmtPlannedVersion.getValue();
        if (!this.prmtPlannedVersion.getText().equals(planVersionInfo.getName())) {
            MsgBox.showError((String)this.getResource("NO_SUCH_PLANVERSION"));
            return false;
        }
        Object info = null;
        info = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (FullOrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        String[] orgUnit = new String[]{info.getName()};
        if (this.productType.isSelected() && !isPermissionProduct) {
            String msg = this.getResource("NO_SOP_PRODUCTPLAN_VIEW_PERMISSION");
            MessageFormat msgFmt = new MessageFormat(msg);
            MsgBox.showError((String)msgFmt.format(orgUnit));
            return false;
        }
        if (this.saleType.isSelected()) {
            if (!isPermissionSale) {
                String msg = this.getResource("NO_SOP_SALEPLAN_VIEW_PERMISSION");
                MessageFormat msgFmt = new MessageFormat(msg);
                MsgBox.showError((String)msgFmt.format(orgUnit));
                return false;
            }
        } else if (!(!this.saleAndProductType.isSelected() || isPermissionSale && isPermissionProduct)) {
            if (!isPermissionSale && isPermissionProduct) {
                String msg = this.getResource("NO_SOP_SALEPLAN_VIEW_PERMISSION");
                MessageFormat msgFmt = new MessageFormat(msg);
                MsgBox.showError((String)msgFmt.format(orgUnit));
                return false;
            }
            if (!isPermissionProduct && isPermissionSale) {
                String msg = this.getResource("NO_SOP_PRODUCTPLAN_VIEW_PERMISSION");
                MessageFormat msgFmt = new MessageFormat(msg);
                MsgBox.showError((String)msgFmt.format(orgUnit));
                return false;
            }
            String msg = this.getResource("NO_SOP_PRODUCTPLAN_AND_SALEPLAN_VIEW_PERMISSION");
            MessageFormat msgFmt = new MessageFormat(msg);
            MsgBox.showError((String)msgFmt.format(orgUnit));
            return false;
        }
        if (!(this.saleType.isSelected() || this.saleAndProductType.isSelected() || this.productType.isSelected())) {
            String msg = this.getResource("NO_SOP_PRODUCTPLAN_AND_SALEPLAN_VIEW_PERMISSION");
            MessageFormat msgFmt = new MessageFormat(msg);
            MsgBox.showError((String)msgFmt.format(orgUnit));
            return false;
        }
        return bRet;
    }

    private Map isPermission(String[] str) throws BOSException, EASBizException {
        Object info = null;
        info = this.prmtstorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (FullOrgUnitInfo)this.prmtstorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        ISOPPermissionFacade sopPermFacade = SOPPermissionFacadeFactory.getRemoteInstance();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Map permMap = sopPermFacade.checkPermissions(userPK.toString(), info.getId().toString(), str);
        return permMap;
    }

    private void setPlannedType() {
        Map permMap = new HashMap();
        String[] str = new String[]{SALE_PERMISSION, PRODUCT_PERMISSION};
        try {
            permMap = this.isPermission(str);
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        isPermissionSale = Boolean.valueOf(permMap.get(SALE_PERMISSION).toString());
        isPermissionProduct = Boolean.valueOf(permMap.get(PRODUCT_PERMISSION).toString());
        if (isPermissionSale && !isPermissionProduct) {
            this.saleType.setSelected(true);
        }
        if (!isPermissionSale && isPermissionProduct) {
            this.productType.setSelected(true);
        }
        if (isPermissionSale && isPermissionProduct) {
            this.saleAndProductType.setSelected(true);
        }
    }

    private Map isFilterPermission(String[] str, OrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        ISOPPermissionFacade sopPermFacade = SOPPermissionFacadeFactory.getRemoteInstance();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Map permMap = sopPermFacade.checkPermissions(userPK.toString(), orgUnitInfo.getId().toString(), str);
        return permMap;
    }

    private EntityViewInfo getMainOrgUnitFilter(Set set) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(this.getPropertyOfMainBizOrg(), (Object)set, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private void setSupplyOrgUnitFilter() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmtSupplyOrgUnit.setEntityViewInfo(viewInfo);
    }
}

