/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.client.AbstractScheDiffAnalyseUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ScheDiffAnalyseUI
extends AbstractScheDiffAnalyseUI {
    private static final Logger logger = CoreUIObject.getLogger(ScheDiffAnalyseUI.class);
    private static final String TB_MATERIALNUM = "materialNum";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MODEL = "model";
    private static final String TB_PLANQTY = "planQty";
    private static final String TB_PLCQTY = "plcQty";
    private static final String TB_PLSQTY = "plsQty";
    private static final String TB_ENDQTY = "endQty";
    private static final String TB_PLANDIFF = "planDiff";
    private static final String TB_PLCDIFF = "plcDiff";
    private static final String TB_PLSDIFF = "plsDiff";
    private static final String TB_ENDDIFF = "endDiff";
    String[] qtyFieldNames = new String[]{"planQty", "plcQty", "plsQty", "endQty", "planDiff", "plcDiff", "plsDiff", "endDiff"};

    public void onLoad() throws Exception {
        super.onLoad();
        List list = (List)this.getUIContext().get("datas");
        Map precisionMap = (Map)this.getUIContext().get("precisionMap");
        this.kdtResult.checkParsed();
        BigDecimal planQtySum = PLSConstant.ZERO;
        BigDecimal plcQtySum = PLSConstant.ZERO;
        BigDecimal plsQtySum = PLSConstant.ZERO;
        BigDecimal endQtySum = PLSConstant.ZERO;
        BigDecimal planDiffQtySum = PLSConstant.ZERO;
        BigDecimal plcDiffQtySum = PLSConstant.ZERO;
        BigDecimal plsDiffQtySum = PLSConstant.ZERO;
        BigDecimal endDiffQtySum = PLSConstant.ZERO;
        if (list != null && list.size() > 0) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Map map = (Map)list.get(i);
                MaterialInfo material = (MaterialInfo)map.get("material");
                MeasureUnitInfo unit = (MeasureUnitInfo)map.get("unit");
                BigDecimal planQty = PLSConstant.ZERO;
                BigDecimal plcQty = PLSConstant.ZERO;
                BigDecimal plsQty = PLSConstant.ZERO;
                BigDecimal endQty = PLSConstant.ZERO;
                if (map.containsKey(TB_PLANQTY)) {
                    planQty = (BigDecimal)map.get(TB_PLANQTY);
                }
                if (map.containsKey(TB_PLCQTY)) {
                    plcQty = (BigDecimal)map.get(TB_PLCQTY);
                }
                if (map.containsKey(TB_PLSQTY)) {
                    plsQty = (BigDecimal)map.get(TB_PLSQTY);
                }
                if (map.containsKey(TB_ENDQTY)) {
                    endQty = (BigDecimal)map.get(TB_ENDQTY);
                }
                BigDecimal planDiffQty = plcQty.subtract(planQty);
                BigDecimal plcDiffQty = plsQty.subtract(plcQty);
                BigDecimal plscDiffQty = plsQty.subtract(planQty);
                BigDecimal endDiffQty = endQty.subtract(planQty);
                map.put(TB_PLANDIFF, planDiffQty);
                map.put(TB_PLCDIFF, plcDiffQty);
                map.put(TB_PLSDIFF, plscDiffQty);
                map.put(TB_ENDDIFF, endDiffQty);
                planQtySum = planQtySum.add(planQty);
                plcQtySum = plcQtySum.add(plcQty);
                plsQtySum = plsQtySum.add(plsQty);
                endQtySum = endQtySum.add(endQty);
                planDiffQtySum = planDiffQtySum.add(planDiffQty);
                plcDiffQtySum = plcDiffQtySum.add(plcDiffQty);
                plsDiffQtySum = plsDiffQtySum.add(plscDiffQty);
                endDiffQtySum = endDiffQtySum.add(endDiffQty);
                IRow row = this.kdtResult.addRow();
                row.getCell(TB_MATERIALNUM).setValue((Object)material.getNumber());
                row.getCell(TB_MATERIALNAME).setValue((Object)material.getName());
                row.getCell(TB_MODEL).setValue((Object)material.getModel());
                row.getCell(TB_PLANQTY).setValue((Object)ScheDiffAnalyseUI.fmtZero(planQty));
                row.getCell(TB_PLCQTY).setValue((Object)ScheDiffAnalyseUI.fmtZero(plcQty));
                row.getCell(TB_PLSQTY).setValue((Object)ScheDiffAnalyseUI.fmtZero(plsQty));
                row.getCell(TB_ENDQTY).setValue((Object)ScheDiffAnalyseUI.fmtZero(endQty));
                row.getCell(TB_PLANDIFF).setValue((Object)ScheDiffAnalyseUI.fmtZero(planDiffQty));
                row.getCell(TB_PLCDIFF).setValue((Object)ScheDiffAnalyseUI.fmtZero(plcDiffQty));
                row.getCell(TB_PLSDIFF).setValue((Object)ScheDiffAnalyseUI.fmtZero(plscDiffQty));
                row.getCell(TB_ENDDIFF).setValue((Object)ScheDiffAnalyseUI.fmtZero(endDiffQty));
                int precision = 8;
                String keyMMU = material.getId().toString() + unit.getId().toString();
                if (precisionMap.containsKey(keyMMU)) {
                    precision = (Integer)precisionMap.get(keyMMU);
                }
                SCMClientUtils.changeCellPrecision((IRow)row, (String[])this.qtyFieldNames, (int)precision, (boolean)true, (boolean)false);
            }
        }
        KDTFootManager footRowManager = this.kdtResult.getFootManager();
        IRow footRow = null;
        if (footRowManager == null) {
            footRowManager = new KDTFootManager(this.kdtResult);
            footRowManager.addFootView();
            this.kdtResult.setFootManager(footRowManager);
        }
        if ((footRow = footRowManager.getFootRow(0)) == null) {
            footRow = footRowManager.addFootRow(0);
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            this.kdtResult.getIndexColumn().setWidthAdjustMode((short)1);
            this.kdtResult.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
        }
        footRow.getCell(TB_PLANQTY).setValue((Object)ScheDiffAnalyseUI.fmtZero(planQtySum));
        footRow.getCell(TB_PLCQTY).setValue((Object)ScheDiffAnalyseUI.fmtZero(plcQtySum));
        footRow.getCell(TB_PLSQTY).setValue((Object)ScheDiffAnalyseUI.fmtZero(plsQtySum));
        footRow.getCell(TB_ENDQTY).setValue((Object)ScheDiffAnalyseUI.fmtZero(endQtySum));
        footRow.getCell(TB_PLANDIFF).setValue((Object)ScheDiffAnalyseUI.fmtZero(planDiffQtySum));
        footRow.getCell(TB_PLCDIFF).setValue((Object)ScheDiffAnalyseUI.fmtZero(plcDiffQtySum));
        footRow.getCell(TB_PLSDIFF).setValue((Object)ScheDiffAnalyseUI.fmtZero(plsDiffQtySum));
        footRow.getCell(TB_ENDDIFF).setValue((Object)ScheDiffAnalyseUI.fmtZero(endDiffQtySum));
    }

    private static BigDecimal fmtZero(BigDecimal decimal) {
        String str = decimal.toString();
        if (str.startsWith("0E-")) {
            return new BigDecimal("0");
        }
        return decimal;
    }
}

