/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.client.AbstractSimulantPlanOrderFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SimulantPlanOrderFilterUI
extends AbstractSimulantPlanOrderFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(SimulantPlanOrderFilterUI.class);
    private CustomerParams cp = null;
    private ItemListener chkExceptionChange = null;
    private List chkOrderTypeList = new LinkedList();
    private List chkMaterialAttributeList = new LinkedList();
    private Map chkGroupMap = new HashMap();
    private Map chkExcepMsgMap = new HashMap();

    public SimulantPlanOrderFilterUI() throws Exception {
        this.chkOrderTypeList.add(this.chkHomeMade);
        this.chkOrderTypeList.add(this.chkOutSourcing);
        this.chkOrderTypeList.add(this.chkPurchased);
        this.chkMaterialAttributeList.add(this.chkHomeMadePart);
        this.chkMaterialAttributeList.add(this.chkOutSourcingPart);
        this.chkMaterialAttributeList.add(this.chkPurchasedPart);
        this.chkExcepMsgMap.put(this.kDPanel1, "ORDERTYPE_MUST_SELECT");
        this.chkExcepMsgMap.put(this.kDPanel2, "MATERIALATTRIBUTE_MUST_SELECT");
        this.chkGroupMap.put(this.kDPanel1, this.chkOrderTypeList);
        this.chkGroupMap.put(this.kDPanel2, this.chkMaterialAttributeList);
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.initFilterElements();
        this.addListener();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter;
        FilterInfo filterInfo = super.getFilterInfo();
        HashSet<Integer> orderTypeSet = new HashSet<Integer>();
        HashSet<Integer> materialAttributeSet = new HashSet<Integer>();
        if (this.chkHomeMade.isSelected()) {
            orderTypeSet.add(new Integer(10));
        }
        if (this.chkOutSourcing.isSelected()) {
            orderTypeSet.add(new Integer(30));
        }
        if (this.chkPurchased.isSelected()) {
            orderTypeSet.add(new Integer(20));
        }
        if (orderTypeSet.size() > 0) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orderType", orderTypeSet, CompareType.INCLUDE));
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        if (this.chkHomeMadePart.isSelected()) {
            materialAttributeSet.add(new Integer(10030));
        }
        if (this.chkOutSourcingPart.isSelected()) {
            materialAttributeSet.add(new Integer(10050));
        }
        if (this.chkPurchasedPart.isSelected()) {
            materialAttributeSet.add(new Integer(10040));
        }
        if (materialAttributeSet.size() > 0) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("materialPlan.materialAttr", materialAttributeSet, CompareType.INCLUDE));
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = super.getCustomerParams();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            if (this.chkHomeMade.isSelected()) {
                customerParams.addCustomerParam("homeMade", String.valueOf(10));
            }
            if (this.chkOutSourcing.isSelected()) {
                customerParams.addCustomerParam("outeSourcing", String.valueOf(30));
            }
            if (this.chkPurchased.isSelected()) {
                customerParams.addCustomerParam("purchased", String.valueOf(20));
            }
            if (this.chkHomeMadePart.isSelected()) {
                customerParams.addCustomerParam("homeMadePart", String.valueOf(10030));
            }
            if (this.chkOutSourcingPart.isSelected()) {
                customerParams.addCustomerParam("outeSourcingPart", String.valueOf(10050));
            }
            if (this.chkPurchasedPart.isSelected()) {
                customerParams.addCustomerParam("purchasedPart", String.valueOf(10040));
            }
        }
        return customerParams;
    }

    public void clear() {
        super.clear();
        Calendar calendar = Calendar.getInstance();
        this.dpPlanStartDateFrom.setValue((Object)calendar.getTime());
        this.dpPlanEndDateFrom.setValue((Object)calendar.getTime());
        calendar.set(2, calendar.get(2) + 1);
        this.dpPlanStartDateTo.setValue((Object)calendar.getTime());
        this.dpPlanEndDateTo.setValue((Object)calendar.getTime());
        this.chkHomeMade.setSelected(true);
        this.chkOutSourcing.setSelected(true);
        this.chkPurchased.setSelected(true);
        this.chkHomeMadePart.setSelected(true);
        this.chkOutSourcingPart.setSelected(true);
        this.chkPurchasedPart.setSelected(true);
        this.prmtPlanVersionSet.setValue((Object)((PlanVersionSetInfo)((Map)this.getContextObject()).get("planVersionSetInfo")));
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.removeListener();
        this.chkHomeMade.setSelected(false);
        this.chkOutSourcing.setSelected(false);
        this.chkPurchased.setSelected(false);
        this.chkHomeMadePart.setSelected(false);
        this.chkOutSourcingPart.setSelected(false);
        this.chkPurchasedPart.setSelected(false);
        super.loadData(entityViewInfo);
        if (this.cp.getCustomerParam("homeMade") != null && this.cp.getCustomerParam("homeMade").length() > 0) {
            this.chkHomeMade.setSelected(true);
        }
        if (this.cp.getCustomerParam("outeSourcing") != null && this.cp.getCustomerParam("outeSourcing").length() > 0) {
            this.chkOutSourcing.setSelected(true);
        }
        if (this.cp.getCustomerParam("purchased") != null && this.cp.getCustomerParam("purchased").length() > 0) {
            this.chkPurchased.setSelected(true);
        }
        if (this.cp.getCustomerParam("homeMadePart") != null && this.cp.getCustomerParam("homeMadePart").length() > 0) {
            this.chkHomeMadePart.setSelected(true);
        }
        if (this.cp.getCustomerParam("outeSourcingPart") != null && this.cp.getCustomerParam("outeSourcingPart").length() > 0) {
            this.chkOutSourcingPart.setSelected(true);
        }
        if (this.cp.getCustomerParam("purchasedPart") != null && this.cp.getCustomerParam("purchasedPart").length() > 0) {
            this.chkPurchasedPart.setSelected(true);
        }
        this.prmtPlanVersionSet.setValue((Object)((PlanVersionSetInfo)((Map)this.getContextObject()).get("planVersionSetInfo")));
        if (this.prmtStorageOrgUnit.getValue() instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            String orgUnitId = orgUnitInfo.getId().toString();
            try {
                StorageOrgUnitInfo storageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
                this.prmtStorageOrgUnit.setValue((Object)storageOrgUnitInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.addListener();
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    public boolean verify() {
        Map parentContext;
        StorageOrgUnitInfo defualtMainOrg;
        boolean isVerifyPass = super.verify();
        if (!isVerifyPass) {
            return isVerifyPass;
        }
        if (this.prmtStorageOrgUnit.getText() != null && !(defualtMainOrg = (StorageOrgUnitInfo)(parentContext = (Map)this.getContextObject()).get("storageOrgUnit")).getName().equals(this.prmtStorageOrgUnit.getText())) {
            String[] arg = new String[]{defualtMainOrg.getName()};
            String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.storageCheck");
            MessageFormat msgFmt = new MessageFormat(msg);
            MsgBox.showInfo((String)msgFmt.format(arg));
            return false;
        }
        return isVerifyPass;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "mm_planorder_view";
    }

    private void initFilterElements() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.getResource("STORAGEORGUNIT_CANNOT_NULL")));
        elements.add((FilterElement)mainOrgElement);
        SingleFilterElement planVersionSetElement = new SingleFilterElement("scheme.number", (Component)this.prmtPlanVersionSet);
        elements.add((FilterElement)planVersionSetElement);
        SingleFilterElement supplyOrgUnitElement = new SingleFilterElement("productionOrgUnit.number", (Component)this.prmtSupplyStorageOrgUnit);
        elements.add((FilterElement)supplyOrgUnitElement);
        elements.add((FilterElement)new MMRangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        elements.add((FilterElement)new MMRangeFilterElement("material.number", (Component)this.prmtMaterialFrom, (Component)this.prmtMaterialTo));
        elements.add((FilterElement)new MMRangeFilterElement("adminOrgUnit.name", (Component)this.prmtAdminOrgUnitFrom, (Component)this.prmtAdminOrgUnitTo));
        elements.add((FilterElement)new MMRangeFilterElement("planner.number", (Component)this.prmtPlannerFrom, (Component)this.prmtPlannerTo));
        elements.add((FilterElement)new MMRangeFilterElement("project.number", (Component)this.prmtProjectFrom, (Component)this.prmtProjectTo));
        elements.add((FilterElement)new MMRangeFilterElement("trackNumber.number", (Component)this.prmtTrackNumberFrom, (Component)this.prmtTrackNumberTo));
        elements.add((FilterElement)new MMRangeFilterElement("startDate", (Component)this.dpPlanStartDateFrom, (Component)this.dpPlanStartDateTo));
        elements.add((FilterElement)new MMRangeFilterElement("endDate", (Component)this.dpPlanEndDateFrom, (Component)this.dpPlanEndDateTo));
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.getFilterManager().setElement((FilterElement)elements);
        this.initNeedMainOrgF7s();
    }

    private String getResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.PlannedOrderResource", (String)sKey);
    }

    private void addListener() {
        KDCheckBox kDCheckBox;
        int i;
        if (this.chkExceptionChange == null) {
            this.chkExceptionChange = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SimulantPlanOrderFilterUI.this.chkExceptionHandle(e);
                }
            };
        }
        for (i = 0; i < this.chkOrderTypeList.size(); ++i) {
            kDCheckBox = (KDCheckBox)this.chkOrderTypeList.get(i);
            kDCheckBox.addItemListener(this.chkExceptionChange);
        }
        for (i = 0; i < this.chkMaterialAttributeList.size(); ++i) {
            kDCheckBox = (KDCheckBox)this.chkMaterialAttributeList.get(i);
            kDCheckBox.addItemListener(this.chkExceptionChange);
        }
    }

    private void chkExceptionHandle(ItemEvent e) {
        KDCheckBox box;
        KDCheckBox currentBox = (KDCheckBox)e.getSource();
        List chkBoxList = (List)this.chkGroupMap.get(currentBox.getParent());
        String excepMessage = (String)this.chkExcepMsgMap.get(currentBox.getParent());
        boolean isSelected = false;
        for (int i = 0; i < chkBoxList.size() && !(isSelected = (box = (KDCheckBox)chkBoxList.get(i)).isSelected()); ++i) {
        }
        if (!isSelected) {
            MsgBox.showInfo((String)this.getResource(excepMessage));
            currentBox.removeItemListener(this.chkExceptionChange);
            currentBox.setSelected(true);
            currentBox.addItemListener(this.chkExceptionChange);
        }
    }

    private void removeListener() {
        KDCheckBox kDCheckBox;
        int i;
        for (i = 0; i < this.chkOrderTypeList.size(); ++i) {
            kDCheckBox = (KDCheckBox)this.chkOrderTypeList.get(i);
            kDCheckBox.removeItemListener(this.chkExceptionChange);
        }
        for (i = 0; i < this.chkMaterialAttributeList.size(); ++i) {
            kDCheckBox = (KDCheckBox)this.chkMaterialAttributeList.get(i);
            kDCheckBox.removeItemListener(this.chkExceptionChange);
        }
    }

    private void initNeedMainOrgF7s() {
        this.f7Manager.registerContextChangeF7(this.prmtMaterialFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtMaterialTo, this.getPropertyOfMainBizOrg());
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMaterialFrom, null);
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMaterialTo, null);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumberFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumberTo);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo});
        try {
            this.prmtSupplyStorageOrgUnit.setEntityViewInfo(SCMClientUtils.getStorageOrgF7OUFilter());
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.setPlanOrderF7(this.prmtNumberFrom, this.prmtStorageOrgUnit);
        this.setPlanOrderF7(this.prmtNumberTo, this.prmtStorageOrgUnit);
        this.setAdminOrgUnitAndPlannerF7(this.prmtStorageOrgUnit, this.prmtAdminOrgUnitFrom, this.prmtPlannerFrom);
        this.setAdminOrgUnitAndPlannerF7(this.prmtStorageOrgUnit, this.prmtAdminOrgUnitTo, this.prmtPlannerTo);
    }

    private void setPlanOrderF7(final KDBizPromptBox prmtPlanOrderBox, KDBizPromptBox prmtStorageOrgUnitBox) {
        prmtPlanOrderBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                String storageOrgUnitId = ((StorageOrgUnitInfo)SimulantPlanOrderFilterUI.this.prmtStorageOrgUnit.getValue()).getId().toString();
                EntityViewInfo planOrderEntityViewInfo = new EntityViewInfo();
                FilterInfo planOrderFilterInfo = new FilterInfo();
                planOrderFilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId));
                planOrderFilterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
                planOrderFilterInfo.getFilterItems().add(new FilterItemInfo("scheme.number", (Object)((PlanVersionSetInfo)SimulantPlanOrderFilterUI.this.prmtPlanVersionSet.getValue()).getNumber()));
                planOrderFilterInfo.getFilterItems().add(new FilterItemInfo("isSimulant", (Object)new Integer(1)));
                planOrderEntityViewInfo.setFilter(planOrderFilterInfo);
                prmtPlanOrderBox.setEntityViewInfo(planOrderEntityViewInfo);
                prmtPlanOrderBox.getQueryAgent().resetRuntimeEntityView();
            }
        });
        prmtPlanOrderBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                String storageOrgUnitId = ((StorageOrgUnitInfo)SimulantPlanOrderFilterUI.this.prmtStorageOrgUnit.getValue()).getId().toString();
                EntityViewInfo planOrderEntityViewInfo = new EntityViewInfo();
                FilterInfo planOrderFilterInfo = new FilterInfo();
                planOrderFilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId));
                planOrderFilterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
                planOrderFilterInfo.getFilterItems().add(new FilterItemInfo("scheme.number", (Object)((PlanVersionSetInfo)SimulantPlanOrderFilterUI.this.prmtPlanVersionSet.getValue()).getNumber()));
                planOrderFilterInfo.getFilterItems().add(new FilterItemInfo("isSimulant", (Object)new Integer(1)));
                planOrderEntityViewInfo.setFilter(planOrderFilterInfo);
                prmtPlanOrderBox.setEntityViewInfo(planOrderEntityViewInfo);
                prmtPlanOrderBox.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    private void setAdminOrgUnitAndPlannerF7(KDBizPromptBox prmtStorageOrgUnitBox, KDBizPromptBox prmtAdminOrgUnitBox, KDBizPromptBox prmtPlannerBox) {
        Set adminOrgUnitIds = this.getAdminOrgUnitIds(this.prmtStorageOrgUnit);
        EntityViewInfo adminOrgUnitViewInfo = new EntityViewInfo();
        FilterInfo adminOrgUnitFilterInfo = new FilterInfo();
        adminOrgUnitFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)adminOrgUnitIds, CompareType.INCLUDE));
        adminOrgUnitViewInfo.setFilter(adminOrgUnitFilterInfo);
        prmtAdminOrgUnitBox.setEntityViewInfo(adminOrgUnitViewInfo);
        prmtAdminOrgUnitBox.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo plannerViewInfo = new EntityViewInfo();
        FilterInfo plannerFilterInfo = new FilterInfo();
        plannerFilterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrgUnitIds, CompareType.INCLUDE));
        plannerViewInfo.setFilter(plannerFilterInfo);
        prmtPlannerBox.setEntityViewInfo(plannerViewInfo);
        prmtPlannerBox.getQueryAgent().resetRuntimeEntityView();
    }

    private Set getAdminOrgUnitIds(KDBizPromptBox prmtStorageOrgUnitBox) {
        Object mainOrg = prmtStorageOrgUnitBox.getData();
        OrgUnitCollection orgUnitInfo = null;
        LinkedHashSet<String> adminOrgUnitIds = new LinkedHashSet<String>();
        if (mainOrg == null) {
            adminOrgUnitIds.add("null");
        } else {
            try {
                IOrgUnitRelation orgUnitRelation = OrgUnitRelationFactory.getRemoteInstance();
                orgUnitInfo = orgUnitRelation.getToUnit(((OrgUnitInfo)mainOrg).getId().toString(), 4, 0);
                if (orgUnitInfo != null) {
                    for (int i = 0; i < orgUnitInfo.size(); ++i) {
                        adminOrgUnitIds.add(orgUnitInfo.get(i).getId().toString());
                    }
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        return adminOrgUnitIds;
    }
}

