/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client.test;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPPlannedTypeEnum;
import com.kingdee.eas.mm.planning.client.SOPDisplaySetUI;
import com.kingdee.eas.mm.planning.client.test.MRPTester;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SOPPeriodTester
extends MRPTester {
    public void testCalendar() {
        try {
            ISOPFacade bean = SOPFacadeFactory.getRemoteInstance();
            Calendar lastDay = Calendar.getInstance();
            lastDay.set(1, 2008);
            lastDay.set(2, 11);
            lastDay.set(5, 28);
            lastDay.setFirstDayOfWeek(7);
            String orgID = "hg/gqe/ISz6K3DlW+ZRUscznrtQ=";
            SOPPeriod period = bean.getCurrentPeriod(SOPEditModeEnum.MONTHLY, orgID);
            this.outputPeriod(period);
            SOPPeriod[] ps = period.forwardPeriods(32);
            for (int i = 0; i < ps.length; ++i) {
                this.outputPeriod(ps[i]);
            }
        }
        catch (EASBizException e) {
            SOPPeriodTester.fail((String)e.getMessage());
        }
        catch (BOSException e) {
            SOPPeriodTester.fail((String)e.getMessage());
        }
    }

    public void testMonthRange() {
        try {
            String orgID = "hg/gqe/ISz6K3DlW+ZRUscznrtQ=";
            ISOPFacade bean = SOPFacadeFactory.getRemoteInstance();
            SOPPeriod period = bean.getCurrentPeriod(SOPEditModeEnum.MONTHLY, orgID);
            this.outputPeriod(period);
            SOPPeriod[] periods = null;
            periods = period.periodRange(29);
            for (int i = 0; i < periods.length; ++i) {
                this.outputPeriod(periods[i]);
            }
            Calendar toDate = Calendar.getInstance();
            toDate.set(1, 2009);
            toDate.set(2, 9);
            toDate.set(5, 23);
            List periodLst = period.forwardPeriods(toDate);
            for (int i = 0; i < periodLst.size(); ++i) {
                this.outputPeriod((SOPPeriod)periodLst.get(i));
            }
        }
        catch (EASBizException e) {
            SOPPeriodTester.fail((String)e.getMessage());
        }
        catch (BOSException e) {
            SOPPeriodTester.fail((String)e.getMessage());
        }
    }

    public void testWeekRange() {
        try {
            String orgID = "hg/gqe/ISz6K3DlW+ZRUscznrtQ=";
            ISOPFacade bean = SOPFacadeFactory.getRemoteInstance();
            SOPPeriod period = bean.getCurrentPeriod(SOPEditModeEnum.WEEKLY, orgID);
            this.outputPeriod(period);
            SOPPeriod[] periods = null;
            periods = period.periodRange(12);
            for (int i = 0; i < periods.length; ++i) {
                this.outputPeriod(periods[i]);
            }
            Calendar toDate = Calendar.getInstance();
            toDate.set(1, 2009);
            toDate.set(2, 9);
            toDate.set(5, 23);
            List periodLst = period.forwardPeriods(toDate);
            for (int i = 0; i < periodLst.size(); ++i) {
                this.outputPeriod((SOPPeriod)periodLst.get(i));
            }
        }
        catch (EASBizException e) {
            SOPPeriodTester.fail((String)e.getMessage());
        }
        catch (BOSException e) {
            SOPPeriodTester.fail((String)e.getMessage());
        }
    }

    public void outputPeriod(SOPPeriod period) {
    }

    public static String dateToString(Date inDate) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        return sf.format(inDate);
    }

    public void testSOPSetting() throws UIException {
        String uiClass = "com.kingdee.eas.mm.planning.client.SOPDisplaySetUI";
        HashMap<String, Object> inMap = new HashMap<String, Object>();
        String orgID = "hg/gqe/ISz6K3DlW+ZRUscznrtQ=";
        inMap.put("currentorgID", orgID);
        inMap.put("currentPlanType", (Object)SOPPlannedTypeEnum.PRODUCT_PLAN);
        inMap.put("saleplan", Boolean.TRUE);
        inMap.put("storagevol", Boolean.TRUE);
        inMap.put("prodplan", Boolean.TRUE);
        inMap.put("targetinv", Boolean.TRUE);
        inMap.put("diaplaydate", Boolean.TRUE);
        inMap.put("hidehistorydata", Boolean.TRUE);
        UIContext ctx = new UIContext();
        ctx.put((Object)"sopdisplay", inMap);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)ctx, null, OprtState.VIEW);
        uiWindow.show();
        SOPDisplaySetUI setUI = (SOPDisplaySetUI)uiWindow.getUIObject();
        Map outMap = setUI.getSetData();
        if (outMap != null) {
            // empty if block
        }
    }

    public void testSOPCopy() throws UIException {
        String uiClass = "com.kingdee.eas.mm.planning.client.SOPCopyUI";
        HashMap<String, Object> inMap = new HashMap<String, Object>();
        String orgID = "hg/gqe/ISz6K3DlW+ZRUscznrtQ=";
        inMap.put("org", orgID);
        inMap.put("sopeditmode", (Object)SOPEditModeEnum.MONTHLY);
        ArrayList<String> materialLst = new ArrayList<String>();
        materialLst.add("ddd");
        materialLst.add("2dd");
        inMap.put("materials", materialLst);
        String srcVerID = "jNDGsh/tTSWJedcDcFtLV5eYTjA=";
        inMap.put("sourceVersion", srcVerID);
        UIContext ctx = new UIContext();
        ctx.put((Object)"COPYSOP", inMap);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)ctx, null, OprtState.VIEW);
        uiWindow.show();
    }
}

