/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.util;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.Vector;

public class FormulaParserUtil {
    public static final String RESOURCE = "com.kingdee.eas.mm.planning.SOPCheckFormulaResource";
    private String Msg;
    private int ErrorLength = -1;
    private int ErrorIndex = -1;
    private String formula;
    private String[] materialFlag = new String[2];
    private String[] bracket = new String[2];
    private String[] sign = new String[4];

    public FormulaParserUtil(String formula) {
        this.formula = formula;
        this.materialFlag[0] = "[";
        this.materialFlag[1] = "]";
        this.bracket[0] = "(";
        this.bracket[1] = ")";
        this.sign[0] = "+";
        this.sign[1] = "-";
        this.sign[2] = "*";
        this.sign[3] = "/";
    }

    protected boolean compareToLR(boolean clientCheckFlag) {
        int lb = this.getLeftBracket(this.formula);
        int rb = this.getRightBracket(this.formula);
        int lf = this.getLeftFlag(this.formula);
        int rf = this.getRightFlag(this.formula);
        boolean CTLR = false;
        if (lb == rb) {
            this.Msg = "";
            CTLR = true;
        } else if (lb > rb) {
            this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_LEFTMORE") : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_LEFTMORE");
            CTLR = false;
        } else {
            this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_LEFTLESS") : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_LEFTLESS");
            CTLR = false;
        }
        if (CTLR) {
            if (lf == rf) {
                this.Msg = "";
                CTLR = true;
            } else {
                this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_WRONGFLAG") : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_WRONGFLAG");
                CTLR = false;
            }
        }
        return CTLR;
    }

    private int getLeftBracket(String calRule) {
        int leftBracket = 0;
        int startL = calRule.indexOf(this.bracket[0]);
        if (startL != -1) {
            calRule = calRule.substring(startL + 1, calRule.length());
        }
        while (startL != -1) {
            ++leftBracket;
            startL = calRule.indexOf(this.bracket[0]);
            calRule = calRule.substring(startL + 1, calRule.length());
        }
        return leftBracket;
    }

    private int getRightBracket(String calRule) {
        int rightBracket = 0;
        int startR = calRule.indexOf(this.bracket[1]);
        if (startR != -1) {
            calRule = calRule.substring(startR + 1, calRule.length());
        }
        while (startR != -1) {
            ++rightBracket;
            startR = calRule.indexOf(this.bracket[1]);
            calRule = calRule.substring(startR + 1, calRule.length());
        }
        return rightBracket;
    }

    private int getLeftFlag(String calRule) {
        int leftBracket = 0;
        int startL = calRule.indexOf(this.materialFlag[0]);
        if (startL != -1) {
            calRule = calRule.substring(startL + 1, calRule.length());
        }
        while (startL != -1) {
            ++leftBracket;
            startL = calRule.indexOf(this.materialFlag[0]);
            calRule = calRule.substring(startL + 1, calRule.length());
        }
        return leftBracket;
    }

    private int getRightFlag(String calRule) {
        int rightBracket = 0;
        int startR = calRule.indexOf(this.materialFlag[1]);
        if (startR != -1) {
            calRule = calRule.substring(startR + 1, calRule.length());
        }
        while (startR != -1) {
            ++rightBracket;
            startR = calRule.indexOf(this.materialFlag[1]);
            calRule = calRule.substring(startR + 1, calRule.length());
        }
        return rightBracket;
    }

    protected boolean checkFormula(boolean clientCheckFlag) {
        int j;
        int i;
        boolean isOk = true;
        String vstr = "";
        for (i = 0; i < this.bracket.length; ++i) {
            for (j = 0; j < this.sign.length; ++j) {
                vstr = i == 0 ? this.bracket[i] + this.sign[j] : this.sign[j] + this.bracket[i];
                if (this.formula.indexOf(vstr) <= 0) continue;
                this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr}) : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr});
                this.ErrorIndex = this.formula.indexOf(vstr);
                this.ErrorLength = vstr.length();
                isOk = false;
                return isOk;
            }
        }
        for (i = 0; i < this.sign.length; ++i) {
            for (j = 0; j < this.sign.length; ++j) {
                vstr = this.sign[i] + this.sign[j];
                if (this.formula.indexOf(vstr) <= 0) continue;
                this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr}) : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr});
                this.ErrorIndex = this.formula.indexOf(vstr);
                this.ErrorLength = vstr.length();
                isOk = false;
                return isOk;
            }
        }
        vstr = this.formula.substring(0, 1);
        for (i = 0; i < this.sign.length; ++i) {
            if (!vstr.equals(this.sign[i])) continue;
            this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr}) : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr});
            this.ErrorIndex = 0;
            this.ErrorLength = 1;
            isOk = false;
            return isOk;
        }
        vstr = this.formula.substring(this.formula.length() - 1, this.formula.length());
        for (i = 0; i < this.sign.length; ++i) {
            if (!vstr.equals(this.sign[i])) continue;
            this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr}) : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr});
            this.ErrorIndex = this.formula.length() - 1;
            this.ErrorLength = 1;
            isOk = false;
            return isOk;
        }
        int n = this.formula.length();
        for (i = 0; i < n; ++i) {
            String s = this.formula.substring(i, i + 1);
            if (!(!s.equals(this.materialFlag[0]) || i == 0 || (s = this.formula.substring(i - 1, i)).equals(this.sign[0]) || s.equals(this.sign[1]) || s.equals(this.sign[2]) || s.equals(this.sign[3]) || s.equals(this.bracket[0]))) {
                vstr = this.formula.substring(i - 1, i + 1);
                this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr}) : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr});
                this.ErrorIndex = i - 1;
                this.ErrorLength = 2;
                isOk = false;
                return isOk;
            }
            if (!s.equals(this.materialFlag[1]) || i == n - 1 || (s = this.formula.substring(i + 1, i + 2)).equals(this.sign[0]) || s.equals(this.sign[1]) || s.equals(this.sign[2]) || s.equals(this.sign[3]) || s.equals(this.bracket[1])) continue;
            vstr = this.formula.substring(i, i + 2);
            this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr}) : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr});
            this.ErrorIndex = i;
            this.ErrorLength = 2;
            isOk = false;
            return isOk;
        }
        vstr = this.materialFlag[0] + this.materialFlag[1];
        if (this.formula.indexOf(vstr) > 0) {
            this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr}) : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr});
            this.ErrorIndex = this.formula.indexOf(vstr);
            this.ErrorLength = vstr.length();
            isOk = false;
        }
        if (this.formula.indexOf(vstr = this.materialFlag[1] + this.materialFlag[0]) > 0) {
            this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr}) : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr});
            this.ErrorIndex = this.formula.indexOf(vstr);
            this.ErrorLength = vstr.length();
            isOk = false;
        }
        if (this.formula.indexOf(vstr = this.bracket[0] + this.bracket[1]) > 0) {
            this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr}) : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr});
            this.ErrorIndex = this.formula.indexOf(vstr);
            this.ErrorLength = vstr.length();
            isOk = false;
        }
        if (this.formula.indexOf(vstr = this.bracket[1] + this.bracket[0]) > 0) {
            this.Msg = clientCheckFlag ? ResourceUtils.getMessageForClient((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr}) : ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_WRONGCHAR", (String[])new String[]{vstr});
            this.ErrorIndex = this.formula.indexOf(vstr);
            this.ErrorLength = vstr.length();
            isOk = false;
        }
        return isOk;
    }

    public boolean checkValid() {
        if (this.formula == null || this.formula.trim().length() <= 0) {
            this.Msg = ResourceUtils.getMessageForServer((String)RESOURCE, (String)"EDITUI_NOFORMULA");
            return false;
        }
        return this.compareToLR(false) && this.checkFormula(false);
    }

    public boolean checkValidForClient() {
        if (this.formula == null || this.formula.trim().length() <= 0) {
            this.Msg = ResourceUtils.getMessageForClient((String)RESOURCE, (String)"EDITUI_NOFORMULA");
            return false;
        }
        return this.compareToLR(true) && this.checkFormula(true);
    }

    public double getResult(boolean clientCheckFlag) throws BOSException {
        int leftBracket = this.getLeftBracket(this.formula);
        double value = 0.0;
        String calRule = this.formula;
        if (clientCheckFlag ? this.checkValidForClient() : this.checkValid()) {
            if (leftBracket > 0) {
                for (int i = 0; i < leftBracket; ++i) {
                    int iStart = calRule.lastIndexOf(this.bracket[0]) + 1;
                    String formulaStr = calRule.substring(iStart, iStart + calRule.substring(iStart).indexOf(this.bracket[1])).trim();
                    Vector list = this.symbolParse(formulaStr);
                    value = this.parseString(list);
                    iStart = calRule.lastIndexOf(this.bracket[0]);
                    int iEnd = calRule.substring(iStart).indexOf(this.bracket[1]) + 1;
                    calRule = calRule.substring(0, iStart).trim() + value + calRule.substring(iStart + iEnd, calRule.length()).trim();
                }
            }
            Vector list = this.symbolParse(calRule);
            value = this.parseString(list);
        }
        double tmp = Math.pow(10.0, 10.0);
        value = (double)Math.round(value * tmp) / tmp;
        return value;
    }

    private Vector symbolParse(String str) {
        Vector<String> list = new Vector<String>();
        int[] sym = this.compareMin(str);
        for (int i = 0; i < 4; ++i) {
            while (sym[i] != -1) {
                String insStr = str.substring(0, sym[i]).trim();
                list.add(insStr);
                insStr = str.substring(sym[i], sym[i] + 1).trim();
                list.add(insStr);
                str = str.substring(sym[i] + 1, str.length()).trim();
                sym = this.compareMin(str);
            }
        }
        if (sym[0] == -1 && sym[1] == -1 && sym[2] == -1 & sym[3] == -1) {
            list.add(str);
        }
        return list;
    }

    private int[] compareMin(String str) {
        int spm;
        int spd;
        int spa;
        int sps = str.indexOf(this.sign[1]);
        int[] sym = new int[]{sps, spa = str.indexOf(this.sign[0]), spd = str.indexOf(this.sign[3]), spm = str.indexOf(this.sign[2])};
        Arrays.sort((int[])sym);
        return sym;
    }

    private double parseString(Vector list) throws BOSException {
        return this.calculate(list);
    }

    private double calculate(Vector list) {
        String leftNumber = "0";
        String rightNumber = "0";
        int spd = list.indexOf(this.sign[3]);
        while (spd != -1) {
            leftNumber = list.get(spd - 1).toString();
            rightNumber = list.get(spd + 1).toString();
            list.remove(spd - 1);
            list.remove(spd - 1);
            list.remove(spd - 1);
            double ln = Double.valueOf(leftNumber);
            double rn = Double.valueOf(rightNumber);
            if (rn == 0.0) {
                return 0.0;
            }
            double answer = ln / rn;
            list.add(spd - 1, String.valueOf(answer));
            spd = list.indexOf(this.sign[3]);
        }
        int spm = list.indexOf(this.sign[2]);
        while (spm != -1) {
            leftNumber = list.get(spm - 1).toString();
            rightNumber = list.get(spm + 1).toString();
            list.remove(spm - 1);
            list.remove(spm - 1);
            list.remove(spm - 1);
            double ln = Double.valueOf(leftNumber);
            double rn = Double.valueOf(rightNumber);
            double answer = ln * rn;
            list.add(spm - 1, String.valueOf(answer));
            spm = list.indexOf(this.sign[2]);
        }
        int sps = list.indexOf(this.sign[1]);
        while (sps != -1) {
            leftNumber = list.get(sps - 1).toString();
            rightNumber = list.get(sps + 1).toString();
            list.remove(sps - 1);
            list.remove(sps - 1);
            list.remove(sps - 1);
            double ln = Double.valueOf(leftNumber);
            double rn = Double.valueOf(rightNumber);
            double answer = ln - rn;
            list.add(sps - 1, String.valueOf(answer));
            sps = list.indexOf(this.sign[1]);
        }
        int spa = list.indexOf(this.sign[0]);
        while (spa != -1) {
            leftNumber = list.get(spa - 1).toString();
            rightNumber = list.get(spa + 1).toString();
            list.remove(spa - 1);
            list.remove(spa - 1);
            list.remove(spa - 1);
            double ln = Double.valueOf(leftNumber);
            double rn = Double.valueOf(rightNumber);
            double answer = ln + rn;
            list.add(spa - 1, String.valueOf(answer));
            spa = list.indexOf(this.sign[0]);
        }
        double answer = 0.0;
        if (list.size() != 0) {
            String result = list.get(0).toString();
            if (result == null || result.length() == 0) {
                result = "0";
            }
            answer = Double.parseDouble(result);
        }
        return answer;
    }

    public String getMsg() {
        return this.Msg;
    }

    public int getErrorLength() {
        return this.ErrorLength;
    }

    public int getErrorIndex() {
        return this.ErrorIndex;
    }
}

