/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SOPUtil {
    String BILLID_LIST = "billIdList";
    String MATID_LIST = "matIdList";

    public static Calendar copyDate(Calendar theDate) {
        Calendar copyDate = Calendar.getInstance();
        copyDate.set(1, theDate.get(1));
        copyDate.set(2, theDate.get(2));
        copyDate.set(5, theDate.get(5));
        return copyDate;
    }

    public static boolean requestMutex(Context ctx, String userID, String storageOrgUnitID, String sopVerID) throws BOSException, EASBizException {
        IMutexServiceControl mutex = null;
        mutex = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String key = storageOrgUnitID + sopVerID;
        return mutex.requestObjIDForUpdate(key, userID, Uuid.create());
    }

    public static boolean requestMutex(Context ctx, String userID, String storageOrgUnitID, String sopVerID, String materialID) throws BOSException, EASBizException {
        IMutexServiceControl mutex = null;
        mutex = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String key = storageOrgUnitID + "," + sopVerID + "," + materialID + ",";
        return mutex.requestObjIDForUpdate(key, userID, Uuid.create());
    }

    public static Map requestMutex(Context ctx, String userID, String storageOrgUnitID, String sopVerID, List matIDList, Map storageMatIds) throws BOSException, EASBizException {
        IMutexServiceControl mutex = null;
        mutex = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map resultMap = null;
        if (matIDList != null) {
            String key = null;
            ArrayList<String> keyList = new ArrayList<String>();
            List billIDList = new ArrayList();
            ISOPFacade sop = null;
            sop = ctx == null ? SOPFacadeFactory.getRemoteInstance() : SOPFacadeFactory.getLocalInstance(ctx);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org", storageOrgUnitID);
            map.put("planVersion", sopVerID);
            map.put("materials", matIDList);
            map.put("matStorageIds", storageMatIds);
            billIDList = sop.getSOPPlanBillIDList(map);
            int n = billIDList.size();
            for (int i = 0; i < n; ++i) {
                key = (String)billIDList.get(i);
                keyList.add(key);
            }
            if (keyList != null && keyList.size() > 0) {
                resultMap = mutex.batchRequestObjIDForUpdate(keyList);
            }
        }
        return resultMap;
    }

    public static HashSet getObjIDForUpdateList(Context ctx, String storageOrgUnitID, String sopVerID) throws BOSException, EASBizException {
        String ais;
        IMutexServiceControl mutex = null;
        mutex = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashMap mutexList = mutex.getObjIDForUpdateList();
        ArrayList list = new ArrayList(mutexList.keySet());
        HashSet<String> materialIDSet = new HashSet<String>();
        Map sopPlanBillMap = new HashMap();
        ISOPFacade sop = null;
        if (ctx == null) {
            sop = SOPFacadeFactory.getRemoteInstance();
            ais = sop.getAIS();
        } else {
            sop = SOPFacadeFactory.getLocalInstance(ctx);
            ais = ctx.getAIS();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("org", storageOrgUnitID);
        map.put("planVersion", sopVerID);
        sopPlanBillMap = sop.getSOPPlanBill(map);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int index;
            String id = (String)list.get(i);
            String keyStr = ais != null ? ((index = id.indexOf(ais)) > 0 ? ((String)list.get(i)).substring(0, index) : id) : id;
            if (!sopPlanBillMap.containsKey(keyStr)) continue;
            materialIDSet.add((String)sopPlanBillMap.get(keyStr));
        }
        return materialIDSet;
    }

    public static List getObjIDForUpdateLists(Context ctx, String storageOrgUnitID, String sopVerID) throws BOSException, EASBizException {
        String ais;
        IMutexServiceControl mutex = null;
        ISOPFacade sop = null;
        if (ctx == null) {
            mutex = MutexServiceControlFactory.getRemoteInstance();
            sop = SOPFacadeFactory.getRemoteInstance();
            ais = sop.getAIS();
        } else {
            mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            ais = ctx.getAIS();
        }
        HashMap mutexList = mutex.getObjIDForUpdateList();
        ArrayList list = new ArrayList(mutexList.keySet());
        ArrayList<String> result = new ArrayList<String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int index;
            String id = (String)list.get(i);
            String keyStr = ais != null ? ((index = id.indexOf(ais)) > 0 ? ((String)list.get(i)).substring(0, index) : id) : id;
            result.add(keyStr);
        }
        return result;
    }

    public static void releaseMutex(Context ctx, String storageOrgUnitID, String sopVerID, List matIDList, Map storageMatIds) throws BOSException, EASBizException {
        IMutexServiceControl mutex = null;
        mutex = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        if (matIDList != null) {
            String key = null;
            ArrayList<String> keyList = new ArrayList<String>();
            List billIDList = new ArrayList();
            ISOPFacade sop = null;
            sop = ctx == null ? SOPFacadeFactory.getRemoteInstance() : SOPFacadeFactory.getLocalInstance(ctx);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org", storageOrgUnitID);
            map.put("planVersion", sopVerID);
            map.put("materials", matIDList);
            map.put("matStorageIds", storageMatIds);
            billIDList = sop.getSOPPlanBillIDList(map);
            int n = billIDList.size();
            for (int i = 0; i < n; ++i) {
                key = (String)billIDList.get(i);
                keyList.add(key);
            }
            mutex.batchReleaseObjIDForUpdate(keyList);
        }
    }

    public static void releaseMutex(Context ctx, String storageOrgUnitID, String sopVerID, String materialID) throws BOSException, EASBizException {
        IMutexServiceControl mutex = null;
        mutex = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String key = storageOrgUnitID + "," + sopVerID + "," + materialID + ",";
        mutex.releaseObjIDForUpdate(key);
    }

    public static void releaseMutex(Context ctx, String storageOrgUnitID, String sopVerID) throws BOSException, EASBizException {
        IMutexServiceControl mutex = null;
        mutex = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String key = storageOrgUnitID + sopVerID;
        mutex.releaseObjIDForUpdate(key);
    }

    public static String getInPredicateFromList(List idList) {
        StringBuffer ids = new StringBuffer();
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            ids.append(",'").append((String)it.next()).append("'");
        }
        if (ids.length() > 0) {
            ids.setCharAt(0, '(');
            ids.append(")");
        }
        return ids.toString();
    }

    public static String getInPredicateFromList(Set idList) {
        StringBuffer ids = new StringBuffer();
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            ids.append(",'").append((String)it.next()).append("'");
        }
        if (ids.length() > 0) {
            ids.setCharAt(0, '(');
            ids.append(")");
        }
        return ids.toString();
    }

    public static int getLastDayOfMonth(int year, int month) {
        Calendar c = Calendar.getInstance();
        if (month == 11) {
            c.set(1, year + 1);
            c.set(2, 1);
        } else {
            c.set(1, year);
            c.set(2, month);
            c.add(2, 1);
        }
        c.set(5, 1);
        c.add(5, -1);
        return c.get(5);
    }

    public static Calendar getMonthStartDay(Calendar theDate, int startDay) {
        int lastDay;
        if (startDay > 28 && startDay > (lastDay = SOPUtil.getLastDayOfMonth(theDate.get(1), theDate.get(2)))) {
            startDay = lastDay;
        }
        theDate.set(5, startDay);
        return theDate;
    }

    public static Calendar getMonthEndDay(Calendar theDate, int startDay) {
        SOPUtil.getMonthStartDay(theDate, startDay);
        theDate.add(5, -1);
        return theDate;
    }

    public static String getPredicateFromList(List idList) {
        StringBuffer ids = new StringBuffer();
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            ids.append((String)it.next()).append(",");
        }
        return ids.toString();
    }

    public static ArrayList getHasMutexBillID(Context ctx, String storageOrgUnitID, String sopVerID) throws BOSException {
        ArrayList<String> billIDList = new ArrayList<String>();
        IMutexServiceControl mutex = null;
        try {
            mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e1) {
            throw new BOSException((Throwable)e1);
        }
        HashMap mutexList = mutex.getObjIDForUpdateList();
        ArrayList allMutexList = new ArrayList(mutexList.keySet());
        ISOPFacade sop = null;
        try {
            sop = SOPFacadeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("org", storageOrgUnitID);
        map.put("planVersion", sopVerID);
        Map sopPlanBillMap = null;
        String ais = null;
        try {
            sopPlanBillMap = sop.getSOPPlanBill(map);
            ais = sop.getAIS();
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList list = new ArrayList(sopPlanBillMap.keySet());
        String keyStr = null;
        int n = allMutexList.size();
        for (int i = 0; i < n; ++i) {
            int index;
            String id = (String)allMutexList.get(i);
            keyStr = ais != null ? ((index = id.indexOf(ais)) > 0 ? ((String)allMutexList.get(i)).substring(0, index) : id) : id;
            if (!list.contains(keyStr)) continue;
            billIDList.add(keyStr);
        }
        return billIDList;
    }
}

