/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.MMBillSorterUtil;
import com.kingdee.eas.mm.mo.util.calculateDateUtil;
import com.kingdee.eas.mm.report.client.AbstractAnalyzeIssueReportFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AnalyzeIssueReportFilterUI
extends AbstractAnalyzeIssueReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AnalyzeIssueReportFilterUI.class);
    private static final String TB_ID = "id";
    private static final String TB_SUMLIST = "fieldName";
    private static final String TB_ISTOTAL = "isTotal";
    private static final String[] TB_CELLS = new String[]{"0", "1", "2"};
    private static final Boolean TB_CELL_CHECK_DEFAULT = Boolean.FALSE;
    Timestamp[] dates = AnalyzeIssueReportFilterUI.getDefaultDateRange(SCMClientUtils.getServerDate2());
    private CustomerParams cp = null;
    HashMap kdRow2Map = new HashMap();

    public AnalyzeIssueReportFilterUI() throws Exception {
        this.kDTable1.checkParsed();
        this.kDTable1.removeRows();
        this.kDTable1.getColumn(TB_ID).getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn(TB_SUMLIST).getStyleAttributes().setLocked(true);
        this.kDTable1.getActionMap().remove("Paste");
        this.kDTable1.getActionMap().remove("Delete");
        this.kDTable1.getActionMap().remove("Copy");
        this.kDTable1.getActionMap().remove("Cut");
        this.kDTable1.getSelectManager().setSelectMode(2);
        String[] tb_sumlist = new String[]{this.getResource("ADMINORGUNITNAME"), this.getResource("NUMBER"), this.getResource("MANUFACTURE")};
        for (int ii = 0; ii < TB_CELLS.length; ++ii) {
            IRow row = this.kDTable1.addRow();
            row.getCell(TB_ID).setValue((Object)TB_CELLS[ii]);
            row.getCell(TB_SUMLIST).setValue((Object)tb_sumlist[ii]);
            row.getCell(TB_ISTOTAL).setValue((Object)TB_CELL_CHECK_DEFAULT);
            this.kdRow2Map.put(TB_CELLS[ii], row);
        }
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtstorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.getResource("STORAGEUNIT_NOT_NULL")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("bizType", (Component)this.prmtBizType));
        SingleFilterElement kdbizbillnumF = new SingleFilterElement("kDBizBillNum1", (Component)this.kDBizBillNumF);
        elements.add((FilterElement)kdbizbillnumF);
        SingleFilterElement kdbizbillnumT = new SingleFilterElement("kDBizBillNum2", (Component)this.kDBizBillNumT);
        elements.add((FilterElement)kdbizbillnumT);
        MMBillSorterUtil.setSorter((KDBizPromptBox)this.kDBizBillNumF, (String)"number", (SortType)SortType.DESCEND);
        MMBillSorterUtil.setSorter((KDBizPromptBox)this.kDBizBillNumT, (String)"number", (SortType)SortType.DESCEND);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectF);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectT);
        elements.add((FilterElement)new SingleFilterElement("projectNumber1", (Component)this.prmtProjectF));
        elements.add((FilterElement)new SingleFilterElement("projectNumber2", (Component)this.prmtProjectT));
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumberF);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumberT);
        elements.add((FilterElement)new SingleFilterElement("trackNumber1", (Component)this.prmtTrackNumberF));
        elements.add((FilterElement)new SingleFilterElement("trackNumber2", (Component)this.prmtTrackNumberT));
        this.BizDateF.setValue(null);
        SingleFilterElement bizdateF = new SingleFilterElement("BizDate1", (Component)this.BizDateF);
        elements.add((FilterElement)bizdateF);
        this.BizDateT.setValue(null);
        SingleFilterElement bizdateT = new SingleFilterElement("BizDate2", (Component)this.BizDateT);
        elements.add((FilterElement)bizdateT);
        this.planBeginDateF.setValue(null);
        SingleFilterElement singlePlanBeginDateF = new SingleFilterElement("planBeginDate1", (Component)this.planBeginDateF);
        elements.add((FilterElement)singlePlanBeginDateF);
        this.planBeginDateT.setValue(null);
        SingleFilterElement singlePlanBeginDateT = new SingleFilterElement("planBeginDate2", (Component)this.planBeginDateT);
        elements.add((FilterElement)singlePlanBeginDateT);
        this.planEndDateF.setValue(null);
        SingleFilterElement singlePlanEndDateF = new SingleFilterElement("planEndDate1", (Component)this.planEndDateF);
        elements.add((FilterElement)singlePlanEndDateF);
        this.planEndDateT.setValue(null);
        SingleFilterElement singlePlanEndDateT = new SingleFilterElement("planEndDate2", (Component)this.planEndDateT);
        elements.add((FilterElement)singlePlanEndDateT);
        SingleFilterElement prommaterialnumF = new SingleFilterElement("promMaterialNum1", (Component)this.promMaterialNumF);
        elements.add((FilterElement)prommaterialnumF);
        SingleFilterElement prommaterialnumT = new SingleFilterElement("promMaterialNum2", (Component)this.promMaterialNumT);
        elements.add((FilterElement)prommaterialnumT);
        SingleFilterElement singlePromMaterialF = new SingleFilterElement("promMaterial1", (Component)this.promMaterialF);
        elements.add((FilterElement)singlePromMaterialF);
        SingleFilterElement singlePromMaterialT = new SingleFilterElement("promMaterial2", (Component)this.promMaterialT);
        elements.add((FilterElement)singlePromMaterialT);
        SingleFilterElement singlePromOrgUnitF = new SingleFilterElement("promOrgUnit1", (Component)this.promOrgUnitF);
        elements.add((FilterElement)singlePromOrgUnitF);
        SingleFilterElement singlePromOrgUnitT = new SingleFilterElement("promOrgUnit2", (Component)this.promOrgUnitT);
        elements.add((FilterElement)singlePromOrgUnitT);
        SingleFilterElement close = new SingleFilterElement("kDCheckBoxClose", (Component)this.kDCheckBoxClose);
        close.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)close);
        SingleFilterElement complete = new SingleFilterElement("kDCheckBoxComplete", (Component)this.kDCheckBoxComplete);
        complete.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)complete);
        SingleFilterElement audit = new SingleFilterElement("kDCheckBoxAudit", (Component)this.kDCheckBoxAudit);
        audit.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)audit);
        SingleFilterElement assign = new SingleFilterElement("kDCheckBoxAssign", (Component)this.kDCheckBoxAssign);
        assign.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)assign);
        SingleFilterElement archives = new SingleFilterElement("kDCheckBoxArchives", (Component)this.kDCheckBoxArchives);
        archives.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)archives);
        SingleFilterElement greater = new SingleFilterElement("kDCheckBoxGreater", (Component)this.kDCheckBoxGreater);
        close.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)greater);
        SingleFilterElement equal = new SingleFilterElement("kDCheckBoxEqual", (Component)this.kDCheckBoxEqual);
        close.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)equal);
        SingleFilterElement less = new SingleFilterElement("kDCheckBoxLess", (Component)this.kDCheckBoxLess);
        close.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)less);
        elements.add((FilterElement)new SingleFilterElement("lot", (Component)this.txtLot));
        elements.add((FilterElement)new KDTableFilterElement("table", this.kDTable1));
        this.f7Manager.registerContextChangeF7(this.kDBizBillNumF, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.kDBizBillNumT, "storageOrgUnit.id");
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        UIHelper.registerBizOrgF7((KDBizPromptBox)this.promOrgUnitF, null, null, (OrgType)this.getMainBizOrgType(), (OrgType)OrgType.Admin, (boolean)false);
        UIHelper.registerBizOrgF7((KDBizPromptBox)this.promOrgUnitT, null, null, (OrgType)this.getMainBizOrgType(), (OrgType)OrgType.Admin, (boolean)false);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.promMaterialF, this.promMaterialT, this.promOrgUnitF, this.promOrgUnitT, this.promMaterialNumF, this.promMaterialNumT});
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_AnalyzeIssueReport_Query");
        this.setMaterialFilter();
    }

    private void setMaterialFilter() {
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.promMaterialF, false, queryInfo);
        this.setBizMaterialF7(this.promMaterialT, false, queryInfo);
        this.setBizMaterialF7(this.promMaterialNumF, false, queryInfo);
        this.setBizMaterialF7(this.promMaterialNumT, false, queryInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        view.setFilter(filter);
        this.promMaterialF.setEntityViewInfo(view);
        this.promMaterialT.setEntityViewInfo(view);
        this.promMaterialF.getQueryAgent().resetRuntimeEntityView();
        this.promMaterialT.getQueryAgent().resetRuntimeEntityView();
        this.promMaterialNumF.setEntityViewInfo(view);
        this.promMaterialNumT.setEntityViewInfo(view);
        this.promMaterialNumF.getQueryAgent().resetRuntimeEntityView();
        this.promMaterialNumT.getQueryAgent().resetRuntimeEntityView();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.planEndDateF.setValue((Object)calculateDateUtil.thisMonth());
        this.planEndDateT.setValue((Object)calculateDateUtil.thisMonthEnd());
        this.kDCheckBoxAudit.setSelected(true);
        this.kDCheckBoxClose.setSelected(true);
        this.kDCheckBoxComplete.setSelected(true);
        this.kDCheckBoxAssign.setSelected(true);
        this.kDCheckBoxArchives.setSelected(true);
        this.kDCheckBoxEqual.setSelected(true);
        this.kDCheckBoxLess.setSelected(true);
        this.kDCheckBoxGreater.setSelected(true);
        this.kDTable1.removeRows();
        int n = this.kdRow2Map.size();
        for (int i = 0; i < n; ++i) {
            this.kDTable1.addRow(i, (IRow)this.kdRow2Map.get("" + i));
            this.kDTable1.getRow(i).getCell(TB_ISTOTAL).setValue((Object)new Boolean(false));
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtstorageOrgUnit;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public boolean verify() {
        boolean result = super.verify();
        if (!result) {
            return result;
        }
        if (this.BizDateT.getValue() != null && this.BizDateF.getValue() != null && ((Date)this.BizDateT.getValue()).getTime() < ((Date)this.BizDateF.getValue()).getTime()) {
            MsgBox.showInfo((String)this.getResource("DATE_NOTVALID"));
            return false;
        }
        if (this.planBeginDateT.getValue() != null && this.planBeginDateF.getValue() != null && ((Date)this.planBeginDateT.getValue()).getTime() < ((Date)this.planBeginDateF.getValue()).getTime()) {
            MsgBox.showInfo((String)this.getResource("DATE_NOTVALID"));
            return false;
        }
        if (this.planEndDateT.getValue() != null && this.planEndDateF.getValue() != null && ((Date)this.planEndDateT.getValue()).getTime() < ((Date)this.planEndDateF.getValue()).getTime()) {
            MsgBox.showInfo((String)this.getResource("DATE_NOTVALID"));
            return false;
        }
        if (this.kDCheckBoxAudit.getSelected() == 16 && this.kDCheckBoxComplete.getSelected() == 16 && this.kDCheckBoxClose.getSelected() == 16 && this.kDCheckBoxAssign.getSelected() == 16 && this.kDCheckBoxArchives.getSelected() == 16) {
            MsgBox.showInfo((String)this.getResource("BILL_STATUS_NOTCHECK"));
            return false;
        }
        if (this.kDCheckBoxGreater.getSelected() == 16 && this.kDCheckBoxEqual.getSelected() == 16 && this.kDCheckBoxLess.getSelected() == 16) {
            MsgBox.showInfo((String)this.getResource("ANALYZE_STATUS_NOTCHECK"));
            return false;
        }
        return result;
    }

    protected void initListener() {
        super.initListener();
        this.prmtstorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object newValue = e.getNewValue();
                Object oldValue = e.getOldValue();
                if (!(newValue instanceof StorageOrgUnitInfo)) {
                    return;
                }
                if (!(oldValue instanceof StorageOrgUnitInfo) && !(oldValue instanceof FullOrgUnitInfo)) {
                    return;
                }
                AnalyzeIssueReportFilterUI.this.kDBizBillNumF.setValue(null);
                AnalyzeIssueReportFilterUI.this.kDBizBillNumT.setValue(null);
                AnalyzeIssueReportFilterUI.this.promMaterialF.setValue(null);
                AnalyzeIssueReportFilterUI.this.promMaterialT.setValue(null);
                AnalyzeIssueReportFilterUI.this.promMaterialNumF.setValue(null);
                AnalyzeIssueReportFilterUI.this.promMaterialNumT.setValue(null);
            }
        });
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalyzeIssueReportFilterUI.this.moveUp();
            }
        });
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalyzeIssueReportFilterUI.this.moveDown();
            }
        });
    }

    private void moveUp() {
        int n = this.kDTable1.getSelectManager().getActiveRowIndex();
        if (n > 0) {
            this.kDTable1.moveRow(n, n - 1);
            this.kDTable1.getSelectManager().select(n - 1, 1, 2);
            this.kDTable1.getSelectManager().setActiveRowIndex(n - 1);
        }
    }

    private void moveDown() {
        int n = this.kDTable1.getSelectManager().getActiveRowIndex();
        if (n < this.kDTable1.getRowCount()) {
            boolean b = this.kDTable1.moveRow(n + 1, n);
            this.kDTable1.getSelectManager().select(n + 1, 1, 2);
            this.kDTable1.getSelectManager().setActiveRowIndex(n + 1);
        }
    }

    private Timestamp getDefaultDateRangeFrom(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    private Timestamp getDefaultDateRangeTo(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    private String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.report.AnalyzeIssueReportResource", (String)strKey);
    }

    public boolean isReport() {
        return true;
    }

    protected String getViewPermission() {
        return "mm_AnalyzeIssueReport_Query";
    }

    public void setCustomerParams(CustomerParams cp) {
        String sort;
        super.setCustomerParams(cp);
        this.cp = cp;
        if (cp != null && (sort = cp.getCustomerParam("sort")) != null) {
            String[] rowids = sort.split(",");
            this.kDTable1.removeRows();
            int n = rowids.length;
            for (int i = 0; i < n; ++i) {
                this.kDTable1.addRow(i, (IRow)this.kdRow2Map.get(rowids[i]));
                if (cp.getCustomerParam("" + i).equals("true")) {
                    this.kDTable1.getRow(i).getCell(TB_ISTOTAL).setValue((Object)new Boolean(true));
                    continue;
                }
                this.kDTable1.getRow(i).getCell(TB_ISTOTAL).setValue((Object)new Boolean(false));
            }
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        String sort = "";
        if (this.prmtstorageOrgUnit.getValue() != null) {
            int n = this.kDTable1.getRowCount();
            for (int i = 0; i < n; ++i) {
                sort = sort + (String)this.kDTable1.getRow(i).getCell(TB_ID).getValue() + ",";
                pp.addCustomerParam("" + i, ((Boolean)this.kDTable1.getRow(i).getCell(TB_ISTOTAL).getValue()).toString());
            }
            pp.addCustomerParam("sort", sort);
        }
        return pp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        String sort = this.cp.getCustomerParam("sort");
        if (sort != null) {
            String[] rowids = sort.split(",");
            this.kDTable1.removeRows();
            int n = rowids.length;
            for (int i = 0; i < n; ++i) {
                this.kDTable1.addRow(i, (IRow)this.kdRow2Map.get(rowids[i]));
                if (this.cp.getCustomerParam("" + i).equals("true")) {
                    this.kDTable1.getRow(i).getCell(TB_ISTOTAL).setValue((Object)new Boolean(true));
                    continue;
                }
                this.kDTable1.getRow(i).getCell(TB_ISTOTAL).setValue((Object)new Boolean(false));
            }
        }
    }

    public static final class KDTableFilterElement
    extends SingleFilterElement {
        private KDTable table;

        public KDTableFilterElement(String id, KDTable component) {
            super(id, (Component)component);
            this.table = component;
        }

        protected String getName(Object obj) {
            if (obj instanceof KDTable) {
                return ((KDTable)obj).getName();
            }
            return null;
        }

        public void addCustomerParam(CustomerParams cp, String key, Object obj) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    IColumn col = this.table.getColumn(j);
                    cp.addCustomerParam("_" + col.getKey() + ":" + i, this.table.getRow(i).getCell(col.getKey()).getValue().toString());
                }
            }
        }

        public void addRptParams(RptParams cp) {
            ArrayList list = this.getParamterFromKDTable();
            cp.setObject(this.getId(), (Object)list);
        }

        private ArrayList getParamterFromKDTable() {
            ArrayList list = new ArrayList();
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    IColumn col = this.table.getColumn(j);
                    map.put(col.getKey(), this.table.getRow(i).getCell(col.getKey()).getValue());
                }
                list.add(map);
            }
            return list;
        }
    }
}

