/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.data.impl.DataSetWrapperFactory;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.form.model.combin.CombinUIApplication;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.ITableTreeController;
import com.kingdee.eas.mm.common.client.TableTreeHelper;
import com.kingdee.eas.mm.common.client.TableTreeNode;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ScrapTypeEnum;
import com.kingdee.eas.mm.mo.client.ManufactureOrderProcessor;
import com.kingdee.eas.mm.planning.PlannedOrderTypeEnum;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.report.IManuOrderTraceFacade;
import com.kingdee.eas.mm.report.ManuOrderTraceFacadeFactory;
import com.kingdee.eas.mm.report.ManuOrderTraceShowBillInfo;
import com.kingdee.eas.mm.report.client.AbstractManufactureOrderTraceListUI;
import com.kingdee.eas.mm.report.client.ITreeController;
import com.kingdee.eas.mm.report.client.ManuOrderTraceSetShowUI;
import com.kingdee.eas.mm.report.client.ManufactureOrderTraceFilterUI;
import com.kingdee.eas.mm.report.client.TableHeaderInfo;
import com.kingdee.eas.mm.sfc.ReportTypeEnum;
import com.kingdee.eas.mm.sfc.WPTransferTypeEnum;
import com.kingdee.eas.qm.basedata.QCStrategyEnum;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.qc.QCBizStateEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.sm.sc.DosingTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ManufactureOrderTraceListUI
extends AbstractManufactureOrderTraceListUI
implements ITableTreeController {
    private static final Logger logger = CoreUIObject.getLogger(ManufactureOrderTraceListUI.class);
    private boolean mustShowQueryDialog = false;
    private boolean ONLOADINTO = false;
    private CommonQueryDialog queryDialog;
    protected IMetaDataPK mainQueryPK;
    private ManufactureOrderTraceFilterUI filterUI = null;
    private OrgUnitCollection authorizedMainOrgs = null;
    private ITreeController controller;
    private DefaultTreeModel model = null;
    boolean isShowHeader = true;
    private KDTable currentTable = new KDTable();
    public static final String REPORT_RESOURCE = "com.kingdee.eas.mm.report.ManuOrderTraceResource";
    private Map tableHeader = new HashMap();
    private List currentBills = new ArrayList();
    private FilterInfo filterInfo;
    private Set manOrderIDSet = null;
    private CombinUIApplication application = null;
    private List disBillTypes = new ArrayList();
    private TableTreeHelper tableTreeHelper;
    private int COLUMN_TREENODE = 0;
    private int COLUMN_TREENODE_WIDTH = 200;
    private DefaultKingdeeTreeNode curSelectedNode = null;
    private static String storageOrgUnitTxt;
    private static String numberTxt;
    private static String transactionTypeTxt;
    private static String materialNumberTxt;
    private static String materialNameTxt;
    private static String billStatusTxt;
    private static String planBeginDateTxt;
    private static String planEndDateTxt;
    private static String qtyTxt;
    private static String pickingNumTxt;
    private static String finishedNumTxt;
    private static String toStoreQtyTxt;
    private static final String ZERO = "0.00000000";
    public boolean saleOrderShow = true;
    public boolean plannedOrderShow = true;
    public boolean materialReqBillShow = true;
    public boolean completionReportShow = true;
    public boolean wPTransferBillShow = true;
    public boolean qCRequestShow = true;
    public boolean scrapOrderShow = true;
    public boolean manufactureRecBillShow = true;
    public boolean transferOrderBill = true;
    public boolean stockTransferBillShow = true;
    public boolean manufactureOrderShow = true;
    public TrackNumberInfo billtrackNumber;
    public ProjectInfo billproject;

    public ManufactureOrderTraceListUI() throws Exception {
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "MsgQuery");
        this.treeMain.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ManufactureOrderTraceListUI.this.manOrderTree_valueChanged(e);
            }
        });
        this.initTableHeader();
        this.initBillList();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTree();
        this.currentTable = this.tblMain;
        this.currentBills = this.disBillTypes;
        this.currentTable.refresh();
        this.tblMain.getColumn(this.COLUMN_TREENODE).setWidth(this.COLUMN_TREENODE_WIDTH);
        this.currentTable.removeRows();
        this.insertRow(this.currentTable, null, 0);
        this.loadOrderData(null);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.mustShowQueryDialog = true;
        if (this.showQueryDialog()) {
            this.currentTable = this.tblMain;
            this.currentBills = this.disBillTypes;
            this.tblMain.getColumn(this.COLUMN_TREENODE).setWidth(this.COLUMN_TREENODE_WIDTH);
            if (!this.ONLOADINTO) {
                this.tblMain.getColumn(this.COLUMN_TREENODE).setWidth(this.COLUMN_TREENODE_WIDTH);
                this.currentTable.removeRows();
                this.insertRow(this.currentTable, null, 0);
                this.loadOrderData(null);
            }
            this.ONLOADINTO = false;
        } else {
            SysUtil.abort();
        }
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ManufactureOrderFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected String getKeyFieldName() {
        return "tree";
    }

    public void setIcon() {
    }

    public String getTreeColumn() {
        return "tree";
    }

    public void onLoad() throws Exception {
        this.removeRequestDataListener();
        this.ONLOADINTO = true;
        super.onLoad();
        this.kDTreeView1.getControlPane().remove(4);
        this.toolBar.remove((Component)this.btnAddNew);
        this.toolBar.remove((Component)this.btnView);
        this.toolBar.remove((Component)this.btnEdit);
        this.toolBar.remove((Component)this.btnRemove);
        this.toolBar.remove((Component)this.btnLocate);
        this.menuBar.remove((Component)this.menuEdit);
        this.menuFile.remove((JMenuItem)this.menuItemAddNew);
        this.menuView.remove((JMenuItem)this.menuItemView);
        this.menuView.remove((JMenuItem)this.menuItemLocate);
        this.btnSetShow.setIcon(EASResource.getIcon((String)"imgTbtn_tableshowsetting"));
        this.menuSetShow.setIcon(EASResource.getIcon((String)"imgTbtn_tableshowsetting"));
        this.btnBomView.setIcon(EASResource.getIcon((String)"imgTbtn_analyze"));
        this.menuBomView.setIcon(EASResource.getIcon((String)"imgTbtn_analyze"));
        this.btnRountingView.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.menuRountingView.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnMaterialView.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.menuMaterialView.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.btnBillView.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.menuBillView.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.initTree();
        this.currentBills = this.disBillTypes;
        this.currentTable = this.tblMain;
        this.tableTreeHelper = new TableTreeHelper((CoreUI)this, this.tblMain, (ITableTreeController)this);
        storageOrgUnitTxt = this.kDStorageOrgUnit.getBoundLabelText();
        numberTxt = this.kDNumber.getBoundLabelText();
        transactionTypeTxt = this.kDtransactionType.getBoundLabelText();
        materialNumberTxt = this.kDMaterial.getBoundLabelText();
        materialNameTxt = this.kDMaterialName.getBoundLabelText();
        billStatusTxt = this.kDBillStatus.getBoundLabelText();
        planBeginDateTxt = this.kDPlanBeginDate.getBoundLabelText();
        planEndDateTxt = this.kDPlanEndDate.getBoundLabelText();
        qtyTxt = this.kDQty.getBoundLabelText();
        pickingNumTxt = this.kDPickingNum.getBoundLabelText();
        finishedNumTxt = this.kDFinishedNum.getBoundLabelText();
        toStoreQtyTxt = this.kDToStoreQty.getBoundLabelText();
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    private void manOrderTree_valueChanged(TreeSelectionEvent e) {
        if (this.isChangeTreeFocus()) {
            DefaultKingdeeTreeNode currentNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
            try {
                if (null != currentNode && currentNode != root) {
                    this.curSelectedNode = currentNode;
                    ManufactureOrderInfo nodeInfo = (ManufactureOrderInfo)this.curSelectedNode.getUserObject();
                    ObjectUuidPK pk = new ObjectUuidPK(nodeInfo.getId());
                    this.currentTable.removeRows();
                    this.insertRow(this.currentTable, null, 0);
                    this.loadOrderData((IObjectPK)pk);
                } else if (currentNode == root) {
                    this.currentTable.removeRows();
                    this.insertRow(this.currentTable, null, 0);
                    this.loadOrderData(null);
                } else {
                    this.curSelectedNode = null;
                    this.treeMain.expandPath(new TreePath(root.getPath()));
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    public void loadOrderData(IObjectPK pk) throws Exception {
        if (pk != null) {
            Map manuOrderMap = this.getTreeInterface().getManuOrders(pk);
            this.kDStorageOrgUnit.setBoundLabelText(storageOrgUnitTxt + manuOrderMap.get("storageOrgUnit"));
            this.kDNumber.setBoundLabelText(numberTxt + manuOrderMap.get("number"));
            this.kDtransactionType.setBoundLabelText(transactionTypeTxt + manuOrderMap.get("transactionType"));
            this.kDMaterial.setBoundLabelText(materialNumberTxt + manuOrderMap.get("materialNumber"));
            this.kDMaterialName.setBoundLabelText(materialNameTxt + manuOrderMap.get("materialName"));
            this.kDBillStatus.setBoundLabelText(billStatusTxt + manuOrderMap.get("billStatus"));
            this.kDPlanBeginDate.setBoundLabelText(planBeginDateTxt + this.convertDate(manuOrderMap.get("planBeginDate").toString()));
            this.kDPlanEndDate.setBoundLabelText(planEndDateTxt + this.convertDate(manuOrderMap.get("planEndDate").toString()));
            if (!"0E-8".equals(manuOrderMap.get("qty").toString())) {
                this.kDQty.setBoundLabelText(qtyTxt + manuOrderMap.get("qty") + "    " + manuOrderMap.get("unit"));
            } else {
                this.kDQty.setBoundLabelText(qtyTxt + ZERO + "    " + manuOrderMap.get("unit"));
            }
            if (!"0E-8".equals(manuOrderMap.get("pickingNum").toString())) {
                this.kDPickingNum.setBoundLabelText(pickingNumTxt + manuOrderMap.get("pickingNum"));
            } else {
                this.kDPickingNum.setBoundLabelText(pickingNumTxt + ZERO);
            }
            if (!"0E-8".equals(manuOrderMap.get("finishedNum").toString())) {
                this.kDFinishedNum.setBoundLabelText(finishedNumTxt + manuOrderMap.get("finishedNum").toString() + "    " + manuOrderMap.get("unit"));
            } else {
                this.kDFinishedNum.setBoundLabelText(finishedNumTxt + ZERO + "    " + manuOrderMap.get("unit"));
            }
            if (!"0E-8".equals(manuOrderMap.get("toStoreQty").toString())) {
                this.kDToStoreQty.setBoundLabelText(toStoreQtyTxt + manuOrderMap.get("toStoreQty") + "    " + manuOrderMap.get("unit"));
            } else {
                this.kDToStoreQty.setBoundLabelText(toStoreQtyTxt + ZERO + "    " + manuOrderMap.get("unit"));
            }
            this.getUIContext().put("ID", pk.toString());
        } else {
            this.kDStorageOrgUnit.setBoundLabelText(storageOrgUnitTxt);
            this.kDNumber.setBoundLabelText(numberTxt);
            this.kDtransactionType.setBoundLabelText(transactionTypeTxt);
            this.kDMaterial.setBoundLabelText(materialNumberTxt);
            this.kDMaterialName.setBoundLabelText(materialNameTxt);
            this.kDBillStatus.setBoundLabelText(billStatusTxt);
            this.kDPlanBeginDate.setBoundLabelText(planBeginDateTxt);
            this.kDPlanEndDate.setBoundLabelText(planEndDateTxt);
            this.kDQty.setBoundLabelText(qtyTxt);
            this.kDPickingNum.setBoundLabelText(pickingNumTxt);
            this.kDFinishedNum.setBoundLabelText(finishedNumTxt);
            this.kDToStoreQty.setBoundLabelText(toStoreQtyTxt);
            this.getUIContext().put("ID", null);
        }
    }

    private void resetTreeFocus() {
        if (null != this.curSelectedNode) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.treeMain.getModel();
            TreePath treePath = new TreePath(treeModel.getPathToRoot((TreeNode)this.curSelectedNode));
            this.treeMain.setSelectionPath(treePath);
        }
    }

    private boolean isChangeTreeFocus() {
        boolean doNext = true;
        DefaultKingdeeTreeNode nextNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
        if (null != nextNode && nextNode != root && null != this.curSelectedNode && this.curSelectedNode != root) {
            ManufactureOrderInfo nextMenuInfo;
            ManufactureOrderInfo showOrderInfo = (ManufactureOrderInfo)this.curSelectedNode.getUserObject();
            if (showOrderInfo.equals((Object)(nextMenuInfo = (ManufactureOrderInfo)nextNode.getUserObject()))) {
                doNext = false;
            }
        } else if (nextNode == root && this.curSelectedNode == root) {
            doNext = false;
        }
        return doNext;
    }

    private boolean showQueryDialog() throws Exception {
        this.initCommonQueryDialog();
        this.filterUI.getUIContext().clear();
        this.filterUI.getUIContext().putAll(this.getUIContext());
        boolean hasDefaultSolution = false;
        if (!this.mustShowQueryDialog) {
            try {
                this.queryDialog.init();
                this.queryDialog.getCommonQueryParam().setDirty(false);
                QuerySolutionInfo currSolution = this.queryDialog.getCurrentSolutionInfo();
                if (null != currSolution && currSolution.isIsUserDefaultSolu() && null != currSolution.getEntityViewInfo()) {
                    if (this.queryDialog.getCommonFilter() == null) {
                        EntityViewInfo entityViewInfo = new EntityViewInfo(currSolution.getEntityViewInfo());
                        this.filterInfo = entityViewInfo.getFilter();
                    } else {
                        this.filterInfo = this.queryDialog.getCommonFilter();
                    }
                    this.setMainOrgByFilter(this.filterInfo);
                    hasDefaultSolution = true;
                    this.initTree();
                    return true;
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        FilterInfo newFilterInfos = null;
        if ((this.mustShowQueryDialog || !hasDefaultSolution) && this.queryDialog.show()) {
            if (this.queryDialog.getEntityViewInfoResult() == null || this.queryDialog.getEntityViewInfoResult().getFilter().getFilterItems().size() == 0) {
                ManufactureOrderTraceFilterUI plsFilterui = (ManufactureOrderTraceFilterUI)this.queryDialog.getUserPanel(0);
                newFilterInfos = plsFilterui.getFilterInfo();
                this.queryDialog.getFilterPanelName();
                this.setMainOrgForCommonQueryDialog((CustomerQueryPanel)plsFilterui);
                this.filterInfo = newFilterInfos;
            } else {
                this.filterInfo = this.queryDialog.getEntityViewInfoResult().getFilter();
            }
            this.initTree();
            return true;
        }
        return false;
    }

    protected final void setMainOrgForCommonQueryDialog(CustomerQueryPanel queryPanel) {
        if (queryPanel != null && queryPanel.getMainBizOrgF7().getData() != null) {
            Object mainOrg = queryPanel.getMainBizOrgF7().getData();
            if (mainOrg instanceof OrgUnitInfo && mainOrg != null) {
                this.initUIMainOrgContext(((OrgUnitInfo)mainOrg).getId().toString());
                return;
            }
            if (mainOrg instanceof Object[]) {
                Object[] orgs = (Object[])mainOrg;
                for (int i = 0; i < orgs.length; ++i) {
                    if (orgs[i] == null || ((OrgUnitInfo)orgs[i]).getId() == null) continue;
                    this.initUIMainOrgContext(((OrgUnitInfo)orgs[i]).getId().toString());
                    return;
                }
            }
        }
    }

    public void initBillList() {
        this.disBillTypes.clear();
        if (this.saleOrderShow) {
            this.disBillTypes.add("SaleOrderInManu");
        }
        if (this.plannedOrderShow) {
            this.disBillTypes.add("PlannedOrderInManu");
        }
        if (this.materialReqBillShow) {
            this.disBillTypes.add("MaterialReqBillInManu");
        }
        if (this.completionReportShow) {
            this.disBillTypes.add("CompletionReportInManu");
        }
        if (this.wPTransferBillShow) {
            this.disBillTypes.add("WPTransferBillInManu");
        }
        if (this.qCRequestShow) {
            this.disBillTypes.add("QCRequestInManu");
        }
        if (this.scrapOrderShow) {
            this.disBillTypes.add("ScrapOrderInManu");
        }
        if (this.manufactureRecBillShow) {
            this.disBillTypes.add("ManufactureRecBillInManu");
        }
        if (this.transferOrderBill) {
            this.disBillTypes.add("TransferOrderBillInManu");
        }
        if (this.stockTransferBillShow) {
            this.disBillTypes.add("StockTransferBillInManu");
        }
        if (this.manufactureOrderShow) {
            this.disBillTypes.add("ManufactureOrderInManu");
        }
    }

    public void insertRow(KDTable table, TableTreeNode treeNode, int rowIndex) {
        if (treeNode == null) {
            TableTreeNode node = new TableTreeNode();
            if (this.currentBills.size() < 1) {
                return;
            }
            List header = (List)this.tableHeader.get(this.currentBills.get(0));
            String rsKey = "";
            node.setId("0");
            node.setLeaf(false);
            node.setFirst(true);
            node.setLast(true);
            node.setLevel(1);
            node.setDataLevel(false);
            node.setHasExpanded(false);
            node.setHasChild(true);
            node.setIconEmpty(false);
            rsKey = ((TableHeaderInfo)header.get(0)).getRsKey();
            node.setName(EASResource.getString((String)REPORT_RESOURCE, (String)rsKey));
            node.setUserObject(this.currentBills.get(0));
            IRow row = this.currentTable.addRow();
            row.getStyleAttributes().setBackground(this.tblMain.getHead().getRow(0).getStyle().getBackground());
            row.getCell(0).setValue((Object)node);
            node.setExpanded(false);
            node.setHasExpanded(false);
            for (int i = 1; i < header.size(); ++i) {
                rsKey = ((TableHeaderInfo)header.get(i)).getRsKey();
                row.getCell(i).setValue((Object)EASResource.getString((String)REPORT_RESOURCE, (String)rsKey));
            }
            this.insertHeader(null, rowIndex);
        } else if (treeNode.isDataLevel() && !treeNode.isLeaf()) {
            treeNode.setHasChild(true);
            treeNode.setLeaf(false);
            this.insertHeader(treeNode, rowIndex);
        } else {
            try {
                if (this.getUIContext().get("ID") == null) {
                    return;
                }
                String pk = this.getUIContext().get("ID").toString();
                IRowSet set = this.getTreeInterface().getBills((String)treeNode.getUserObject(), this.billtrackNumber, this.billproject, pk);
                this.insertData(treeNode, set, rowIndex);
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
    }

    public void insertData(TableTreeNode treeNode, IRowSet set, int rowIndex) throws Exception {
        String billType = (String)treeNode.getUserObject();
        int i = 0;
        while (set.next()) {
            IRow row = this.currentTable.addRow(++rowIndex);
            TableTreeNode node = new TableTreeNode();
            node.setId(String.valueOf(i));
            node.setLeaf(true);
            node.setFirst(i == 0);
            node.setLast(i == set.size() - 1);
            node.setLevel(treeNode.getLevel() + 1);
            node.setDataLevel(true);
            node.setHasExpanded(false);
            node.setIconEmpty(false);
            node.setName(set.getString("FNUMBER"));
            node.setUserObject((Object)set.getString("ID"));
            node.setParent(treeNode);
            row.getCell(0).setValue((Object)node);
            row.getCell("materialId").setValue((Object)set.getString("MaterialID"));
            List tableHeaderExpand = (List)this.tableHeader.get(billType);
            String fieldName = "";
            for (int j = 1; j < tableHeaderExpand.size(); ++j) {
                fieldName = ((TableHeaderInfo)tableHeaderExpand.get(j)).getFieldName();
                if ("baseStatus".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)BillBaseStatusEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("entryBaseStatus".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)EntryBaseStatusEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("RowStatus".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)EntryBaseStatusEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("scrapType".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)ScrapTypeEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("reportType".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)ReportTypeEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("transferType".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)WPTransferTypeEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("orderType".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)PlannedOrderTypeEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("DOSINGTYPE".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)DosingTypeEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("OUTPUTTYPE".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)MaterialProductEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("billStatus".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)QMBillBaseStatusEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("qcStrategy".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)QCStrategyEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("sampleState".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)QCBizStateEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("qcBillState".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)QCBizStateEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("reportState".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)QCBizStateEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if ("isReturnResult".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)(set.getString(fieldName).equals("1") ? EASResource.getString((String)"com.kingdee.eas.mm.report.REPORTAutoGenerateResource", (String)"81_ManufactureOrderTraceListUI") : EASResource.getString((String)"com.kingdee.eas.mm.report.REPORTAutoGenerateResource", (String)"80_PlannerWorkPlatSigleProcessServer")));
                    continue;
                }
                if ("MaterialAttribute".equals(fieldName)) {
                    if (null == set.getString(fieldName)) continue;
                    row.getCell(j).setValue((Object)MaterialAttributeEnum.getEnum((int)new Integer(set.getString(fieldName))));
                    continue;
                }
                if (fieldName.indexOf("Date") != -1) {
                    row.getCell(j).setValue((Object)this.convertDate(set.getString(fieldName)));
                    continue;
                }
                if (fieldName.indexOf("Qty") != -1) {
                    row.getCell(j).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row.getCell(j).setValue((Object)set.getString(fieldName));
                    continue;
                }
                row.getCell(j).setValue((Object)set.getString(fieldName));
            }
            ++i;
        }
        if (i == 0) {
            treeNode.setHasChild(false);
        }
    }

    protected IManuOrderTraceFacade getTreeInterface() throws Exception {
        return ManuOrderTraceFacadeFactory.getRemoteInstanceWithObjectContext(this.getUserContext());
    }

    public void insertHeader(TableTreeNode treeNode, int rowIndex) {
        String billType = "";
        String rsKey = "";
        for (int i = 1; i < this.currentBills.size(); ++i) {
            IRow row = this.currentTable.addRow(++rowIndex);
            row.getStyleAttributes().setBackground(this.tblMain.getHead().getRow(0).getStyle().getBackground());
            billType = (String)this.currentBills.get(i);
            List header = (List)this.tableHeader.get(billType);
            TableTreeNode node = new TableTreeNode();
            node.setId(String.valueOf(i));
            node.setLeaf(false);
            node.setFirst(i == 1);
            node.setLast(i == this.currentBills.size() - 1);
            node.setLevel(null != treeNode ? treeNode.getLevel() + 1 : 1);
            node.setDataLevel(false);
            node.setHasExpanded(false);
            node.setHasChild(true);
            node.setIconEmpty(false);
            rsKey = ((TableHeaderInfo)header.get(0)).getRsKey();
            node.setName(EASResource.getString((String)REPORT_RESOURCE, (String)rsKey));
            node.setParent(treeNode);
            node.setUserObject((Object)billType);
            row.getCell(0).setValue((Object)node);
            for (int j = 1; j < header.size(); ++j) {
                rsKey = ((TableHeaderInfo)header.get(j)).getRsKey();
                row.getCell(j).setValue((Object)EASResource.getString((String)REPORT_RESOURCE, (String)rsKey));
            }
        }
    }

    private String convertDate(String source) {
        Date date;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if ("".equals(source) || source == null) {
                return "";
            }
            date = dateFormat.parse(source);
        }
        catch (ParseException e) {
            date = new Date();
        }
        return dateFormat.format(date);
    }

    protected ISCMFilter getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ManufactureOrderTraceFilterUI();
        }
        return this.filterUI;
    }

    protected void initTableParams() {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(10);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        ManufactureOrderProcessor processor = new ManufactureOrderProcessor();
        this.queryDialog = super.initCommonQueryDialog();
        this.queryDialog.setProcessor((IProcessor)processor);
        this.queryDialog.setWidth(540);
        this.queryDialog.setHeight(440);
        try {
            ISCMFilter iFilter = this.getFilterUI();
            iFilter.setIsSupportMultiOrgs(true);
            iFilter.setContextObject((Object)this.getUIContext());
            this.queryDialog.addUserPanel((KDPanel)iFilter);
            this.queryDialog.setShowFilter(true);
            this.queryDialog.setUiObject(null);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return this.queryDialog;
    }

    protected void initTree() throws Exception {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource.ManufactureOrder"));
        ManufactureOrderCollection moCol = null;
        IManufactureOrder imo = (IManufactureOrder)this.getBizInterface();
        moCol = (ManufactureOrderCollection)imo.getManOrderCollectionForTree(this.filterInfo);
        this.buildManOrderTree(root, moCol);
        this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        this.treeMain.setRootVisible(true);
        this.treeMain.setShowsRootHandles(true);
        this.treeMain.getSelectionModel().setSelectionMode(2);
    }

    protected final void setMainOrgByFilter(FilterInfo filter) throws BOSException {
        if (filter.getFilterItems() != null && filter.getFilterItems().size() > 0) {
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo filterItemInfo = filter.getFilterItems().get(i);
                CompareType comp = filterItemInfo.getCompareType();
                if (!filterItemInfo.getPropertyName().equals("storageOrgUnit.number")) continue;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo orgFilter = new FilterInfo();
                if (comp.equals((Object)CompareType.INCLUDE)) {
                    HashSet orgSet = (HashSet)filterItemInfo.getCompareValue();
                    orgFilter.getFilterItems().add(new FilterItemInfo("number", (Object)orgSet, CompareType.INCLUDE));
                } else if (comp.equals((Object)CompareType.EQUALS)) {
                    String orgNumber = (String)filterItemInfo.getCompareValue();
                    orgFilter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber, CompareType.EQUALS));
                }
                view.setFilter(orgFilter);
                IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
                FullOrgUnitCollection orgCol = iOrgUnit.getFullOrgUnitCollection(view);
                if (orgCol.size() <= 0) continue;
                this.initUIMainOrgContext(orgCol.get(0).getId().toString());
                return;
            }
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    public void actionSetShow_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)this.getMainBizOrgType(), this.getMainOrgContext().get((Object)this.getMainBizOrgType()));
        ManuOrderTraceShowBillInfo billInfobefore = new ManuOrderTraceShowBillInfo();
        billInfobefore.setSaleOrderShow(this.saleOrderShow);
        billInfobefore.setPlannedOrderShow(this.plannedOrderShow);
        billInfobefore.setMaterialReqBillShow(this.materialReqBillShow);
        billInfobefore.setCompletionReportShow(this.completionReportShow);
        billInfobefore.setWPTransferBillShow(this.wPTransferBillShow);
        billInfobefore.setQCRequestShow(this.qCRequestShow);
        billInfobefore.setScrapOrderShow(this.scrapOrderShow);
        billInfobefore.setManufactureRecBillShow(this.manufactureRecBillShow);
        billInfobefore.setTransferOrderBill(this.transferOrderBill);
        billInfobefore.setStockTransferBillShow(this.stockTransferBillShow);
        billInfobefore.setManufactureOrderShow(this.manufactureOrderShow);
        billInfobefore.setTrackNumber(this.billtrackNumber);
        billInfobefore.setProject(this.billproject);
        uiContext.put((Object)"billInfo", (Object)billInfobefore);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.mm.report.client.ManuOrderTraceSetShowUI", (Map)uiContext, null);
        window.show();
        Map showMap = ((ManuOrderTraceSetShowUI)window.getUIObject()).getUIContext();
        if (showMap.get("ShowBillInfo") != null) {
            ManuOrderTraceShowBillInfo billInfo = (ManuOrderTraceShowBillInfo)showMap.get("ShowBillInfo");
            this.saleOrderShow = billInfo.isSaleOrderShow();
            this.plannedOrderShow = billInfo.isPlannedOrderShow();
            this.materialReqBillShow = billInfo.isMaterialReqBillShow();
            this.completionReportShow = billInfo.isCompletionReportShow();
            this.wPTransferBillShow = billInfo.isWPTransferBillShow();
            this.qCRequestShow = billInfo.isQCRequestShow();
            this.scrapOrderShow = billInfo.isScrapOrderShow();
            this.manufactureRecBillShow = billInfo.isManufactureRecBillShow();
            this.transferOrderBill = billInfo.isTransferOrderBill();
            this.stockTransferBillShow = billInfo.isStockTransferBillShow();
            this.manufactureOrderShow = billInfo.isManufactureOrderShow();
            this.billproject = billInfo.getProject() != null ? billInfo.getProject() : null;
            this.billtrackNumber = billInfo.getTrackNumber() != null ? billInfo.getTrackNumber() : null;
            this.initBillList();
            this.currentTable.removeRows();
            if (this.disBillTypes.size() > 0) {
                this.insertRow(this.currentTable, null, 0);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionBillView_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"NoSelectedDataRow"));
            return;
        }
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        TableTreeNode node = (TableTreeNode)this.tblMain.getCell(i, 0).getValue();
        if (node.getLevel() <= 1) {
            MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"NoSelectedDataRow"));
            return;
        }
        if (node.getUserObject() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"NoSelectedDataRow"));
            return;
        }
        String billUI = "";
        TableTreeNode treenode = node;
        for (int j = node.getLevel() - 1; j >= 1; treenode = treenode.getParent(), --j) {
        }
        String billType = treenode.getUserObject().toString();
        if ("SaleOrderInManu".equals(billType)) {
            billUI = "com.kingdee.eas.scm.sd.sale.client.SaleOrderEditUI";
        } else if ("PlannedOrderInManu".equals(billType)) {
            billUI = "com.kingdee.eas.mm.planning.client.PlannedOrderEditUI";
        } else if ("MaterialReqBillInManu".equals(billType)) {
            billUI = "com.kingdee.eas.scm.im.inv.client.MaterialReqBillEditUI";
        } else if ("CompletionReportInManu".equals(billType)) {
            billUI = "com.kingdee.eas.mm.sfc.client.CompletionReportEditUI";
        } else if ("WPTransferBillInManu".equals(billType)) {
            billUI = "com.kingdee.eas.mm.sfc.client.WPTransferBillEditUI";
        } else if ("QCRequestInManu".equals(billType)) {
            billUI = "com.kingdee.eas.qm.qc.client.QCRequestEditUI";
        } else if ("ScrapOrderInManu".equals(billType)) {
            billUI = "com.kingdee.eas.mm.mo.client.ScrapOrderEditUI";
        } else if ("ManufactureRecBillInManu".equals(billType)) {
            billUI = "com.kingdee.eas.scm.im.inv.client.ManufactureRecBillEditUI";
        } else if ("TransferOrderBillInManu".equals(billType)) {
            billUI = "com.kingdee.eas.scm.im.inv.client.TransferOrderBillEditUI";
        } else if ("StockTransferBillInManu".equals(billType)) {
            billUI = "com.kingdee.eas.scm.im.inv.client.StockTransferBillEditUI";
        } else if ("ManufactureOrderInManu".equals(billType)) {
            billUI = "com.kingdee.eas.mm.mo.client.ManufactureOrderEditUI";
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"NoHasBillType"));
            SysUtil.abort();
        }
        String voucherId = (String)node.getUserObject();
        this.getTreeInterface().checkBillViewPermission(voucherId, billType);
        UIContext uiContext = new UIContext((Object)this);
        RealModeIDList idList = RealModeIDList.getEmptyIDList();
        idList.add(node.getUserObject().toString());
        uiContext.put((Object)"IDList", (Object)idList);
        uiContext.put((Object)"ID", node.getUserObject());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(billUI, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionBomView_actionPerformed(ActionEvent e) throws Exception {
        ManufactureOrderInfo moInfo;
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        ipermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId().toString()), "mm_bom_view");
        DefaultKingdeeTreeNode currentNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
        if (null != currentNode && currentNode != root) {
            this.curSelectedNode = currentNode;
            ManufactureOrderInfo nodeInfo = (ManufactureOrderInfo)this.curSelectedNode.getUserObject();
            ObjectUuidPK pk = new ObjectUuidPK(nodeInfo.getId());
            moInfo = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderInfo((IObjectPK)pk);
            if (null == moInfo.getBomID()) {
                MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"ManuHasnotBom"));
                return;
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"NoSelectedManu"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)moInfo.getBomID());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.basedata.client.BomEditUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionMaterialView_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode currentNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
        if (null != currentNode && currentNode != root) {
            ManufactureOrderInfo moInfo;
            ObjectUuidPK pk = null;
            BOSUuid materialID = null;
            this.curSelectedNode = currentNode;
            ManufactureOrderInfo nodeInfo = (ManufactureOrderInfo)this.curSelectedNode.getUserObject();
            if (this.tblMain.getSelectManager().size() != 0) {
                int i = this.tblMain.getSelectManager().getActiveRowIndex();
                TableTreeNode node = (TableTreeNode)this.tblMain.getCell(i, 0).getValue();
                if (node.getLevel() > 1) {
                    if (this.tblMain.getCell(i, "materialId").getValue() == null) {
                        MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"ManuHasnotMaterial"));
                        return;
                    }
                    materialID = BOSUuid.read((String)this.tblMain.getCell(i, "materialId").getValue().toString());
                } else {
                    pk = new ObjectUuidPK(nodeInfo.getId());
                }
            } else {
                pk = new ObjectUuidPK(nodeInfo.getId());
            }
            if (pk != null && null != (moInfo = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderInfo((IObjectPK)pk)).getMaterial()) {
                materialID = moInfo.getMaterial().getId();
            }
            if (materialID == null) {
                MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"ManuHasnotMaterial"));
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)materialID.toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.master.material.client.MaterialEditUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            return;
        }
        MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"SelectedManuOrRow"));
    }

    @Override
    public void actionRountingView_actionPerformed(ActionEvent e) throws Exception {
        ManufactureOrderInfo moInfo;
        DefaultKingdeeTreeNode currentNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
        if (null != currentNode && currentNode != root) {
            this.curSelectedNode = currentNode;
            ManufactureOrderInfo nodeInfo = (ManufactureOrderInfo)this.curSelectedNode.getUserObject();
            ObjectUuidPK pk = new ObjectUuidPK(nodeInfo.getId());
            moInfo = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderInfo((IObjectPK)pk);
            if (null == moInfo.getRouting()) {
                MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"ManuHasnotRouting"));
                return;
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"NoSelectedManu"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)moInfo.getRouting().getId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.basedata.client.StandardRootingEditUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void buildManOrderTree(DefaultKingdeeTreeNode root, ManufactureOrderCollection moCol) throws Exception {
        IObjectValue[] moArray = this.preProcessTreeData(moCol);
        Arrays.sort(moArray, new ManufactureOrderTraceComparator());
        int maxLevel = 0;
        if (moArray.length > 0) {
            maxLevel = ((ManufactureOrderInfo)moArray[moArray.length - 1]).getLevel();
        }
        ArrayList list = new ArrayList();
        for (int i = 0; i <= maxLevel; ++i) {
            ArrayList list1 = new ArrayList();
            list.add(list1);
        }
        Icon Icon_Folder_Open = EASResource.getIcon((String)"imgTree_folder_open");
        Icon Icon_Folder_Close = EASResource.getIcon((String)"imgTree_folder_close");
        Icon Icon_Leaf = EASResource.getIcon((String)"imgTree_folder_leaf");
        ManufactureOrderInfo moInfo = null;
        DefaultKingdeeTreeNode parent = null;
        String longNumber = null;
        String pathTemp = null;
        String parentID = null;
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        int size = moArray.length;
        for (int index = 0; index < size; ++index) {
            moInfo = (ManufactureOrderInfo)moArray[index];
            longNumber = moInfo.getLongNumber();
            KDTreeNode subTreeNode = new KDTreeNode((Object)moInfo);
            subTreeNode.setText(moInfo.getNumber());
            if (moInfo.isIsLeaf()) {
                subTreeNode.setCustomIcon(Icon_Leaf);
            } else {
                subTreeNode.setCustomOpenIcon(Icon_Folder_Open);
                subTreeNode.setCustomClosedIcon(Icon_Folder_Close);
                nodeMap.put(moInfo.getId().toString(), subTreeNode);
            }
            if (moInfo.getLevel() == 0) {
                root.add((MutableTreeNode)subTreeNode);
                continue;
            }
            pathTemp = longNumber.substring(0, longNumber.lastIndexOf("!"));
            if (pathTemp.lastIndexOf("!") > 0) {
                parentID = pathTemp.substring(pathTemp.lastIndexOf("!"));
                String[] parentIds = parentID.split("!");
                parentID = parentIds[parentIds.length - 1];
            } else {
                parentID = pathTemp;
            }
            parent = (DefaultKingdeeTreeNode)nodeMap.get(parentID);
            if (parent == null) continue;
            ArrayList list1 = (ArrayList)list.get(moInfo.getLevel());
            HashMap<KDTreeNode, DefaultKingdeeTreeNode> map = new HashMap<KDTreeNode, DefaultKingdeeTreeNode>();
            map.put(subTreeNode, parent);
            list1.add(map);
        }
        for (int i = 0; i < list.size(); ++i) {
            ArrayList list1 = (ArrayList)list.get(i);
            for (int j = 0; j < list1.size(); ++j) {
                Map map = (Map)list1.get(j);
                for (DefaultKingdeeTreeNode subNode : map.keySet()) {
                    parent = (DefaultKingdeeTreeNode)map.get(subNode);
                    parent.add((MutableTreeNode)subNode);
                }
            }
        }
    }

    public IObjectValue[] preProcessTreeData(ManufactureOrderCollection moCol) throws Exception {
        IObjectValue[] moArray = new IObjectValue[moCol.size()];
        ManufactureOrderInfo moInfo = null;
        String longNumber = null;
        int level = 0;
        Iterator iter = moCol.iterator();
        this.manOrderIDSet = new HashSet();
        HashSet<String> parentLongNumberSet = new HashSet<String>();
        while (iter.hasNext()) {
            moInfo = (ManufactureOrderInfo)iter.next();
            this.manOrderIDSet.add(moInfo.getId().toString());
            longNumber = moInfo.getLongNumber();
            if (longNumber.lastIndexOf("!") <= 0) continue;
            parentLongNumberSet.add(longNumber.substring(0, longNumber.lastIndexOf("!")));
        }
        int size = moCol.size();
        for (int index = 0; index < size; ++index) {
            moInfo = moCol.get(index);
            longNumber = moInfo.getLongNumber();
            level = longNumber.split("!").length - 1;
            moInfo.setLevel(level);
            if (parentLongNumberSet.contains(moInfo.getLongNumber())) {
                moInfo.setIsLeaf(false);
            } else {
                moInfo.setIsLeaf(true);
            }
            moArray[index] = moInfo;
        }
        if (this.application != null) {
            Context ctx = new Context();
            ctx.put((Object)"IDList", (Object)this.manOrderIDSet);
            ctx.put((Object)"ORGID", (Object)((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId().toString());
            this.application.setContext(ctx);
        }
        return moArray;
    }

    public void attach(CombinUIApplication app) {
        this.application = app;
    }

    public void initTableHeader() {
        this.tableHeader.put("SaleOrderInManu", this.initSaleOrderHeader());
        this.tableHeader.put("PlannedOrderInManu", this.initPlannedOrderHeader());
        this.tableHeader.put("MaterialReqBillInManu", this.initMaterialReqBillHeader());
        this.tableHeader.put("CompletionReportInManu", this.initCompletionReportHeader());
        this.tableHeader.put("WPTransferBillInManu", this.initWPTransferBillHeader());
        this.tableHeader.put("QCRequestInManu", this.initQCRequestHeader());
        this.tableHeader.put("ScrapOrderInManu", this.initScrapOrderHeader());
        this.tableHeader.put("ManufactureRecBillInManu", this.initManufactureRecBillHeader());
        this.tableHeader.put("TransferOrderBillInManu", this.initTransferOrderBillHeader());
        this.tableHeader.put("StockTransferBillInManu", this.initStockTransferBillHeader());
        this.tableHeader.put("ManufactureOrderInManu", this.initManufactureOrderHeader());
        this.currentBills.add(this.tableHeader);
    }

    public List initManufactureOrderHeader() {
        ArrayList<TableHeaderInfo> manufactureOrderHeader = new ArrayList<TableHeaderInfo>();
        manufactureOrderHeader.add(new TableHeaderInfo("ManufactureOrderInManu", "FNUMBER", "ManufactureOrder_Order"));
        manufactureOrderHeader.add(new TableHeaderInfo("bizType", "bizType", "bizType"));
        manufactureOrderHeader.add(new TableHeaderInfo("baseStatus", "baseStatus", "baseStatus"));
        manufactureOrderHeader.add(new TableHeaderInfo("productNumber", "productNumber", "productNumber"));
        manufactureOrderHeader.add(new TableHeaderInfo("productName", "productName", "productName"));
        manufactureOrderHeader.add(new TableHeaderInfo("Qty", "Qty", "Qty"));
        manufactureOrderHeader.add(new TableHeaderInfo("Unit", "Unit", "Unit"));
        manufactureOrderHeader.add(new TableHeaderInfo("startDate", "startDate", "startDate"));
        manufactureOrderHeader.add(new TableHeaderInfo("endDate", "endDate", "endDate"));
        manufactureOrderHeader.add(new TableHeaderInfo("finishedQty", "finishedQty", "finishedQty"));
        manufactureOrderHeader.add(new TableHeaderInfo("scrapQty", "scrapQty", "scrapQty"));
        manufactureOrderHeader.add(new TableHeaderInfo("repairQty", "repairQty", "repairQty"));
        manufactureOrderHeader.add(new TableHeaderInfo("toStroreQty", "toStroreQty", "toStroreQty"));
        manufactureOrderHeader.add(new TableHeaderInfo("project", "project", "project"));
        manufactureOrderHeader.add(new TableHeaderInfo("trackNumber", "trackNumber", "trackNumber"));
        return manufactureOrderHeader;
    }

    public List initStockTransferBillHeader() {
        ArrayList<TableHeaderInfo> stockTransferBillHeader = new ArrayList<TableHeaderInfo>();
        stockTransferBillHeader.add(new TableHeaderInfo("StockTransferBillInManu", "FNUMBER", "StockTransferBill_Order"));
        stockTransferBillHeader.add(new TableHeaderInfo("bizType", "bizType", "bizType"));
        stockTransferBillHeader.add(new TableHeaderInfo("baseStatus", "baseStatus", "baseStatus"));
        stockTransferBillHeader.add(new TableHeaderInfo("RowStatus", "RowStatus", "RowStatus"));
        stockTransferBillHeader.add(new TableHeaderInfo("MaterialNumber", "MaterialNumber", "MaterialNumber"));
        stockTransferBillHeader.add(new TableHeaderInfo("MaterialName", "MaterialName", "MaterialName"));
        stockTransferBillHeader.add(new TableHeaderInfo("lot", "lot", "lot"));
        stockTransferBillHeader.add(new TableHeaderInfo("Unit", "Unit", "Unit"));
        stockTransferBillHeader.add(new TableHeaderInfo("Qty", "Qty", "Qty"));
        stockTransferBillHeader.add(new TableHeaderInfo("moveOutStorageOrgUnit", "moveOutStorageOrgUnit", "moveOutStorageOrgUnit"));
        stockTransferBillHeader.add(new TableHeaderInfo("moveOutWarehouse", "moveOutWarehouse", "moveOutWarehouse"));
        stockTransferBillHeader.add(new TableHeaderInfo("moveInStorageOrgUnit", "moveInStorageOrgUnit", "moveInStorageOrgUnit"));
        stockTransferBillHeader.add(new TableHeaderInfo("moveInWarehouse", "moveInWarehouse", "moveInWarehouse"));
        stockTransferBillHeader.add(new TableHeaderInfo("totalMoveOutQty", "totalMoveOutQty", "totalMoveOutQty"));
        stockTransferBillHeader.add(new TableHeaderInfo("totalMoveInQty", "totalMoveInQty", "totalMoveInQty"));
        stockTransferBillHeader.add(new TableHeaderInfo("project", "project", "project"));
        stockTransferBillHeader.add(new TableHeaderInfo("trackNumber", "trackNumber", "trackNumber"));
        return stockTransferBillHeader;
    }

    public List initTransferOrderBillHeader() {
        ArrayList<TableHeaderInfo> transferOrderBillHeader = new ArrayList<TableHeaderInfo>();
        transferOrderBillHeader.add(new TableHeaderInfo("TransferOrderBillInManu", "FNUMBER", "TransferOrderBill_Order"));
        transferOrderBillHeader.add(new TableHeaderInfo("bizType", "bizType", "bizType"));
        transferOrderBillHeader.add(new TableHeaderInfo("baseStatus", "baseStatus", "baseStatus"));
        transferOrderBillHeader.add(new TableHeaderInfo("RowStatus", "RowStatus", "RowStatus"));
        transferOrderBillHeader.add(new TableHeaderInfo("MaterialNumber", "MaterialNumber", "MaterialNumber"));
        transferOrderBillHeader.add(new TableHeaderInfo("MaterialName", "MaterialName", "MaterialName"));
        transferOrderBillHeader.add(new TableHeaderInfo("lot", "lot", "lot"));
        transferOrderBillHeader.add(new TableHeaderInfo("Unit", "Unit", "Unit"));
        transferOrderBillHeader.add(new TableHeaderInfo("Qty", "Qty", "Qty"));
        transferOrderBillHeader.add(new TableHeaderInfo("issueStorageOrgUnit", "issueStorageOrgUnit", "issueStorageOrgUnit"));
        transferOrderBillHeader.add(new TableHeaderInfo("issueWarehouse", "issueWarehouse", "issueWarehouse"));
        transferOrderBillHeader.add(new TableHeaderInfo("receiveStorageOrgUnit", "receiveStorageOrgUnit", "receiveStorageOrgUnit"));
        transferOrderBillHeader.add(new TableHeaderInfo("receiptWarehouse", "receiptWarehouse", "receiptWarehouse"));
        transferOrderBillHeader.add(new TableHeaderInfo("issueQty", "issueQty", "issueQty"));
        transferOrderBillHeader.add(new TableHeaderInfo("receiptQty", "receiptQty", "receiptQty"));
        transferOrderBillHeader.add(new TableHeaderInfo("project", "project", "project"));
        transferOrderBillHeader.add(new TableHeaderInfo("trackNumber", "trackNumber", "trackNumber"));
        return transferOrderBillHeader;
    }

    public List initManufactureRecBillHeader() {
        ArrayList<TableHeaderInfo> manufactureRecBillHeader = new ArrayList<TableHeaderInfo>();
        manufactureRecBillHeader.add(new TableHeaderInfo("ManufactureRecBillInManu", "FNUMBER", "ManufactureRecBill_Order"));
        manufactureRecBillHeader.add(new TableHeaderInfo("transactionType", "transactionType", "transactionType"));
        manufactureRecBillHeader.add(new TableHeaderInfo("baseStatus", "baseStatus", "baseStatus"));
        manufactureRecBillHeader.add(new TableHeaderInfo("MaterialNumber", "MaterialNumber", "MaterialNumber"));
        manufactureRecBillHeader.add(new TableHeaderInfo("MaterialName", "MaterialName", "MaterialName"));
        manufactureRecBillHeader.add(new TableHeaderInfo("Unit", "Unit", "Unit"));
        manufactureRecBillHeader.add(new TableHeaderInfo("Qty", "Qty", "Qty"));
        manufactureRecBillHeader.add(new TableHeaderInfo("receiveQty", "receiveQty", "receiveQty"));
        manufactureRecBillHeader.add(new TableHeaderInfo("lot", "lot", "lot"));
        manufactureRecBillHeader.add(new TableHeaderInfo("mfg", "mfgDate", "mfg"));
        manufactureRecBillHeader.add(new TableHeaderInfo("warehouse", "warehouse", "warehouse"));
        manufactureRecBillHeader.add(new TableHeaderInfo("location", "location", "location"));
        manufactureRecBillHeader.add(new TableHeaderInfo("project", "project", "project"));
        manufactureRecBillHeader.add(new TableHeaderInfo("trackNumber", "trackNumber", "trackNumber"));
        return manufactureRecBillHeader;
    }

    public List initQCRequestHeader() {
        ArrayList<TableHeaderInfo> qCRequestHeader = new ArrayList<TableHeaderInfo>();
        qCRequestHeader.add(new TableHeaderInfo("QCRequestInManu", "FNUMBER", "QCRequest_Order"));
        qCRequestHeader.add(new TableHeaderInfo("qualityOrgUnit", "qualityOrgUnit", "qualityOrgUnit"));
        qCRequestHeader.add(new TableHeaderInfo("baseStatus", "billStatus", "baseStatus"));
        qCRequestHeader.add(new TableHeaderInfo("MaterialNumber", "MaterialNumber", "MaterialNumber"));
        qCRequestHeader.add(new TableHeaderInfo("MaterialName", "MaterialName", "MaterialName"));
        qCRequestHeader.add(new TableHeaderInfo("deliverQty", "deliverQty", "deliverQty"));
        qCRequestHeader.add(new TableHeaderInfo("Unit", "Unit", "Unit"));
        qCRequestHeader.add(new TableHeaderInfo("qcStandard", "qcStandard", "qcStandard"));
        qCRequestHeader.add(new TableHeaderInfo("reqFinishDate", "reqFinishDate", "reqFinishDate"));
        qCRequestHeader.add(new TableHeaderInfo("qcStrategy", "qcStrategy", "qcStrategy"));
        qCRequestHeader.add(new TableHeaderInfo("sampleState", "sampleState", "sampleState"));
        qCRequestHeader.add(new TableHeaderInfo("qcBillState", "qcBillState", "qcBillState"));
        qCRequestHeader.add(new TableHeaderInfo("reportState", "reportState", "reportState"));
        qCRequestHeader.add(new TableHeaderInfo("isReturnResult", "isReturnResult", "isReturnResult"));
        return qCRequestHeader;
    }

    public List initWPTransferBillHeader() {
        ArrayList<TableHeaderInfo> wpTransferBillHeader = new ArrayList<TableHeaderInfo>();
        wpTransferBillHeader.add(new TableHeaderInfo("WPTransferBillInManu", "FNUMBER", "WPTransferBill_ORDER"));
        wpTransferBillHeader.add(new TableHeaderInfo("transferType", "transferType", "transferType"));
        wpTransferBillHeader.add(new TableHeaderInfo("baseStatus", "baseStatus", "baseStatus"));
        wpTransferBillHeader.add(new TableHeaderInfo("rounting", "rounting", "rounting"));
        wpTransferBillHeader.add(new TableHeaderInfo("srcOperationNO", "srcOperationNO", "srcOperationNO"));
        wpTransferBillHeader.add(new TableHeaderInfo("srcOperationName", "srcOperationName", "srcOperationName"));
        wpTransferBillHeader.add(new TableHeaderInfo("targetOperationNO", "targetOperationNO", "targetOperationNO"));
        wpTransferBillHeader.add(new TableHeaderInfo("targetOperationName", "targetOperationName", "targetOperationName"));
        wpTransferBillHeader.add(new TableHeaderInfo("transferQty", "transferQty", "transferQty"));
        wpTransferBillHeader.add(new TableHeaderInfo("Unit", "Unit", "Unit"));
        wpTransferBillHeader.add(new TableHeaderInfo("MaterialNumber", "MaterialNumber", "MaterialNumber"));
        wpTransferBillHeader.add(new TableHeaderInfo("MaterialName", "MaterialName", "MaterialName"));
        wpTransferBillHeader.add(new TableHeaderInfo("project", "project", "project"));
        wpTransferBillHeader.add(new TableHeaderInfo("trackNumber", "trackNumber", "trackNumber"));
        return wpTransferBillHeader;
    }

    public List initSaleOrderHeader() {
        ArrayList<TableHeaderInfo> saleOrderHeader = new ArrayList<TableHeaderInfo>();
        saleOrderHeader.add(new TableHeaderInfo("SaleOrderInManu", "FNUMBER", "SaleOrder_ORDER"));
        saleOrderHeader.add(new TableHeaderInfo("baseStatus", "baseStatus", "baseStatus"));
        saleOrderHeader.add(new TableHeaderInfo("saleOrgUnit", "saleOrgUnit", "saleOrgUnit"));
        saleOrderHeader.add(new TableHeaderInfo("RowStatus", "entryBaseStatus", "RowStatus"));
        saleOrderHeader.add(new TableHeaderInfo("MaterialNumber", "MaterialNumber", "MaterialNumber"));
        saleOrderHeader.add(new TableHeaderInfo("MaterialName", "MaterialName", "MaterialName"));
        saleOrderHeader.add(new TableHeaderInfo("Unit", "Unit", "Unit"));
        saleOrderHeader.add(new TableHeaderInfo("Qty", "Qty", "Qty"));
        saleOrderHeader.add(new TableHeaderInfo("sendDate", "sendDate", "sendDate"));
        saleOrderHeader.add(new TableHeaderInfo("project", "project", "project"));
        saleOrderHeader.add(new TableHeaderInfo("trackNumber", "trackNumber", "trackNumber"));
        return saleOrderHeader;
    }

    public List initMaterialReqBillHeader() {
        ArrayList<TableHeaderInfo> materialReqBillHeader = new ArrayList<TableHeaderInfo>();
        materialReqBillHeader.add(new TableHeaderInfo("MaterialReqBillInManu", "FNUMBER", "MaterialReqBill_Order"));
        materialReqBillHeader.add(new TableHeaderInfo("baseStatus", "baseStatus", "baseStatus"));
        materialReqBillHeader.add(new TableHeaderInfo("transactionType", "transactionType", "transactionType"));
        materialReqBillHeader.add(new TableHeaderInfo("MaterialNumber", "MaterialNumber", "MaterialNumber"));
        materialReqBillHeader.add(new TableHeaderInfo("MaterialName", "MaterialName", "MaterialName"));
        materialReqBillHeader.add(new TableHeaderInfo("Unit", "Unit", "Unit"));
        materialReqBillHeader.add(new TableHeaderInfo("Qty", "Qty", "Qty"));
        materialReqBillHeader.add(new TableHeaderInfo("requireDate", "requireDate", "requireDate"));
        materialReqBillHeader.add(new TableHeaderInfo("project", "project", "project"));
        materialReqBillHeader.add(new TableHeaderInfo("trackNumber", "trackNumber", "trackNumber"));
        return materialReqBillHeader;
    }

    public List initScrapOrderHeader() {
        ArrayList<TableHeaderInfo> scrapOrderHeader = new ArrayList<TableHeaderInfo>();
        scrapOrderHeader.add(new TableHeaderInfo("ScrapOrderInManu", "FNUMBER", "ScrapOrder_ORDER"));
        scrapOrderHeader.add(new TableHeaderInfo("scrapType", "scrapType", "scrapType"));
        scrapOrderHeader.add(new TableHeaderInfo("baseStatus", "baseStatus", "baseStatus"));
        scrapOrderHeader.add(new TableHeaderInfo("MaterialNumber", "MaterialNumber", "MaterialNumber"));
        scrapOrderHeader.add(new TableHeaderInfo("MaterialName", "MaterialName", "MaterialName"));
        scrapOrderHeader.add(new TableHeaderInfo("Unit", "Unit", "Unit"));
        scrapOrderHeader.add(new TableHeaderInfo("scrapQty", "scrapQty", "scrapQty"));
        scrapOrderHeader.add(new TableHeaderInfo("supplyRequiredQty", "supplyRequiredQty", "supplyRequiredQty"));
        scrapOrderHeader.add(new TableHeaderInfo("suppliedQty", "suppliedQty", "suppliedQty"));
        scrapOrderHeader.add(new TableHeaderInfo("requireDate", "requireDate", "requireDate"));
        scrapOrderHeader.add(new TableHeaderInfo("project", "project", "project"));
        scrapOrderHeader.add(new TableHeaderInfo("trackNumber", "trackNumber", "trackNumber"));
        return scrapOrderHeader;
    }

    public List initPlannedOrderHeader() {
        ArrayList<TableHeaderInfo> plannedOrderHeader = new ArrayList<TableHeaderInfo>();
        plannedOrderHeader.add(new TableHeaderInfo("PlannedOrderInManu", "FNUMBER", "PlannedOrder_ORDER"));
        plannedOrderHeader.add(new TableHeaderInfo("baseStatus", "baseStatus", "baseStatus"));
        plannedOrderHeader.add(new TableHeaderInfo("orderType", "orderType", "orderType"));
        plannedOrderHeader.add(new TableHeaderInfo("MaterialNumber", "MaterialNumber", "MaterialNumber"));
        plannedOrderHeader.add(new TableHeaderInfo("MaterialName", "MaterialName", "MaterialName"));
        plannedOrderHeader.add(new TableHeaderInfo("MaterialAttribute", "MaterialAttribute", "MaterialAttribute"));
        plannedOrderHeader.add(new TableHeaderInfo("startDate", "startDate", "startDate"));
        plannedOrderHeader.add(new TableHeaderInfo("endDate", "endDate", "endDate"));
        plannedOrderHeader.add(new TableHeaderInfo("productUnit", "productUnit", "productUnit"));
        plannedOrderHeader.add(new TableHeaderInfo("productQty", "productQty", "productQty"));
        plannedOrderHeader.add(new TableHeaderInfo("totalReleaseQty", "totalReleaseQty", "totalReleaseQty"));
        plannedOrderHeader.add(new TableHeaderInfo("scheduleQty", "scheduleQty", "scheduleQty"));
        plannedOrderHeader.add(new TableHeaderInfo("project", "project", "project"));
        plannedOrderHeader.add(new TableHeaderInfo("trackNumber", "trackNumber", "trackNumber"));
        return plannedOrderHeader;
    }

    public List initCompletionReportHeader() {
        ArrayList<TableHeaderInfo> completionReportHeader = new ArrayList<TableHeaderInfo>();
        completionReportHeader.add(new TableHeaderInfo("CompletionReportInManu", "FNUMBER", "CompletRep_ORDER"));
        completionReportHeader.add(new TableHeaderInfo("baseStatus", "baseStatus", "baseStatus"));
        completionReportHeader.add(new TableHeaderInfo("OperationNo", "OperationNo", "OperationNo"));
        completionReportHeader.add(new TableHeaderInfo("OperationName", "OperationName", "OperationName"));
        completionReportHeader.add(new TableHeaderInfo("productNumber", "productNumber", "productNumber"));
        completionReportHeader.add(new TableHeaderInfo("productName", "productName", "productName"));
        completionReportHeader.add(new TableHeaderInfo("reportTime", "reportDate", "reportTime"));
        completionReportHeader.add(new TableHeaderInfo("reportType", "reportType", "reportType"));
        completionReportHeader.add(new TableHeaderInfo("Unit", "Unit", "Unit"));
        completionReportHeader.add(new TableHeaderInfo("reportQty", "reportQty", "reportQty"));
        completionReportHeader.add(new TableHeaderInfo("qualifiedQty", "qualifiedQty", "qualifiedQty"));
        completionReportHeader.add(new TableHeaderInfo("project", "project", "project"));
        completionReportHeader.add(new TableHeaderInfo("trackNumber", "trackNumber", "trackNumber"));
        return completionReportHeader;
    }

    public void removeRequestDataListener() {
        DataSetWrapperFactory dataSetFactory = this.tblMain.getDataRequestManager().getDataSetFactory();
        EventListener[] listener = dataSetFactory.getRequestRowSetListeners();
        for (int i = 0; i < listener.length; ++i) {
            dataSetFactory.removeRequestRowSetListener((RequestRowSetListener)listener[i]);
        }
    }

    private class ManufactureOrderTraceComparator
    implements Comparator {
        private ManufactureOrderTraceComparator() {
        }

        public int doCompare(Object arg0, Object arg1) {
            int l2;
            ManufactureOrderInfo order1 = (ManufactureOrderInfo)arg0;
            ManufactureOrderInfo order2 = (ManufactureOrderInfo)arg1;
            int l1 = order1.getLevel();
            int result = l1 - (l2 = order2.getLevel());
            if (result != 0) {
                return result;
            }
            String number1 = order1.getNumber() == null ? " " : order1.getNumber();
            String number2 = order2.getNumber() == null ? " " : order2.getNumber();
            return number1.compareTo(number2);
        }

        public int compare(Object o1, Object o2) {
            return this.doCompare(o1, o2);
        }
    }
}

