/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.report.ReportListener;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;

public class TrackBillPluginClassName
extends ReportListener {
    public void onInitialize() throws Exception {
        super.onInitialize();
        String orgnumber = this.getReportApplication().getFilter().getString("storageOrgUnit.number");
        if (orgnumber != null && !this.isAuditPermison(orgnumber)) {
            StorageOrgUnitInfo fullOrgUnitByNumber = TrackBillPluginClassName.getFullOrgUnitByNumber(orgnumber);
            MsgBox.showInfo((String)(TrackBillPluginClassName.getResource("VIEW_TICK_PRESION") + fullOrgUnitByNumber.getName() + TrackBillPluginClassName.getResource("VIEW_CIEJJPROJECTIE")));
            SysUtil.abort();
        }
        IObjectPK pk = LogUtil.beginLog(null, (String)"onLoad", (BOSObjectType)new BOSObjectType("1D0D80DD"), null, (String)TrackBillPluginClassName.getResource("TRACKBILLVIEW"), (String)"mm_trackbillreport_view");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void fireAfterPrint() throws Exception {
        super.fireAfterPrint();
        IObjectPK pk = LogUtil.beginLog(null, (String)"onLoad", (BOSObjectType)new BOSObjectType("1D0D80DD"), null, (String)TrackBillPluginClassName.getResource("TRACKBILLPRINT"), (String)"mm_trackbillreport_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.report.TrackBillReportResource", (String)strKey);
    }

    private boolean isAuditPermison(String orgnumber) throws EASBizException, BOSException {
        UserInfo currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        FullOrgUnitCollection result = TrackBillPluginClassName.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(currentUserInfo.getId()), OrgType.Storage, "mm_TrackBillReport_Qurey");
        if (result != null) {
            for (int i = 0; i < result.size(); ++i) {
                if (!result.get(i).getNumber().toString().equals(orgnumber.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static FullOrgUnitCollection getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        result = permission.getAuthorizedOrg(user, orgType, null, permItem);
        return result;
    }

    public static StorageOrgUnitInfo getFullOrgUnitByNumber(String number) throws EASBizException, BOSException {
        EntityViewInfo viewInfo1 = new EntityViewInfo();
        StorageOrgUnitInfo orgunit = null;
        viewInfo1.setFilter(TrackBillPluginClassName.getFilterDup("number", number, CompareType.EQUALS));
        StorageOrgUnitCollection collection = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(viewInfo1);
        if (collection == null || collection.size() <= 0) {
            throw new BOSException("StorageOrgUnitInfo is null");
        }
        orgunit = collection.get(0);
        return orgunit;
    }

    public static FilterInfo getFilterDup(String fieldName, Object compareValue, CompareType compareType) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(fieldName, compareValue, compareType);
        filter.getFilterItems().add(filterItem);
        filter.setMaskString("#0");
        return filter;
    }
}

