/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.ncm.cal.CalCostFacadeFactory;
import com.kingdee.eas.ncm.cal.client.AbstractCostCalCalcInReportUI;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostCalCalcInReportUI
extends AbstractCostCalCalcInReportUI {
    private static final Logger logger = CoreUIObject.getLogger(CostCalCalcInReportUI.class);
    private String companyId = null;
    private String periodId = null;
    private String typeId = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionQuery.setEnabled(false);
        this.actionQuery.setVisible(false);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        Map parentParam = (Map)this.getUIContext().get("param");
        if (parentParam == null) {
            parentParam = (Map)this.getUIContext().get("key.cost.task.entry.param");
        }
        this.companyId = (String)parentParam.get("companyId");
        this.periodId = (String)parentParam.get("periodId");
        this.typeId = (String)parentParam.get("typeId");
        this.refresh();
    }

    private void refresh() throws Exception {
        this.tblMain.removeRows();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("companyId", this.companyId);
        params.put("periodId", this.periodId);
        params.put("typeId", this.typeId);
        Map result = CalCostFacadeFactory.getRemoteInstance().getCalcInReport(params);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)result.get("company");
        if (company == null) {
            return;
        }
        this.prmtCompany.setValue((Object)company);
        PeriodInfo period = (PeriodInfo)result.get("period");
        this.prmtPeriod.setValue((Object)period);
        IRowSet rowSet = (IRowSet)result.get("rowSet");
        if (rowSet == null) {
            return;
        }
        while (rowSet.next()) {
            IRow row = this.tblMain.addRow();
            row.getCell("costCenterNumber").setValue((Object)rowSet.getString("FCostCenterNumber"));
            row.getCell("costCenterName").setValue((Object)rowSet.getString("FCostCenterName"));
            row.getCell("costObjectNumber").setValue((Object)rowSet.getString("FCostObjectNumber"));
            row.getCell("costObjectName").setValue((Object)rowSet.getString("FCostObjectName"));
            row.getCell("productNumber").setValue((Object)rowSet.getString("FProductNumber"));
            row.getCell("productName").setValue((Object)rowSet.getString("FProductName"));
            row.getCell("orderNumber").setValue((Object)rowSet.getString("FOrderNumber"));
            row.getCell("lot").setValue((Object)rowSet.getString("FLot"));
            row.getCell("model").setValue((Object)rowSet.getString("FModel"));
            int precision = rowSet.getInt("FPricePrecision");
            if (precision == 0) {
                precision = 4;
            }
            row.getCell("unitActualCost").setValue((Object)rowSet.getBigDecimal("FUnitActualCost"));
            row.getCell("unitActualCost").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }
}

