/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.cal.client.AbstractCostCalUI;
import com.kingdee.eas.ncm.cal.client.CostCalOptionUI;
import com.kingdee.eas.ncm.cal.utils.CostCalUtils;
import com.kingdee.eas.ncm.common.client.AdvanceOptionInfo;
import com.kingdee.eas.ncm.common.client.AdvanceOptionListener;
import com.kingdee.eas.ncm.common.client.AdvanceOptionUI;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.client.CostTaskClientUtils;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class CostCalUI
extends AbstractCostCalUI
implements AdvanceOptionListener {
    private static final Logger logger = CoreUIObject.getLogger(CostCalUI.class);
    private static final ImageIcon iconCalc = new ImageIcon(CostCalUI.class.getResource("/com/kingdee/eas/ncm/common/resource/pic/ncm_calc.png"));
    private IUIWindow uiWindow = null;
    private CostCalOptionUI optionUI = null;
    private Map param = null;
    private List options = null;
    private Map advparam = null;

    public CostCalUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.lbPicture.setIcon((Icon)iconCalc);
        this.lbSetting.getBoundLabel().setForeground(Color.BLUE);
        this.lbSetting.setUnderlineColor(Color.BLUE);
        this.lbSetting.setCursor(new Cursor(12));
        this.lbSetting.getBoundLabel().setHorizontalAlignment(0);
        this.lbSetting.getBoundLabel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Map temp = CostCalUI.this.showOptionUI();
                    if (temp != null) {
                        CostCalUI.this.param = temp;
                    }
                }
                catch (Exception exc) {
                    CostCalUI.this.handUIException(exc);
                }
            }
        });
        this.param = new HashMap();
        this.param.put("isCCOAlloc.check", "true");
        this.param.put("isMatAlloc.check", "true");
        this.param.put("isOtherAlloc.check", "true");
        this.param.put("isAuxAlloc.check", "true");
        this.param.put("isCheckEopWipException", "true");
    }

    @Override
    protected String getCostTaskNumber() {
        return "FactCostCal";
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.menuFile.add((JMenuItem)new AbstractHidedMenuItem("ctrl alt S"){

            public void action_actionPerformed() {
                try {
                    AdvanceOptionUI.show((Object)((Object)CostCalUI.this), (AdvanceOptionListener)CostCalUI.this);
                }
                catch (Exception e) {
                    CostCalUI.this.handleException(e);
                }
            }
        });
    }

    public Map showOptionUI() throws Exception {
        if (this.uiWindow == null) {
            HashMap param = new HashMap();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"param", param);
            this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CostCalOptionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            this.optionUI = (CostCalOptionUI)((Object)param.get("ui"));
        }
        this.optionUI.init(this.param);
        ((UIModelDialog)this.uiWindow).setVisible(true);
        return this.optionUI.getParam();
    }

    public List getAdvanceOptions() {
        if (this.options == null) {
            this.options = new ArrayList();
            AdvanceOptionInfo option = new AdvanceOptionInfo("isSendQueue", "\u662f\u5426\u6392\u961f", (Object)Boolean.TRUE, Boolean.class, "\u52fe\u9009\uff1a\u6392\u961f\uff0c\u4e0d\u52fe\u9009\uff1a\u4e0d\u6392\u961f");
            this.options.add(option);
            option = new AdvanceOptionInfo("isUseSystemTempTable", "\u6210\u672c\u8ba1\u7b97\u4e34\u65f6\u8868", (Object)Boolean.TRUE, Boolean.class, "\u52fe\u9009\uff1a\u7cfb\u7edf\u4e34\u65f6\u8868\uff0c\u4e0d\u52fe\u9009\uff1a\u5e38\u89c4\u4e34\u65f6\u8868");
            this.options.add(option);
            option = new AdvanceOptionInfo("numberOfOneBatchOnWip", "\u6279\u6b21\u5927\u5c0f", (Object)new Integer(300), Integer.class, "\u5b8c\u5de5\u4e0e\u5728\u4ea7\u5206\u914d\u65f6\u5355\u6279\u5904\u7406\u6210\u672c\u5bf9\u8c61\u7684\u4e2a\u6570");
            this.options.add(option);
        }
        return this.options;
    }

    public boolean verify() {
        return true;
    }

    public void onOk() {
        if (this.options != null) {
            this.advparam = new HashMap();
            for (int i = 0; i < this.options.size(); ++i) {
                AdvanceOptionInfo option = (AdvanceOptionInfo)this.options.get(i);
                if (option.getValue() == null) continue;
                this.advparam.put(option.getKey(), option.getValue());
            }
        }
    }

    public void onCancel() {
        this.options = null;
        this.advparam = null;
    }

    @Override
    protected void btnCal_actionPerformed(ActionEvent e) throws Exception {
        Set companyIds = this.getSelectedCompanyIds();
        if (companyIds.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.task.CostCalResource", (String)"CHOOSE_COMPANY_EMPTY"));
            return;
        }
        HashMap<String, Object> source = this.param;
        if (source == null) {
            source = new HashMap<String, Object>();
        }
        boolean isSendQueue = true;
        if (this.advparam != null && this.advparam.get("isSendQueue") != null && this.advparam.get("isSendQueue").toString().equalsIgnoreCase("false")) {
            isSendQueue = false;
        }
        CostTaskUtils.setSendQueue(source, (boolean)isSendQueue);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        view.setSelector(selector);
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        HashMap<String, PeriodInfo> periods = new HashMap<String, PeriodInfo>();
        for (int i = 0; i < companys.size(); ++i) {
            CompanyOrgUnitInfo company = companys.get(i);
            if (!NCMUtils.isStart(null, (String)company.getId().toString())) {
                MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ncm.cal.task.CostCalResource", (String)"COST_NOT_ON"), company.getName()));
                return;
            }
            PeriodInfo period = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
            periods.put(company.getId().toString(), period);
        }
        ArrayList<Map> params = new ArrayList<Map>(companys.size());
        for (int i = 0; i < companys.size(); ++i) {
            CompanyOrgUnitInfo company = companys.get(i);
            PeriodInfo period = (PeriodInfo)periods.get(company.getId().toString());
            source.put("company", company);
            source.put("period", period);
            source.put("user", SysContext.getSysContext().getCurrentUserInfo());
            Map param = CostCalUtils.buildCalParam(source);
            if (this.advparam != null) {
                param.putAll(this.advparam);
            }
            params.add(param);
        }
        CostTaskClientUtils.execute(params, (CoreUIObject)this, (boolean)true);
    }
}

