/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.client.AbstractCostResultRptFilterUI;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.utils.client.OrgUnitClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class CostResultRptFilterUI
extends AbstractCostResultRptFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CostResultRptFilterUI.class);
    public static final String STFSOURCE_PATH = "com.kingdee.eas.ncm.cal.client.CalResource";
    public static final String RPTPARAM_COMPANYORGFROM = "companyOrgFrom";
    public static final String RPTPARAM_CALCULATEPERIOD = "calculatePeriodFrom";
    public static final String RPTPARAM_COSTCENTER1 = "costCenterFrom";
    public static final String RPTPARAM_COSTCENTER2 = "costCenterTo";
    public static final String RPTPARAM_COSTObject1 = "costObjectFrom";
    public static final String RPTPARAM_COSTObject2 = "costObjectTo";
    public static final String RPTPARAM_MATERIAL1 = "MaterialFrom";
    public static final String RPTPARAM_MATERIAL2 = "MaterialTo";
    public static final String RPTPARAM_COSTITEM1 = "costItemFrom";
    public static final String RPTPARAM_COSTITEM2 = "costItemTo";
    public static final String RPTPARAM_PATCHNUMBER1 = "PatchNumberFrom";
    public static final String RPTPARAM_PATCHNUMBER2 = "PatchNumberTo";
    private String typeStr = "1";
    private String opertPermItemName = "";
    private Context mainOrgContext;
    private DataChangeListener prmtCompanyChange = null;

    public CostResultRptFilterUI() throws Exception {
        this.initF7Control();
        this.prmtCompanyChange = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    CostResultRptFilterUI.this.prmtCompanyOrgFrom_dataChanged(e);
                }
                catch (Exception exc) {
                    CostResultRptFilterUI.this.handUIException(exc);
                }
            }
        };
        this.prmtCompanyOrgFrom.addDataChangeListener(this.prmtCompanyChange);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
        if (initParams.getString("type") != null) {
            this.typeStr = initParams.getString("type");
        }
        if (!"2".equals(this.typeStr)) {
            this.kDLabelContainer3.setVisible(false);
            this.kDLabelContainer8.setVisible(false);
            this.kDLabelContainer9.setVisible(false);
            this.kDLabelContainer10.setVisible(false);
        }
    }

    public RptParams getCustomCondition() {
        RptParams pp = new RptParams();
        if (this.prmtCompanyOrgFrom.getText() != null) {
            pp.setObject(RPTPARAM_COMPANYORGFROM, (Object)((CompanyOrgUnitInfo)this.prmtCompanyOrgFrom.getData()).getId().toString());
        } else {
            pp.setObject(RPTPARAM_COMPANYORGFROM, null);
        }
        if (this.prmtCalculatePeriodFrom.getText() != null) {
            pp.setObject(RPTPARAM_CALCULATEPERIOD, (Object)((PeriodInfo)this.prmtCalculatePeriodFrom.getData()).getId().toString());
        } else {
            pp.setObject(RPTPARAM_CALCULATEPERIOD, null);
        }
        if (this.prmtCostCenterFrom.getText() != null) {
            pp.setObject(RPTPARAM_COSTCENTER1, (Object)this.prmtCostCenterFrom.getText());
        } else {
            pp.setObject(RPTPARAM_COSTCENTER1, null);
        }
        if (this.prmtCostCenterTo.getText() != null) {
            pp.setObject(RPTPARAM_COSTCENTER2, (Object)this.prmtCostCenterTo.getText());
        } else {
            pp.setObject(RPTPARAM_COSTCENTER2, null);
        }
        if (this.prmtCostObjectFrom.getText() != null) {
            pp.setObject(RPTPARAM_COSTObject1, (Object)this.prmtCostObjectFrom.getText());
        } else {
            pp.setObject(RPTPARAM_COSTObject1, null);
        }
        if (this.prmtCostObjectTo.getText() != null) {
            pp.setObject(RPTPARAM_COSTObject2, (Object)this.prmtCostObjectTo.getText());
        } else {
            pp.setObject(RPTPARAM_COSTObject2, null);
        }
        if (this.prmtMaterialFrom.getText() != null) {
            pp.setObject(RPTPARAM_MATERIAL1, (Object)this.prmtMaterialFrom.getText());
        } else {
            pp.setObject(RPTPARAM_MATERIAL1, null);
        }
        if (this.prmtMaterialTo.getText() != null) {
            pp.setObject(RPTPARAM_MATERIAL2, (Object)this.prmtMaterialTo.getText());
        } else {
            pp.setObject(RPTPARAM_MATERIAL2, null);
        }
        if (this.txtPatchNumber1.getText() != null) {
            pp.setObject(RPTPARAM_PATCHNUMBER1, (Object)this.txtPatchNumber1.getText());
        } else {
            pp.setObject(RPTPARAM_PATCHNUMBER1, null);
        }
        if (this.txtPatchNumber2.getText() != null) {
            pp.setObject(RPTPARAM_PATCHNUMBER2, (Object)this.txtPatchNumber2.getText());
        } else {
            pp.setObject(RPTPARAM_PATCHNUMBER2, null);
        }
        return pp;
    }

    public void setCustomCondition(RptParams params) {
        if (params == null) {
            params = new RptParams();
        }
        if (params.containsKey(RPTPARAM_COMPANYORGFROM)) {
            this.prmtCompanyOrgFrom.setText(params.getString(RPTPARAM_COMPANYORGFROM));
        }
        if (params.containsKey(RPTPARAM_CALCULATEPERIOD)) {
            this.prmtCalculatePeriodFrom.setText(params.getString(RPTPARAM_CALCULATEPERIOD));
        }
        if (params.containsKey(RPTPARAM_COSTCENTER1)) {
            this.prmtCostCenterFrom.setText(params.getString(RPTPARAM_COSTCENTER1));
        }
        if (params.containsKey(RPTPARAM_COSTCENTER2)) {
            this.prmtCostCenterTo.setText(params.getString(RPTPARAM_COSTCENTER2));
        }
        if (params.containsKey(RPTPARAM_COSTObject1)) {
            this.prmtCostObjectFrom.setText(params.getString(RPTPARAM_COSTObject1));
        }
        if (params.containsKey(RPTPARAM_COSTObject2)) {
            this.prmtCostObjectTo.setText(params.getString(RPTPARAM_COSTObject2));
        }
        if (params.containsKey(RPTPARAM_MATERIAL1)) {
            this.prmtMaterialFrom.setText(params.getString(RPTPARAM_MATERIAL1));
        }
        if (params.containsKey(RPTPARAM_MATERIAL2)) {
            this.prmtMaterialTo.setText(params.getString(RPTPARAM_MATERIAL2));
        }
        if (params.containsKey(RPTPARAM_PATCHNUMBER1)) {
            this.txtPatchNumber1.setText(params.getString(RPTPARAM_PATCHNUMBER1));
        }
        if (params.containsKey(RPTPARAM_PATCHNUMBER2)) {
            this.txtPatchNumber2.setText(params.getString(RPTPARAM_PATCHNUMBER2));
        }
    }

    public void initF7Control() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        if (!companyOrg.isIsBizUnit()) {
            companyOrg = (CompanyOrgUnitInfo)this.getBizOrgUnitInfo();
        }
        this.prmtCompanyOrgFrom.setValue((Object)companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrgFrom, (OrgType)OrgType.Company);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)((CompanyOrgUnitInfo)this.prmtCompanyOrgFrom.getValue()).getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)((CompanyOrgUnitInfo)this.prmtCompanyOrgFrom.getValue()).getId().toString());
        if (this.prmtCompanyOrgFrom.getData() != null) {
            BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObjectFrom, (String)companyOrg.getId().toString());
            BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObjectTo, (String)companyOrg.getId().toString());
        }
        if (this.prmtCompanyOrgFrom.getData() != null) {
            CalculateUtil.setDefaultPeriod((CompanyOrgUnitInfo)this.prmtCompanyOrgFrom.getData(), this.prmtCalculatePeriodFrom);
        }
        this.prmtCalculatePeriodFrom.setEditFormat("$periodYear$$periodNumber$");
        this.prmtCalculatePeriodFrom.setCommitFormat("periodYear$$periodNumber$");
    }

    public boolean verify() {
        if (this.prmtCalculatePeriodFrom.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)STFSOURCE_PATH, (String)"COMPANY_PERIOD_ISNULL"));
            this.prmtCalculatePeriodFrom.requestFocus();
            return false;
        }
        if (this.prmtCompanyOrgFrom.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)STFSOURCE_PATH, (String)"COMPANY_PERIOD_ISNULL"));
            this.prmtCompanyOrgFrom.requestFocus();
            return false;
        }
        try {
            ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getRemoteInstance();
            CompanyOrgUnitInfo companyinfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgFrom.getValue();
            if (!ctrol.isStart(1001, companyinfo.getId().toString())) {
                MsgBox.showInfo((String)EASResource.getString((String)STFSOURCE_PATH, (String)"NOT_ON"));
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return true;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrgFrom;
    }

    protected PeriodInfo getPeriodByBizDate(Date date, CompanyOrgUnitInfo orgInfo) throws EASBizException, BOSException {
        KDBizPromptBox prmt = new KDBizPromptBox();
        BDCMClientUtils.filterCompanyOrgForPeriod((KDBizPromptBox)prmt, (CompanyOrgUnitInfo)orgInfo);
        FilterInfo filter = prmt.getEntityViewInfo().getFilter();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)date, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)date, CompareType.GREATER_EQUALS));
        PeriodCollection pc = null;
        try {
            prmt.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            IPeriod ipe = PeriodFactory.getRemoteInstance();
            pc = ipe.getPeriodCollection(prmt.getEntityViewInfo());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (pc != null && pc.size() > 0) {
            return pc.get(0);
        }
        return null;
    }

    public Component getFocusComponent() {
        if (this.prmtCalculatePeriodFrom.getValue() != null) {
            this.prmtCalculatePeriodFrom.setValue(this.prmtCalculatePeriodFrom.getValue());
        }
        if (this.prmtCompanyOrgFrom.getValue() != null) {
            this.prmtCompanyOrgFrom.setValue(this.prmtCompanyOrgFrom.getValue());
        }
        return this.prmtCompanyOrgFrom;
    }

    protected OrgUnitInfo getBizOrgUnitInfo() {
        if (this.opertPermItemName == null) {
            return null;
        }
        OrgType orgType = OrgType.Company;
        this.mainOrgContext = new Context();
        this.getUIContext().put(orgType, SysContext.getSysContext().getCurrentOrgUnit(orgType));
        OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit(orgType);
        if (org != null && org.getId() != null) {
            this.initUIMainOrgContext(org.getId().toString());
        }
        return OrgUnitClientUtils.getBizOrgUnitInfo((String)this.opertPermItemName, (OrgType)orgType, (Context)this.mainOrgContext);
    }

    private void initUIMainOrgContext(String orgID) {
        if (this.mainOrgContext == null) {
            this.mainOrgContext = new Context();
        }
        try {
            FrameWorkUtils.switchOrg((Context)this.mainOrgContext, (String)orgID);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void prmtCompanyOrgFrom_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getOldValue() != null && e.getNewValue() != null) {
            CalculateUtil.setDefaultPeriod((CompanyOrgUnitInfo)e.getNewValue(), this.prmtCalculatePeriodFrom);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        if (this.prmtCalculatePeriodFrom.getValue() != null) {
            this.prmtCalculatePeriodFrom.setValue(this.prmtCalculatePeriodFrom.getValue());
        }
        if (this.prmtCompanyOrgFrom.getValue() != null) {
            this.prmtCompanyOrgFrom.setValue(this.prmtCompanyOrgFrom.getValue());
        }
    }

    public void clear() {
        super.clear();
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtCostObjectFrom.setValue(null);
        this.prmtCostObjectTo.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.txtPatchNumber1.setText(null);
        this.txtPatchNumber2.setText(null);
    }
}

