/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.bill.client.MaterialAllocLogReportUI;
import com.kingdee.eas.ncm.bill.client.OtherAllocLogReportUI;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemInfo;
import com.kingdee.eas.ncm.cal.CheckCalTypeEnum;
import com.kingdee.eas.ncm.cal.CheckStatusEnum;
import com.kingdee.eas.ncm.cal.client.AbstractLogReportPickUI;
import com.kingdee.eas.ncm.cal.client.CostCalcLogReportUI;
import com.kingdee.eas.ncm.cal.client.ReportListElement;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LogReportPickUI
extends AbstractLogReportPickUI {
    private static final Logger logger = CoreUIObject.getLogger(LogReportPickUI.class);
    private CompanyOrgUnitInfo _company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
    private PeriodInfo _period = NCMUtils.GetCurrentPeriod(null, (String)this._company.getId().toString());

    public LogReportPickUI() throws Exception {
        BDCMClientUtils.checkLoginCompanyOrgIsVirtual();
        if (!NCMUtils.isStart(null, (String)this._company.getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtCompany.setText(this._company.getName());
        this.txtPeriod.setText(String.valueOf(this._period.getNumber()));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("companyName", this._company.getName());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        this.lstLogList.removeAllElements();
        this.lstLogList.addElement((Object)new ReportListElement(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"11_CalProject3UI"), param));
        this.lstLogList.addElement((Object)new ReportListElement(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"12_CalProject3UI"), param));
        this.lstLogList.addElement((Object)new ReportListElement(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"13_CalProject3UI"), param));
        this.lstLogList.addElement((Object)new ReportListElement(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"17_LogReportPickUI"), param));
        this.lstLogList.addElement((Object)new ReportListElement(CalculateUtil.getClientCalResource("CalWizOtherAllocReport"), param));
        this.lstLogList.addElement((Object)new ReportListElement(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"20_EopWipBill"), param));
        this.lstLogList.addElement((Object)new ReportListElement(CalculateUtil.getClientCalResource("CalWizCalcReport"), param));
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        if (this.lstLogList.getSelectedIndex() == -1) {
            return;
        }
        ReportListElement item = (ReportListElement)this.lstLogList.getElement(this.lstLogList.getSelectedIndex());
        if (item != null) {
            String reportName = item.getReportName();
            Map data = item.getData();
            if (reportName.equals(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"20_EopWipBill"))) {
                UIContext uiContext = new UIContext((Object)this);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("companyId", this._company.getId().toString());
                uiContext.put((Object)"param", param);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.ncm.cal.client.CostCalEopWipExReportUI", (Map)uiContext, null);
                uiWindow.show();
            }
            if (reportName.equals(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"11_CalProject3UI"))) {
                data.put("logTblName", "T_NCM_LOG_CCO");
                OtherAllocLogReportUI.showAllocReportUI((CoreUIObject)this, (Map)data);
            }
            if (reportName.equals(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"12_CalProject3UI"))) {
                data.put("logTblName", "T_NCM_LOG_Mat");
                MaterialAllocLogReportUI.showAllocReportUI((CoreUIObject)this, (Map)data);
            }
            if (reportName.equals(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"13_CalProject3UI"))) {
                data.put("logTblName", "T_NCM_LOG_OtherInWH");
                MaterialAllocLogReportUI.showAllocReportUI((CoreUIObject)this, (Map)data);
            }
            if (reportName.equals(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"17_LogReportPickUI"))) {
                data.put("logTblName", "T_NCM_LOG_CostAdjust");
                MaterialAllocLogReportUI.showAllocReportUI((CoreUIObject)this, (Map)data);
            } else if (reportName.equals(CalculateUtil.getClientCalResource("CalWizOtherAllocReport"))) {
                data.put("logTblName", "T_NCM_LOG_Other");
                OtherAllocLogReportUI.showAllocReportUI((CoreUIObject)this, (Map)data);
            } else if (reportName.equals(CalculateUtil.getClientCalResource("CalWizCalcCheckReport"))) {
                String companyOrgID = this._company.getId().toString();
                CalCostCheckItemCollection aCalCostCheckItemCollection = null;
                aCalCostCheckItemCollection = new CalCostCheckItemCollection();
                String s1250 = "";
                if (!NCMUtils.isCostObjectOfBillRequired(null, (String)this._company.getId().toString())) {
                    s1250 = "FSeq <> 1250 and ";
                }
                StringBuffer kSql = new StringBuffer();
                kSql.append(" select * ");
                kSql.append(" from T_CAL_CalCostCheckItem ");
                kSql.append(" where " + s1250);
                kSql.append(" (FCompanyID = '" + companyOrgID + "' or FCompanyID = '' or FCompanyID is null)");
                kSql.append(" and FCalType != 5 order by FSeq asc");
                String locale = SysContext.getSysContext().getLocale().toString();
                IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)kSql.toString()).executeSQL();
                while (rs.next()) {
                    CalCostCheckItemInfo info = new CalCostCheckItemInfo();
                    info.setId(BOSUuid.read((String)rs.getString("FID")));
                    info.setCheckStatus(CheckStatusEnum.getEnum(rs.getString("FCheckStatus")));
                    info.setIsNeed(rs.getBoolean("FIsNeed"));
                    info.setCalType(CheckCalTypeEnum.getEnum(rs.getString("FCalType")));
                    info.setSeq(rs.getInt("FSeq"));
                    info.setCalcHMSString(rs.getString("FCalcHMSString"));
                    info.setStartDateTime(rs.getTimestamp("FStartDateTime"));
                    info.setEndDateTime(rs.getTimestamp("FEndDateTime"));
                    info.setCompanyID(rs.getString("FCompanyID"));
                    info.setDescription(rs.getString("FDescription_" + locale));
                    aCalCostCheckItemCollection.add(info);
                }
                CalCostCheckItemCollection temp = new CalCostCheckItemCollection();
                HashMap<String, CalCostCheckItemInfo> checkItems = new HashMap<String, CalCostCheckItemInfo>();
                for (int i = 0; i < aCalCostCheckItemCollection.size(); ++i) {
                    CalCostCheckItemInfo checkItem = aCalCostCheckItemCollection.get(i);
                    String seq = String.valueOf(checkItem.getSeq());
                    if (checkItems.containsKey(seq)) {
                        if (checkItem.getCompanyID() == null || checkItem.getCompanyID().equals("")) continue;
                        temp.remove((CalCostCheckItemInfo)checkItems.get(seq));
                        checkItems.put(seq, checkItem);
                        temp.add(checkItem);
                        continue;
                    }
                    checkItems.put(seq, checkItem);
                    temp.add(checkItem);
                }
                aCalCostCheckItemCollection = temp;
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"CalCostCheckItemCollection", (Object)aCalCostCheckItemCollection);
                uiContext.put((Object)"companyOrgUnitInfo", (Object)this._company);
                uiContext.put((Object)"periodInfo", (Object)this._period);
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow window = uiFactory.create("com.kingdee.eas.ncm.cal.client.CalfactCostResultUI", (Map)uiContext, null);
                window.show();
            } else if (reportName.equals(CalculateUtil.getClientCalResource("CalWizCalcReport"))) {
                CostCalcLogReportUI.showCalcReportUI((CoreUIObject)this, data);
            }
        }
    }

    @Override
    protected void lstLogList_mouseClicked(MouseEvent e) throws Exception {
        super.lstLogList_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.actionView_actionPerformed(null);
        }
    }
}

