/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.ncm.bill.OtherFeeBillFactory;
import com.kingdee.eas.ncm.bill.OtherFeeBillInfo;
import com.kingdee.eas.ncm.bill.client.OtherAllocEditUI;
import com.kingdee.eas.ncm.bill.client.OtherFeeBillEditUI;
import com.kingdee.eas.ncm.cal.OtherAllocResultVoucheredFactory;
import com.kingdee.eas.ncm.cal.VoucherDAPTransImpl;
import com.kingdee.eas.ncm.cal.client.AbstractOtherAllocVoucherListUI;
import com.kingdee.eas.ncm.cal.client.OtherAllocVoucherFilterUI;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class OtherAllocVoucherListUI
extends AbstractOtherAllocVoucherListUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherAllocVoucherListUI.class);
    private static final String Col_ID = "id";
    private static final String Col_EntryID = "entries.id";
    private CompanyOrgUnitInfo _company;
    private PeriodInfo _period;
    private static final String QtyCol = "entries.qty";
    private static final String PriceCol = "entries.price";
    private static final String AmtCol = "entries.amount";
    private FilterInfo _currFilterInfo = null;
    private CommonQueryDialog dialog = null;
    private OtherAllocVoucherFilterUI filterUI = null;

    public OtherAllocVoucherListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionStartWorkFlow.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionRemove.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.menuBiz.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.menuEdit.setVisible(false);
        this.btnViewBill.setIcon(this.btnTraceUp.getIcon());
        this.actionAuditResult.setVisible(false);
        this.actionVoucher.setVisible(false);
        this.actionVoucher.setEnabled(false);
    }

    public void onLoad() throws Exception {
        this._company = this.getCompanyOrgInfoWithDefault();
        this._period = this.GetCurrentPeriod();
        super.onLoad();
        this.initFormatTable();
    }

    protected void initDapButtons() throws Exception {
        super.initDapButtons();
        this.actionVoucher.setVisible(false);
        this.actionVoucher.setEnabled(false);
        this.auditAction.setVisible(false);
        this.unauditAction.setVisible(false);
        Object period = this.filterUI.prmtPeriod.getValue();
        if (period != null && period instanceof PeriodInfo) {
            String periodID = ((PeriodInfo)period).getId().toString();
            if (!this._period.getId().toString().equals(periodID)) {
                this.ActionByAll.setEnabled(false);
                this.actionByBill.setEnabled(false);
                this.actionDelVoucher.setEnabled(false);
            } else {
                this.ActionByAll.setEnabled(true);
                this.actionByBill.setEnabled(true);
                this.actionDelVoucher.setEnabled(true);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.actionAuditResult.setVisible(false);
        this.actionTraceDown.setVisible(true);
        this.actionDelVoucher.setVisible(true);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OtherFeeBillFactory.getRemoteInstance();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnByAll.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnByBill.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.btnViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.checkVoucherPermission("other_viewAlloc");
            this.actionViewAlloc_actionPerformed(null);
        }
    }

    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "View_1");
        this.tblMain.getActionMap().put("View_1", new AbstractAction(){
            private static final long serialVersionUID = -5669325198048189263L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent evt = new ActionEvent(OtherAllocVoucherListUI.this.btnViewAlloc, 0, "Enter");
                ItemAction actView = OtherAllocVoucherListUI.this.getActionFromActionEvent(evt);
                actView.actionPerformed(evt);
            }
        });
    }

    private boolean checkVoucherPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int amoutPre = 2;
        int priceprec = 8;
        int baseUnitprce = 8;
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                baseUnitprce = rowSet.getInt("unit.qtyPrecision");
                priceprec = rowSet.getInt("expense.pricePrecision");
                amoutPre = rowSet.getInt("baseCurrency.precision");
                NCMClientUtils.iniColumnsPrecision((int)baseUnitprce, (String[])new String[]{QtyCol}, (IRowSet)rowSet);
                NCMClientUtils.iniColumnsPrecision((int)priceprec, (String[])new String[]{PriceCol}, (IRowSet)rowSet);
                NCMClientUtils.iniColumnsPrecision((int)amoutPre, (String[])new String[]{AmtCol}, (IRowSet)rowSet);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void initFormatTable() throws Exception {
        this.tblMain.getColumn(QtyCol).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(PriceCol).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(AmtCol).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm:ss");
        String[] cols = new String[]{QtyCol, PriceCol, AmtCol};
        NCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])cols, (String)"%{0.##########}f");
        this.setMergeColumn();
        this.tblMain.getSelectManager().setSelectMode(10);
        String[] a = new String[]{AmtCol};
        NCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])a, (String)"%{###,###,###.##########}f");
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
            filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("costCenter.costCenterType", (Object)String.valueOf(CostCenterType.DirectProdDept.getValue())));
            FilterItemInfo newItem = null;
            newItem = new FilterItemInfo("entries.isAlloced", (Object)1, CompareType.EQUALS, false);
            filter.getFilterItems().add(newItem);
            try {
                if (ev.getFilter() != null) {
                    ev.getFilter().mergeFilter(filter, "and");
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this._period.getId().toString()));
                    ev.setFilter(filter);
                }
                this._currFilterInfo = (FilterInfo)ev.getFilter().clone();
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private PeriodInfo GetCurrentPeriod() throws BOSException, EASBizException {
        return NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)this.getCompanyOrgInfoWithDefault().getId().toString());
        cmcq.set("query", (Object)"OtherAllocQuery");
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new OtherAllocVoucherFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return new FilterInfo();
    }

    private void setMergeColumn() {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("number").setGroup(true);
        this.tblMain.getColumn("number").setMergeable(true);
        this.tblMain.getColumn("billStatus").setGroup(true);
        this.tblMain.getColumn("billStatus").setMergeable(true);
        this.tblMain.getColumn("bizDate").setGroup(true);
        this.tblMain.getColumn("bizDate").setMergeable(true);
        this.tblMain.getColumn("fivouchered").setGroup(true);
        this.tblMain.getColumn("fivouchered").setMergeable(true);
        this.tblMain.getColumn("vouchernumber").setGroup(true);
        this.tblMain.getColumn("vouchernumber").setMergeable(true);
        this.tblMain.getColumn("companyOrg.name").setGroup(true);
        this.tblMain.getColumn("companyOrg.name").setMergeable(true);
        this.tblMain.getColumn("costCenter.number").setGroup(true);
        this.tblMain.getColumn("costCenter.number").setMergeable(true);
        this.tblMain.getColumn("costCenter.name").setGroup(true);
        this.tblMain.getColumn("costCenter.name").setMergeable(true);
        this.tblMain.getColumn("expense.number").setGroup(true);
        this.tblMain.getColumn("expense.number").setMergeable(true);
        this.tblMain.getColumn("expense.name").setGroup(true);
        this.tblMain.getColumn("expense.name").setMergeable(true);
    }

    @Override
    public void actionByAll_actionPerformed(ActionEvent e) throws Exception {
        this.check();
        BOTMappingInfo botMappingInfo = VoucherDAPTransImpl.getBotpInfo((CoreUI)this, null, "BCAAC063", this.getCompanyOrgInfoWithDefault());
        if (botMappingInfo != null) {
            OtherAllocResultVoucheredFactory.getRemoteInstance().addVoucherByAll(this.getSelectedIdValues(), this.getCompanyOrgInfoWithDefault().getId().toString(), this._period.getId().toString(), botMappingInfo);
            this.showWindow(botMappingInfo);
            this.refresh(e);
        }
    }

    @Override
    public void actionByBill_actionPerformed(ActionEvent e) throws Exception {
        this.check();
        BOTMappingInfo botMappingInfo = VoucherDAPTransImpl.getBotpInfo((CoreUI)this, null, "BCAAC063", this.getCompanyOrgInfoWithDefault());
        if (botMappingInfo != null) {
            OtherAllocResultVoucheredFactory.getRemoteInstance().addVoucherByBill(this.getSelectedIdValues(), this.getCompanyOrgInfoWithDefault().getId().toString(), this._period.getId().toString(), botMappingInfo);
            this.showWindow(botMappingInfo);
            this.refresh(e);
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    public void actionViewAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewAlloc_actionPerformed(e);
        this.showAllocEditUI("VIEW");
    }

    private void showAllocEditUI(String operType) throws Exception {
        this.checkSelected();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this.getCompanyOrgInfoWithDefault().getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("companyName", this.getCompanyOrgInfoWithDefault().getName().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        param.put("filterInfo", (String)this.GetManuFilter(this._currFilterInfo));
        OtherAllocEditUI.showAllocEditUI((CoreUIObject)this, (String)OtherAllocEditUI.class.getName(), param, (String)operType, (KDTable)this.tblMain);
    }

    private FilterInfo GetManuFilter(FilterInfo filter) {
        int top = this.tblMain.getSelectManager().get(0).getBeginRow();
        String id = this.tblMain.getRow(top).getCell(Col_ID).getValue().toString();
        String entryId = this.tblMain.getRow(top).getCell(Col_EntryID).getValue().toString();
        FilterInfo ret = new FilterInfo();
        try {
            FilterInfo addfilter = new FilterInfo();
            addfilter.getFilterItems().add(new FilterItemInfo(Col_ID, (Object)id));
            addfilter.getFilterItems().add(new FilterItemInfo(Col_EntryID, (Object)entryId));
            try {
                ret.mergeFilter(filter, "and ");
                ret.mergeFilter(addfilter, "and");
                return ret;
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return ret;
    }

    public void check() throws Exception {
        this.checkSelected();
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!NCMUtils.isEquals((PeriodInfo)ctrol.getCacheCurrentPeriod(6, this.getCompanyOrgInfoWithDefault().getId().toString()), (PeriodInfo)this._period)) {
            throw new CMBillException(CMBillException.NOTEQUALS_VOUCHER);
        }
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OtherFeeBillEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void showWindow(BOTMappingInfo botMappingInfo) throws Exception {
        if (botMappingInfo == null || botMappingInfo.isEmpty()) {
            return;
        }
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String id = ids.get(0).toString();
        OtherFeeBillInfo billInfo = OtherFeeBillFactory.getRemoteInstance().getOtherFeeBillInfo((IObjectPK)new ObjectUuidPK(id));
        if (billInfo.getVoucher() == null || billInfo.getVoucher().getId() == null) {
            return;
        }
        ArrayList<String> voucherIdList = new ArrayList<String>();
        voucherIdList.add(billInfo.getVoucher().getId().toString());
        HashMap<String, String> param = new HashMap<String, String>();
        IUIWindow uiWindow = null;
        if (botMappingInfo.getIsShowEditUI() == 1) {
            RealModeIDList idList = RealModeIDList.getEmptyIDList();
            int size = voucherIdList.toArray().length;
            for (int i = 0; i < size; ++i) {
                idList.add(voucherIdList.toArray()[i].toString());
                param.put("ID", idList.getCurrentID());
                param.put("IDList", (String)idList);
            }
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.VoucherEditUI", param, null, OprtState.EDIT);
            }
            catch (UIException e) {
                throw new BOSException((Throwable)e);
            }
        } else if (botMappingInfo.getIsShowEditUI() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource.transSuccess"));
            return;
        }
        if (uiWindow != null) {
            uiWindow.show();
        }
        if (uiWindow instanceof JFrame) {
            ((JFrame)uiWindow).setExtendedState(6);
        }
    }

    protected boolean isEnableMultiOrgSupport() {
        return true;
    }

    public void afterFilterUIMainOrgChanged(ChangeEvent e) {
        try {
            this._period = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
    }
}

