/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.cal.CalCostFacadeFactory;
import com.kingdee.eas.ncm.cal.RecoveryCalcLogCollection;
import com.kingdee.eas.ncm.cal.RecoveryCalcLogInfo;
import com.kingdee.eas.ncm.cal.client.AbstractRecoveryCalcLogReportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Assert;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecoveryCalcLogReportUI
extends AbstractRecoveryCalcLogReportUI {
    private static final Logger logger = CoreUIObject.getLogger(RecoveryCalcLogReportUI.class);
    private Map _parentParam = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _companyName = null;
    private String _periodDispNumber = null;
    private RecoveryCalcLogCollection _logData = null;

    public static void showRecoveryCheckReportUI(CoreUIObject ui, Map param) throws Exception {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("companyName"));
        Assert.that((boolean)param.containsKey("periodDispNumber"));
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RecoveryCalcLogReportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        if (this._parentParam == null) {
            this._parentParam = (Map)this.getUIContext().get("key.cost.task.entry.param");
        }
        this._companyId = (String)this._parentParam.get("companyId");
        this._periodId = (String)this._parentParam.get("periodId");
        this._companyName = (String)this._parentParam.get("companyName");
        if (this._companyName == null) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this._companyId));
            this._companyName = company.getName();
        }
        this._periodDispNumber = (String)this._parentParam.get("periodDispNumber");
        if (this._periodDispNumber == null) {
            PeriodInfo period = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(this._periodId));
            this._periodDispNumber = String.valueOf(period.getNumber());
        }
        this._logData = this._parentParam.containsKey("logData") ? (RecoveryCalcLogCollection)((Object)this._parentParam.get("logData")) : CalCostFacadeFactory.getRemoteInstance().getRecoveryCalcLogData(this._companyId, this._periodId);
        this.kDTable.checkParsed();
        this.kDTable.getGroupManager().setGroup(true);
        this.kDTable.getColumn("level").setGroup(true);
        this.kDTable.getColumn("level").setMergeable(true);
        this.kDTable.getColumn("reportItem").setGroup(true);
        this.kDTable.getColumn("reportItem").setMergeable(true);
        this.kDTable.setAutoResize(true);
        this.kDTable.getStyleAttributes().setWrapText(true);
        this.kDTable.setAutoResize(true);
        this.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
        int rowCount = this.kDTable.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            KDTableHelper.autoFitRowHeight((KDTable)this.kDTable, (int)i, (int)2, (boolean)false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fillReportData();
    }

    private void fillReportData() {
        this.txtCompany.setText(this._companyName);
        this.txtPeriod.setText(this._periodDispNumber);
        if (this._logData == null) {
            return;
        }
        boolean isHandle = false;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < this._logData.size(); ++i) {
            RecoveryCalcLogInfo item = this._logData.get(i);
            if (!isHandle) {
                this.txtLogTime.setText(sdf.format(item.getCreateTime()));
                this.txtLogUser.setText(item.getCreator().getName());
                isHandle = true;
            }
            IRow row = this.kDTable.addRow();
            row.getCell("level").setValue((Object)item.getLevel());
            row.getCell("reportItem").setValue((Object)item.getReportItem());
            row.getCell("reportDetail").setValue((Object)item.getReportDetail());
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().printPreview();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }
}

