/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.cal.CalCostFacadeFactory;
import com.kingdee.eas.ncm.cal.RecoveryCheckLogCollection;
import com.kingdee.eas.ncm.cal.RecoveryCheckLogEntryCollection;
import com.kingdee.eas.ncm.cal.RecoveryCheckLogInfo;
import com.kingdee.eas.ncm.cal.client.AbstractRecoveryCheckLogReportUI;
import com.kingdee.eas.ncm.cal.client.RecoveryCheckLogDetailReportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Assert;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecoveryCheckLogReportUI
extends AbstractRecoveryCheckLogReportUI {
    private static final Logger logger = CoreUIObject.getLogger(RecoveryCheckLogReportUI.class);
    private Map _parentParam = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _companyName = null;
    private String _periodDispNumber = null;
    private RecoveryCheckLogCollection _logData = null;

    public static void showRecoveryCheckReportUI(CoreUIObject ui, Map param) throws Exception {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("companyName"));
        Assert.that((boolean)param.containsKey("periodDispNumber"));
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RecoveryCheckLogReportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        if (this._parentParam == null) {
            this._parentParam = (Map)this.getUIContext().get("key.cost.task.entry.param");
        }
        this._companyId = (String)this._parentParam.get("companyId");
        this._periodId = (String)this._parentParam.get("periodId");
        this._companyName = (String)this._parentParam.get("companyName");
        if (this._companyName == null) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this._companyId));
            this._companyName = company.getName();
        }
        this._periodDispNumber = (String)this._parentParam.get("periodDispNumber");
        if (this._periodDispNumber == null) {
            PeriodInfo period = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(this._periodId));
            this._periodDispNumber = String.valueOf(period.getNumber());
        }
        this._logData = this._parentParam.containsKey("logData") ? (RecoveryCheckLogCollection)((Object)this._parentParam.get("logData")) : CalCostFacadeFactory.getRemoteInstance().getRecoveryCheckLogData(this._companyId, this._periodId);
        this.kDTable.checkParsed();
        this.kDTable.getGroupManager().setGroup(true);
        this.kDTable.getColumn("sort").setGroup(true);
        this.kDTable.getColumn("sort").setMergeable(true);
        this.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fillReportData();
    }

    private void fillReportData() {
        this.txtCompany.setText(this._companyName);
        this.txtPeriod.setText(this._periodDispNumber);
        if (this._logData == null) {
            return;
        }
        boolean isHandle = false;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < this._logData.size(); ++i) {
            RecoveryCheckLogInfo item = this._logData.get(i);
            if (!isHandle) {
                this.txtLogTime.setText(sdf.format(item.getCreateTime()));
                this.txtLogUser.setText(item.getCreator().getName());
                isHandle = true;
            }
            IRow row = this.kDTable.addRow();
            row.getCell("sort").setValue((Object)String.valueOf(item.getSort()));
            row.getCell("checkItem").setValue((Object)item.getCheckItem());
            row.getCell("status").setValue((Object)item.getStatus());
            row.getCell("attachment").setValue((Object)item.getAttachment());
            row.getCell("logDetail").setValue((Object)item.getEntries());
            if (item.getEntries().size() <= 0) continue;
            row.getStyleAttributes().setBackground(new Color(246, 246, 191));
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().printPreview();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }

    @Override
    protected void kDTable_tableClicked(KDTMouseEvent e) throws Exception {
        RecoveryCheckLogEntryCollection item;
        super.kDTable_tableClicked(e);
        if (e.getClickCount() == 2 && e.getColIndex() == this.kDTable.getColumnIndex("attachment") && (item = (RecoveryCheckLogEntryCollection)((Object)this.kDTable.getCell(e.getRowIndex(), this.kDTable.getColumnIndex("logDetail")).getValue())).size() > 0) {
            HashMap<String, RecoveryCheckLogEntryCollection> param = new HashMap<String, RecoveryCheckLogEntryCollection>();
            param.put("logDetail", item);
            RecoveryCheckLogDetailReportUI.showRecoveryCheckDetailReportUI((CoreUIObject)this, param);
        }
    }
}

