/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class NCMReportHelper {
    private static Logger logger = Logger.getLogger((String)NCMReportHelper.class.getName());
    public static final int DETAIL_TotalRow = 0;
    public static final int Subtotal_TotalRow = 1;
    public static final int Total_TotalRow = 2;
    public static final int CostItem_TotalRow = 3;
    public static final int CostItemGroup_TotalRow = 4;
    public static final int Product_TotalRow = 5;
    public static final int CostObject_TotalRow = 6;
    public static final int CostCenter_TotalRow = 7;
    public static final int Period_TotalRow = 8;

    public static void AppendCaseSQLClause(StringBuffer sb, String sNumerator, String sDenominator, String sAlias, String precision) {
        sb.append('\n').append("CASE ").append(sDenominator).append(" WHEN 0 THEN 0 ").append(" ELSE Round( TO_Decimal(").append(sNumerator).append(",23,10)").append("     /TO_Decimal(").append(sDenominator).append(",23,10) ,").append(precision).append(" ) END ").append(sAlias).append('\n');
    }

    public static void AppendCaseSQLClause(StringBuffer sb, String sNumerator, String sDenominator, String defaulValue, String sAlias, String precision) {
        sb.append('\n').append("CASE ").append(sDenominator).append(" WHEN 0 THEN ").append(defaulValue).append('\n').append(" ELSE Round( TO_Decimal(").append(sNumerator).append(",23,10)").append("     /TO_Decimal(").append(sDenominator).append(",23,10) ,").append(precision).append(" ) END ").append(sAlias).append('\n');
    }

    public static void AppendPredicate(Context ctx, StringBuffer sb, RptParams filter, boolean bIsPeriod, String sFieldName, String sOP, String sFilterName) {
        if (bIsPeriod) {
            NCMReportHelper.AppendPredicateString(sb, false, sFieldName, ">=", NCMReportHelper.getPeriodNumber(filter.getString("spYearFrom"), filter.getString("spPeriodFrom")));
            NCMReportHelper.AppendPredicateString(sb, false, sFieldName, "<=", NCMReportHelper.getPeriodNumber(filter.getString("spYearTo"), filter.getString("spPeriodTo")));
        } else {
            String ov = CalSeverUtils.getParamString((Context)ctx, (RptParams)filter, (String)sFilterName);
            if (!StringUtils.isEmpty((String)ov)) {
                NCMReportHelper.AppendPredicateString(sb, true, sFieldName, sOP, ov);
            }
        }
    }

    public static String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    public static void AppendPredicateString(StringBuffer sb, boolean bIsString, String sFieldName, String sOP, String sValue) {
        sb.append(" AND ");
        sb.append(sFieldName);
        sb.append(sOP);
        if (bIsString) {
            sb.append("'");
        }
        sb.append(sValue);
        if (bIsString) {
            sb.append("' ");
        } else {
            sb.append(" ");
        }
    }

    public static void AppendInPredicate(StringBuffer sb, RptParams filter, String sFilterName, String sFieldName) {
        Collection ins;
        Object ov = filter.getObject(sFilterName);
        if (ov instanceof Collection && (ins = (Collection)ov).size() > 0) {
            sb.append('\n').append(" AND ").append(sFieldName).append(" IN ( ");
            StringBuffer inString = BDCMUtils.splitPK((Collection)ins);
            sb.append(inString).append(" ) ");
        }
    }

    public static String getSortString(Context ctx, RptParams filter) {
        ArrayList tableList = (ArrayList)filter.getObject("table");
        if (tableList == null) {
            tableList = new ArrayList();
            HashMap<String, Object> member = new HashMap<String, Object>();
            member.put("id", "FPeriodName");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"58_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostcenterID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"83_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostobjectID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"84_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FProductID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"181_ByClassCostCalReportFilter2UI", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
            member = new HashMap();
            member.put("id", "FCostItemID");
            member.put("fieldName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"85_CostCalTotalDetailReport", (Locale)ctx.getLocale()));
            member.put("isTotal", Boolean.TRUE);
            tableList.add(member);
        }
        StringBuffer sbChecked = new StringBuffer();
        StringBuffer sbNoChecked = new StringBuffer();
        for (int i = 0; i < tableList.size(); ++i) {
            HashMap map = (HashMap)tableList.get(i);
            if (((Boolean)map.get("isTotal")).booleanValue()) {
                if (sbChecked.length() > 0) {
                    sbChecked.append(",");
                }
                sbChecked.append(NCMReportHelper.getField(map));
                continue;
            }
            if (sbNoChecked.length() > 0) {
                sbNoChecked.append(",");
            }
            sbNoChecked.append(NCMReportHelper.getField(map));
        }
        if (sbNoChecked.length() > 0 && sbChecked.length() > 0) {
            sbChecked.append(",").append(sbNoChecked);
        } else {
            sbChecked.append(sbNoChecked);
        }
        return sbChecked.toString();
    }

    public static StringBuffer getShowString(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(NCMReportHelper.getField(map));
        }
        return sb;
    }

    public static ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("groupby", sb.toString());
            map.put("totalrow", BigDecimal.valueOf(8 - i));
            newList.add(map);
        }
        return newList;
    }

    private static StringBuffer getField(HashMap map) {
        StringBuffer sb = new StringBuffer();
        String field = (String)map.get("id");
        String fieldName = "";
        String fieldNumber = "";
        if (field.equalsIgnoreCase("FPeriodNumber") || field.equalsIgnoreCase("FPeriodName")) {
            sb.append("FPeriodNumber");
        } else {
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            sb.append(fieldNumber + "," + fieldName);
        }
        return sb;
    }

    public static ReportHeader sortHeader(RptParams filter, ReportHeader header, Object[] HeaderGroup) {
        HashMap<String, ReportHeader> mapHeader = new HashMap<String, ReportHeader>();
        ArrayList list = header.getChilds();
        for (int i = 0; i < HeaderGroup.length; ++i) {
            String[] groups = (String[])HeaderGroup[i];
            block1: for (int j = 0; j < groups.length; ++j) {
                for (int k = 0; k < list.size(); ++k) {
                    ReportHeader child = (ReportHeader)list.get(k);
                    if (!groups[j].equalsIgnoreCase(child.getFieldName())) continue;
                    list.remove(k);
                    mapHeader.put(child.getFieldName().toLowerCase(), child);
                    continue block1;
                }
            }
        }
        ArrayList listFields = (ArrayList)filter.getObject("table");
        int count = 0;
        for (int i = 0; i < listFields.size(); ++i) {
            HashMap map = (HashMap)listFields.get(i);
            String fieldID = (String)map.get("id");
            String[] groups = NCMReportHelper.getHeaderGroups(fieldID, HeaderGroup);
            if (groups == null) continue;
            for (int j = 0; j < groups.length; ++j) {
                ReportHeader child = (ReportHeader)mapHeader.get(groups[j].toLowerCase());
                if (child != null) {
                    list.add(count++, child);
                    continue;
                }
                logger.debug((Object)groups[j].toLowerCase());
            }
        }
        return header;
    }

    private static String[] getHeaderGroups(String fieldID, Object[] HeaderGroup) {
        for (int i = 0; i < HeaderGroup.length; ++i) {
            String[] groups = (String[])HeaderGroup[i];
            if (!groups[0].equalsIgnoreCase(fieldID)) continue;
            return groups;
        }
        return null;
    }

    public static IRowSet getListWithDynamicRowSet(Context ctx, Integer nCountPerPage, IRowSet rs, String colName) throws SQLException {
        String[] multiCols = colName.split("_");
        DynamicRowSet drs = new DynamicRowSet(1);
        drs.setColInfo(1, colName, ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"140_RecoveryByEndlReport", (Locale)ctx.getLocale()), 12, null);
        StringBuffer sb = new StringBuffer();
        rs.first();
        for (int i = 1; i <= rs.size(); ++i) {
            for (int k = 0; k < multiCols.length; ++k) {
                sb.append("").append(rs.getString(multiCols[k])).append("_");
            }
            sb.append(",");
            if (i == rs.size() || i % nCountPerPage == 0) {
                drs.moveToInsertRow();
                drs.updateString(colName, sb.substring(0, sb.length() - 2).toString());
                drs.insertRow();
                sb.setLength(0);
            }
            rs.next();
        }
        return drs;
    }

    public static void AppendPredicateForOnePage(StringBuffer sb, RptParams filter, String sFieldName, String sFilterName) {
        int k;
        String[] multiFilterName = sFilterName.split("_");
        HashMap map = (HashMap)filter.getObject("position");
        String productIDs = (String)map.get(sFieldName.toLowerCase());
        if (StringUtils.isEmpty((String)productIDs)) {
            return;
        }
        String[] multiCols = productIDs.split(",");
        StringBuffer[] multiFilterIDs = new StringBuffer[multiFilterName.length];
        for (int h = 0; h < multiFilterName.length; ++h) {
            multiFilterIDs[h] = new StringBuffer();
        }
        for (k = 0; k < multiCols.length; ++k) {
            String[] multiIDs = multiCols[k].split("_");
            for (int j = 0; j < multiFilterName.length; ++j) {
                multiFilterIDs[j].append("'").append(multiIDs[j]).append("',");
            }
        }
        for (k = 0; k < multiFilterName.length; ++k) {
            sb.append(" and ").append(multiFilterName[k]).append(" IN ( ").append(multiFilterIDs[k].substring(0, multiFilterIDs[k].length() - 1)).append(" ) ");
        }
    }

    public static String[] ExtractForOnePage(RptParams filter, String sFieldName, String sFilterName) {
        String[] multiFilterName = sFilterName.split("_");
        HashMap map = (HashMap)filter.getObject("position");
        String productIDs = (String)map.get(sFieldName.toLowerCase());
        String[] multiCols = productIDs.split(",");
        String[] multiFilterIDs = new String[multiCols.length];
        for (int k = 0; k < multiCols.length; ++k) {
            String[] multiIDs = multiCols[k].split("_");
            StringBuffer row = new StringBuffer();
            for (int j = 0; j < multiFilterName.length; ++j) {
                multiFilterIDs[k] = row.append(" and ").append(multiFilterName[j]).append(" = '").append(multiIDs[j]).append("'").toString();
            }
        }
        return multiFilterIDs;
    }

    public static final class KDTableFilterElement
    extends SingleFilterElement {
        private KDTable table;

        public KDTableFilterElement(String id, KDTable component) {
            super(id, (Component)component);
            this.table = component;
        }

        protected String getName(Object obj) {
            if (obj instanceof KDTable) {
                return ((KDTable)obj).getName();
            }
            return null;
        }

        public void addCustomerParam(CustomerParams cp, String key, Object obj) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    IColumn col = this.table.getColumn(j);
                    cp.addCustomerParam("_" + col.getKey() + ":" + i, this.table.getRow(i).getCell(col.getKey()).getValue().toString());
                }
            }
        }

        public void setElementValue(CustomerParams cp) {
            Set keySet;
            if (cp != null && (keySet = (Set)cp.getKeys()) != null && keySet.size() > 0) {
                String key2 = null;
                for (String key2 : keySet) {
                    if (key2 == null || !key2.startsWith("_")) continue;
                    int index = Integer.parseInt(key2.substring(key2.lastIndexOf(":") + 1));
                    String fieldKey = key2.substring(1, key2.lastIndexOf(":"));
                    if (!fieldKey.equals("isTotal")) continue;
                    this.table.getRow(index).getCell(fieldKey).setValue((Object)Boolean.valueOf(cp.getCustomerParam(key2)));
                }
            }
        }

        public void addRptParams(RptParams cp) {
            ArrayList list = this.getParamterFromKDTable();
            cp.setObject(this.getId(), (Object)list);
        }

        private ArrayList getParamterFromKDTable() {
            ArrayList list = new ArrayList();
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    IColumn col = this.table.getColumn(j);
                    map.put(col.getKey(), this.table.getRow(i).getCell(col.getKey()).getValue());
                }
                list.add(map);
            }
            return list;
        }
    }
}

