/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.birpt.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.ncm.cal.report.birpt.client.AbstractCompareAnalyseFixFilterUI;
import com.kingdee.eas.ncm.cal.report.client.ReportSpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Container;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import org.apache.log4j.Logger;

public class CompareAnalyseFixFilterUI
extends AbstractCompareAnalyseFixFilterUI {
    private static final long serialVersionUID = 5902762720326991346L;
    private static final Logger logger = CoreUIObject.getLogger(CompareAnalyseFixFilterUI.class);
    protected Object[][] basePeriods = null;
    private static final String basePeriodsKey = "BASE_PERIODS_KEY";
    protected Object[][] comparePeriods = null;
    private static final String comparePeriodsKey = "COMPARE_PERIODS_KEY";

    public Object[][] getPeriods() {
        if (this.basePeriods == null) {
            return null;
        }
        return (Object[][])this.basePeriods.clone();
    }

    public void setPeriods(Object[][] periods) {
        this.basePeriods = periods == null ? (Object[][])null : (Object[][])periods.clone();
    }

    public Object[][] getComparePeriods() {
        if (this.comparePeriods == null) {
            return null;
        }
        return (Object[][])this.comparePeriods.clone();
    }

    public void setComparePeriods(Object[][] comparePeriod) {
        this.comparePeriods = comparePeriod == null ? (Object[][])null : (Object[][])comparePeriod.clone();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.filterOrder(this.prmtOrder);
        this.filterProject(this.prmtProject);
        this.filterTrack(this.prmtTrack);
        this.filterMaterial(this.prmtMaterial);
        super.registerPeriodComponents(this.spinnerYearFrom, this.spinnerMonthFrom, this.spinnerYearTo, this.spinnerMonthTo, this.btnSPPeriod, "getPeriods", "setPeriods");
        super.registerPeriodComponents(this.spinnerYearFrom2, this.spinnerMonthFrom2, this.spinnerYearTo2, this.spinnerMonthTo2, this.btnSPPeriod2, "getComparePeriods", "setComparePeriods");
    }

    public void clear() {
        super.clear();
        try {
            this.basePeriods = null;
            this.comparePeriods = null;
            super.registerPeriodComponents(this.spinnerYearFrom, this.spinnerMonthFrom, this.spinnerYearTo, this.spinnerMonthTo, this.btnSPPeriod, "getPeriods", "setPeriods");
            super.registerPeriodComponents(this.spinnerYearFrom2, this.spinnerMonthFrom2, this.spinnerYearTo2, this.spinnerMonthTo2, this.btnSPPeriod2, "getComparePeriods", "setComparePeriods");
            this.prmtCostCenter.setData(null);
            this.prmtCostObject.setData(null);
            this.prmtCostItem.setData(null);
            this.prmtOrder.setData(null);
            this.prmtProject.setData(null);
            this.prmtTrack.setData(null);
            this.prmtMaterial.setData(null);
            this.tfBatch.setText("");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.common.CommonResource", (String)"QueryFail"));
        }
    }

    @Override
    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.recordAllStatus((Container)((Object)this));
        rm.setProperty(basePeriodsKey, (Object)this.basePeriods);
        rm.setProperty(comparePeriodsKey, (Object)this.comparePeriods);
        return rm.toRptParams();
    }

    @Override
    public void setCustomCondition(RptParams rptParams) {
        try {
            RptConditionManager rm = new RptConditionManager(rptParams);
            rm.restoreAllStatus((Container)((Object)this));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Object basePeriodsParam = rptParams.getObject(basePeriodsKey);
        if (basePeriodsParam instanceof Object[][]) {
            this.basePeriods = (Object[][])basePeriodsParam;
            this.spinnerYearFrom.setEnabled(false);
            this.spinnerMonthFrom.setEnabled(false);
            this.spinnerYearTo.setEnabled(false);
            this.spinnerMonthTo.setEnabled(false);
            this.spinnerYearFrom.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spinnerMonthFrom.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spinnerYearTo.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spinnerMonthTo.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
        } else {
            this.basePeriods = null;
            this.spinnerYearFrom.setEnabled(true);
            this.spinnerMonthFrom.setEnabled(true);
            this.spinnerYearTo.setEnabled(true);
            this.spinnerMonthTo.setEnabled(true);
            try {
                super.registerPeriodComponents(this.spinnerYearFrom, this.spinnerMonthFrom, this.spinnerYearTo, this.spinnerMonthTo, this.btnSPPeriod, "getPeriods", "setPeriods", this.getInitPeriods(rptParams, new String[]{"spinnerYearFrom.value", "spinnerMonthFrom.value", "spinnerYearTo.value", "spinnerMonthTo.value"}));
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
        }
        Object comparePeriodsParam = rptParams.getObject(comparePeriodsKey);
        if (comparePeriodsParam instanceof Object[][]) {
            this.comparePeriods = (Object[][])comparePeriodsParam;
            this.spinnerYearFrom2.setEnabled(false);
            this.spinnerMonthFrom2.setEnabled(false);
            this.spinnerYearTo2.setEnabled(false);
            this.spinnerMonthTo2.setEnabled(false);
            this.spinnerYearFrom2.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spinnerMonthFrom2.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spinnerYearTo2.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spinnerMonthTo2.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
        } else {
            this.comparePeriods = null;
            this.spinnerYearFrom2.setEnabled(true);
            this.spinnerMonthFrom2.setEnabled(true);
            this.spinnerYearTo2.setEnabled(true);
            this.spinnerMonthTo2.setEnabled(true);
            try {
                super.registerPeriodComponents(this.spinnerYearFrom2, this.spinnerMonthFrom2, this.spinnerYearTo2, this.spinnerMonthTo2, this.btnSPPeriod2, "getComparePeriods", "setComparePeriods", this.getInitPeriods(rptParams, new String[]{"spinnerYearFrom2.value", "spinnerMonthFrom2.value", "spinnerYearTo2.value", "spinnerMonthTo2.value"}));
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
        }
    }

    @Override
    public boolean verify() {
        int to;
        int from;
        Integer periodTo;
        Integer yearTo;
        Integer periodFrom;
        Integer yearFrom;
        if (this.spinnerYearFrom.isEnabled() && this.spinnerMonthFrom.isEnabled() && this.spinnerYearTo.isEnabled() && this.spinnerMonthTo.isEnabled()) {
            yearFrom = this.spinnerYearFrom.getIntegerVlaue();
            periodFrom = this.spinnerMonthFrom.getIntegerVlaue();
            yearTo = this.spinnerYearTo.getIntegerVlaue();
            periodTo = this.spinnerMonthTo.getIntegerVlaue();
            from = ReportSpinnerUtil.getNumberOfPeriod(yearFrom, periodFrom);
            if (from > (to = ReportSpinnerUtil.getNumberOfPeriod(yearTo, periodTo))) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseResource", (String)"PERIOD_ERROR"));
                return false;
            }
        }
        if (this.spinnerYearFrom2.isEnabled() && this.spinnerMonthFrom2.isEnabled() && this.spinnerYearTo2.isEnabled() && this.spinnerMonthTo2.isEnabled()) {
            yearFrom = this.spinnerYearFrom2.getIntegerVlaue();
            periodFrom = this.spinnerMonthFrom2.getIntegerVlaue();
            yearTo = this.spinnerYearTo2.getIntegerVlaue();
            periodTo = this.spinnerMonthTo2.getIntegerVlaue();
            from = ReportSpinnerUtil.getNumberOfPeriod(yearFrom, periodFrom);
            if (from > (to = ReportSpinnerUtil.getNumberOfPeriod(yearTo, periodTo))) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseResource", (String)"PERIOD_ERROR"));
                return false;
            }
        }
        return super.verify();
    }
}

