/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.birpt.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.ncm.cal.report.birpt.client.AbstractProductUseOfMatAnalyseFixFilterUI;
import com.kingdee.eas.ncm.cal.report.client.ReportSpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Container;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import org.apache.log4j.Logger;

public class ProductUseOfMatAnalyseFixFilterUI
extends AbstractProductUseOfMatAnalyseFixFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductUseOfMatAnalyseFixFilterUI.class);
    protected Object[][] basePeriods = null;
    private static final String basePeriodsKey = "BASE_PERIODS_KEY";
    protected Object[][] comparePeriods = null;
    private static final String comparePeriodsKey = "COMPARE_PERIODS_KEY";

    public Object[][] getPeriods() {
        if (this.basePeriods == null) {
            return null;
        }
        return (Object[][])this.basePeriods.clone();
    }

    public void setPeriods(Object[][] periods) {
        this.basePeriods = periods == null ? (Object[][])null : (Object[][])periods.clone();
    }

    public Object[][] getComparePeriods() {
        if (this.comparePeriods == null) {
            return null;
        }
        return (Object[][])this.comparePeriods.clone();
    }

    public void setComparePeriods(Object[][] comparePeriod) {
        this.comparePeriods = comparePeriod == null ? (Object[][])null : (Object[][])comparePeriod.clone();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.filterOrder(this.prmtOrder);
        this.filterProject(this.prmtProject);
        this.filterTrack(this.prmtTrack);
        this.filterMaterial(this.prmtMaterial);
        super.registerPeriodComponents(this.spBaseYearFrom, this.spBaseMonthFrom, this.spBaseYearTo, this.spBaseMonthTo, this.btnSPBasePeriod, "getPeriods", "setPeriods");
        super.registerPeriodComponents(this.spCompYearFrom, this.spCompMonthFrom, this.spCompYearTo, this.spCompMonthTo, this.btnSPCompPeriod, "getComparePeriods", "setComparePeriods");
    }

    public void clear() {
        super.clear();
        try {
            this.basePeriods = null;
            this.comparePeriods = null;
            super.registerPeriodComponents(this.spBaseYearFrom, this.spBaseMonthFrom, this.spBaseYearTo, this.spBaseMonthTo, this.btnSPBasePeriod, "getPeriods", "setPeriods");
            super.registerPeriodComponents(this.spCompYearFrom, this.spCompMonthFrom, this.spCompYearTo, this.spCompMonthTo, this.btnSPCompPeriod, "getComparePeriods", "setComparePeriods");
            this.prmtCostCenter.setData(null);
            this.prmtCostObject.setData(null);
            this.prmtCostItem.setData(null);
            this.prmtOrder.setData(null);
            this.prmtProject.setData(null);
            this.prmtTrack.setData(null);
            this.prmtMaterial.setData(null);
            this.tfBatch.setText("");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.common.CommonResource", (String)"QueryFail"));
        }
    }

    @Override
    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.recordAllStatus((Container)((Object)this));
        rm.setProperty(basePeriodsKey, (Object)this.basePeriods);
        rm.setProperty(comparePeriodsKey, (Object)this.comparePeriods);
        return rm.toRptParams();
    }

    @Override
    public void setCustomCondition(RptParams rptParams) {
        try {
            RptConditionManager rm = new RptConditionManager(rptParams);
            rm.restoreAllStatus((Container)((Object)this));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Object basePeriodsParam = rptParams.getObject(basePeriodsKey);
        if (basePeriodsParam instanceof Object[][]) {
            this.basePeriods = (Object[][])basePeriodsParam;
            this.spBaseYearFrom.setEnabled(false);
            this.spBaseMonthFrom.setEnabled(false);
            this.spBaseYearTo.setEnabled(false);
            this.spBaseMonthTo.setEnabled(false);
            this.spBaseYearFrom.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spBaseMonthFrom.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spBaseYearTo.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spBaseMonthTo.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
        } else {
            this.basePeriods = null;
            this.spBaseYearFrom.setEnabled(true);
            this.spBaseMonthFrom.setEnabled(true);
            this.spBaseYearTo.setEnabled(true);
            this.spBaseMonthTo.setEnabled(true);
            try {
                super.registerPeriodComponents(this.spBaseYearFrom, this.spBaseMonthFrom, this.spBaseYearTo, this.spBaseMonthTo, this.btnSPBasePeriod, "getPeriods", "setPeriods", this.getInitPeriods(rptParams, new String[]{"spBaseYearFrom.value", "spBaseMonthFrom.value", "spBaseYearTo.value", "spBaseMonthTo.value"}));
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
        }
        Object comparePeriodsParam = rptParams.getObject(comparePeriodsKey);
        if (comparePeriodsParam instanceof Object[][]) {
            this.comparePeriods = (Object[][])comparePeriodsParam;
            this.spCompYearFrom.setEnabled(false);
            this.spCompMonthFrom.setEnabled(false);
            this.spCompYearTo.setEnabled(false);
            this.spCompMonthTo.setEnabled(false);
            this.spCompYearFrom.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spCompMonthFrom.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spCompYearTo.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spCompMonthTo.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
        } else {
            this.comparePeriods = null;
            this.spCompYearFrom.setEnabled(true);
            this.spCompMonthFrom.setEnabled(true);
            this.spCompYearTo.setEnabled(true);
            this.spCompMonthTo.setEnabled(true);
            try {
                super.registerPeriodComponents(this.spCompYearFrom, this.spCompMonthFrom, this.spCompYearTo, this.spCompMonthTo, this.btnSPCompPeriod, "getComparePeriods", "setComparePeriods", this.getInitPeriods(rptParams, new String[]{"spCompYearFrom.value", "spCompMonthFrom.value", "spCompYearTo.value", "spCompMonthTo.value"}));
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
        }
    }

    @Override
    public boolean verify() {
        int to;
        int from;
        Integer periodTo;
        Integer yearTo;
        Integer periodFrom;
        Integer yearFrom;
        if (this.spBaseYearFrom.isEnabled() && this.spBaseMonthFrom.isEnabled() && this.spBaseYearTo.isEnabled() && this.spBaseMonthTo.isEnabled()) {
            yearFrom = this.spBaseYearFrom.getIntegerVlaue();
            periodFrom = this.spBaseMonthFrom.getIntegerVlaue();
            yearTo = this.spBaseYearTo.getIntegerVlaue();
            periodTo = this.spBaseMonthTo.getIntegerVlaue();
            from = ReportSpinnerUtil.getNumberOfPeriod(yearFrom, periodFrom);
            if (from > (to = ReportSpinnerUtil.getNumberOfPeriod(yearTo, periodTo))) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseResource", (String)"PERIOD_ERROR"));
                return false;
            }
        }
        if (this.spCompYearFrom.isEnabled() && this.spCompMonthFrom.isEnabled() && this.spCompYearTo.isEnabled() && this.spCompMonthTo.isEnabled()) {
            yearFrom = this.spCompYearFrom.getIntegerVlaue();
            periodFrom = this.spCompMonthFrom.getIntegerVlaue();
            yearTo = this.spCompYearTo.getIntegerVlaue();
            periodTo = this.spCompMonthTo.getIntegerVlaue();
            from = ReportSpinnerUtil.getNumberOfPeriod(yearFrom, periodFrom);
            if (from > (to = ReportSpinnerUtil.getNumberOfPeriod(yearTo, periodTo))) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseResource", (String)"PERIOD_ERROR"));
                return false;
            }
        }
        return super.verify();
    }
}

