/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.birpt.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.ncm.cal.report.birpt.client.AbstractTrendAnalyseFixFilterUI;
import com.kingdee.eas.ncm.cal.report.client.ReportSpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Container;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import org.apache.log4j.Logger;

public class TrendAnalyseFixFilterUI
extends AbstractTrendAnalyseFixFilterUI {
    private static final long serialVersionUID = -538306952973445100L;
    private static final Logger logger = CoreUIObject.getLogger(TrendAnalyseFixFilterUI.class);
    private static final String rptPeriodsKey = "RPT_PERIODS_KEY";
    protected Object[][] periods = null;

    public Object[][] getPeriods() {
        if (this.periods == null) {
            return null;
        }
        return (Object[][])this.periods.clone();
    }

    public void setPeriods(Object[][] period) {
        this.periods = period == null ? (Object[][])null : (Object[][])period.clone();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.filterOrder(this.prmtOrder);
        this.filterProject(this.prmtProject);
        this.filterTrack(this.prmtTrack);
        this.filterMaterial(this.prmtMaterial);
        super.registerPeriodComponents(this.spYearFrom, this.spMonthFrom, this.spYearTo, this.spMonthTo, this.btnSPPeriod, "getPeriods", "setPeriods");
    }

    public void clear() {
        super.clear();
        try {
            this.periods = null;
            super.registerPeriodComponents(this.spYearFrom, this.spMonthFrom, this.spYearTo, this.spMonthTo, this.btnSPPeriod, "getPeriods", "setPeriods");
            this.prmtCostCenter.setData(null);
            this.prmtCostObject.setData(null);
            this.prmtCostItem.setData(null);
            this.prmtOrder.setData(null);
            this.prmtProject.setData(null);
            this.prmtTrack.setData(null);
            this.prmtMaterial.setData(null);
            this.tfBatch.setText("");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.common.CommonResource", (String)"QueryFail"));
        }
    }

    @Override
    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.recordAllStatus((Container)((Object)this));
        rm.setProperty(rptPeriodsKey, (Object)this.periods);
        return rm.toRptParams();
    }

    @Override
    public void setCustomCondition(RptParams rptParams) {
        try {
            RptConditionManager rm = new RptConditionManager(rptParams);
            rm.restoreAllStatus((Container)((Object)this));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Object periodsParam = rptParams.getObject(rptPeriodsKey);
        if (periodsParam instanceof Object[][]) {
            this.periods = (Object[][])periodsParam;
            this.spYearFrom.setEnabled(false);
            this.spMonthFrom.setEnabled(false);
            this.spYearTo.setEnabled(false);
            this.spMonthTo.setEnabled(false);
            this.spYearFrom.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spMonthFrom.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spYearTo.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spMonthTo.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
        } else {
            this.periods = null;
            this.spYearFrom.setEnabled(true);
            this.spMonthFrom.setEnabled(true);
            this.spYearTo.setEnabled(true);
            this.spMonthTo.setEnabled(true);
            try {
                super.registerPeriodComponents(this.spYearFrom, this.spMonthFrom, this.spYearTo, this.spMonthTo, this.btnSPPeriod, "getPeriods", "setPeriods", this.getInitPeriods(rptParams, new String[]{"spYearFrom.value", "spMonthFrom.value", "spYearTo.value", "spMonthTo.value"}));
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
        }
    }

    @Override
    public boolean verify() {
        if (this.spYearFrom.isEnabled() && this.spMonthFrom.isEnabled() && this.spYearTo.isEnabled() && this.spMonthTo.isEnabled()) {
            int to;
            Integer yearFrom = this.spYearFrom.getIntegerVlaue();
            Integer periodFrom = this.spMonthFrom.getIntegerVlaue();
            Integer yearTo = this.spYearTo.getIntegerVlaue();
            Integer periodTo = this.spMonthTo.getIntegerVlaue();
            int from = ReportSpinnerUtil.getNumberOfPeriod(yearFrom, periodFrom);
            if (from > (to = ReportSpinnerUtil.getNumberOfPeriod(yearTo, periodTo))) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseResource", (String)"PERIOD_ERROR"));
                return false;
            }
        }
        return super.verify();
    }
}

