/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.AUXOverheadCollection;
import com.kingdee.eas.basedata.ncm.AUXOverheadFactory;
import com.kingdee.eas.basedata.ncm.AUXOverheadInfo;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.ncm.cal.report.client.AbstractAUXOverheadSumReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.text.ParseException;
import java.util.HashSet;
import javax.swing.JSpinner;
import org.apache.log4j.Logger;

public class AUXOverheadSumReportFilterUI
extends AbstractAUXOverheadSumReportFilterUI {
    private static final long serialVersionUID = 6049691201819555232L;
    private CompanyOrgUnitInfo companyOrg = null;
    private static final String _prmtCostCenter = "prmtCostCenter";
    private static final String _prmtExpense = "prmtExpense";
    private static final String _prmtOverhead = "prmtOverhead";
    private static final String _prmtCostObject = "prmtCostObject";
    private static final String _prmtCostItem = "prmtCostItem";
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public AUXOverheadSumReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!sysctrol.isStart(1001, this.companyOrg.getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(1001, this.companyOrg.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.startPeriod = sysctrol.getStartPeriod(1001, this.companyOrg.getId().toString());
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)this.companyOrg, (PeriodInfo)this.currentPeriod);
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccCol = null;
        try {
            ccCol = iOUR.getFromUnit(this.companyOrg.getId().toString(), 1, 5);
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
        if (ccCol == null || ccCol.size() == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource((String)"NoCostCenterDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.formatUI();
    }

    private void formatUI() throws Exception {
        this.prmtCompany.setValue((Object)this.companyOrg);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenter, (String)this.companyOrg.getId().toString());
        this.filterAuxOverheadF7();
        BDCMClientUtils.filterDataBaseDF7((String)"4A255827", (KDBizPromptBox)this.prmtExpense);
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObject, (String)this.companyOrg.getId().toString());
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObject, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.prmtCostObject.setSelector((KDPromptSelector)arg0);
        FilterInfo costItemFilter = CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
        EntityViewInfo costItemView = null;
        costItemView = this.prmtCostItem.getEntityViewInfo() != null ? this.prmtCostItem.getEntityViewInfo() : new EntityViewInfo();
        costItemView.setFilter(costItemFilter);
        this.prmtCostItem.setEntityViewInfo(costItemView);
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtOrder, (String)this.companyOrg.getId().toString());
        this.filterProject(this.prmtProjectNumber);
        this.filterTrack(this.prmtTrackNumber);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrg.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(1)));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        this.prmtMaterial.setEntityViewInfo(view);
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleBizPromptFilterElement("companyOrg", this.prmtCompany));
        SpinnerFilterElement element = new SpinnerFilterElement("yearForm", (Component)this.yearFromSpinner);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("yearTo", (Component)this.yearToSpinner);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("monthFrom", (Component)this.monthFromSpinner);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("monthTo", (Component)this.monthToSpinner);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new F7SingleFilterElement("costCenters", (Component)this.prmtCostCenter));
        elements.add((FilterElement)new F7SingleFilterElement("expense", (Component)this.prmtExpense));
        elements.add((FilterElement)new F7SingleFilterElement("overhead", (Component)this.prmtOverhead));
        elements.add((FilterElement)new F7SingleFilterElement("costObjects", (Component)this.prmtCostObject));
        elements.add((FilterElement)new F7SingleFilterElement("costItems", (Component)this.prmtCostItem));
        elements.add((FilterElement)new F7SingleFilterElement("order", (Component)this.prmtOrder));
        elements.add((FilterElement)new SingleFilterElement("batchNumber", (Component)this.txtBatchNumber));
        elements.add((FilterElement)new F7SingleFilterElement("projectNumber", (Component)this.prmtProjectNumber));
        elements.add((FilterElement)new F7SingleFilterElement("trackNumber", (Component)this.prmtTrackNumber));
        elements.add((FilterElement)new F7SingleFilterElement("material", (Component)this.prmtMaterial));
        return elements;
    }

    protected void filterProject(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = ProjectFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    protected void filterTrack(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    private void filterAuxOverheadF7() throws Exception {
        BDCMClientUtils.filterDataBaseDF7((String)"8CB367E7", (KDBizPromptBox)this.prmtOverhead);
        EntityViewInfo view = this.prmtOverhead.getEntityViewInfo();
        FilterInfo filter = null;
        filter = view.getFilter() != null ? view.getFilter() : new FilterInfo();
        HashSet<String> auxIds = new HashSet<String>();
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT DISTINCT aux.FID ");
        kSql.append(" FROM   T_NCM_AUXOverhead aux ");
        kSql.append("        INNER JOIN T_NCM_AUXOverheadCompanyInfo auxCompany ");
        kSql.append("          ON aux.FID = auxCompany.FAuxOverheadID ");
        kSql.append(" WHERE  auxCompany.FCompanyID = '" + this.companyOrg.getId().toString() + "' ");
        kSql.append("   AND  auxCompany.FCostCenterID IS NOT NULL ");
        IRowSet rst = SQLExecutorFactory.getRemoteInstance((String)kSql.toString()).executeSQL();
        while (rst.next()) {
            auxIds.add(rst.getString(1));
        }
        if (auxIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", auxIds, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"####################", CompareType.EQUALS));
        }
        filter.mergeFilter(view.getFilter(), "AND");
        view.setFilter(filter);
        this.prmtOverhead.setEntityViewInfo(view);
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
            this.loadCostCenterNum(params);
            this.loadExpense(params);
            this.loadOverhead(params);
            this.loadCostObject(params);
            this.loadCostItemNum(params);
            this.loadOrder(params);
            this.loadProject(params);
            this.loadTrack(params);
            this.loadBatch(params);
            this.loadMaterialNum(params);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.currentPeriod;
        PeriodInfo initPeriodTo = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("yearFromSpinner");
        String initMonthFrom = params.getCustomerParam("monthFromSpinner");
        String initYearTo = params.getCustomerParam("yearToSpinner");
        String initMonthTo = params.getCustomerParam("monthToSpinner");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.yearFromSpinner, (JSpinner)this.monthFromSpinner, (PeriodInfo)initPeriodFrom, (JSpinner)this.yearToSpinner, (JSpinner)this.monthToSpinner, (PeriodInfo)initPeriodTo);
    }

    @Override
    protected void setDefaultValue() {
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompany.setValue((Object)this.companyOrg);
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.yearFromSpinner, (JSpinner)this.monthFromSpinner, (PeriodInfo)this.currentPeriod, (JSpinner)this.yearToSpinner, (JSpinner)this.monthToSpinner, (PeriodInfo)this.currentPeriod);
    }

    private void loadCostCenterNum(CustomerParams params) {
        String costCenter = "";
        if (params.getCustomerParam(_prmtCostCenter) != null) {
            costCenter = params.getCustomerParam(_prmtCostCenter);
        }
        if (StringUtils.isEmpty((String)costCenter)) {
            this.prmtCostCenter.setData(null);
            return;
        }
        String[] costCenterNumbers = costCenter.split(";");
        HashSet<String> costCenterNumbersSet = new HashSet<String>();
        for (int i = 0; i < costCenterNumbers.length; ++i) {
            costCenterNumbersSet.add(costCenterNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", costCenterNumbersSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        CostCenterOrgUnitCollection costCenterOrgUnitCol = null;
        try {
            costCenterOrgUnitCol = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterOrgUnitCol != null && costCenterOrgUnitCol.size() > 0) {
                int size = costCenterOrgUnitCol.size();
                CostCenterOrgUnitInfo[] costCenters = new CostCenterOrgUnitInfo[size];
                for (int i = 0; i < size; ++i) {
                    costCenters[i] = costCenterOrgUnitCol.get(i);
                }
                this.prmtCostCenter.setData((Object)costCenters);
            }
        }
        catch (BOSException e) {
            this.prmtCostCenter.setData(null);
        }
    }

    private void loadExpense(CustomerParams params) {
        String expense = "";
        if (params.getCustomerParam(_prmtExpense) != null) {
            expense = params.getCustomerParam(_prmtExpense);
        }
        if (StringUtils.isEmpty((String)expense)) {
            this.prmtExpense.setData(null);
            return;
        }
        String[] expenseNumbers = expense.split(";");
        HashSet<String> expenseNumbersSet = new HashSet<String>();
        for (int i = 0; i < expenseNumbers.length; ++i) {
            expenseNumbersSet.add(expenseNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", expenseNumbersSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        ExpenseCollection ExpenseCol = null;
        try {
            ExpenseCol = ExpenseFactory.getRemoteInstance().getExpenseCollection(view);
            if (ExpenseCol != null && ExpenseCol.size() > 0) {
                int size = ExpenseCol.size();
                ExpenseInfo[] expenses = new ExpenseInfo[size];
                for (int i = 0; i < size; ++i) {
                    expenses[i] = ExpenseCol.get(i);
                }
                this.prmtExpense.setData((Object)expenses);
            }
        }
        catch (BOSException e) {
            this.prmtExpense.setData(null);
        }
    }

    private void loadOverhead(CustomerParams params) {
        String overHead = "";
        if (params.getCustomerParam(_prmtOverhead) != null) {
            overHead = params.getCustomerParam(_prmtOverhead);
        }
        if (StringUtils.isEmpty((String)overHead)) {
            this.prmtOverhead.setData(null);
            return;
        }
        String[] overHeadNumbers = overHead.split(";");
        HashSet<String> overheadNumbersSet = new HashSet<String>();
        for (int i = 0; i < overHeadNumbers.length; ++i) {
            overheadNumbersSet.add(overHeadNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", overheadNumbersSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        AUXOverheadCollection overheadCol = null;
        try {
            overheadCol = AUXOverheadFactory.getRemoteInstance().getAUXOverheadCollection(view);
            if (overheadCol != null && overheadCol.size() > 0) {
                int size = overheadCol.size();
                AUXOverheadInfo[] overheads = new AUXOverheadInfo[size];
                for (int i = 0; i < size; ++i) {
                    overheads[i] = overheadCol.get(i);
                }
                this.prmtOverhead.setData((Object)overheads);
            }
        }
        catch (BOSException e) {
            this.prmtOverhead.setData(null);
        }
    }

    private void loadCostObject(CustomerParams params) {
        String costObject = "";
        if (params.getCustomerParam(_prmtCostObject) != null) {
            costObject = params.getCustomerParam(_prmtCostObject);
        }
        if (StringUtils.isEmpty((String)costObject)) {
            this.prmtCostObject.setData(null);
            return;
        }
        String[] coNumbers = costObject.split(";");
        HashSet<String> coNumbersSet = new HashSet<String>();
        for (int i = 0; i < coNumbers.length; ++i) {
            coNumbersSet.add(coNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", coNumbersSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        CostObjectCollection costObjectCol = null;
        try {
            costObjectCol = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
            if (costObjectCol != null && costObjectCol.size() > 0) {
                int size = costObjectCol.size();
                CostObjectInfo[] costObjects = new CostObjectInfo[size];
                for (int i = 0; i < size; ++i) {
                    costObjects[i] = costObjectCol.get(i);
                }
                this.prmtCostObject.setData((Object)costObjects);
            }
        }
        catch (BOSException e) {
            this.prmtCostObject.setData(null);
        }
    }

    private void loadCostItemNum(CustomerParams params) {
        String costItem = "";
        if (params.getCustomerParam(_prmtCostItem) != null) {
            costItem = params.getCustomerParam(_prmtCostItem);
        }
        if (StringUtils.isEmpty((String)costItem)) {
            this.prmtCostItem.setData(null);
            return;
        }
        String[] costItemNumbers = costItem.split(";");
        HashSet<String> costItemNumbersSet = new HashSet<String>();
        for (int i = 0; i < costItemNumbers.length; ++i) {
            costItemNumbersSet.add(costItemNumbers[i].trim());
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", costItemNumbersSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo costItemFilterInfo = CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
            costItemFilterInfo.mergeFilter(filter, "and");
            view.setFilter(costItemFilterInfo);
            CostItemCollection costItemCol = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (costItemCol != null && costItemCol.size() > 0) {
                int size = costItemCol.size();
                CostItemInfo[] costItems = new CostItemInfo[size];
                for (int i = 0; i < size; ++i) {
                    costItems[i] = costItemCol.get(i);
                }
                this.prmtCostItem.setData((Object)costItems);
            }
        }
        catch (Exception e) {
            this.prmtCostItem.setData(null);
        }
    }

    private void loadOrder(CustomerParams params) {
        String order = "";
        if (params.getCustomerParam("prmtOrder") != null) {
            order = params.getCustomerParam("prmtOrder");
        }
        try {
            String companyId = this.getCompanyOrgInfoWithDefault().getId().toString();
            String oql = " select * where  number = '" + order + "'";
            ManufactureOrderCollection orderColl = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(oql);
            if (orderColl != null && orderColl.size() > 0) {
                if (orderColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (!orderColl.get(i).getNumber().equals(order)) continue;
                        this.prmtOrder.setData((Object)orderColl.get(i));
                    }
                } else if (orderColl.size() == 1 && orderColl.get(0).getNumber().equals(order)) {
                    this.prmtOrder.setData((Object)orderColl.get(0));
                }
            }
        }
        catch (BOSException e) {
            this.prmtOrder.setData(null);
        }
    }

    private void loadProject(CustomerParams params) {
        String project = "";
        if (params.getCustomerParam("prmtProjectNumber") != null) {
            project = params.getCustomerParam("prmtProjectNumber");
        }
        try {
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            String oql = " select * where  number = '" + project + "'";
            ProjectCollection projectColl = ProjectFactory.getRemoteInstance().getProjectCollection(oql);
            if (projectColl != null && projectColl.size() > 0) {
                if (projectColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (!projectColl.get(i).getNumber().equals(project)) continue;
                        this.prmtProjectNumber.setData((Object)projectColl.get(i));
                    }
                } else if (projectColl.size() == 1 && projectColl.get(0).getNumber().equals(project)) {
                    this.prmtProjectNumber.setData((Object)projectColl.get(0));
                }
            }
        }
        catch (BOSException e) {
            this.prmtProjectNumber.setData(null);
        }
    }

    private void loadTrack(CustomerParams params) {
        String track = "";
        if (params.getCustomerParam("prmtTrackNumber") != null) {
            track = params.getCustomerParam("prmtTrackNumber");
        }
        try {
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            String oql = " select * where  number = '" + track + "' ";
            TrackNumberCollection trackColl = TrackNumberFactory.getRemoteInstance().getTrackNumberCollection(oql);
            if (trackColl != null && trackColl.size() > 0) {
                if (trackColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (!trackColl.get(i).getNumber().equals(track)) continue;
                        this.prmtTrackNumber.setData((Object)trackColl.get(i));
                    }
                } else if (trackColl.size() == 1 && trackColl.get(0).getNumber().equals(track)) {
                    this.prmtTrackNumber.setData((Object)trackColl.get(0));
                }
            }
        }
        catch (BOSException e) {
            this.prmtTrackNumber.setData(null);
        }
    }

    private void loadBatch(CustomerParams params) {
        String batch = "";
        if (params.getCustomerParam("txtBatchNumber") != null) {
            batch = params.getCustomerParam("txtBatchNumber");
        }
        this.txtBatchNumber.setText(batch);
    }

    private void loadMaterialNum(CustomerParams params) {
        String material = "";
        if (params.getCustomerParam("prmtMaterial") != null) {
            material = params.getCustomerParam("prmtMaterial");
        }
        try {
            String oql = "select mateial.id,mateial.name,mateial.number where (mateial.number ='" + material + "') AND company='" + this.getCompanyOrgInfoWithDefault().getId().toString() + "'";
            MaterialCompanyInfoCollection materialColl = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(oql);
            if (materialColl != null && materialColl.size() > 0) {
                if (materialColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (!materialColl.get(i).getMateial().getNumber().equals(material)) continue;
                        this.prmtMaterial.setData((Object)materialColl.get(i).getMateial());
                    }
                } else if (materialColl.size() == 1 && materialColl.get(0).getMateial().getNumber().equals(material)) {
                    this.prmtMaterial.setData((Object)materialColl.get(0).getMateial());
                }
            }
        }
        catch (BOSException e) {
            this.prmtMaterial.setData(null);
        }
    }

    @Override
    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    @Override
    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    @Override
    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompany;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenter);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObject, true);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtExpense, "com.kingdee.eas.basedata.ncm.app.ExpenseF7Query", "CompanyInfo.id");
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtOverhead, "com.kingdee.eas.basedata.ncm.app.AUXOverheadF7Query", "CompanyInfo.id");
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(5);
        statuses.add(8);
        statuses.add(7);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrder, filter);
        this.prmtOrder.setDisplayFormat("$number$");
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterial, null);
        MaterialF7TreeListSelector selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterial);
        this.prmtMaterial.setSelector((KDPromptSelector)selector);
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostCenter.setValue(null);
                this.prmtCostObject.setValue(null);
                this.prmtOrder.setValue(null);
                this.txtBatchNumber.setText(null);
                this.prmtProjectNumber.setValue(null);
                this.prmtTrackNumber.setValue(null);
                this.prmtMaterial.setValue(null);
                this.prmtExpense.setValue(null);
                this.prmtOverhead.setValue(null);
                this.prmtCostItem.setValue(null);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.yearFromSpinner, (JSpinner)this.monthFromSpinner, (PeriodInfo)this.currentPeriod, (JSpinner)this.yearToSpinner, (JSpinner)this.monthToSpinner, (PeriodInfo)this.currentPeriod);
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "AUXOverheadSumReportView";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "AUXOverheadSumReportPrint";
    }

    static class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;
        private static final Logger logger = CoreUIObject.getLogger(SingleBizPromptFilterElement.class);

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }

    class F7SingleFilterElement
    extends SingleFilterElement {
        public F7SingleFilterElement(String id, Component component) {
            super(id, component);
        }

        protected void setNumber(Object obj, String value) {
            ((KDBizPromptBox)obj).setData((Object)value);
        }
    }
}

