/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.AUXOverheadCollection;
import com.kingdee.eas.basedata.ncm.AUXOverheadFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.client.AbstractAuxAllocDiffReportFilterUI;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class AuxAllocDiffReportFilterUI
extends AbstractAuxAllocDiffReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AuxAllocDiffReportFilterUI.class);
    private static final int PERIOD_MAX_MONTH = 12;
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private CustomerParams cp = null;
    private PeriodInfo startPeriod = null;
    private PeriodInfo currentPeriod = null;

    public AuxAllocDiffReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
        if (!NCMUtils.isPlannedAuxAlloc(null, (String)this.company.getId().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.ReportResource", (String)"IsNotPlanAUXalloc"));
            SysUtil.abort();
        }
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(1001, this.company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.startPeriod = sysctrol.getStartPeriod(1001, this.company.getId().toString());
        BDCMClientUtils.filterAssistantCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)this.company.getId().toString());
        BDCMClientUtils.filterAssistantCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)this.company.getId().toString());
        BDCMClientUtils.filterDataBaseDF7((String)"8CB367E7", (KDBizPromptBox)this.prmtAUXOverheadFrom);
        BDCMClientUtils.filterDataBaseDF7((String)"8CB367E7", (KDBizPromptBox)this.prmtAUXOverheadTo);
        BDCMClientUtils.filterDataBaseDF7((String)"548C5A91", (KDBizPromptBox)this.prmtCostItemFrom);
        BDCMClientUtils.filterDataBaseDF7((String)"548C5A91", (KDBizPromptBox)this.prmtCostItemTo);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleSpinnerFilterElement element = new SingleSpinnerFilterElement("period", (Component)this.spPeriod);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costCenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costCenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("auxOverheadFrom", (Component)this.prmtAUXOverheadFrom));
        elements.add((FilterElement)new SingleFilterElement("auxOverheadTo", (Component)this.prmtAUXOverheadTo));
        elements.add((FilterElement)new SingleFilterElement("expenseFrom", (Component)this.prmtExpenseFrom));
        elements.add((FilterElement)new SingleFilterElement("expenseTo", (Component)this.prmtExpenseTo));
        elements.add((FilterElement)new SingleFilterElement("costItemFrom", (Component)this.prmtCostItemFrom));
        elements.add((FilterElement)new SingleFilterElement("costItemTo", (Component)this.prmtCostItemTo));
        elements.add((FilterElement)new CheckBoxFilterElement("isSumByCC", this.cbSumByCC));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtExpenseFrom.setEditFormat("$number$");
        this.prmtExpenseFrom.setCommitFormat("$number$");
        this.prmtExpenseFrom.setDisplayFormat("$name$");
        this.prmtExpenseFrom.setQueryInfo("com.kingdee.eas.basedata.ncm.app.ExpenseF7Query");
        EntityViewInfo view = this.prmtExpenseFrom.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
            this.prmtExpenseFrom.setEntityViewInfo(view);
        }
        HashSet<Integer> extypes = new HashSet<Integer>();
        extypes.add(1);
        extypes.add(2);
        extypes.add(30);
        extypes.add(40);
        extypes.add(50);
        extypes.add(60);
        BDCMClientUtils.filterExpenseF7((EntityViewInfo)view, (String)this.company.getId().toString(), extypes);
        this.prmtExpenseTo.setEditFormat("$number$");
        this.prmtExpenseTo.setCommitFormat("$number$");
        this.prmtExpenseTo.setDisplayFormat("$name$");
        this.prmtExpenseTo.setQueryInfo("com.kingdee.eas.basedata.ncm.app.ExpenseF7Query");
        EntityViewInfo viewto = this.prmtExpenseTo.getEntityViewInfo();
        if (viewto == null) {
            viewto = new EntityViewInfo();
            this.prmtExpenseTo.setEntityViewInfo(viewto);
        }
        BDCMClientUtils.filterExpenseF7((EntityViewInfo)viewto, (String)this.company.getId().toString(), extypes);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void initComp() throws Exception {
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void setDefaultValue() {
        super.setDefaultValue();
        this.prmtCompanyOrg.setValue((Object)this.company);
        this.initPeriod((JSpinner)this.spPeriod, this.startPeriod.getNumber(), this.currentPeriod.getNumber());
        this.prmtCostCenterFrom.setData(null);
        this.prmtCostCenterTo.setData(null);
        this.prmtAUXOverheadFrom.setData(null);
        this.prmtAUXOverheadTo.setData(null);
        this.prmtExpenseFrom.setData(null);
        this.prmtExpenseTo.setData(null);
        this.cbSumByCC.setSelected(true);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.prmtCompanyOrg.setValue((Object)this.company);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
            this.loadCostCenter(params);
            this.loadOverhead(params);
            this.loadExpense(params);
            this.loadCostItem(params);
        }
    }

    private void loadPeriod(CustomerParams params) {
        int initPeriod = 0;
        String sInitPeriod = params.getCustomerParam("spPeriod");
        try {
            initPeriod = Integer.parseInt(sInitPeriod);
            if (initPeriod < this.startPeriod.getNumber()) {
                initPeriod = this.startPeriod.getNumber();
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.initPeriod((JSpinner)this.spPeriod, this.startPeriod.getNumber(), initPeriod);
    }

    private void initPeriod(JSpinner spPeriod, final int minPeriod, int initPeriod) {
        boolean argumentError = false;
        if (minPeriod <= 0) {
            argumentError = true;
        }
        String sMinPeriod = String.valueOf(minPeriod);
        if (!argumentError && sMinPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [minPeriod:" + minPeriod + "] error.");
        }
        argumentError = false;
        if (initPeriod <= 0 || initPeriod < minPeriod) {
            argumentError = true;
        }
        String sInitPeriod = String.valueOf(initPeriod);
        if (!argumentError && sInitPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initPeriod:" + initPeriod + "] error.");
        }
        final int minYear = Integer.parseInt(sMinPeriod.substring(0, 4));
        final int minMonth = Integer.parseInt(sMinPeriod.substring(4));
        SpinnerNumberModel model = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                return Integer.valueOf(minPeriod);
            }

            public Comparable getMaximum() {
                return Integer.valueOf(999912);
            }

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                super.setValue(value);
            }
        };
        spPeriod.setModel(model);
        spPeriod.setValue(initPeriod);
    }

    private void loadCostCenter(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam("prmtCostCenterFrom") != null) {
            costCenterFrom = params.getCustomerParam("prmtCostCenterFrom");
        }
        if (params.getCustomerParam("prmtCostCenterTo") != null) {
            costCenterTo = params.getCustomerParam("prmtCostCenterTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costCenterColl.get(i).getNumber().equals(costCenterFrom)) {
                            this.prmtCostCenterFrom.setData((Object)costCenterColl.get(i));
                            continue;
                        }
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(i));
                    }
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFrom)) {
                        this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterTo)) {
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostCenterFrom.setData(null);
            this.prmtCostCenterTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadOverhead(CustomerParams params) {
        String auxOverheadFrom = "";
        String auxOverheadTo = "";
        if (params.getCustomerParam("prmtAUXOverheadFrom") != null) {
            auxOverheadFrom = params.getCustomerParam("prmtAUXOverheadFrom");
        }
        if (params.getCustomerParam("prmtAUXOverheadTo") != null) {
            auxOverheadTo = params.getCustomerParam("prmtAUXOverheadTo");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)auxOverheadFrom));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)auxOverheadTo));
        filter.setMaskString("#0 or #1");
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        try {
            AUXOverheadCollection coll = AUXOverheadFactory.getRemoteInstance().getAUXOverheadCollection(view);
            if (coll != null && coll.size() > 0) {
                if (coll.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (coll.get(i).getNumber().equals(auxOverheadFrom)) {
                            this.prmtAUXOverheadFrom.setData((Object)coll.get(i));
                            continue;
                        }
                        this.prmtAUXOverheadTo.setData((Object)coll.get(i));
                    }
                } else if (coll.size() == 1) {
                    if (coll.get(0).getNumber().equals(auxOverheadFrom)) {
                        this.prmtAUXOverheadFrom.setData((Object)coll.get(0));
                    }
                    if (coll.get(0).getNumber().equals(auxOverheadTo)) {
                        this.prmtAUXOverheadTo.setData((Object)coll.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtAUXOverheadFrom.setData(null);
            this.prmtAUXOverheadTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadExpense(CustomerParams params) {
        String expenseFrom = "";
        String expenseTo = "";
        if (params.getCustomerParam("prmtExpenseFrom") != null) {
            expenseFrom = params.getCustomerParam("prmtExpenseFrom");
        }
        if (params.getCustomerParam("prmtExpenseTo") != null) {
            expenseTo = params.getCustomerParam("prmtExpenseTo");
        }
        try {
            ExpenseCollection expenseColl = ExpenseFactory.getRemoteInstance().getExpenseCollection("select id, number, name where number = '" + expenseFrom + "' or number = '" + expenseTo + "'");
            if (expenseColl != null && expenseColl.size() > 0) {
                if (expenseColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (expenseColl.get(i).getNumber().equals(expenseFrom)) {
                            this.prmtExpenseFrom.setData((Object)expenseColl.get(i));
                            continue;
                        }
                        this.prmtExpenseTo.setData((Object)expenseColl.get(i));
                    }
                } else if (expenseColl.size() == 1) {
                    if (expenseColl.get(0).getNumber().equals(expenseFrom)) {
                        this.prmtExpenseFrom.setData((Object)expenseColl.get(0));
                    }
                    if (expenseColl.get(0).getNumber().equals(expenseTo)) {
                        this.prmtExpenseTo.setData((Object)expenseColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtExpenseFrom.setData(null);
            this.prmtExpenseTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostItem(CustomerParams params) {
        String costItemFrom = "";
        String costItemTo = "";
        if (params.getCustomerParam("prmtCostItemFrom") != null) {
            costItemFrom = params.getCustomerParam("prmtCostItemFrom");
        }
        if (params.getCustomerParam("prmtCostItemTo") != null) {
            costItemTo = params.getCustomerParam("prmtCostItemTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemTo));
            filter.setMaskString("#0 or #1");
            FilterInfo costItemFilterInfo = this.getCostItemFilter();
            costItemFilterInfo.mergeFilter(filter, "and");
            view.setFilter(costItemFilterInfo);
            CostItemCollection costItemColl = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (costItemColl != null && costItemColl.size() > 0) {
                if (costItemColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costItemColl.get(i).getNumber().equals(costItemFrom)) {
                            this.prmtCostItemFrom.setData((Object)costItemColl.get(i));
                            continue;
                        }
                        this.prmtCostItemTo.setData((Object)costItemColl.get(i));
                    }
                } else if (costItemColl.size() == 1) {
                    if (costItemColl.get(0).getNumber().equals(costItemFrom)) {
                        this.prmtCostItemFrom.setData((Object)costItemColl.get(0));
                    }
                    if (costItemColl.get(0).getNumber().equals(costItemTo)) {
                        this.prmtCostItemTo.setData((Object)costItemColl.get(0));
                    }
                }
            }
        }
        catch (Exception e) {
            this.prmtCostItemFrom.setData(null);
            this.prmtCostItemTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    class CheckBoxFilterElement
    extends SingleFilterElement {
        KDCheckBox kdCb;

        public CheckBoxFilterElement(String id, KDCheckBox component) {
            super(id, (Component)component);
            this.kdCb = component;
        }

        public void addRptParams(RptParams cp) {
            cp.setObject(this.getId(), (Object)new Boolean(this.kdCb.isSelected()));
        }
    }

    class SingleSpinnerFilterElement
    extends SingleFilterElement {
        private KDSpinner spinner;

        public SingleSpinnerFilterElement(String id, Component component) {
            super(id, component);
            this.spinner = (KDSpinner)component;
        }

        protected void setNumber(Object obj, String value) {
            this.spinner.setValue((Object)Integer.valueOf(value));
        }

        protected String getName(Object obj) {
            return ((Component)obj).getName();
        }

        protected void setData(Component obj, Object value) {
            this.spinner.setValue(value);
        }
    }
}

