/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.report.ReportListener;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.ncm.cal.AuxAllocDiffVoucheredFactory;
import com.kingdee.eas.ncm.cal.VoucherDAPTransImpl;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class AuxAllocDiffVoucherReportListener
extends ReportListener {
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.cal.report.AuxAllocDiffVoucherReportResource";
    private static final Logger logger = Logger.getLogger(AuxAllocDiffVoucherReportListener.class);
    private String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();

    public AuxAllocDiffVoucherReportListener() {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        try {
            NCMClientUtils.checkIsStart();
        }
        catch (Exception e) {
            MsgBox.showError((String)e.getMessage());
            SysUtil.abort();
        }
    }

    public void onInitialize() throws Exception {
        this.reportApplication.addBarItem("viewVoucher", this.getResource("viewVoucher"), this.getResource("viewVoucher"), this.getResource("viewVoucher"), null, (Object)EASResource.getIcon((String)"imgTbtn_downview"), "", true, true, false);
        this.reportApplication.addBarItem("genVoucher", this.getResource("genVoucher"), this.getResource("genVoucher"), this.getResource("genVoucher"), null, (Object)EASResource.getIcon((String)"imgTbtn_flowexample"), "", true, true, false);
        this.reportApplication.addBarItem("delVoucher", this.getResource("delVoucher"), this.getResource("delVoucher"), this.getResource("delVoucher"), null, (Object)EASResource.getIcon((String)"imgTbtn_deletecredence"), "", true, true, true);
    }

    public void onMenuClick(String name) throws Exception {
        IRowSet data = null;
        try {
            data = this.getReportApplication().getData();
        }
        catch (Throwable exc) {
            logger.error((Object)"", exc);
        }
        if (data == null || !data.first()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"194_CostCalPreDtlVoucherReportListener"));
            SysUtil.abort();
        }
        if (name.equalsIgnoreCase("viewVoucher")) {
            this.checkVoucherPermission("AuxAllocDiffVoucherReportTrace");
            this.actionView_actionPerformed();
        } else if (name.equalsIgnoreCase("genVoucher")) {
            this.checkVoucherPermission("AuxAllocDiffVoucherReportGenerate");
            this.actionGenVoucher_actionPerformed();
            this.getReportApplication().Refresh();
        } else if (name.equalsIgnoreCase("delVoucher")) {
            this.checkVoucherPermission("AuxAllocDiffVoucherReportDelete");
            this.actionDelVoucher_actionPerformed();
            this.getReportApplication().Refresh();
        }
    }

    private boolean checkVoucherPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    public void actionGenVoucher_actionPerformed() throws Exception {
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getRemoteInstance();
        PeriodInfo cmCurPeriod = ctrol.getCacheCurrentPeriod(1001, this.companyId);
        PeriodInfo glCurPeriod = ctrol.getCacheCurrentPeriod(6, this.companyId);
        if (glCurPeriod == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{SystemEnum.GENERALLEDGER.getAlias() + EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"176_AuxFeeCostCalReportListener")});
        }
        if (!NCMUtils.isEquals((PeriodInfo)glCurPeriod, (PeriodInfo)cmCurPeriod)) {
            throw new CMBillException(CMBillException.NOTEQUALS_VOUCHER);
        }
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        BOTMappingInfo botMappingInfo = VoucherDAPTransImpl.getBotpInfo(cu, null, "978626EF", SysContext.getSysContext().getCurrentFIUnit());
        if (botMappingInfo != null) {
            List voucherIdList = null;
            voucherIdList = AuxAllocDiffVoucheredFactory.getRemoteInstance().addVoucherByAUXOverhead(this.companyId, botMappingInfo);
            if (voucherIdList != null && voucherIdList.size() > 0) {
                this.showWindow(botMappingInfo, voucherIdList);
            }
        }
    }

    private void showWindow(BOTMappingInfo botMappingInfo, List voucherIdList) throws Exception {
        if (botMappingInfo == null || voucherIdList == null) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        IUIWindow uiWindow = null;
        if (botMappingInfo.getIsShowEditUI() == 1) {
            RealModeIDList idList = RealModeIDList.getEmptyIDList();
            int size = voucherIdList.toArray().length;
            for (int i = 0; i < size; ++i) {
                idList.add(voucherIdList.toArray()[i].toString());
                param.put("ID", idList.getCurrentID());
                param.put("IDList", (String)idList);
            }
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.VoucherEditUI", param, null, OprtState.EDIT);
            }
            catch (UIException e) {
                throw new BOSException((Throwable)e);
            }
        } else if (botMappingInfo.getIsShowEditUI() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource.transSuccess"));
            return;
        }
        if (uiWindow != null) {
            uiWindow.show();
        }
        if (uiWindow instanceof JFrame) {
            ((JFrame)uiWindow).setExtendedState(6);
        }
    }

    public void actionView_actionPerformed() throws Exception {
        if (UIRuleUtil.getIntValue(this.reportApplication.getCurrentRow().get("FFIVOUCHERED")) == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"195_CostCalPreDtlVoucherReportListener"));
            SysUtil.abort();
        } else if (this.reportApplication.getCurrentRow().get("FVOUCHERNUMBER") != null && this.reportApplication.getCurrentRow().get("FVOUCHERNUMBER").toString().length() != 0) {
            this.reportApplication.showEditUI("FVOUCHERID", "com.kingdee.eas.fi.gl.client.VoucherEditUI");
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"196_CostCalPreDtlVoucherReportListener"));
            SysUtil.abort();
        }
    }

    public void actionDelVoucher_actionPerformed() throws Exception {
        boolean isSCMVouchered = false;
        ArrayList rows = this.reportApplication.getSelectRows();
        int idCount = rows.size();
        String[] ids = new String[idCount];
        Vector<ObjectUuidPK> vec = new Vector<ObjectUuidPK>(idCount);
        Map row = null;
        String voucherID = null;
        ObjectUuidPK voucherPk = null;
        for (int i = 0; i < idCount; ++i) {
            row = (Map)rows.get(i);
            if (UIRuleUtil.getIntValue(row.get("FFIVOUCHERED")) == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"197_CostCalPreDtlVoucherReportListener"));
                SysUtil.abort();
            }
            if (UIRuleUtil.isNotNull((String)(voucherID = (String)row.get("FVOUCHERID")))) {
                voucherPk = new ObjectUuidPK(voucherID);
                if (vec.contains(voucherPk)) continue;
                vec.add(voucherPk);
                ids[i] = voucherID.toString();
                continue;
            }
            isSCMVouchered = true;
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            if (vec.size() > 0) {
                IObjectPK[] pks = new IObjectPK[vec.size()];
                AuxAllocDiffVoucheredFactory.getRemoteInstance().delete(vec.toArray(pks));
            }
            if (isSCMVouchered) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"198_CostCalPreDtlVoucherReportListener"));
                SysUtil.abort();
            }
        }
    }

    protected String getResource(String resName) {
        return EASResource.getString((String)RES_CLASSNAME, (String)resName);
    }
}

