/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.report.CellEvent;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.client.CostComputeSumPlugin;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalCuOutLogPlugin
extends CostComputeSumPlugin {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.client.CalCuOutLogPlugin");

    public void onInitialize() throws Exception {
        String rptTitle = CalculateClientUtil.getCalResource((String)"COSTCALDETAILRPT");
        this.reportApplication.addBarItem("openDetailCostRpt", rptTitle, rptTitle, rptTitle, null, (Object)EASResource.getIcon((String)"imgTbtn_bill"), null, true, true, false);
    }

    public void onMenuClick(String name) throws Exception {
        if (name.equals("openDetailCostRpt")) {
            this.openCostComputeDetailRpt();
        }
    }

    public void fireTableDbClick(CellEvent event) throws Exception {
        if (event.getCellValue() != null) {
            this.openCostComputeDetailRpt();
        }
    }

    private void openCostComputeDetailRpt() throws Exception {
        this.checkSelected();
        this.checkViewPermission();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        try {
            uiContext.put((Object)"rptFilterInfo", (Object)this.getDetailRptFilterEntity());
            uiContext.put((Object)"rptParams", (Object)this.getReportApplication().getFilter());
        }
        catch (SQLException e) {
            throw new UIException((Throwable)e);
        }
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.scm.cal.client.CostComputeReportUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void checkViewPermission() throws Exception {
        Object companyOrg;
        RptParams params = this.reportApplication.getFilter();
        if (params != null && params.getObject("company") != null && (companyOrg = params.getObject("company")) != null) {
            ObjectUuidPK orgPk = new ObjectUuidPK(((CompanyOrgUnitInfo)companyOrg).getId());
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPk, (String)"costComputeReport");
        }
    }

    private EntityViewInfo getDetailRptFilterEntity() throws SQLException {
        HashMap selectMap;
        ArrayList selList;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        RptParams rptParams = this.getReportApplication().getFilter();
        FilterItemInfo fItemnfo = null;
        if (rptParams != null && (selList = this.reportApplication.getSelectRows()) != null && selList.size() > 0 && (selectMap = (HashMap)selList.get(0)) != null) {
            if (selectMap.get("FSTORAGENUMBER") != null) {
                fItemnfo = new FilterItemInfo("STORAGEORG.NUMBER", selectMap.get("FSTORAGENUMBER"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
            }
            if (selectMap.get("FWAREHOUSENUMBER") != null) {
                fItemnfo = new FilterItemInfo("WAREHOUSE.NUMBER", selectMap.get("FWAREHOUSENUMBER"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
            }
            if (selectMap.get("FMATERIALNUMBER") != null) {
                fItemnfo = new FilterItemInfo("MATERIAL.NUMBER", selectMap.get("FMATERIALNUMBER"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
                rptParams.setString("MATERIAL.NUMBER", (String)selectMap.get("FMATERIALNUMBER"));
            }
            if (selectMap.get("FYEAR") != null) {
                fItemnfo = new FilterItemInfo("YEAR", selectMap.get("FYEAR"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
                rptParams.setObject("YEAR", selectMap.get("FYEAR"));
            }
            if (selectMap.get("FPERIOD") != null) {
                fItemnfo = new FilterItemInfo("PERIOD", selectMap.get("FPERIOD"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
                rptParams.setObject("PERIOD", selectMap.get("FPERIOD"));
            }
            if (selectMap.get("FCOMPANYORGUNITID") != null) {
                fItemnfo = new FilterItemInfo("FINANCEORG.ID", selectMap.get("FCOMPANYORGUNITID"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
                rptParams.setString("FINANCEORG.ID", (String)selectMap.get("FCOMPANYORGUNITID"));
            }
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void checkSelected() throws UIException {
        try {
            if (this.reportApplication.getSelectRows() == null || this.reportApplication.getSelectRows().size() == 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
        }
        catch (SQLException e) {
            throw new UIException((Throwable)e);
        }
    }

    protected String getSelectedKeyValue() {
        String keyValue = null;
        try {
            HashMap selectMap;
            ArrayList selList = this.reportApplication.getSelectRows();
            if (selList != null && selList.size() > 0 && (selectMap = (HashMap)selList.get(0)) != null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(selectMap.get("FMATERIALNUMBER"));
                if (selectMap.get("FWAREHOUSENUMBER") != null) {
                    buffer.append(selectMap.get("FWAREHOUSENUMBER"));
                }
                if (selectMap.get("FSTORAGENUMBER") != null) {
                    buffer.append(selectMap.get("FSTORAGENUMBER"));
                }
                keyValue = buffer.toString();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return keyValue;
    }

    public void fireBeforePrint(boolean isPreview) throws Exception {
        RptParams rptParams = this.getReportApplication().getFilter();
        String companyNumber = rptParams.getString("companyNumber");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber, CompareType.EQUALS));
        view.setFilter(filter);
        CoreBaseCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCollection(view);
        if (coll != null && coll.size() > 0) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)coll.get(0);
            CalculateClientUtil.checkHasAuthorized((String)company.getId().toString(), (String)company.getDisplayName(), (OrgType)OrgType.Company, (String)"invOutSumRpt_Print");
        }
    }
}

