/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.ncm.cal.report.client.AbstractFinishedProductCostDetailReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.CheckBoxFilterElement;
import com.kingdee.eas.ncm.cal.report.client.NCMReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class FinishedProductCostDetailReportFilterUI
extends AbstractFinishedProductCostDetailReportFilterUI {
    private static final long serialVersionUID = -868760541117198062L;
    private static final Logger logger = CoreUIObject.getLogger(FinishedProductCostDetailReportFilterUI.class);
    private int selectedTotalCheckBoxNum = 3;
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public FinishedProductCostDetailReportFilterUI() throws Exception {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(1001, companyOrg.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.startPeriod = sysctrol.getStartPeriod(1001, companyOrg.getId().toString());
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)companyOrg, (PeriodInfo)this.currentPeriod);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.rbBaseUnit);
        group.add((AbstractButton)this.rbStatUnit);
        this.initComp();
        this.kDLabelContainer15.setVisible(false);
        this.spCostObjectNum.setVisible(false);
        this.chkIsTotalExpense.setSelected(false);
        this.chkIsTotalExpense.setVisible(false);
        this.spExpenseLevel.setVisible(false);
        this.kDLabelContainer14.setVisible(false);
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        NCMReportFilterUI.SingleComPromptFilterElement filterElement = new NCMReportFilterUI.SingleComPromptFilterElement(this, "companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SingleFilterElement element = new SpinnerFilterElement("spYearFrom", (Component)this.spYearFrom);
        element.setDefaultValue((Object)this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("spYearTo", (Component)this.spYearTo);
        element.setDefaultValue((Object)this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("spPeriodFrom", (Component)this.spPeriodFrom);
        element.setDefaultValue((Object)this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("spPeriodTo", (Component)this.spPeriodTo);
        element.setDefaultValue((Object)this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        element = new RadioButtonFilterElement(this.rbBaseUnit.getName(), this.rbBaseUnit);
        elements.add((FilterElement)element);
        element = new RadioButtonFilterElement(this.rbStatUnit.getName(), this.rbStatUnit);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("spCostObjectNum", (Component)this.spCostObjectNum);
        element.setDefaultValue((Object)1);
        elements.add((FilterElement)element);
        element = new CheckBoxFilterElement("chkIsTotalCostItem", this.chkIsTotalCostItem);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("spCostItemLevel", (Component)this.spCostItemLevel);
        element.setDefaultValue((Object)1);
        elements.add((FilterElement)element);
        element = new CheckBoxFilterElement("chkIsTotalMaterial", this.chkIsTotalMaterial);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("spMaterialLevel", (Component)this.spMaterialLevel);
        element.setDefaultValue((Object)1);
        elements.add((FilterElement)element);
        element = new CheckBoxFilterElement("chkIsTotalExpense", this.chkIsTotalExpense);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("spExpenseLevel", (Component)this.spExpenseLevel);
        element.setDefaultValue((Object)1);
        elements.add((FilterElement)element);
        element = new CheckBoxFilterElement("chkIsDisplayTotalRowsOnly", this.chkIsDisplayTotalRowsOnly);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costCenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costCenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("costObjectFrom", (Component)this.prmtCostObjectFrom));
        elements.add((FilterElement)new SingleFilterElement("costObjectTo", (Component)this.prmtCostObjectTo));
        elements.add((FilterElement)new SingleFilterElement("costItemFrom", (Component)this.prmtCostItemFrom));
        elements.add((FilterElement)new SingleFilterElement("costItemTo", (Component)this.prmtCostItemTo));
        elements.add((FilterElement)new SingleFilterElement("orderNumberFrom", (Component)this.prmtOrderNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("orderNumberTo", (Component)this.prmtOrderNumberTo));
        elements.add((FilterElement)new SingleFilterElement("batchNumberFrom", (Component)this.txtBatchFrom));
        elements.add((FilterElement)new SingleFilterElement("batchNumberTo", (Component)this.txtBatchTo));
        elements.add((FilterElement)new SingleFilterElement("projectNumberFrom", (Component)this.prmtProjectFrom));
        elements.add((FilterElement)new SingleFilterElement("projectNumberTo", (Component)this.prmtProjectTo));
        elements.add((FilterElement)new SingleFilterElement("trackNumberFrom", (Component)this.prmtTrackFrom));
        elements.add((FilterElement)new SingleFilterElement("trackNumberTo", (Component)this.prmtTrackTo));
        elements.add((FilterElement)new SingleFilterElement("productFrom", (Component)this.prmtProductFrom));
        elements.add((FilterElement)new SingleFilterElement("productTo", (Component)this.prmtProductTo));
        return elements;
    }

    public void initComp() throws Exception {
        this.prmtCostObjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE);
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        this.prmtCostObjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE);
        this.prmtCostObjectTo.setSelector((KDPromptSelector)arg1);
        this.filterProject(this.prmtProjectFrom);
        this.filterProject(this.prmtProjectTo);
        this.filterTrack(this.prmtTrackFrom);
        this.filterTrack(this.prmtTrackTo);
        this.chkIsTotalCostItem.setSelected(false);
        this.chkIsTotalMaterial.setSelected(false);
        this.chkIsTotalExpense.setSelected(false);
        this.spCostItemLevel.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 100, 1));
        this.spMaterialLevel.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 100, 1));
        this.spExpenseLevel.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 100, 1));
        this.spCostItemLevel.setEnabled(false);
        this.spMaterialLevel.setEnabled(false);
        this.spExpenseLevel.setEnabled(false);
        this.spCostObjectNum.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 1000, 1));
    }

    protected void filterProject(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = ProjectFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    protected void filterTrack(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.chkIsDisplayTotalRowsOnly.setBounds(new Rectangle(12, 243, 130, 19));
        this.repaint();
    }

    @Override
    protected void chkIsTotalCostItem_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIsTotalCostItem.isSelected()) {
            this.spCostItemLevel.setEnabled(true);
            ++this.selectedTotalCheckBoxNum;
        } else {
            this.spCostItemLevel.setEnabled(false);
            this.spCostItemLevel.setValue((Object)Integer.valueOf("1"));
            --this.selectedTotalCheckBoxNum;
        }
        this.chkIsDisplayTotalRowsOnly.setEnabled(this.selectedTotalCheckBoxNum > 0);
    }

    @Override
    protected void chkIsTotalMaterial_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIsTotalMaterial.isSelected()) {
            this.spMaterialLevel.setEnabled(true);
            ++this.selectedTotalCheckBoxNum;
        } else {
            this.spMaterialLevel.setEnabled(false);
            this.spMaterialLevel.setValue((Object)Integer.valueOf("1"));
            --this.selectedTotalCheckBoxNum;
        }
        this.chkIsDisplayTotalRowsOnly.setEnabled(this.selectedTotalCheckBoxNum > 0);
    }

    @Override
    protected void chkIsTotalExpense_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIsTotalExpense.isSelected()) {
            this.spExpenseLevel.setEnabled(true);
            ++this.selectedTotalCheckBoxNum;
        } else {
            this.spExpenseLevel.setEnabled(false);
            this.spExpenseLevel.setValue((Object)Integer.valueOf("1"));
            --this.selectedTotalCheckBoxNum;
        }
        this.chkIsDisplayTotalRowsOnly.setEnabled(this.selectedTotalCheckBoxNum > 0);
    }

    @Override
    protected void chkIsDisplayTotalRowsOnly_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsDisplayTotalRowsOnly_itemStateChanged(e);
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.currentPeriod;
        PeriodInfo initPeriodTo = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("spYearFrom");
        String initMonthFrom = params.getCustomerParam("spPeriodFrom");
        String initYearTo = params.getCustomerParam("spYearTo");
        String initMonthTo = params.getCustomerParam("spPeriodTo");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)initPeriodTo);
    }

    @Override
    public void setDefaultValue() {
        super.setDefaultValue();
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
        this.rbBaseUnit.setSelected(true);
        this.rbStatUnit.setSelected(false);
        this.spCostObjectNum.setValue((Object)1);
    }

    private void initUnit() {
        CompositeFilterElement elements = null;
        Object element = this.getFilterManager().getElement();
        if (element instanceof CompositeFilterElement) {
            elements = (CompositeFilterElement)element;
            element = new RadioButtonFilterElement(this.rbBaseUnit.getName(), this.rbBaseUnit);
            elements.add(element);
            element = new RadioButtonFilterElement(this.rbStatUnit.getName(), this.rbStatUnit);
            elements.add(element);
        }
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo1) {
        super.loadData(entityViewInfo1);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
            this.loadCostObjectNum(params);
            this.chkIsTotalCostItem.setSelected(Boolean.valueOf(this.cp.getCustomerParam("chkIsTotalCostItem")).booleanValue());
            this.chkIsTotalMaterial.setSelected(Boolean.valueOf(this.cp.getCustomerParam("chkIsTotalMaterial")).booleanValue());
            this.chkIsTotalExpense.setSelected(Boolean.valueOf(this.cp.getCustomerParam("chkIsTotalExpense")).booleanValue());
            this.spCostItemLevel.setValue((Object)Integer.valueOf(this.cp.getCustomerParam("spCostItemLevel")));
            this.spMaterialLevel.setValue((Object)Integer.valueOf(this.cp.getCustomerParam("spMaterialLevel")));
            this.spExpenseLevel.setValue((Object)Integer.valueOf(this.cp.getCustomerParam("spExpenseLevel")));
            this.chkIsDisplayTotalRowsOnly.setSelected(Boolean.valueOf(this.cp.getCustomerParam("chkIsDisplayTotalRowsOnly")).booleanValue());
        }
        boolean isBaseUnitSelected = true;
        boolean isStatUnitSelected = false;
        if (this.cp != null) {
            String str = this.cp.getCustomerParam("rbBaseUnit");
            if (str != null && str.equalsIgnoreCase("true")) {
                isBaseUnitSelected = true;
            }
            if ((str = this.cp.getCustomerParam("rbStatUnit")) != null && str.equalsIgnoreCase("true")) {
                isStatUnitSelected = true;
            }
        }
        if (!isBaseUnitSelected && !isStatUnitSelected) {
            isBaseUnitSelected = true;
        }
        this.rbBaseUnit.setSelected(isBaseUnitSelected);
        this.rbStatUnit.setSelected(isStatUnitSelected);
    }

    private void loadCostObjectNum(CustomerParams params) {
        String costObjectNum = params.getCustomerParam("spCostObjectNum");
        this.getDisplayCountSpinner().setValue((Object)Integer.valueOf(costObjectNum));
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterTo);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectFrom, true);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectTo, true);
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(5);
        statuses.add(8);
        statuses.add(7);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberFrom, filter);
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberTo, filter);
        this.prmtOrderNumberFrom.setDisplayFormat("$number$");
        this.prmtOrderNumberTo.setDisplayFormat("$number$");
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductFrom, null);
        MaterialF7TreeListSelector selector1 = new MaterialF7TreeListSelector((Object)this, this.prmtProductFrom);
        this.prmtProductFrom.setSelector((KDPromptSelector)selector1);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductTo, null);
        selector1 = new MaterialF7TreeListSelector((Object)this, this.prmtProductTo);
        this.prmtProductTo.setSelector((KDPromptSelector)selector1);
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostCenterFrom.setValue(null);
                this.prmtCostCenterTo.setValue(null);
                this.prmtCostObjectFrom.setValue(null);
                this.prmtCostObjectTo.setValue(null);
                this.prmtOrderNumberFrom.setValue(null);
                this.prmtOrderNumberTo.setValue(null);
                this.prmtProductFrom.setValue(null);
                this.prmtProductTo.setValue(null);
                this.txtBatchFrom.setText(null);
                this.txtBatchTo.setText(null);
                this.prmtProjectFrom.setValue(null);
                this.prmtProjectTo.setValue(null);
                this.prmtTrackFrom.setValue(null);
                this.prmtTrackTo.setValue(null);
                this.prmtCostItemFrom.setValue(null);
                this.prmtCostItemTo.setValue(null);
                this.rbBaseUnit.setSelected(true);
                this.rbStatUnit.setSelected(false);
                this.chkIsTotalCostItem.setSelected(false);
                this.chkIsTotalMaterial.setSelected(false);
                this.chkIsTotalExpense.setSelected(false);
                this.spCostItemLevel.setValue((Object)1);
                this.spMaterialLevel.setValue((Object)1);
                this.spExpenseLevel.setValue((Object)1);
                this.spCostObjectNum.setValue((Object)1);
                this.chkIsDisplayTotalRowsOnly.setSelected(false);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "FinishedProductCostDetailReportView";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "FinishedProductCostDetailReportPrint";
    }

    @Override
    protected KDSpinner[] getPeriodSpinner() {
        return new KDSpinner[]{this.spYearFrom, this.spYearTo, this.spPeriodFrom, this.spPeriodTo};
    }

    @Override
    protected KDBizPromptBox[] getCostCenterF7() {
        return new KDBizPromptBox[]{this.prmtCostCenterFrom, this.prmtCostCenterTo};
    }

    @Override
    protected KDBizPromptBox[] getCostObjectF7() {
        return new KDBizPromptBox[]{this.prmtCostObjectFrom, this.prmtCostObjectTo};
    }

    @Override
    protected KDBizPromptBox[] getOrderNumberF7() {
        return new KDBizPromptBox[]{this.prmtOrderNumberFrom, this.prmtOrderNumberTo};
    }

    @Override
    protected KDBizPromptBox[] getProjectNumberF7() {
        return new KDBizPromptBox[]{this.prmtProjectFrom, this.prmtProjectTo};
    }

    @Override
    protected KDBizPromptBox[] getTrackNumberF7() {
        return new KDBizPromptBox[]{this.prmtTrackFrom, this.prmtTrackTo};
    }

    @Override
    protected KDBizPromptBox[] getMaterialF7() {
        return new KDBizPromptBox[]{this.prmtProductFrom, this.prmtProductTo};
    }

    @Override
    protected KDTextField[] getBatchNumberCtrls() {
        return new KDTextField[]{this.txtBatchFrom, this.txtBatchTo};
    }

    @Override
    protected KDBizPromptBox[] getCostItemF7() {
        return new KDBizPromptBox[]{this.prmtCostItemFrom, this.prmtCostItemTo};
    }

    @Override
    protected KDSpinner getDisplayCountSpinner() {
        return this.spCostObjectNum;
    }

    static class RadioButtonFilterElement
    extends SingleFilterElement {
        KDRadioButton kdRb;

        public RadioButtonFilterElement(String id, KDRadioButton component) {
            super(id, (Component)component);
            this.kdRb = component;
        }

        public void addRptParams(RptParams cp) {
            cp.setObject(this.getId(), (Object)new Boolean(this.kdRb.isSelected()));
        }
    }
}

