/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteCollection;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.ncm.cal.report.client.AbstractMaterialCostTotalReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.BizPromptFilterElement;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.JSpinner;
import org.apache.log4j.Logger;

public class MaterialCostTotalReportFilterUI
extends AbstractMaterialCostTotalReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialCostTotalReportFilterUI.class);
    private CompanyOrgUnitInfo companyOrg;
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public MaterialCostTotalReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(1001, this.companyOrg.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.startPeriod = sysctrol.getStartPeriod(1001, this.companyOrg.getId().toString());
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)this.companyOrg, (PeriodInfo)this.currentPeriod);
        this.prmtCompanyOrg.setValue((Object)this.companyOrg);
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtOrderNumberFrom, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtOrderNumberTo, (String)this.companyOrg.getId().toString());
        this.costobjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.costobjectFrom, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        this.costobjectFrom.setSelector((KDPromptSelector)arg0);
        this.costobjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.costobjectTo, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        this.costobjectTo.setSelector((KDPromptSelector)arg1);
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.costobjectFrom, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.costobjectTo, (String)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.materialIdFrom, (String)"company.id", (Object)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.materialIdFrom, (String)"status", (IntEnum)UsedStatusEnum.APPROVED);
        BDCMClientUtils.filterF7((KDBizPromptBox)this.materialIdTo, (String)"company.id", (Object)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.materialIdTo, (String)"status", (IntEnum)UsedStatusEnum.APPROVED);
        FilterInfo filterPrmt = this.materialIdFrom.getEntityViewInfo().getFilter();
        filterPrmt.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(1), CompareType.EQUALS));
        this.materialIdFrom = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.materialIdFrom, (FilterInfo)filterPrmt);
        this.materialIdTo = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.materialIdTo, (FilterInfo)filterPrmt);
        FilterInfo costItemFilterInfo = this.getCostItemFilter();
        this.setFilterInfoF7(this.prmtCostItemFrom, costItemFilterInfo);
        this.setFilterInfoF7(this.prmtCostItemTo, costItemFilterInfo);
        this.filterF7ForCU(this.prmtProjectNumberFrom);
        this.filterF7ForCU(this.prmtProjectNumberTo);
        this.filterF7ForCU(this.prmtTrackNumberFrom);
        this.filterF7ForCU(this.prmtTrackNumberTo);
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtMaterialFrom, (String)"company.id", (Object)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtMaterialFrom, (String)"status", (IntEnum)UsedStatusEnum.APPROVED);
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtMaterialTo, (String)"company.id", (Object)this.companyOrg.getId().toString());
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtMaterialTo, (String)"status", (IntEnum)UsedStatusEnum.APPROVED);
        FilterInfo filterPrmt2 = this.prmtMaterialFrom.getEntityViewInfo().getFilter();
        filterPrmt2.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(1), CompareType.EQUALS));
        this.prmtMaterialFrom = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtMaterialFrom, (FilterInfo)filterPrmt2);
        this.prmtMaterialTo = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtMaterialTo, (FilterInfo)filterPrmt2);
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        BizPromptFilterElement filterElement = new BizPromptFilterElement("companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SpinnerFilterElement element = new SpinnerFilterElement("yearFrom", (Component)this.spYearFrom);
        element.setDefaultValue(this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("yearTo", (Component)this.spYearTo);
        element.setDefaultValue(this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodFrom", (Component)this.spPeriodFrom);
        element.setDefaultValue(this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodTo", (Component)this.spPeriodTo);
        element.setDefaultValue(this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("prmtCostCenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("prmtCostCenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("costobjectFrom", (Component)this.costobjectFrom));
        elements.add((FilterElement)new SingleFilterElement("costobjectTo", (Component)this.costobjectTo));
        elements.add((FilterElement)new SingleFilterElement("costitemFrom", (Component)this.prmtCostItemFrom));
        elements.add((FilterElement)new SingleFilterElement("costitemTo", (Component)this.prmtCostItemTo));
        elements.add((FilterElement)new SingleFilterElement("materialIdFrom", (Component)this.materialIdFrom));
        elements.add((FilterElement)new SingleFilterElement("materialIdTo", (Component)this.materialIdTo));
        elements.add((FilterElement)new SingleFilterElement("costObjectGroupFrom", (Component)this.costObjectGroupFrom));
        elements.add((FilterElement)new SingleFilterElement("costObjectGroupTo", (Component)this.costObjectGroupTo));
        elements.add((FilterElement)new SingleFilterElement("orderNumberFrom", (Component)this.prmtOrderNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("orderNumberTo", (Component)this.prmtOrderNumberTo));
        elements.add((FilterElement)new SingleFilterElement("batchNumberFrom", (Component)this.txtBatchNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("batchNumberTo", (Component)this.txtBatchNumberTo));
        elements.add((FilterElement)new SingleFilterElement("projectNumberFrom", (Component)this.prmtProjectNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("projectNumberTo", (Component)this.prmtProjectNumberTo));
        elements.add((FilterElement)new SingleFilterElement("trackNumberFrom", (Component)this.prmtTrackNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("trackNumberTo", (Component)this.prmtTrackNumberTo));
        elements.add((FilterElement)new SingleFilterElement("materialFrom", (Component)this.prmtMaterialFrom));
        elements.add((FilterElement)new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo));
        elements.add((FilterElement)new SingleFilterElement("prmtexpensefrom", (Component)this.prmtexpensefrom));
        elements.add((FilterElement)new SingleFilterElement("prmtexpenseto", (Component)this.prmtexpenseto));
        return elements;
    }

    protected void filterF7ForCU(KDBizPromptBox f7) throws BOSException, EASBizException {
        CtrlUnitInfo cU = SysContext.getSysContext().getCurrentCtrlUnit();
        String cUID = null;
        if (cU != null) {
            cUID = cU.getId().toString();
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cUID, CompareType.EQUALS));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    @Override
    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    @Override
    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    @Override
    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterTo);
        this.f7ContextManager.registerCostObjectF7(this.costobjectFrom, true);
        this.f7ContextManager.registerCostObjectF7(this.costobjectTo, true);
        this.f7ContextManager.registerCostObjectSuiteF7(this.costObjectGroupFrom);
        this.f7ContextManager.registerCostObjectSuiteF7(this.costObjectGroupTo);
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(5);
        statuses.add(8);
        statuses.add(7);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberFrom, filter);
        this.prmtOrderNumberFrom.setDisplayFormat("$number$");
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberTo, filter);
        this.prmtOrderNumberTo.setDisplayFormat("$number$");
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterialFrom, null);
        MaterialF7TreeListSelector selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterialFrom);
        this.prmtMaterialFrom.setSelector((KDPromptSelector)selector);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterialTo, null);
        selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterialTo);
        this.prmtMaterialTo.setSelector((KDPromptSelector)selector);
        this.f7ContextManager.registerMaterialTreeF7(this.materialIdFrom, null);
        MaterialF7TreeListSelector selector1 = new MaterialF7TreeListSelector((Object)this, this.materialIdFrom);
        this.materialIdFrom.setSelector((KDPromptSelector)selector1);
        this.f7ContextManager.registerMaterialTreeF7(this.materialIdTo, null);
        selector1 = new MaterialF7TreeListSelector((Object)this, this.materialIdTo);
        this.materialIdTo.setSelector((KDPromptSelector)selector1);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtexpensefrom, "com.kingdee.eas.basedata.ncm.app.ExpenseF7Query", "CompanyInfo.id");
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtexpenseto, "com.kingdee.eas.basedata.ncm.app.ExpenseF7Query", "CompanyInfo.id");
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostCenterFrom.setValue(null);
                this.prmtCostCenterTo.setValue(null);
                this.costobjectFrom.setValue(null);
                this.costobjectTo.setValue(null);
                this.prmtCostItemTo.setValue(null);
                this.prmtCostItemTo.setValue(null);
                this.materialIdFrom.setValue(null);
                this.materialIdTo.setValue(null);
                this.costObjectGroupTo.setValue(null);
                this.costObjectGroupFrom.setValue(null);
                this.prmtOrderNumberFrom.setValue(null);
                this.prmtOrderNumberTo.setValue(null);
                this.txtBatchNumberFrom.setText(null);
                this.txtBatchNumberTo.setText(null);
                this.prmtProjectNumberFrom.setValue(null);
                this.prmtProjectNumberTo.setValue(null);
                this.prmtTrackNumberFrom.setValue(null);
                this.prmtTrackNumberTo.setValue(null);
                this.prmtMaterialFrom.setValue(null);
                this.prmtMaterialTo.setValue(null);
                this.prmtCostItemFrom.setValue(null);
                this.prmtCostItemTo.setValue(null);
                this.prmtexpensefrom.setValue(null);
                this.prmtexpenseto.setValue(null);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "MaterialCostTotalReportView";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "MaterialCostTotalReportPrint";
    }

    @Override
    protected KDBizPromptBox[] getOrderNumberF7() {
        return new KDBizPromptBox[]{this.prmtOrderNumberFrom, this.prmtOrderNumberTo};
    }

    @Override
    protected KDBizPromptBox[] getProjectNumberF7() {
        return new KDBizPromptBox[]{this.prmtProjectNumberFrom, this.prmtProjectNumberTo};
    }

    @Override
    protected KDBizPromptBox[] getTrackNumberF7() {
        return new KDBizPromptBox[]{this.prmtTrackNumberFrom, this.prmtTrackNumberTo};
    }

    @Override
    protected KDBizPromptBox[] getMaterialF7() {
        return new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo};
    }

    @Override
    protected KDTextField[] getBatchNumberCtrls() {
        return new KDTextField[]{this.txtBatchNumberFrom, this.txtBatchNumberTo};
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
            this.loadCostCenterNum(params);
            this.loadCostObject(params);
            this.loadCostItemNum(params);
            this.loadCostObjectGroup(params);
            this.loadMaterialNum(params);
            this.loadExpense(params);
        }
    }

    private void loadExpense(CustomerParams params) {
        String expenseFrom = "";
        String expenseTo = "";
        if (params.getCustomerParam("prmtexpensefrom") != null) {
            expenseFrom = params.getCustomerParam("prmtexpensefrom");
        }
        if (params.getCustomerParam("prmtexpenseto") != null) {
            expenseTo = params.getCustomerParam("prmtexpenseto");
        }
        try {
            ExpenseCollection expenseColl = ExpenseFactory.getRemoteInstance().getExpenseCollection("select * where number = '" + expenseFrom + "' or number = '" + expenseTo + "'");
            if (expenseColl != null && expenseColl.size() > 0) {
                if (expenseColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (expenseColl.get(i).getNumber().equals(expenseFrom)) {
                            this.prmtexpensefrom.setData((Object)expenseColl.get(i));
                            continue;
                        }
                        this.prmtexpenseto.setData((Object)expenseColl.get(i));
                    }
                } else if (expenseColl.size() == 1) {
                    if (expenseColl.get(0).getNumber().equals(expenseFrom)) {
                        this.prmtexpensefrom.setData((Object)expenseColl.get(0));
                    }
                    if (expenseColl.get(0).getNumber().equals(expenseTo)) {
                        this.prmtexpenseto.setData((Object)expenseColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtexpensefrom.setData(null);
            this.prmtexpenseto.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.currentPeriod;
        PeriodInfo initPeriodTo = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("spYearFrom");
        String initMonthFrom = params.getCustomerParam("spPeriodFrom");
        String initYearTo = params.getCustomerParam("spYearTo");
        String initMonthTo = params.getCustomerParam("spPeriodTo");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)initPeriodTo);
    }

    @Override
    protected void setDefaultValue() {
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)this.companyOrg);
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.costobjectFrom.setValue(null);
        this.costobjectTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.materialIdFrom.setValue(null);
        this.materialIdTo.setValue(null);
        this.costObjectGroupTo.setValue(null);
        this.costObjectGroupFrom.setValue(null);
    }

    private void loadCostCenterNum(CustomerParams params) {
        String costCenterFromStr = "";
        String costCenterToStr = "";
        if (params.getCustomerParam("prmtCostCenterFrom") != null) {
            costCenterFromStr = params.getCustomerParam("prmtCostCenterFrom");
        }
        if (params.getCustomerParam("prmtCostCenterTo") != null) {
            costCenterToStr = params.getCustomerParam("prmtCostCenterTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFromStr));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterToStr));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costCenterColl.get(i).getNumber().equals(costCenterFromStr)) {
                            this.prmtCostCenterFrom.setData((Object)costCenterColl.get(i));
                            continue;
                        }
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(i));
                    }
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFromStr)) {
                        this.prmtCostCenterFrom.setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterToStr)) {
                        this.prmtCostCenterTo.setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostCenterFrom.setData(null);
            this.prmtCostCenterTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostObject(CustomerParams params) {
        String costObjectFromStr = "";
        String costObjectToStr = "";
        if (params.getCustomerParam("costobjectFrom") != null) {
            costObjectFromStr = params.getCustomerParam("costobjectFrom");
        }
        if (params.getCustomerParam("costobjectTo") != null) {
            costObjectToStr = params.getCustomerParam("costobjectTo");
        }
        try {
            String companyId = this.getCompanyOrgInfoWithDefault().getId().toString();
            String oql = " select * where company.id = '" + companyId + "'  and ( number = '" + costObjectFromStr + "' or number = '" + costObjectToStr + "')";
            CostObjectCollection costObjectColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(oql);
            if (costObjectColl != null && costObjectColl.size() > 0) {
                if (costObjectColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costObjectColl.get(i).getNumber().equals(costObjectFromStr)) {
                            this.costobjectFrom.setData((Object)costObjectColl.get(i));
                            continue;
                        }
                        this.costobjectTo.setData((Object)costObjectColl.get(i));
                    }
                } else if (costObjectColl.size() == 1) {
                    if (costObjectColl.get(0).getNumber().equals(costObjectFromStr)) {
                        this.costobjectFrom.setData((Object)costObjectColl.get(0));
                    }
                    if (costObjectColl.get(0).getNumber().equals(costObjectToStr)) {
                        this.costobjectTo.setData((Object)costObjectColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.costobjectFrom.setData(null);
            this.costobjectTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadOrderNum(CustomerParams params) {
        String orderNumberFromStr = "";
        String orderNumberToStr = "";
        if (params.getCustomerParam("orderNumberFrom") != null) {
            orderNumberFromStr = params.getCustomerParam("orderNumberFrom");
        }
        if (params.getCustomerParam("orderNumberTo") != null) {
            orderNumberToStr = params.getCustomerParam("orderNumberTo");
        }
        try {
            String companyId = this.getCompanyOrgInfoWithDefault().getId().toString();
            String oql = " select * where company.id = '" + companyId + "'  and ( number = '" + orderNumberFromStr + "' or number = '" + orderNumberToStr + "')";
            ManufactureOrderCollection orderNumberColl = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(oql);
            if (orderNumberColl != null && orderNumberColl.size() > 0) {
                if (orderNumberColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (orderNumberColl.get(i).getNumber().equals(orderNumberFromStr)) {
                            this.prmtOrderNumberFrom.setData((Object)orderNumberColl.get(i));
                            continue;
                        }
                        this.prmtOrderNumberTo.setData((Object)orderNumberColl.get(i));
                    }
                } else if (orderNumberColl.size() == 1) {
                    if (orderNumberColl.get(0).getNumber().equals(orderNumberFromStr)) {
                        this.prmtOrderNumberFrom.setData((Object)orderNumberColl.get(0));
                    }
                    if (orderNumberColl.get(0).getNumber().equals(orderNumberToStr)) {
                        this.prmtOrderNumberTo.setData((Object)orderNumberColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtOrderNumberFrom.setData(null);
            this.prmtOrderNumberTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostObjectGroup(CustomerParams params) {
        String costobjectgroupfromStr = "";
        String costobjectgrouptoStr = "";
        if (params.getCustomerParam("costObjectGroupFrom") != null) {
            costobjectgroupfromStr = params.getCustomerParam("costObjectGroupFrom");
        }
        if (params.getCustomerParam("costObjectGroupTo") != null) {
            costobjectgrouptoStr = params.getCustomerParam("costObjectGroupTo");
        }
        try {
            CostObjectSuiteCollection costobjectgroupColl = CostObjectSuiteFactory.getRemoteInstance().getCostObjectSuiteCollection("select * where (number ='" + costobjectgroupfromStr + "' or number = '" + costobjectgrouptoStr + "')AND company='" + this.getCompanyOrgInfoWithDefault().getId().toString() + "'");
            if (costobjectgroupColl != null && costobjectgroupColl.size() > 0) {
                if (costobjectgroupColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costobjectgroupColl.get(i).getNumber().equals(costobjectgroupfromStr)) {
                            this.costObjectGroupFrom.setData((Object)costobjectgroupColl.get(i));
                            continue;
                        }
                        this.costObjectGroupTo.setData((Object)costobjectgroupColl.get(i));
                    }
                } else if (costobjectgroupColl.size() == 1) {
                    if (costobjectgroupColl.get(0).getNumber().equals(costobjectgroupfromStr)) {
                        this.costObjectGroupFrom.setData((Object)costobjectgroupColl.get(0));
                    }
                    if (costobjectgroupColl.get(0).getNumber().equals(costobjectgrouptoStr)) {
                        this.costObjectGroupTo.setData((Object)costobjectgroupColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.costObjectGroupFrom.setData(null);
            this.costObjectGroupTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostItemNum(CustomerParams params) {
        String costItemFromStr = "";
        String costItemToStr = "";
        if (params.getCustomerParam("prmtCostItemFrom") != null) {
            costItemFromStr = params.getCustomerParam("prmtCostItemFrom");
        }
        if (params.getCustomerParam("prmtCostItemTo") != null) {
            costItemToStr = params.getCustomerParam("prmtCostItemTo");
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemFromStr));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemToStr));
            filter.setMaskString("#0 or #1");
            try {
                FilterInfo costItemFilterInfo = this.getCostItemFilter();
                costItemFilterInfo.mergeFilter(filter, "and");
                view.setFilter(costItemFilterInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            CostItemCollection costItemColl = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (costItemColl != null && costItemColl.size() > 0) {
                if (costItemColl.size() == 2) {
                    this.prmtCostItemFrom.setData((Object)costItemColl.get(0));
                    this.prmtCostItemTo.setData((Object)costItemColl.get(1));
                    for (int i = 0; i < 2; ++i) {
                        if (costItemColl.get(i).getNumber().equals(costItemFromStr)) {
                            this.prmtCostItemFrom.setData((Object)costItemColl.get(i));
                            continue;
                        }
                        this.prmtCostItemTo.setData((Object)costItemColl.get(i));
                    }
                } else if (costItemColl.size() == 1) {
                    if (costItemColl.get(0).getNumber().equals(costItemFromStr)) {
                        this.prmtCostItemFrom.setData((Object)costItemColl.get(0));
                    }
                    if (costItemColl.get(0).getNumber().equals(costItemToStr)) {
                        this.prmtCostItemTo.setData((Object)costItemColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.prmtCostItemFrom.setData(null);
            this.prmtCostItemTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadMaterialNum(CustomerParams params) {
        String materialFromStr = "";
        String materialToStr = "";
        if (params.getCustomerParam("materialIdFrom") != null) {
            materialFromStr = params.getCustomerParam("materialIdFrom");
        }
        if (params.getCustomerParam("materialIdTo") != null) {
            materialToStr = params.getCustomerParam("materialIdTo");
        }
        try {
            String sql = "select mateial.id,mateial.name,mateial.number where (mateial.number ='" + materialFromStr + "' or mateial.number = '" + materialToStr + "') AND company='" + this.getCompanyOrgInfoWithDefault().getId().toString() + "'";
            MaterialCompanyInfoCollection expenseColl = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(sql);
            if (expenseColl != null && expenseColl.size() > 0) {
                if (expenseColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (expenseColl.get(i).getMateial().getNumber().equals(materialFromStr)) {
                            this.materialIdFrom.setData((Object)expenseColl.get(i).getMateial());
                            continue;
                        }
                        this.materialIdTo.setData((Object)expenseColl.get(i).getMateial());
                    }
                } else if (expenseColl.size() == 1) {
                    if (expenseColl.get(0).getMateial().getNumber().equals(materialFromStr)) {
                        this.materialIdFrom.setData((Object)expenseColl.get(0).getMateial());
                    }
                    if (expenseColl.get(0).getMateial().getNumber().equals(materialToStr)) {
                        this.materialIdTo.setData((Object)expenseColl.get(0).getMateial());
                    }
                }
            }
        }
        catch (BOSException e) {
            this.materialIdFrom.setData(null);
            this.materialIdTo.setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }
}

