/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.cal.report.client.AbstractRecoveryByEndlReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.BizPromptFilterElement;
import com.kingdee.eas.ncm.cal.report.client.CheckBoxFilterElement;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class RecoveryByEndlReportFilterUI
extends AbstractRecoveryByEndlReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RecoveryByEndlReportFilterUI.class);
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public RecoveryByEndlReportFilterUI() throws Exception {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(1001, companyOrg.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.startPeriod = sysctrol.getStartPeriod(1001, companyOrg.getId().toString());
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)companyOrg, (PeriodInfo)this.currentPeriod);
        this.spDisplayCount.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 1000, 1));
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        BizPromptFilterElement filterElement = new BizPromptFilterElement("prmtCompanyOrg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SingleFilterElement element = new SpinnerFilterElement("spYearFrom", (Component)this.spYearFrom);
        element.setDefaultValue((Object)this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("spYearTo", (Component)this.spYearTo);
        element.setDefaultValue((Object)this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("spPeriodFrom", (Component)this.spPeriodFrom);
        element.setDefaultValue((Object)this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("spPeriodTo", (Component)this.spPeriodTo);
        element.setDefaultValue((Object)this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("prmtProductFrom", (Component)this.prmtProductFrom));
        elements.add((FilterElement)new SingleFilterElement("prmtProductTo", (Component)this.prmtProductTo));
        elements.add((FilterElement)new SingleFilterElement("txtLotFrom", (Component)this.txtLotFrom));
        elements.add((FilterElement)new SingleFilterElement("txtLotTo", (Component)this.txtLotTo));
        element = new CheckBoxFilterElement("chkIsTotalCostItem", this.chkIsTotalCostItem);
        elements.add((FilterElement)element);
        element = new CheckBoxFilterElement("chkIsOnlyCostItem", this.chkIsOnlyCostItem);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("spDisplayCount", (Component)this.spDisplayCount);
        element.setDefaultValue((Object)1);
        elements.add((FilterElement)element);
        return elements;
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        FilterInfo filter = new FilterInfo();
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductFrom, filter);
        MaterialF7TreeListSelector selector1 = new MaterialF7TreeListSelector((Object)this, this.prmtProductFrom);
        this.prmtProductFrom.setSelector((KDPromptSelector)selector1);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductTo, filter);
        selector1 = new MaterialF7TreeListSelector((Object)this, this.prmtProductTo);
        this.prmtProductTo.setSelector((KDPromptSelector)selector1);
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtProductFrom.setValue(null);
                this.prmtProductTo.setValue(null);
                this.chkIsTotalCostItem.setSelected(false);
                this.txtLotFrom.setText(null);
                this.txtLotTo.setText(null);
                this.chkIsTotalCostItem.setSelected(false);
                this.chkIsOnlyCostItem.setSelected(false);
                this.spDisplayCount.setValue((Object)1);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "NCMCostRestoreReportByTotal";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "NCMCostRestoreReportByTotalPrint";
    }

    @Override
    protected KDSpinner[] getPeriodSpinner() {
        return new KDSpinner[]{this.spYearFrom, this.spYearTo, this.spPeriodFrom, this.spPeriodTo};
    }

    @Override
    protected KDBizPromptBox[] getMaterialF7() {
        return new KDBizPromptBox[]{this.prmtProductFrom, this.prmtProductTo};
    }

    @Override
    protected KDTextField[] getBatchNumberCtrls() {
        return new KDTextField[]{this.txtLotFrom, this.txtLotTo};
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo1) {
        super.loadData(entityViewInfo1);
        CustomerParams params = this.cp;
        if (params != null) {
            this.chkIsTotalCostItem.setSelected(Boolean.valueOf(this.cp.getCustomerParam("chkIsTotalCostItem")).booleanValue());
            this.chkIsOnlyCostItem.setSelected(Boolean.valueOf(this.cp.getCustomerParam("chkIsOnlyCostItem")).booleanValue());
            this.spDisplayCount.setValue((Object)Integer.valueOf(this.cp.getCustomerParam("spDisplayCount")));
        }
    }
}

