/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.client.AbstractReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.BizPromptFilterElement;
import com.kingdee.eas.ncm.cal.report.client.CheckBoxFilterElement;
import com.kingdee.eas.ncm.cal.report.client.SingleSpinnerFilterElement;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Assert;
import java.awt.Component;
import java.awt.Container;
import java.text.ParseException;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public abstract class ReportFilterUI
extends AbstractReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ReportFilterUI.class);
    protected CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
    protected String companyOrgID = this.companyOrg.getId().toString();

    public ReportFilterUI() throws Exception {
        BDCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.checkPeriod();
    }

    protected void checkPeriod() throws Exception {
        if (!NCMUtils.isStart(null, (String)this.companyOrgID)) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
    }

    public void setReport(boolean isReport) {
        super.setReport(true);
    }

    public CompanyOrgUnitInfo getCompanyOrg() {
        return this.companyOrg;
    }

    public String getCompanyOrgID() {
        return this.companyOrgID;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getCompanyF7();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComp();
        this.setUIParam();
    }

    public abstract void initComp() throws Exception;

    public void setUIParam2() throws EASBizException, BOSException {
        PeriodInfo currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)this.companyOrgID);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        Assert.that((this.getCompanyF7() != null ? 1 : 0) != 0);
        SingleComPromptFilterElement filterElement = new SingleComPromptFilterElement(this.getCompanyF7().getName(), this.getCompanyF7());
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        Assert.that((this.getPeriodSpinner() != null && this.getPeriodSpinner().length == 4 ? 1 : 0) != 0);
        SingleFilterElement element = new SingleSpinnerFilterElement(this.getPeriodSpinner()[0].getName(), (Component)this.getPeriodSpinner()[0]);
        element.setDefaultValue((Object)currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement(this.getPeriodSpinner()[1].getName(), (Component)this.getPeriodSpinner()[1]);
        element.setDefaultValue((Object)currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement(this.getPeriodSpinner()[2].getName(), (Component)this.getPeriodSpinner()[2]);
        element.setDefaultValue((Object)currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement(this.getPeriodSpinner()[3].getName(), (Component)this.getPeriodSpinner()[3]);
        element.setDefaultValue((Object)currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        if (this.getCostCenterF7() != null && this.getCostCenterF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getCostCenterF7()[0].getName(), (Component)this.getCostCenterF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getCostCenterF7()[1].getName(), (Component)this.getCostCenterF7()[1]));
        }
        if (this.getCostObjectF7() != null && this.getCostObjectF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getCostObjectF7()[0].getName(), (Component)this.getCostObjectF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getCostObjectF7()[1].getName(), (Component)this.getCostObjectF7()[1]));
        }
        if (this.getMaterialF7() != null && this.getMaterialF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getMaterialF7()[0].getName(), (Component)this.getMaterialF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getMaterialF7()[1].getName(), (Component)this.getMaterialF7()[1]));
        }
        if (this.getCostItemF7() != null && this.getCostItemF7().length == 2) {
            elements.add((FilterElement)new SingleFilterElement(this.getCostItemF7()[0].getName(), (Component)this.getCostItemF7()[0]));
            elements.add((FilterElement)new SingleFilterElement(this.getCostItemF7()[1].getName(), (Component)this.getCostItemF7()[1]));
        }
        if (this.getDisplayCountSpinner() != null) {
            element = new SpinnerFilterElement(this.getDisplayCountSpinner().getName(), (Component)this.getDisplayCountSpinner());
            elements.add((FilterElement)element);
        }
        if (this.getOtherComponent() != null) {
            for (int i = 0; i < this.getOtherComponent().length; ++i) {
                element = new SingleFilterElement(this.getOtherComponent()[i].getName(), (Component)this.getOtherComponent()[i]);
                elements.add((FilterElement)element);
            }
        }
        if (this.getCostItemLevelSpinner() != null) {
            element = new SpinnerFilterElement(this.getCostItemLevelSpinner().getName(), (Component)this.getCostItemLevelSpinner());
            elements.add((FilterElement)element);
        }
        if (this.getExpenseLevelSpinner() != null) {
            element = new SpinnerFilterElement(this.getExpenseLevelSpinner().getName(), (Component)this.getExpenseLevelSpinner());
            elements.add((FilterElement)element);
        }
        if (this.getMaterialLevelSpinner() != null) {
            element = new SpinnerFilterElement(this.getMaterialLevelSpinner().getName(), (Component)this.getMaterialLevelSpinner());
            elements.add((FilterElement)element);
        }
        if (this.getIsTotalCostItemCheckBox() != null) {
            element = new CheckBoxFilterElement(this.getIsTotalCostItemCheckBox().getName(), this.getIsTotalCostItemCheckBox());
            elements.add((FilterElement)element);
        }
        if (this.getIsTotalExpenseCheckBox() != null) {
            this.getIsTotalExpenseCheckBox().setSelected(true);
            element = new CheckBoxFilterElement(this.getIsTotalExpenseCheckBox().getName(), this.getIsTotalExpenseCheckBox());
            elements.add((FilterElement)element);
        }
        if (this.getIsTotalMaterialCheckBox() != null) {
            element = new CheckBoxFilterElement(this.getIsTotalMaterialCheckBox().getName(), this.getIsTotalMaterialCheckBox());
            elements.add((FilterElement)element);
        }
        if (this.getIsDisplayTotalRowsOnlyCheckBox() != null) {
            element = new CheckBoxFilterElement(this.getIsDisplayTotalRowsOnlyCheckBox().getName(), this.getIsDisplayTotalRowsOnlyCheckBox());
            elements.add((FilterElement)element);
        }
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void setUIParam() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        Set allLeafComponents = ClientVerifyHelper.getAllComponents((Container)((Object)this));
        for (Component comp : allLeafComponents) {
            if (!(comp instanceof IKDTextComponent)) continue;
            if (comp instanceof KDTextField) {
                elements.add((FilterElement)new SingleFilterElement(comp.getName(), comp));
                IKDTextComponent txtComp = (IKDTextComponent)comp;
                if (txtComp.isRequired()) {
                    ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)((KDTextField)comp));
                }
            } else if (comp instanceof KDBizPromptBox) {
                BizPromptFilterElement filterElement = new BizPromptFilterElement(comp.getName(), (KDBizPromptBox)comp);
                IKDTextComponent txtComp = (IKDTextComponent)comp;
                if (txtComp.isRequired()) {
                    ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)((KDBizPromptBox)comp));
                }
                elements.add((FilterElement)filterElement);
            } else if (comp instanceof KDSpinner) {
                elements.add((FilterElement)new SpinnerFilterElement(comp.getName(), comp));
            } else if (comp instanceof KDLabelContainer) {
                KDLabelContainer lbl = (KDLabelContainer)comp;
                lbl.setBoundLabelUnderline(true);
            } else {
                elements.add((FilterElement)new SingleFilterElement(comp.getName(), comp));
            }
            this.getFilterManager().setElement((FilterElement)elements);
        }
    }

    public void setDefaultValue() {
        if (this.getCompanyF7() != null) {
            this.getCompanyF7().setData((Object)this.companyOrg);
        }
        if (this.getCostCenterF7() != null && this.getCostCenterF7().length == 2) {
            this.getCostCenterF7()[0].setData(null);
            this.getCostCenterF7()[1].setData(null);
        }
        if (this.getCostObjectF7() != null && this.getCostObjectF7().length == 2) {
            this.getCostObjectF7()[0].setData(null);
            this.getCostObjectF7()[1].setData(null);
        }
        if (this.getMaterialF7() != null && this.getMaterialF7().length == 2) {
            this.getMaterialF7()[0].setData(null);
            this.getMaterialF7()[1].setData(null);
        }
        if (this.getCostItemF7() != null && this.getCostItemF7().length == 2) {
            this.getCostItemF7()[0].setData(null);
            this.getCostItemF7()[1].setData(null);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo1) {
        CustomerParams params;
        super.loadData(entityViewInfo1);
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        if (this.getCompanyF7() != null) {
            this.getCompanyF7().setValue((Object)this.companyOrg);
        }
        if ((params = this.getCustomerParams()) != null) {
            if (this.getCostCenterF7() != null && this.getCostCenterF7().length == 2) {
                this.loadCostCenter(params);
            }
            if (this.getCostObjectF7() != null && this.getCostObjectF7().length == 2) {
                this.loadCostObject(params);
            }
            if (this.getMaterialF7() != null && this.getMaterialF7().length == 2) {
                this.loadMaterial(params);
            }
            if (this.getCostItemF7() != null && this.getCostItemF7().length == 2) {
                this.loadCostItem(params);
            }
        }
    }

    private void loadCostObject(CustomerParams params) {
        String costObjectFrom = "";
        String costObjectTo = "";
        if (params.getCustomerParam(this.getCostObjectF7()[0].getName()) != null) {
            costObjectFrom = params.getCustomerParam(this.getCostObjectF7()[0].getName());
        }
        if (params.getCustomerParam(this.getCostObjectF7()[1].getName()) != null) {
            costObjectTo = params.getCustomerParam(this.getCostObjectF7()[1].getName());
        }
        try {
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            String oql = " select * where company.id = '" + companyId + "'  and ( number = '" + costObjectFrom + "' or number = '" + costObjectTo + "')";
            CostObjectCollection costObjectColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(oql);
            if (costObjectColl != null && costObjectColl.size() > 0) {
                if (costObjectColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costObjectColl.get(i).getNumber().equals(costObjectFrom)) {
                            this.getCostObjectF7()[0].setData((Object)costObjectColl.get(i));
                            continue;
                        }
                        this.getCostObjectF7()[1].setData((Object)costObjectColl.get(i));
                    }
                } else if (costObjectColl.size() == 1) {
                    if (costObjectColl.get(0).getNumber().equals(costObjectFrom)) {
                        this.getCostObjectF7()[0].setData((Object)costObjectColl.get(0));
                    }
                    if (costObjectColl.get(0).getNumber().equals(costObjectTo)) {
                        this.getCostObjectF7()[1].setData((Object)costObjectColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.getCostObjectF7()[0].setData(null);
            this.getCostObjectF7()[1].setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostCenter(CustomerParams params) {
        String costCenterFrom = "";
        String costCenterTo = "";
        if (params.getCustomerParam(this.getCostCenterF7()[0].getName()) != null) {
            costCenterFrom = params.getCustomerParam(this.getCostCenterF7()[0].getName());
        }
        if (params.getCustomerParam(this.getCostCenterF7()[1].getName()) != null) {
            costCenterTo = params.getCustomerParam(this.getCostCenterF7()[1].getName());
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costCenterTo));
            view.setFilter(filter);
            view.getFilter().setMaskString("#0 or #1");
            CostCenterOrgUnitCollection costCenterColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterColl != null && costCenterColl.size() > 0) {
                if (costCenterColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costCenterColl.get(i).getNumber().equals(costCenterFrom)) {
                            this.getCostCenterF7()[0].setData((Object)costCenterColl.get(i));
                            continue;
                        }
                        this.getCostCenterF7()[1].setData((Object)costCenterColl.get(i));
                    }
                } else if (costCenterColl.size() == 1) {
                    if (costCenterColl.get(0).getNumber().equals(costCenterFrom)) {
                        this.getCostCenterF7()[0].setData((Object)costCenterColl.get(0));
                    }
                    if (costCenterColl.get(0).getNumber().equals(costCenterTo)) {
                        this.getCostCenterF7()[1].setData((Object)costCenterColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.getCostCenterF7()[0].setData(null);
            this.getCostCenterF7()[1].setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadMaterial(CustomerParams params) {
        String materialFrom = "";
        String materialTo = "";
        if (params.getCustomerParam(this.getMaterialF7()[0].getName()) != null) {
            materialFrom = params.getCustomerParam(this.getMaterialF7()[0].getName());
        }
        if (params.getCustomerParam("getMaterialF7()[1].getName()") != null) {
            materialTo = params.getCustomerParam("getMaterialF7()[1].getName()");
        }
        try {
            String sql = "select mateial.id,mateial.name,mateial.number where (mateial.number ='" + materialFrom + "' or mateial.number = '" + materialTo + "') AND company='" + this.companyOrg.getId().toString() + "'";
            MaterialCompanyInfoCollection expenseColl = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(sql);
            if (expenseColl != null && expenseColl.size() > 0) {
                if (expenseColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (expenseColl.get(i).getMateial().getNumber().equals(materialFrom)) {
                            this.getMaterialF7()[0].setData((Object)expenseColl.get(i).getMateial());
                            continue;
                        }
                        this.getMaterialF7()[1].setData((Object)expenseColl.get(i).getMateial());
                    }
                } else if (expenseColl.size() == 1) {
                    if (expenseColl.get(0).getMateial().getNumber().equals(materialFrom)) {
                        this.getMaterialF7()[0].setData((Object)expenseColl.get(0).getMateial());
                    }
                    if (expenseColl.get(0).getMateial().getNumber().equals(materialTo)) {
                        this.getMaterialF7()[1].setData((Object)expenseColl.get(0).getMateial());
                    }
                }
            }
        }
        catch (BOSException e) {
            this.getMaterialF7()[0].setData(null);
            this.getMaterialF7()[1].setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void loadCostItem(CustomerParams params) {
        String costItemFrom = "";
        String costItemTo = "";
        if (params.getCustomerParam(this.getCostItemF7()[0].getName()) != null) {
            costItemFrom = params.getCustomerParam(this.getCostItemF7()[0].getName());
        }
        if (params.getCustomerParam(this.getCostItemF7()[1].getName()) != null) {
            costItemTo = params.getCustomerParam(this.getCostItemF7()[1].getName());
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemFrom));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)costItemTo));
            filter.setMaskString("#0 or #1");
            try {
                FilterInfo costItemFilterInfo = this.getCostItemFilter();
                costItemFilterInfo.mergeFilter(filter, "and");
                view.setFilter(costItemFilterInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            CostItemCollection costItemColl = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (costItemColl != null && costItemColl.size() > 0) {
                if (costItemColl.size() == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (costItemColl.get(i).getNumber().equals(costItemFrom)) {
                            this.getCostItemF7()[0].setData((Object)costItemColl.get(i));
                            continue;
                        }
                        this.getCostItemF7()[1].setData((Object)costItemColl.get(i));
                    }
                } else if (costItemColl.size() == 1) {
                    if (costItemColl.get(0).getNumber().equals(costItemFrom)) {
                        this.getCostItemF7()[0].setData((Object)costItemColl.get(0));
                    }
                    if (costItemColl.get(0).getNumber().equals(costItemTo)) {
                        this.getCostItemF7()[1].setData((Object)costItemColl.get(0));
                    }
                }
            }
        }
        catch (BOSException e) {
            this.getCostItemF7()[0].setData(null);
            this.getCostItemF7()[1].setData(null);
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    protected KDBizPromptBox getCompanyF7() {
        return null;
    }

    protected KDSpinner[] getPeriodSpinner() {
        return null;
    }

    protected KDSpinner getDisplayCountSpinner() {
        return null;
    }

    protected JComponent[] getOtherComponent() {
        return null;
    }

    protected KDBizPromptBox[] getCostCenterF7() {
        return null;
    }

    protected KDBizPromptBox[] getCostObjectF7() {
        return null;
    }

    protected KDBizPromptBox[] getMaterialF7() {
        return null;
    }

    protected KDBizPromptBox[] getCostItemF7() {
        return null;
    }

    protected KDTable getOptionTable() {
        return null;
    }

    protected KDSpinner getCostItemLevelSpinner() {
        return null;
    }

    protected KDSpinner getExpenseLevelSpinner() {
        return null;
    }

    protected KDSpinner getMaterialLevelSpinner() {
        return null;
    }

    protected KDCheckBox getIsTotalCostItemCheckBox() {
        return null;
    }

    protected KDCheckBox getIsTotalExpenseCheckBox() {
        return null;
    }

    protected KDCheckBox getIsTotalMaterialCheckBox() {
        return null;
    }

    protected KDCheckBox getIsDisplayTotalRowsOnlyCheckBox() {
        return null;
    }

    class SingleComPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleComPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[] && (object = ((Object[])object)[0]) == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object == null) {
                object = this.prmt.getText().trim();
            }
            cp.setObject(this.getId(), object);
        }
    }
}

