/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.formula.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.ncm.cal.report.formula.INCMRptFormulaFacade;
import com.kingdee.eas.ncm.cal.report.formula.NCMRptFormulaFacadeFactory;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class NCMFormulaWizardUI
extends FormulaWizardUI {
    private static Logger logger = Logger.getLogger((String)NCMFormulaWizardUI.class.getName());
    private static final long serialVersionUID = -928375944525048664L;
    protected KDBizPromptBox companyBox = null;
    protected KDTextField companyTxt = null;
    protected KDSpinner yearBox = null;
    protected KDTextField yearTxt = null;
    protected KDSpinner periodBox = null;
    protected KDTextField periodTxt = null;
    protected KDBizPromptBox costCenterBox = null;
    protected KDTextField costCenterTxt = null;
    protected KDBizPromptBox costObjectBox = null;
    protected KDTextField costObjectTxt = null;
    protected KDBizPromptBox costItemBox = null;
    protected KDTextField costItemTxt = null;
    INCMRptFormulaFacade iNCMRptFacade = null;

    protected void onOpen() {
        super.onOpen();
        this.companyBox = (KDBizPromptBox)this.getParamComponent("company");
        this.companyTxt = (KDTextField)this.getBaseParamComponent("company");
        this.yearBox = (KDSpinner)this.getParamComponent("year");
        this.periodTxt = (KDTextField)this.getBaseParamComponent("year");
        this.periodBox = (KDSpinner)this.getParamComponent("period");
        this.periodTxt = (KDTextField)this.getBaseParamComponent("period");
        this.costCenterBox = (KDBizPromptBox)this.getParamComponent("costCenter");
        this.costCenterTxt = (KDTextField)this.getBaseParamComponent("costCenter");
        this.costObjectBox = (KDBizPromptBox)this.getParamComponent("costObject");
        this.costObjectTxt = (KDTextField)this.getBaseParamComponent("costObject");
        this.costItemBox = (KDBizPromptBox)this.getParamComponent("costItem");
        this.costItemTxt = (KDTextField)this.getBaseParamComponent("costItem");
        this.costCenterBox.setEnabledMultiSelection(true);
        this.costObjectBox.setEnabledMultiSelection(true);
        if (this.companyBox.getSelector() instanceof CompanyF7) {
            ((CompanyF7)this.companyBox.getSelector()).setMultiSelect(false);
        }
        try {
            this.init();
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    protected void init() throws EASBizException, BOSException {
        this.setDefaultCompany();
        this.companyTxt.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                try {
                    NCMFormulaWizardUI.this.processCompanyFilter();
                    CompanyOrgUnitInfo company = NCMFormulaWizardUI.this.getInputCompany();
                    if (company != null) {
                        NCMFormulaWizardUI.this.companyBox.setData((Object)company);
                    }
                }
                catch (ObjectNotFoundException ex) {
                    NCMFormulaWizardUI.this.handUIException(ex);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
        this.costCenterTxt.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                try {
                    Object costCenter;
                    CompanyOrgUnitInfo company = NCMFormulaWizardUI.this.getInputCompany();
                    if (company != null) {
                        NCMFormulaWizardUI.this.processCostCenterFilter(company);
                    }
                    if ((costCenter = NCMFormulaWizardUI.this.costCenterBox.getValue()) instanceof String && costCenter.toString().length() > 0) {
                        NCMFormulaWizardUI.this.costCenterBox.setData((Object)CostCenterOrgUnitFactory.getRemoteInstance().getValue("select id,number,name where number='" + costCenter + "'"));
                    }
                }
                catch (ObjectNotFoundException ex) {
                    NCMFormulaWizardUI.this.handUIException(ex);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
        this.costObjectTxt.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                try {
                    CompanyOrgUnitInfo company = NCMFormulaWizardUI.this.getInputCompany();
                    if (company != null) {
                        NCMFormulaWizardUI.this.processCostObjectFilter(company);
                        Object costObject = NCMFormulaWizardUI.this.costObjectBox.getValue();
                        if (costObject instanceof String && costObject.toString().length() > 0 && NCMFormulaWizardUI.this.costObjectBox.getEntityViewInfo() != null && NCMFormulaWizardUI.this.costObjectBox.getEntityViewInfo().getFilter() != null && NCMFormulaWizardUI.this.costObjectBox.getEntityViewInfo().getFilter().toString().length() > 0) {
                            NCMFormulaWizardUI.this.costObjectBox.setData((Object)CostObjectFactory.getRemoteInstance().getCostObjectInfo(" select id,number,name where number ='" + costObject + "' and " + NCMFormulaWizardUI.this.costObjectBox.getEntityViewInfo().getFilter()));
                        }
                    }
                }
                catch (ObjectNotFoundException ex) {
                    NCMFormulaWizardUI.this.handUIException(ex);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
        this.costItemTxt.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                try {
                    Object costItem;
                    CompanyOrgUnitInfo company = NCMFormulaWizardUI.this.getInputCompany();
                    if (company != null) {
                        NCMFormulaWizardUI.this.processCostItemFilter(company);
                    }
                    if ((costItem = NCMFormulaWizardUI.this.costItemBox.getValue()) instanceof String && costItem.toString().length() > 0 && NCMFormulaWizardUI.this.costItemBox.getEntityViewInfo() != null && NCMFormulaWizardUI.this.costItemBox.getEntityViewInfo().getFilter() != null && NCMFormulaWizardUI.this.costItemBox.getEntityViewInfo().toString().length() > 0) {
                        NCMFormulaWizardUI.this.costItemBox.setData((Object)CostItemFactory.getRemoteInstance().getCostItemInfo("select id,number,name where number='" + costItem + "' and " + NCMFormulaWizardUI.this.costItemBox.getEntityViewInfo().getFilter().toString()));
                    }
                }
                catch (ObjectNotFoundException ex) {
                    NCMFormulaWizardUI.this.handUIException(ex);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
    }

    protected void setDefaultCompany() {
        if (!this.isAddNewOprtState()) {
            return;
        }
        if (this.companyBox.getData() != null && this.companyBox.getData().toString().length() > 0) {
            return;
        }
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company == null || company.getId() == null) {
            return;
        }
        if (GLUtil.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            return;
        }
        this.companyBox.setData((Object)company);
        this.companyTxt.setText(company.getNumber());
    }

    protected void processCompanyFilter() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.companyBox.setFilterInfoProducer((IFilterInfoProducer)new FilterInfoProducer(filter));
        this.companyBox.setEntityViewInfo(view);
    }

    protected void processCostCenterFilter(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company == null || company.getId() == null) {
            return;
        }
        CostCenterOrgUnitCollection costCenters = this.getNCMRptFacade().getChildrenCostCenters(company.getId().toString());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (costCenters == null || costCenters.size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"####", CompareType.EQUALS));
        } else {
            HashSet<String> costCenterIds = new HashSet<String>();
            int size = costCenters.size();
            for (int i = 0; i < size; ++i) {
                costCenterIds.add(costCenters.get(i).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", costCenterIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        this.costCenterBox.setFilterInfoProducer((IFilterInfoProducer)new FilterInfoProducer(filter));
        this.costCenterBox.setEntityViewInfo(view);
    }

    protected void processCostObjectFilter(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company == null || company.getId() == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        this.costObjectBox.setFilterInfoProducer((IFilterInfoProducer)new FilterInfoProducer(filter));
        this.costObjectBox.setEntityViewInfo(view);
    }

    protected void processCostItemFilter(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (company == null || company.getId() == null) {
            return;
        }
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isCU"));
        sic.add(new SelectorItemInfo("parent.id"));
        company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), sic);
        if (company == null) {
            return;
        }
        HashSet<String> cuSet = new HashSet<String>();
        while (true) {
            try {
                company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), sic);
            }
            catch (ObjectNotFoundException e) {
                this.handUIException(e);
            }
            if (company.isIsCU()) {
                cuSet.add(company.getId().toString());
                if (company.get("parent") == null) break;
                company.setId(company.getParent().getId());
                continue;
            }
            if (company.get("parent") == null) break;
            company.setId(company.getParent().getId());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", cuSet, CompareType.INCLUDE));
        view.setFilter(filter);
        this.costItemBox.setFilterInfoProducer((IFilterInfoProducer)new FilterInfoProducer(filter));
        this.costItemBox.setEntityViewInfo(view);
    }

    protected boolean isAddNewOprtState() {
        return this.getUIContext().get("Owner").getClass().getName().equals("com.kingdee.eas.fi.rpt.client.FormulaPickerUI");
    }

    private CompanyOrgUnitInfo getInputCompany() throws EASBizException, BOSException {
        Object companyObj = this.companyBox.getData();
        if (companyObj instanceof CompanyOrgUnitInfo) {
            return (CompanyOrgUnitInfo)companyObj;
        }
        if (companyObj instanceof String) {
            CompanyOrgUnitInfo company = null;
            try {
                company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(" select id,number,name where number='" + companyObj + "'");
            }
            catch (Exception exc) {
                logger.error((Object)"", (Throwable)exc);
            }
            return company;
        }
        return null;
    }

    private INCMRptFormulaFacade getNCMRptFacade() throws BOSException {
        if (this.iNCMRptFacade == null) {
            return NCMRptFormulaFacadeFactory.getRemoteInstance();
        }
        return this.iNCMRptFacade;
    }

    private class FilterInfoProducer
    implements IFilterInfoProducer {
        private FilterInfo filter;

        public FilterInfoProducer(FilterInfo filter) {
            this.filter = filter;
        }

        public FilterInfo getFilterInfo() {
            return this.filter;
        }

        public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
        }

        public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
        }
    }
}

