/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.client.NCMLongTimeDialog;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.bill.STDCostResourceTypeQtyFactory;
import com.kingdee.eas.ncm.std.bill.client.AbstractGenerateSTDCostResourceTypeQtyUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class GenerateSTDCostResourceTypeQtyUI
extends AbstractGenerateSTDCostResourceTypeQtyUI {
    private static final long serialVersionUID = 2170554437412635033L;

    public void onLoad() throws Exception {
        super.onLoad();
        if (!(this.getUIContext().get("STORAGE_ORG") instanceof StorageOrgUnitInfo)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"21_GenerateSTDCostDataUI"));
            SysUtil.abort();
        }
        StorageOrgUnitInfo storageOrg = (StorageOrgUnitInfo)this.getUIContext().get("STORAGE_ORG");
        this.storageOrgBizPromptBox.setValue((Object)storageOrg);
        this.filterSchemeF7(storageOrg);
    }

    private void filterSchemeF7(StorageOrgUnitInfo storageOrg) throws Exception {
        EntityViewInfo view = null;
        view = this.schemeBizPromptBox.getEntityViewInfo() == null ? new EntityViewInfo() : this.schemeBizPromptBox.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (storageOrg != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrg.getId().toString(), CompareType.EQUALS));
        }
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        PeriodInfo period = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)period.getEndDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("schemeType", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.schemeBizPromptBox.setEntityViewInfo(view);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.storageOrgBizPromptBox.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"21_GenerateSTDCostDataUI"));
            SysUtil.abort();
        }
        String storageOrgId = ((StorageOrgUnitInfo)this.storageOrgBizPromptBox.getValue()).getId().toString();
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        ArrayList<String> schemeList = new ArrayList<String>();
        if (this.schemeBizPromptBox.getValue() instanceof STDCostEstimateSchemeInfo) {
            schemeList.add(((STDCostEstimateSchemeInfo)this.schemeBizPromptBox.getValue()).getId().toString());
        } else if (this.schemeBizPromptBox.getValue() instanceof Object[]) {
            Object[] schemes = (Object[])this.schemeBizPromptBox.getValue();
            for (int i = 0; i < schemes.length; ++i) {
                if (!(schemes[i] instanceof STDCostEstimateSchemeInfo)) continue;
                schemeList.add(((STDCostEstimateSchemeInfo)schemes[i]).getId().toString());
            }
        }
        boolean onlyHasStdPrice = this.chkOnlyHasStdPrice.isSelected();
        this.generateData(storageOrgId, companyId, schemeList, onlyHasStdPrice);
    }

    private void generateData(final String storageOrgId, final String companyId, final List schemeList, final boolean onlyHasStdPrice) {
        NCMLongTimeDialog dialog = null;
        String hint = EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"22_GenerateSTDCostDataUI");
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new NCMLongTimeDialog((Frame)win, hint);
        } else if (win instanceof Dialog) {
            dialog = new NCMLongTimeDialog((Dialog)win, hint);
        }
        if (dialog != null) {
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    STDCostResourceTypeQtyFactory.getRemoteInstance().generateData(storageOrgId, companyId, schemeList, onlyHasStdPrice);
                    return "";
                }

                public void afterExec(Object result) throws Exception {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"23_GenerateSTDCostDataUI"));
                    GenerateSTDCostResourceTypeQtyUI.this.getUIWindow().close();
                }
            });
            dialog.show();
        }
    }
}

