/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.perflog;

import com.kingdee.eas.perflog.IMonitor;
import com.kingdee.eas.perflog.IMonitorEvent;
import com.kingdee.eas.perflog.IMonitorListener;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractMonitor
implements IMonitor {
    private boolean isValid = false;
    protected Set<IMonitorListener> listenerSet = new HashSet<IMonitorListener>();

    @Override
    public void addListener(IMonitorListener listener) {
        this.listenerSet.add(listener);
        this.isValid = true;
    }

    @Override
    public void removeListener(IMonitorListener listener) {
        this.listenerSet.remove(listener);
        if (this.listenerSet.isEmpty()) {
            this.isValid = false;
        }
    }

    @Override
    public void eventStart(IMonitorEvent event) {
        for (IMonitorListener listener : this.listenerSet) {
            listener.monitorEventStart(event);
        }
    }

    @Override
    public void eventEnd(IMonitorEvent event) {
        for (IMonitorListener listener : this.listenerSet) {
            listener.monitorEventEnd(event);
        }
    }

    @Override
    public void eventPerformed(IMonitorEvent event) {
        for (IMonitorListener listener : this.listenerSet) {
            listener.monitorEventPerformed(event);
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }
}

