/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.perflog.client.log.swingrpc;

import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.perflog.AbstractPerfLog;
import com.kingdee.eas.perflog.IMonitorEvent;
import com.kingdee.eas.perflog.PerfBean;
import com.kingdee.eas.perflog.RpcEvent;
import com.kingdee.eas.perflog.client.PerfLogConfig;
import com.kingdee.eas.perflog.client.log.swingrpc.SwingRpcLogMBean;
import com.kingdee.eas.perflog.client.monitor.swing.SwingEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;

public class SwingRpcLog
extends AbstractPerfLog
implements SwingRpcLogMBean {
    private ThreadLocal<Integer> stackLevelLocal = new ThreadLocal();
    private ArrayBlockingQueue<HashMap> perfQueue = new ArrayBlockingQueue(1000);

    public SwingRpcLog() {
        this.setConfig(PerfLogConfig.getInstance());
        this.setMonitorSet("swingmonitor;userinputmonitor;rpcmonitor");
    }

    @Override
    public void setValid(boolean valid) {
        if (this.isValid() == valid) {
            return;
        }
        this.perfQueue.clear();
        super.setValid(valid);
    }

    @Override
    public void monitorEventStart(IMonitorEvent event) {
        if (event instanceof SwingEvent) {
            this.startAction((SwingEvent)event);
        }
    }

    @Override
    public void monitorEventEnd(IMonitorEvent event) {
        if (event instanceof SwingEvent) {
            this.endAction((SwingEvent)event);
        }
    }

    @Override
    public void monitorEventPerformed(IMonitorEvent event) {
        if (event instanceof RpcEvent) {
            this.rpcPerformed((RpcEvent)event);
        }
    }

    private void rpcPerformed(RpcEvent event) {
        PerfBean action = (PerfBean)this.transaction.get();
        if (action == null) {
            return;
        }
        PerfBean perfBean = action;
        perfBean.rpcBytes = perfBean.rpcBytes + (event.requestBytes + event.responseBytes);
        perfBean = action;
        Integer n = perfBean.rpcNum;
        Integer n2 = perfBean.rpcNum = Integer.valueOf(perfBean.rpcNum + 1);
        perfBean = action;
        perfBean.rpcTime = perfBean.rpcTime + event.timespan;
        perfBean = action;
        perfBean.netTime = perfBean.netTime + event.netTime;
    }

    private void startAction(SwingEvent event) {
        Integer stackLevel = this.stackLevelLocal.get();
        if (stackLevel == null) {
            stackLevel = new Integer(1);
            this.stackLevelLocal.set(stackLevel);
            PerfBean action = new PerfBean();
            action.id = event.id;
            action.name = event.ui + "." + event.action;
            this.startTransaction(action);
        }
    }

    private void endAction(SwingEvent event) {
        Integer stackLevel = this.stackLevelLocal.get();
        if (stackLevel == null) {
            return;
        }
        this.stackLevelLocal.remove();
        PerfBean action = (PerfBean)this.transaction.get();
        if (action == null) {
            return;
        }
        action.name = event.ui + "." + event.action;
        action.url = UIConfig.getUrl();
        SysContext sysContext = SysContext.getSysContext();
        if (sysContext != null) {
            action.dc = sysContext.getDCNumber();
            action.easUser = sysContext.getUserName();
            OrgUnitInfo orgUnit = sysContext.getCurrentOrgUnit();
            if (orgUnit != null) {
                action.ou = orgUnit.getNumber();
            }
        }
        this.endTransaction();
        if (!action.isFilter && this.isLog()) {
            this.perfQueue.offer(action.toMap());
        }
    }

    @Override
    public Collection<HashMap> getPerfQueue() {
        ArrayList<HashMap> c = new ArrayList<HashMap>();
        this.perfQueue.drainTo(c);
        return c;
    }
}

