/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.IQualityOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.QualityOrgUnitCollection;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.qm.basedata.IQCItem;
import com.kingdee.eas.qm.basedata.QCAnalysisMethodEnum;
import com.kingdee.eas.qm.basedata.QCGroupInfo;
import com.kingdee.eas.qm.basedata.QCIdentityEnum;
import com.kingdee.eas.qm.basedata.QCItemAttributeEnum;
import com.kingdee.eas.qm.basedata.QCItemExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCItemExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCItemFactory;
import com.kingdee.eas.qm.basedata.QCItemGroupInfo;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCValueAcquisitionModeEnum;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.client.AbstractQCItemEditUI;
import com.kingdee.eas.qm.common.DBCheckedStatusEnum;
import com.kingdee.eas.qm.common.cache.QMBatchExecuteParam;
import com.kingdee.eas.qm.common.codingrule.QMCodingRuleData;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMPrecisionUtil;
import com.kingdee.eas.qm.common.util.QMResourceUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.util.backup.QMHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class QCItemEditUI
extends AbstractQCItemEditUI {
    private static final long serialVersionUID = 457482477687726062L;
    private static final Logger logger = CoreUIObject.getLogger(QCItemEditUI.class);
    private boolean canEditAll = true;
    private static final String qualityOrgOql = "select * where isBizUnit=1 and isSealUp=0";
    private IKDTextComponent[] cmpts = new IKDTextComponent[]{this.prmtItemGroup, this.txtNumber, this.txtName, this.txtseqNo, this.txtSimpleName, this.qCItemAttr, this.analysisMethod, this.qCIdentity, this.qCValueType, this.txtenums, this.qCValueAcquisitionMode, this.txtdataPrecision, this.txtdefaultValue, this.cbodefaultValue, this.chkisModify, this.chkisVisibleForQCC, this.chkisRuinous, this.txtDescription};
    private boolean isShowNumberMessage = false;
    private ItemListener qCValueTypeItemListener;
    private ItemListener defaultValueItemListener;
    private ItemListener analysisMethodItemListener;
    private DataChangeListener delegOrgUnitDataChangeListener;
    private ItemListener qCIdentityItemListener;
    private ItemListener chkisModifyItemListener;
    private DocumentListener enumsDocumentListener;

    public QCItemEditUI() throws Exception {
        logger.debug((Object)"QCItemEditUI");
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        Context mainOrgCtx = this.getMainOrgContext();
        Context newCtx = null;
        if (mainOrgCtx != null) {
            QualityOrgUnitInfo quan = (QualityOrgUnitInfo)this.getMainOrgInfo();
            newCtx = new Context();
            newCtx.put((Object)OrgType.ControlUnit, (Object)(quan == null ? null : quan.getCU()));
            newCtx.put((Object)OrgType.Quality, (Object)quan);
        }
        return QCItemFactory.getRemoteInstanceWithObjectContext(newCtx);
    }

    @Override
    public void loadFields() {
        this.removeListeners();
        super.loadFields();
        boolean isModify = this.editData.isIsModify();
        this.chkisModify.setSelected(isModify);
        this.qCIdentity.setSelectedItem((Object)this.editData.getQCIdentity());
        this.qCValueType.setSelectedItem((Object)this.editData.getQCValueType());
        QCItemExtendAttrCollection extAttr = this.editData.getExtendAttr();
        if (extAttr != null && extAttr.size() > 0) {
            QCItemExtendAttrInfo info = extAttr.get(0);
            this.prmptDelegOrgUnit.setData((Object)info.getDelegOrgUnit());
            this.prmtQCGroup.setData((Object)info.getQCGroup());
        }
        if (this.editData.getDefaultValue() != null) {
            this.cbodefaultValue.setSelectedItem((Object)this.editData.getDefaultValue());
        }
        this.storeFields();
        this.addListeners();
    }

    @Override
    public void storeFields() {
        QCItemExtendAttrCollection extAttr;
        String strSeqNo;
        super.storeFields();
        String strDataPrecision = this.txtdataPrecision.getText();
        if (strDataPrecision == null || "".equals(strDataPrecision)) {
            this.editData.setDataPrecision(0);
        }
        if ((strSeqNo = this.txtseqNo.getText()) == null || "".equals(strSeqNo)) {
            this.editData.setSeqNo(0);
        }
        if ((extAttr = this.editData.getExtendAttr()) != null && extAttr.size() > 0) {
            QCItemExtendAttrInfo info = extAttr.get(0);
            info.setDelegOrgUnit((QualityOrgUnitInfo)this.prmptDelegOrgUnit.getData());
            info.setQCGroup((QCGroupInfo)this.prmtQCGroup.getData());
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("qualityOrgUnit.id"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.name"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.number"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("group.id"));
        sic.add(new SelectorItemInfo("group.number"));
        sic.add(new SelectorItemInfo("group.name"));
        sic.add(new SelectorItemInfo("EffectedStatus"));
        return sic;
    }

    @Override
    protected IObjectValue createNewData() {
        IObjectValue data = this.doCreateNewData(null);
        return data;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected IObjectValue newInstanceData() {
        QCItemInfo objectValue = new QCItemInfo();
        QualityOrgUnitInfo info = (QualityOrgUnitInfo)this.getMainOrgInfo();
        objectValue.setAnalysisMethod(QCAnalysisMethodEnum.quantitativeAnalysis);
        objectValue.setQCItemAttr(QCItemAttributeEnum.checkItem);
        objectValue.setQCIdentity(QCIdentityEnum.measure);
        objectValue.setQCValueType(QCValueTypeEnum.number);
        objectValue.setQCValueAcquisitionMode(QCValueAcquisitionModeEnum.BYQCITEM);
        this.txtenums.setEnabled(false);
        objectValue.setQualityOrgUnit(info);
        objectValue.setCheckedStatus(DBCheckedStatusEnum.UNAUDITED);
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Map map = this.getUIContext();
        QCItemGroupInfo group = (QCItemGroupInfo)map.get("ParentNode");
        if (group != null) {
            objectValue.setGroup(group);
        }
        objectValue.setDeletedStatus(DeletedStatusEnum.NORMAL);
        objectValue.setDataPrecision(4);
        QCItemExtendAttrInfo item = this.getDefaultExtendAttrInfo(info);
        objectValue.getExtendAttr().add(item);
        return objectValue;
    }

    private QCItemExtendAttrInfo getDefaultExtendAttrInfo(QualityOrgUnitInfo info) {
        QualityOrgUnitCollection orgCollection = null;
        try {
            orgCollection = QualityOrgUnitFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getQualityOrgUnitCollection(qualityOrgOql);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        QualityOrgUnitInfo delegQualityOrgUnitInfo = null;
        if (orgCollection != null && orgCollection.contains(info)) {
            delegQualityOrgUnitInfo = info;
        }
        QCItemExtendAttrInfo item = new QCItemExtendAttrInfo();
        item.setQualityOrgUnit(info);
        item.setDelegOrgUnit(delegQualityOrgUnitInfo);
        return item;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        QCItemInfo value = ((IQCItem)this.getBizInterface()).getExtValue(pk, this.getMergedSelector());
        List list = this.getValueFecthCache((IObjectValue)value);
        this.getCacheManager().batchInvoke(null, list.toArray(new QMBatchExecuteParam[list.size()]));
        return value;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        DBCheckedStatusEnum v;
        if (this.canEditAll && (v = this.editData.getCheckedStatus()) != null && v == DBCheckedStatusEnum.AUDITED) {
            String info = EASResource.getString((String)"com.kingdee.eas.qm.basedata.client.BasedataResource", (String)"Msg_AuditedCannotEdit");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmptDelegOrgUnit.getData() == null) {
            this.prmtQCGroup.setData(null);
        }
        super.actionSubmit_actionPerformed(e);
    }

    private void lockComponents() {
        this.prmptDelegOrgUnit.setEditable(true);
        this.prmptDelegOrgUnit.setAccessAuthority(0);
        this.prmtQCGroup.setEditable(true);
        this.prmtQCGroup.setAccessAuthority(0);
        this.btnSubmit.setEnabled(true);
        this.btnRemove.setEnabled(false);
    }

    private boolean checkCanEditAll() {
        String currentORG = ((QualityOrgUnitInfo)this.getMainOrgInfo()).getId().toString();
        String authorORG = ((QCItemInfo)this.getDataObject()).getQualityOrgUnit().getId().toString();
        return currentORG.equals(authorORG);
    }

    protected KDBizPromptBox getMainBizOrg() {
        return null;
    }

    protected boolean isSuportAudit() {
        return false;
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }

    public void onLoad() throws Exception {
        this.getUIContextManager().registerMainBizOrgF7(this.prmptDelegOrgUnit, this.getMainType(), this.getAddNewPermItemName(), false);
        this.createListeners();
        super.onLoad();
        this.regDelegateQualityOrgFilter();
        this.regQCItemGroupFilter();
        QualityOrgUnitInfo qcOrgInfo = (QualityOrgUnitInfo)this.prmptDelegOrgUnit.getData();
        this.delegOrgUnitChange(qcOrgInfo);
    }

    protected void createListeners() {
        this.qCValueTypeItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QCItemEditUI.this.qCValueType_actionPerformed();
            }
        };
        this.defaultValueItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QCItemEditUI.this.defaultValue_actionPerformed();
            }
        };
        this.analysisMethodItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QCItemEditUI.this.analysisMethodChangge(null);
            }
        };
        this.delegOrgUnitDataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                QCItemEditUI.this.delegOrgUnit_DataChangedPerformed(eventObj);
            }
        };
        this.qCIdentityItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QCItemEditUI.this.qCIdentity_itemPerformed(null);
            }
        };
        this.chkisModifyItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QCItemEditUI.this.chkisModify_actionPerformed();
            }
        };
        this.enumsDocumentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                QCItemEditUI.this.changeDefalutValueCompent(null, null);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                QCItemEditUI.this.changeDefalutValueCompent(null, null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                QCItemEditUI.this.changeDefalutValueCompent(null, null);
            }
        };
    }

    protected void removeListeners() {
        this.qCValueType.removeItemListener(this.qCValueTypeItemListener);
        this.cbodefaultValue.removeItemListener(this.defaultValueItemListener);
        this.analysisMethod.removeItemListener(this.analysisMethodItemListener);
        this.prmptDelegOrgUnit.removeDataChangeListener(this.delegOrgUnitDataChangeListener);
        this.qCIdentity.removeItemListener(this.qCIdentityItemListener);
        this.chkisModify.removeItemListener(this.chkisModifyItemListener);
        this.txtenums.getDocument().removeDocumentListener(this.enumsDocumentListener);
    }

    protected void addListeners() {
        this.qCValueType.addItemListener(this.qCValueTypeItemListener);
        this.cbodefaultValue.addItemListener(this.defaultValueItemListener);
        this.analysisMethod.addItemListener(this.analysisMethodItemListener);
        this.prmptDelegOrgUnit.addDataChangeListener(this.delegOrgUnitDataChangeListener);
        this.qCIdentity.addItemListener(this.qCIdentityItemListener);
        this.chkisModify.addItemListener(this.chkisModifyItemListener);
        this.txtenums.getDocument().addDocumentListener(this.enumsDocumentListener);
    }

    public void regDelegateQualityOrgFilter() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)Boolean.FALSE, CompareType.EQUALS));
        ev.setFilter(filter);
        this.prmptDelegOrgUnit.setEntityViewInfo(ev);
    }

    private void regQCItemGroupFilter() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.EQUALS));
        ev.setFilter(filter);
        this.prmtItemGroup.setEntityViewInfo(ev);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.txtseqNo.setValue(null);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        QCValueAcquisitionModeEnum mode;
        super.verifyInput(e);
        QCValueTypeEnum type = (QCValueTypeEnum)((Object)this.qCValueType.getSelectedItem());
        if (type == QCValueTypeEnum.number && this.txtdefaultValue.getText() != null && this.txtdefaultValue.getText().length() > 0) {
            BigDecimal number = null;
            try {
                number = new BigDecimal(this.txtdefaultValue.getText());
            }
            catch (Exception ex) {
                this.isShowNumberMessage = true;
                String info = EASResource.getString((String)"com.kingdee.eas.qm.basedata.client.BasedataResource", (String)"IsNotNumer");
                MsgBox.showInfo((Component)((Object)this), (String)info);
                this.txtdefaultValue.requestFocus();
                SysUtil.abort();
            }
            if (QMPrecisionUtil.BigDecimal_MaxValue.compareTo(number) < 0) {
                MsgBox.showInfo((String)QMResourceUtils.getMessage((String)"com.kingdee.eas.qm.basedata.QCItemResource", (String)"DefaultValueMustLessMax"));
                this.txtdefaultValue.requestFocus();
                SysUtil.abort();
            }
            if (QMPrecisionUtil.BigDecimal_MinValue.compareTo(number) > 0) {
                MsgBox.showInfo((String)QMResourceUtils.getMessage((String)"com.kingdee.eas.qm.basedata.QCItemResource", (String)"DefaultValueMustMoreMin"));
                this.txtdefaultValue.requestFocus();
                SysUtil.abort();
            }
            this.txtdefaultValue.setText(QMStringUtils.stripTrailingZeros((BigDecimal)number));
        }
        if (!(type != QCValueTypeEnum.number && type != QCValueTypeEnum.formula || this.chkisModify.isSelected())) {
            Integer dataPrecision = this.txtdataPrecision.getIntegerValue();
            if (dataPrecision == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCItemResource", (String)"DataPrecision_Cannot_Null"));
                this.txtdataPrecision.requestFocus();
                SysUtil.abort();
            } else if (dataPrecision > 8 || dataPrecision < -8) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCItemResource", (String)"DataPrecision_Confine"));
                this.txtdataPrecision.requestFocus();
                SysUtil.abort();
            }
        }
        if ((mode = (QCValueAcquisitionModeEnum)((Object)this.qCValueAcquisitionMode.getSelectedItem())) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCItemResource", (String)"QCValueAcquisitionModeEnum_Cannot_Null"));
            this.qCValueAcquisitionMode.requestFocus();
            SysUtil.abort();
        }
        if (type == QCValueTypeEnum.formula && (mode = (QCValueAcquisitionModeEnum)((Object)this.qCValueAcquisitionMode.getSelectedItem())) != QCValueAcquisitionModeEnum.BYQCITEM) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCItemResource", (String)"FormulaEnums_NotMatch_ByQcItem"));
            this.qCValueAcquisitionMode.requestFocus();
            SysUtil.abort();
        }
        if (type == QCValueTypeEnum.enumvalue) {
            if (QMHelper.isEmpty((String)this.txtenums.getText())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCItemResource", (String)"Enums_Cannot_Null"));
                this.txtenums.requestFocus();
                SysUtil.abort();
            } else {
                String[] list = this.txtenums.getText().split("#", -1);
                for (int i = 0; i < list.length; ++i) {
                    if (!QMHelper.isEmpty((String)list[i])) continue;
                    MsgBox.showInfo((String)QMResourceUtils.getMessage((String)"com.kingdee.eas.qm.basedata.QCItemResource", (String)"Enums_Cannot_Defined", (String[])new String[]{"\n"}));
                    this.txtenums.requestFocus();
                    SysUtil.abort();
                }
            }
        }
    }

    @Override
    protected void txtdefaultValue_focusLost(FocusEvent e) throws Exception {
        QCValueTypeEnum type;
        if (!this.isShowNumberMessage && (type = (QCValueTypeEnum)((Object)this.qCValueType.getSelectedItem())) == QCValueTypeEnum.number && this.txtdefaultValue.getText() != null && this.txtdefaultValue.getText().length() > 0) {
            BigDecimal number = null;
            try {
                number = new BigDecimal(this.txtdefaultValue.getText());
            }
            catch (Exception ex) {
                String info = EASResource.getString((String)"com.kingdee.eas.qm.basedata.client.BasedataResource", (String)"IsNotNumer");
                MsgBox.showInfo((Component)((Object)this), (String)info);
                this.txtdefaultValue.setText(null);
                this.txtdefaultValue.requestFocus();
                SysUtil.abort();
            }
            if (QMPrecisionUtil.BigDecimal_MaxValue.compareTo(number) < 0) {
                MsgBox.showInfo((String)QMResourceUtils.getMessage((String)"com.kingdee.eas.qm.basedata.QCItemResource", (String)"DefaultValueMustLessMax"));
                this.txtdefaultValue.setText(String.valueOf(QMPrecisionUtil.BigDecimal_MaxValue));
                this.txtdefaultValue.requestFocus();
                SysUtil.abort();
            }
            if (QMPrecisionUtil.BigDecimal_MinValue.compareTo(number) > 0) {
                MsgBox.showInfo((String)QMResourceUtils.getMessage((String)"com.kingdee.eas.qm.basedata.QCItemResource", (String)"DefaultValueMustMoreMin"));
                this.txtdefaultValue.setText(String.valueOf(QMPrecisionUtil.BigDecimal_MinValue));
                this.txtdefaultValue.requestFocus();
                SysUtil.abort();
            }
            this.txtdefaultValue.setText(QMStringUtils.stripTrailingZeros((BigDecimal)number));
        }
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
        super.setFieldsNull(arg0);
        QCItemInfo info = (QCItemInfo)arg0;
        info.setCheckedStatus(DBCheckedStatusEnum.UNAUDITED);
        info.setQualityOrgUnit((QualityOrgUnitInfo)this.getMainOrgInfo());
        info.getExtendAttr().get(0).setId(null);
    }

    protected void initDataStatus() {
        this.removeListeners();
        super.initDataStatus();
        QCItemInfo info = (QCItemInfo)this.getDataObject();
        this.canEditAll = this.checkCanEditAll();
        if (this.canEditAll && info != null && info.getId() != null) {
            if (this.getOprtState().equals(OprtState.EDIT)) {
                this.btnEdit.setEnabled(false);
            } else {
                this.btnEdit.setEnabled(true);
            }
        } else {
            this.btnEdit.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnRemove.setEnabled(false);
        } else {
            this.btnRemove.setEnabled(this.canEditAll);
        }
        if ("VIEW".equals(this.getOprtState())) {
            this.btnEdit.setEnabled(true);
            for (int i = 0; i < this.cmpts.length; ++i) {
                this.cmpts[i].setEnabled(true);
                this.cmpts[i].setAccessAuthority(1);
            }
        } else if (this.canEditAll) {
            for (int i = 0; i < this.cmpts.length; ++i) {
                this.cmpts[i].setEnabled(true);
                this.cmpts[i].setAccessAuthority(0);
            }
            if (QCValueTypeEnum.number == info.getQCValueType()) {
                this.txtenums.setEnabled(false);
            } else if (QCValueTypeEnum.formula == info.getQCValueType()) {
                this.txtenums.setEnabled(false);
                this.txtdefaultValue.setEnabled(false);
                this.txtdataPrecision.setEnabled(false);
            } else if (QCValueTypeEnum.enumvalue == info.getQCValueType()) {
                this.txtdataPrecision.setEnabled(false);
                this.chkisModify.setEnabled(false);
                this.chkisModify.setSelected(false);
            } else if (QCValueTypeEnum.text == info.getQCValueType()) {
                this.txtdataPrecision.setEnabled(false);
                this.txtenums.setEnabled(false);
                this.chkisModify.setEnabled(false);
                this.chkisModify.setSelected(false);
            }
            try {
                String orgID = "";
                orgID = this.getMainOrgInfo() != null ? this.getMainOrgInfo().getId().toString() : SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                this.getCodingRuleStrategy().setNumberFieldEnableStatus(this.getMainOrgContext(), this.getNumTextField(), this.getDataObject(), orgID);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        } else {
            for (int i = 0; i < this.cmpts.length; ++i) {
                this.cmpts[i].setEnabled(false);
                this.cmpts[i].setAccessAuthority(0);
            }
        }
        this.analysisMethodChangge(info.getAnalysisMethod());
        this.qCIdentity_itemPerformed(info.getQCIdentity());
        if (info.getQCValueType() != null) {
            this.qCValueType.setSelectedItem((Object)info.getQCValueType());
        }
        QCValueTypeEnum type = info.getQCValueType();
        this.changeDefalutValueCompent(type, info.getEnums());
        if (info.isIsModify()) {
            this.txtdataPrecision.setEnabled(false);
        } else {
            if ((type == QCValueTypeEnum.number || type == QCValueTypeEnum.formula) && this.checkCanEditAll()) {
                this.txtdataPrecision.setEnabled(true);
            }
            if (type == QCValueTypeEnum.text || type == QCValueTypeEnum.enumvalue) {
                this.txtdataPrecision.setEnabled(false);
            }
        }
        this.addListeners();
    }

    public List getInitCache() {
        List list = super.getInitCache();
        QMBatchExecuteParam p1 = new QMBatchExecuteParam("com.kingdee.eas.basedata.org.QualityOrgUnit", IQualityOrgUnit.class, "getQualityOrgUnitCollection", new Class[]{String.class}, new Object[]{qualityOrgOql});
        list.add(p1);
        return list;
    }

    protected void doFieldPermission() throws Exception {
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
    }

    protected void initListener() {
        super.initListener();
    }

    protected void changeDefalutValueCompent(QCValueTypeEnum type, String txt) {
        if (type == null) {
            type = (QCValueTypeEnum)((Object)this.qCValueType.getSelectedItem());
        }
        if (txt == null) {
            txt = this.txtenums.getText();
        }
        if (type == QCValueTypeEnum.enumvalue && !QMHelper.isEmpty((String)txt)) {
            Object[] list = QMHelper.parseEnumString((String)txt);
            Object tempValue = this.cbodefaultValue.getSelectedItem();
            this.cbodefaultValue.removeAllItems();
            this.cbodefaultValue.addItems(list);
            this.cbodefaultValue.setSelectedItem(tempValue);
            this.contdefaultValue.setBoundEditor((JComponent)this.cbodefaultValue);
            this.cbodefaultValue.setVisible(true);
            this.txtdefaultValue.setVisible(false);
        } else {
            this.contdefaultValue.setBoundEditor((JComponent)this.txtdefaultValue);
            this.txtdefaultValue.setVisible(true);
            this.cbodefaultValue.setVisible(false);
        }
    }

    protected void qCIdentity_itemPerformed(QCIdentityEnum type) {
        if (type == null) {
            type = (QCIdentityEnum)((Object)this.qCIdentity.getSelectedItem());
        }
        if (type == QCIdentityEnum.measure) {
            this.qCValueType.removeAllItems();
            this.qCValueType.addItem((Object)QCValueTypeEnum.number);
            this.qCValueType.addItem((Object)QCValueTypeEnum.formula);
        } else if (type == QCIdentityEnum.point) {
            this.qCValueType.removeAllItems();
            this.qCValueType.addItem((Object)QCValueTypeEnum.text);
            this.qCValueType.addItem((Object)QCValueTypeEnum.enumvalue);
        } else if (this.qCValueType.getItemCount() != QCValueTypeEnum.getEnumList().size()) {
            this.qCValueType.removeAllItems();
            this.qCValueType.addItems(QCValueTypeEnum.getEnumList().toArray());
        }
    }

    public void delegOrgUnit_DataChangedPerformed(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() == null) {
            this.prmtQCGroup.setData(null);
            this.prmtQCGroup.setEnabled(false);
        }
        if (!(eventObj.getNewValue() == null || eventObj.getOldValue() != null && eventObj.getOldValue().equals(eventObj.getNewValue()))) {
            QualityOrgUnitInfo qcOrgInfo = (QualityOrgUnitInfo)eventObj.getNewValue();
            this.delegOrgUnitChange(qcOrgInfo);
            this.prmtQCGroup.setData(null);
            this.prmtQCGroup.setEnabled(true);
        }
    }

    protected void defaultValue_actionPerformed() {
        QCValueTypeEnum type = (QCValueTypeEnum)((Object)this.qCValueType.getSelectedItem());
        if (type == QCValueTypeEnum.enumvalue) {
            String item = (String)this.cbodefaultValue.getSelectedItem();
            this.txtdefaultValue.setText(item);
        }
    }

    public void qCValueType_actionPerformed() {
        QCValueTypeEnum type = (QCValueTypeEnum)((Object)this.qCValueType.getSelectedItem());
        if (type == QCValueTypeEnum.number) {
            this.txtdataPrecision.setEnabled(true);
            this.chkisModify.setEnabled(true);
            this.chkisModify.setSelected(false);
            this.txtenums.setEnabled(false);
            this.txtdefaultValue.setEditable(true);
            this.txtdefaultValue.setEnabled(true);
            this.txtdataPrecision.setValue(null);
            this.txtenums.setText(null);
            this.txtdefaultValue.setText(null);
        } else if (type == QCValueTypeEnum.formula) {
            this.txtdataPrecision.setEnabled(true);
            this.chkisModify.setEnabled(true);
            this.chkisModify.setSelected(false);
            this.txtenums.setEnabled(false);
            this.txtdefaultValue.setEditable(false);
            this.txtdataPrecision.setValue(null);
            this.txtenums.setText(null);
            this.txtdefaultValue.setText(null);
        } else if (type == QCValueTypeEnum.enumvalue) {
            this.txtdataPrecision.setEnabled(false);
            this.chkisModify.setEnabled(false);
            this.chkisModify.setSelected(false);
            this.txtenums.setEnabled(true);
            this.txtdefaultValue.setEditable(false);
            this.txtdataPrecision.setValue(null);
            this.txtdefaultValue.setText(null);
        } else if (type == QCValueTypeEnum.text) {
            this.txtdataPrecision.setEnabled(false);
            this.chkisModify.setEnabled(false);
            this.chkisModify.setSelected(false);
            this.txtenums.setEnabled(false);
            this.txtdefaultValue.setEditable(true);
            this.txtdefaultValue.setEnabled(true);
            this.txtdataPrecision.setValue(null);
            this.txtenums.setText(null);
            this.txtdefaultValue.setText(null);
        }
    }

    public void chkisModify_actionPerformed() {
        QCValueTypeEnum type = (QCValueTypeEnum)((Object)this.qCValueType.getSelectedItem());
        if (this.chkisModify.isSelected()) {
            this.txtdataPrecision.setEnabled(false);
            this.txtdataPrecision.setValue(null);
        } else {
            if ((type == QCValueTypeEnum.number || type == QCValueTypeEnum.formula) && this.checkCanEditAll()) {
                this.txtdataPrecision.setEnabled(true);
                this.txtdataPrecision.setValue((Object)QMConstant.ZERO);
            }
            if (type == QCValueTypeEnum.text || type == QCValueTypeEnum.enumvalue) {
                this.txtdataPrecision.setEnabled(false);
                this.txtdataPrecision.setValue(null);
            }
        }
    }

    private void analysisMethodChangge(QCAnalysisMethodEnum type) {
        if (type == null) {
            type = (QCAnalysisMethodEnum)((Object)this.analysisMethod.getSelectedItem());
        }
        Object tempSelectedItem = this.qCIdentity.getSelectedItem();
        if (type == QCAnalysisMethodEnum.quantitativeAnalysis) {
            this.qCIdentity.removeAllItems();
            this.qCIdentity.addItem((Object)QCIdentityEnum.measure);
        } else {
            this.qCIdentity.removeAllItems();
            this.qCIdentity.addItems(QCIdentityEnum.getEnumList().toArray());
        }
        this.qCIdentity.setSelectedItem(tempSelectedItem);
    }

    private void delegOrgUnitChange(QualityOrgUnitInfo qcOrgInfo) {
        if (qcOrgInfo == null) {
            return;
        }
        String orgUnitID = qcOrgInfo.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)orgUnitID, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtQCGroup.setEntityViewInfo(view);
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.oprtState) && this.getMainOrgInfo() != null && this.editData != null) {
            try {
                QMCodingRuleData qmCodeData = this.getCodingRuleStrategy().getCodingRuleData(this.getMainOrgContext(), (IObjectValue)this.editData, this.getMainOrgInfo().getId().toString());
                if (qmCodeData == null || qmCodeData.isAddView()) {
                    this.getNumTextField().setAccessAuthority(0);
                    this.getNumTextField().setEnabled(true);
                }
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    protected void unLockUI() {
        super.unLockUI();
    }
}

