/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client;

import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.qm.basedata.QCCalcuationMultipleEnum;
import com.kingdee.eas.qm.basedata.QCModifyModeFactory;
import com.kingdee.eas.qm.basedata.QCModifyModeInfo;
import com.kingdee.eas.qm.basedata.client.AbstractQCModifyModeEditUI;
import com.kingdee.eas.qm.basedata.client.util.QCModifyModeClientUtils;
import com.kingdee.eas.qm.common.DBCheckedStatusEnum;
import com.kingdee.eas.qm.common.ctx.QMContextHelperFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class QCModifyModeEditUI
extends AbstractQCModifyModeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(QCModifyModeEditUI.class);
    private DataChangeListener txtModifyOffset_dataChangeListener = null;

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return QCModifyModeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    protected IObjectValue createNewData() {
        IObjectValue data = this.doCreateNewData(null);
        return data;
    }

    protected IObjectValue newInstanceData() {
        QCModifyModeInfo info = new QCModifyModeInfo();
        QualityOrgUnitInfo orgInfo = QMContextHelperFactory.getRemoteInstance().getCurrentQuality();
        info.setQualityOrgUnit(orgInfo);
        info.setCheckedStatus(DBCheckedStatusEnum.UNAUDITED);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setModifyOffset(new BigDecimal(1));
        info.setMultiple(QCCalcuationMultipleEnum.one);
        info.setDataPrecision(0);
        return info;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (!this.verifyModifyOffset()) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("verifyModifyOffset"));
            this.txtModifyOffset.requestFocus();
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtModifyOffset.setPrecision(8);
        this.txtModifyOffset.setRemoveingZeroInDispaly(false);
        this.txtModifyOffset.setRemoveingZeroInEdit(false);
        this.txtModifyOffset.setMaximumValue((Comparable)new BigDecimal("9999999999.99999999"));
        if (this.txtModifyOffset_dataChangeListener == null) {
            this.txtModifyOffset_dataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        QCModifyModeEditUI.this.verifyModifyOffset();
                    }
                    catch (Exception exc) {
                        QCModifyModeEditUI.this.handUIException(exc);
                    }
                }
            };
            this.txtModifyOffset.addDataChangeListener(this.txtModifyOffset_dataChangeListener);
        }
    }

    private boolean verifyModifyOffset() {
        BigDecimal obj = this.txtModifyOffset.getBigDecimalValue();
        HashMap map = QCModifyModeClientUtils.isValidOffset(obj);
        int multipleValue = 0;
        Integer percision = null;
        if (map != null) {
            multipleValue = (Integer)map.get("MultipleValue");
            percision = (Integer)map.get("Percision");
        }
        this.txtDataPrecision.setValue(percision);
        switch (multipleValue) {
            case 1: {
                this.combMultiple.setSelectedItem((Object)QCCalcuationMultipleEnum.one);
                return true;
            }
            case 2: {
                this.combMultiple.setSelectedItem((Object)QCCalcuationMultipleEnum.two);
                return true;
            }
            case 5: {
                this.combMultiple.setSelectedItem((Object)QCCalcuationMultipleEnum.five);
                return true;
            }
        }
        return false;
    }

    private String getResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCModifyModeResource", (String)strKey);
    }

    protected boolean isSuportAudit() {
        return false;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("checkedstatus"));
        sic.add(new SelectorItemInfo("EffectedStatus"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
        super.setFieldsNull(arg0);
        QCModifyModeInfo info = (QCModifyModeInfo)arg0;
        info.setCheckedStatus(DBCheckedStatusEnum.UNAUDITED);
    }
}

