/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.qm.basedata.InspectionLevelEnum;
import com.kingdee.eas.qm.basedata.QCAQLDataCollection;
import com.kingdee.eas.qm.basedata.QCAQLDataInfo;
import com.kingdee.eas.qm.basedata.QCAQLSetInfo;
import com.kingdee.eas.qm.basedata.QCPlanAcceptStandardCollection;
import com.kingdee.eas.qm.basedata.QCPlanAcceptStandardInfo;
import com.kingdee.eas.qm.basedata.QCSamplingPlanFactory;
import com.kingdee.eas.qm.basedata.QCSamplingPlanInfo;
import com.kingdee.eas.qm.basedata.QCSamplingPlanTightDegreeEntryCollection;
import com.kingdee.eas.qm.basedata.QCSamplingPlanTightDegreeEntryInfo;
import com.kingdee.eas.qm.basedata.QCSamplingPlanTreeInfo;
import com.kingdee.eas.qm.basedata.QCTightDegreeSetInfo;
import com.kingdee.eas.qm.basedata.SampleModeEnum;
import com.kingdee.eas.qm.basedata.SampleTableEnum;
import com.kingdee.eas.qm.basedata.client.AbstractQCSamplingPlanEditUI;
import com.kingdee.eas.qm.basedata.client.util.EntrysDetailPanelManager;
import com.kingdee.eas.qm.common.DBCheckedStatusEnum;
import com.kingdee.eas.qm.common.IQMCoreDataBase;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMClientControlStrategy;
import com.kingdee.eas.qm.common.client.util.QMPromptDialogFactory;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class QCSamplingPlanEditUI
extends AbstractQCSamplingPlanEditUI {
    private static final Logger logger = CoreUIObject.getLogger(QCSamplingPlanEditUI.class);
    protected static final String PROP_FILE = "com.kingdee.eas.qm.basedata.QCSamplingPlanResource";
    private SampleTableEnum curSamTableItem = null;
    private String panelName = "";
    private int curTightDegreeRow = -1;
    private int curAQLRow = -1;
    private boolean aqlRemoveEnded = true;
    private boolean copyEnded = true;

    public void onLoad() throws Exception {
        super.onLoad();
        EntrysDetailPanelManager entrysPanelManager = EntrysDetailPanelManager.getInstance((JPanel[])new KDPanel[]{this.PanelTightDegree, this.PanelAQL, this.PanelAcceptStandard}, (Action)this.actionAddLine, (Action)this.actionInsertLine, (Action)this.actionRemoveLine);
        entrysPanelManager.regPanel();
        if (this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegree) {
            this.PaneCondition.remove((Component)this.PanelAQL);
            KDTableUtils.setShowColumn((KDTable)this.kdtAcceptStandard, (String[])new String[]{"tightDegree", "characterCode", "lotSize", "sampleSize", "Ac1", "Re1"});
        }
    }

    protected void initKeyStroke() {
        super.initKeyStroke();
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("shift F8"), "cancel");
        actionMap.put("cancel", (Action)this.actionCancel);
        this.menuItemCancel.setAccelerator(KeyStroke.getKeyStroke("shift F8"));
        inputMap.put(KeyStroke.getKeyStroke("shift F9"), "cancelCancel");
        actionMap.put("cancelCancel", (Action)this.actionCancelCancel);
        this.menuItemCancelCancel.setAccelerator(KeyStroke.getKeyStroke("shift F9"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
        KDTableUtils.setLockColumn((KDTable)this.kdtAcceptStandard, (String[])new String[]{"tightDegree", "AQL"});
    }

    @Override
    public OrgType getMainBizOrgType() {
        return OrgType.Quality;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        CoreBaseInfo o = null;
        if (table == this.kdtTightDegree && this.PaneCondition.getSelectedComponent() == this.PanelTightDegree) {
            o = new QCSamplingPlanTightDegreeEntryInfo();
            this.editData.getTightDegreeEntry().add((QCSamplingPlanTightDegreeEntryInfo)o);
        } else if (table == this.kdtAQL && this.PaneCondition.getSelectedComponent() == this.PanelAQL) {
            if (this.curTightDegreeRow != -1) {
                o = new QCAQLDataInfo();
                super.storeFields();
                ((QCAQLDataInfo)o).setTightDegree((QCSamplingPlanTightDegreeEntryInfo)this.kdtTightDegree.getRow(this.curTightDegreeRow).getUserObject());
            }
        } else if (table == this.kdtAcceptStandard && this.curTightDegreeRow != -1) {
            o = new QCPlanAcceptStandardInfo();
            super.storeFields();
            QCSamplingPlanTightDegreeEntryInfo tightDegree = (QCSamplingPlanTightDegreeEntryInfo)this.kdtTightDegree.getRow(this.curTightDegreeRow).getUserObject();
            ((QCPlanAcceptStandardInfo)o).setTightDegree(tightDegree);
            ((QCPlanAcceptStandardInfo)o).setTightDegreeSet(tightDegree.getTightDegreeSet());
            if (this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegreeAQL && this.curAQLRow != -1) {
                QCAQLDataInfo aqlDataInfo = (QCAQLDataInfo)this.kdtAQL.getRow(this.curAQLRow).getUserObject();
                ((QCPlanAcceptStandardInfo)o).setAqlData(aqlDataInfo);
                ((QCPlanAcceptStandardInfo)o).setAqlSet(aqlDataInfo.getAQLSet());
            }
        }
        return o;
    }

    protected void initListener() {
        super.initListener();
        this.sampleTable.addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    QCSamplingPlanEditUI.this.sampleTable_itemStateChanged(e);
                }
                catch (Exception exc) {
                    QCSamplingPlanEditUI.this.handUIException(exc);
                }
            }
        });
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        return this.getBizInterface().getValue(pk, this.getSelectors(), this.getSorters());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.sortData();
            QCSamplingPlanInfo spInfo = this.editData;
            QMPromptDialogFactory.createPrmptList((KDTable)this.kdtTightDegree, (String)"tightNumber", (String)"com.kingdee.eas.qm.basedata.app.F7QCTightDegreeSetQuery", (String)"$number$", (String)"$number$");
            QMPromptDialogFactory.createPrmptList((KDTable)this.kdtAQL, (String)"AQLNumber", (String)"com.kingdee.eas.qm.basedata.app.QCAQLSetQuery", (String[])new String[]{"checkedStatus"}, (Object[])new Object[]{new Integer(2)}, (CompareType[])new CompareType[]{CompareType.EQUALS}, (String)"$number$", (String)"$number$");
            KDTableUtils.setLockColumn((KDTable)this.kdtTightDegree, (String[])new String[]{"tightName"});
            KDTableUtils.setLockColumn((KDTable)this.kdtAQL, (String[])new String[]{"tightDegree", "AQLData"});
            this.menuBiz.setEnabled(true);
            this.menuBiz.setVisible(true);
            if (this.getOprtState() == "ADDNEW") {
                this.checkedStatus.setSelectedItem((Object)DBCheckedStatusEnum.UNAUDITED);
                this.deletedStatus.setSelectedItem((Object)DeletedStatusEnum.NORMAL);
                this.inspectionLevel.setSelectedItem((Object)InspectionLevelEnum.II);
                this.sampleMode.setSelectedItem((Object)SampleModeEnum.AttributeTypeOnceSampling);
                if (this.copyEnded) {
                    this.sampleTable.setSelectedItem((Object)SampleTableEnum.TightDegree);
                }
            }
            this.setInitStatus(spInfo);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        ((KDBizPromptBox)this.kdtTightDegree.getColumn("tightNumber").getEditor().getComponent()).setEditable(false);
        ((KDBizPromptBox)this.kdtAQL.getColumn("AQLNumber").getEditor().getComponent()).setEditable(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        return this.doCreateNewData(null);
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        QCSamplingPlanTightDegreeEntryCollection tdColl = this.editData.getTightDegreeEntry();
        this.verifyKdtTightDegree(tdColl);
        for (int i = 0; i < tdColl.size(); ++i) {
            if (tdColl.get(i).getTightDegreeSet() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PROP_FILE, (String)"TIGHTDEGREE_LINE_ERROR"));
                this.kdtTightDegree.requestFocus();
                this.kdtTightDegree.getSelectManager().select(i, 0);
                SysUtil.abort();
                continue;
            }
            if (this.editData.getSampleTable() == SampleTableEnum.TightDegreeAQL) {
                QCAQLDataCollection aqlColl = tdColl.get(i).getAqlDataEntry();
                for (int j = 0; j < aqlColl.size(); ++j) {
                    this.verifyAQLEmpty(tdColl, i, aqlColl, j);
                }
            }
            QCPlanAcceptStandardCollection asColl = tdColl.get(i).getAcceptStandard();
            this.verifyAccStandardEmpty(tdColl, i, asColl);
            HashSet aqlSet = new HashSet();
            for (int k = 0; k < asColl.size(); ++k) {
                if (this.editData.getSampleTable() == SampleTableEnum.TightDegreeAQL) {
                    QCAQLDataCollection aqlColl = tdColl.get(i).getAqlDataEntry();
                    this.fillAqlSet(asColl, aqlSet, k, aqlColl);
                }
                if (asColl.get(k).getLotSize() <= 0) {
                    this.focusErrItemInAccStandard(tdColl, i, asColl, k, 3, "ACCSTANDARD_LOTSIZE_ERROR");
                }
                if (asColl.get(k).getSampleSize() <= 0) {
                    this.focusErrItemInAccStandard(tdColl, i, asColl, k, 4, "ACCSTANDARD_SAMPLESIZE_ERROR");
                }
                if (asColl.get(k).getAc1() < 0) {
                    this.focusErrItemInAccStandard(tdColl, i, asColl, k, 5, "ACCSTANDARD_AC_ERROR");
                }
                if (asColl.get(k).getAc1() < asColl.get(k).getRe1()) continue;
                this.focusErrItemInAccStandard(tdColl, i, asColl, k, 6, "ACCSTANDARD_RE_ERROR");
            }
            if (this.editData.getSampleTable() == SampleTableEnum.TightDegreeAQL) {
                this.verifyAqlWithoutAccStandard(tdColl, i, aqlSet);
            }
            this.verifyRepeatAccStandard(asColl, i, tdColl);
        }
    }

    private void verifyRepeatAccStandard(QCPlanAcceptStandardCollection asColl, int tdRowIndex, QCSamplingPlanTightDegreeEntryCollection tdColl) {
        boolean b = true;
        try {
            for (int i = 0; i < asColl.size(); ++i) {
                int sampldata = asColl.get(i).getLotSize();
                String samplaqlValue = "";
                for (int j = i + 1; j < asColl.size(); ++j) {
                    b = true;
                    int curData = asColl.get(j).getLotSize();
                    String curaqlValue = "";
                    if (this.editData.getSampleTable() == SampleTableEnum.TightDegreeAQL) {
                        samplaqlValue = asColl.get(i).getAqlData().getAQLSet().getNumber();
                        if (samplaqlValue.equals(curaqlValue = asColl.get(j).getAqlData().getAQLSet().getNumber()) && sampldata == curData) {
                            b = false;
                        }
                    } else if (sampldata == curData) {
                        b = false;
                    }
                    if (b) continue;
                    this.setWarningTightDegreeRow(tdColl.get(tdRowIndex).getTightDegreeSet().getName());
                    if (this.editData.getSampleTable() == SampleTableEnum.TightDegreeAQL) {
                        this.setWarningAqlRow(samplaqlValue, tdColl.get(tdRowIndex).getTightDegreeSet().getName());
                    }
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PROP_FILE, (String)"ACCTABLE_HASREPEATROW"));
                    this.kdtAcceptStandard.getSelectManager().select(j, 3);
                    SysUtil.abort();
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return QCSamplingPlanFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.put("treeid", (QCSamplingPlanTreeInfo)this.getUIContext().get("ParentNode"));
        }
    }

    protected IObjectValue newInstanceData() {
        QCSamplingPlanInfo objectValue = new QCSamplingPlanInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setQualityOrgUnit((QualityOrgUnitInfo)this.getMainOrgInfo());
        Map map = this.getUIContext();
        QCSamplingPlanTreeInfo group = (QCSamplingPlanTreeInfo)map.get("ParentNode");
        if (group != null && !group.getNumber().equals(EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCSamplingPlanResource.GB2828"))) {
            objectValue.setGroup(group);
        }
        return objectValue;
    }

    @Override
    protected void kdtTightDegree_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.curTightDegreeRow = this.kdtTightDegree.getSelectManager().getActiveRowIndex();
        if (this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegreeAQL) {
            this.kdtAQL.removeRows();
            this.curAQLRow = -1;
            this.reLoadAQLEntryTable();
        } else {
            this.kdtAcceptStandard.removeRows();
            this.reLoadAcceptStandardEntryTable();
        }
    }

    @Override
    protected void kdtAQL_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (!this.aqlRemoveEnded) {
            return;
        }
        this.curAQLRow = this.kdtAQL.getSelectManager().getActiveRowIndex();
        this.kdtAcceptStandard.removeRows();
        if (((QCAQLDataInfo)this.kdtAQL.getRow(this.curAQLRow).getUserObject()).getAQLSet() != null) {
            this.reLoadAcceptStandardEntryTable();
        }
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_AUDIT", this.getCUIDFromBizobject());
        super.actionAudit_actionPerformed(e);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_UNAUDIT", this.getCUIDFromBizobject());
        super.actionUnAudit_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_CANCEL", this.getCUIDFromBizobject());
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreDataBase biz = (IQMCoreDataBase)this.getBizInterface();
        biz.cancel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(EASResource.getString((String)PROP_FILE, (String)"Cancel"), (IObjectPK)pk);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_CANCELCANCEL", this.getCUIDFromBizobject());
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreDataBase biz = (IQMCoreDataBase)this.getBizInterface();
        biz.cancelCancel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(EASResource.getString((String)PROP_FILE, (String)"CancelCancel"), (IObjectPK)pk);
    }

    private void checkPermission(String action, String cuID) throws Exception {
        IQMClientControlStrategy stategy = this.getClientControlStrategy();
        if (stategy instanceof QMClientControlStrategy) {
            ((QMClientControlStrategy)stategy).checkPermission(action, cuID);
        }
    }

    private String getCUIDFromBizobject() throws Exception {
        return this.getICGF().getCUID(this.editData.getId().toString());
    }

    private ICUIDGetterFacade getICGF() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance();
    }

    private void afterDoAction(String btnText, IObjectPK pk) throws Exception {
        this.setMessageText(btnText + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"SUCCESS"));
        this.setShowMessagePolicy(0);
        this.showMessage();
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.copyEnded = false;
        super.actionCopy_actionPerformed(e);
        this.copyEnded = true;
    }

    protected void sampleTable_itemStateChanged(ItemEvent e) throws Exception {
        try {
            if (e.getStateChange() != 1) {
                return;
            }
            if (e.getItem() == SampleTableEnum.TightDegree) {
                this.PaneCondition.remove((Component)this.PanelAQL);
                KDTableUtils.setShowColumn((KDTable)this.kdtAcceptStandard, (String[])new String[]{"tightDegree", "characterCode", "lotSize", "sampleSize", "Ac1", "Re1"});
            } else {
                this.PaneCondition.add((Component)this.PanelAQL, (Object)this.resHelper.getString("PanelAQL.constraints"));
                KDTableUtils.setShowColumn((KDTable)this.kdtAcceptStandard, (String[])new String[]{"tightDegree", "AQL", "characterCode", "lotSize", "sampleSize", "Ac1", "Re1"});
            }
            this.clearAqlAndAcc();
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    @Override
    protected void kdtTightDegree_editStopped(KDTEditEvent e) throws Exception {
        try {
            QCTightDegreeSetInfo newObject = (QCTightDegreeSetInfo)e.getValue();
            if (null != newObject && e.getOldValue() != e.getValue()) {
                if (this.checkNewLineRepeat(this.kdtTightDegree, e.getRowIndex(), "tightName", newObject.getName(), EASResource.getString((String)PROP_FILE))) {
                    this.kdtTightDegree.getRow(e.getRowIndex()).getCell("tightName").setValue((Object)newObject.getName());
                    this.refreshTightDegree(newObject);
                } else {
                    this.kdtTightDegree.getRow(e.getRowIndex()).getCell("tightNumber").setValue(e.getOldValue());
                    if (e.getOldValue() == null) {
                        this.removeTableLine(this.kdtTightDegree, e.getRowIndex());
                    }
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    protected void kdtAQL_editStopped(KDTEditEvent e) throws Exception {
        try {
            QCAQLSetInfo newObject;
            if (e.getValue() instanceof QCAQLSetInfo && null != (newObject = (QCAQLSetInfo)e.getValue()) && e.getOldValue() != e.getValue()) {
                if (this.checkNewLineRepeat(this.kdtAQL, e.getRowIndex(), "AQLData", newObject.getAqlValue().toString(), EASResource.getString((String)PROP_FILE))) {
                    this.kdtAQL.getRow(e.getRowIndex()).getCell("description").setValue((Object)newObject.getDescription());
                    this.kdtAQL.getRow(e.getRowIndex()).getCell("AQLData").setValue((Object)newObject.getAqlValue());
                    this.refreshAQL((QCAQLSetInfo)e.getOldValue(), newObject);
                } else {
                    this.kdtAQL.getRow(e.getRowIndex()).getCell("AQLNumber").setValue(e.getOldValue());
                    if (e.getOldValue() == null) {
                        this.removeTableLine(this.kdtAQL, e.getRowIndex());
                    }
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    protected void kdtAcceptStandard_editStopped(KDTEditEvent e) throws Exception {
        super.kdtAcceptStandard_editStopped(e);
        int newObject = 0;
        if (e.getColIndex() == 3) {
            newObject = (Integer)e.getValue();
        }
        if (newObject >= 0 && e.getOldValue() != e.getValue() && !this.checkNewLineRepeat(this.kdtAcceptStandard, e.getRowIndex(), "lotSize", String.valueOf(newObject), EASResource.getString((String)PROP_FILE))) {
            this.kdtAcceptStandard.getRow(e.getRowIndex()).getCell("lotSize").setValue(e.getOldValue());
        }
        this.storeFields();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.curTightDegreeRow = -1;
        this.curAQLRow = -1;
        super.actionAddNew_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            String itemName = this.txtName.getText().trim();
            super.actionSubmit_actionPerformed(e);
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCSamplingPlanResource.SAVE_OK"), itemName));
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (e.getSource() instanceof KDWorkButton) {
            KDWorkButton bt = (KDWorkButton)e.getSource();
            this.panelName = bt.getParent().getParent().getParent().getName();
        }
        if (this.panelName.equals("PanelTightDegree")) {
            super.actionAddLine_actionPerformed(e);
            this.kdtTightDegree.getSelectManager().select(this.kdtTightDegree.getRowCount() - 1, 0);
        } else if (this.panelName.equals("PanelAQL") && this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegreeAQL) {
            if (this.curTightDegreeRow != -1 && this.checkNewRow(this.panelName, (SampleTableEnum)((Object)this.sampleTable.getSelectedItem()))) {
                super.actionAddLine_actionPerformed(e);
                this.kdtAQL.getSelectManager().select(this.kdtAQL.getRowCount() - 1, 0);
            }
        } else if (this.panelName.equals("PanelAcceptStandard") && (this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegree && this.curTightDegreeRow != -1 || this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegreeAQL && this.curAQLRow != -1) && this.checkNewRow(this.panelName, (SampleTableEnum)((Object)this.sampleTable.getSelectedItem()))) {
            super.actionAddLine_actionPerformed(e);
            this.kdtAcceptStandard.getSelectManager().select(this.kdtAcceptStandard.getRowCount() - 1, 0);
            this.storeFields();
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (e.getSource() instanceof KDWorkButton) {
            KDWorkButton bt = (KDWorkButton)e.getSource();
            this.panelName = bt.getParent().getParent().getParent().getName();
        }
        if (this.panelName.equals("PanelTightDegree")) {
            super.actionInsertLine_actionPerformed(e);
        } else if (this.panelName.equals("PanelAQL") && this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegreeAQL) {
            if (this.curAQLRow != -1 && this.checkNewRow(this.panelName, (SampleTableEnum)((Object)this.sampleTable.getSelectedItem()))) {
                super.actionInsertLine_actionPerformed(e);
            }
        } else if (this.panelName.equals("PanelAcceptStandard") && (this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegree && this.curTightDegreeRow != -1 || this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegreeAQL && this.curAQLRow != -1) && this.checkNewRow(this.panelName, (SampleTableEnum)((Object)this.sampleTable.getSelectedItem()))) {
            super.actionInsertLine_actionPerformed(e);
            this.storeFields();
        }
    }

    private boolean checkNewRow(String panelName, SampleTableEnum sampleTableEnum) {
        return !("PanelAcceptStandard".equals(panelName) ? (sampleTableEnum == SampleTableEnum.TightDegree ? this.kdtTightDegree.getRow(this.kdtTightDegree.getSelectManager().getActiveRowIndex()).getCell("tightNumber").getValue() == null : sampleTableEnum == SampleTableEnum.TightDegreeAQL && this.kdtAQL.getRow(this.kdtAQL.getSelectManager().getActiveRowIndex()).getCell("AQLNumber").getValue() == null) : "PanelAQL".equals(panelName) && sampleTableEnum == SampleTableEnum.TightDegreeAQL && this.kdtTightDegree.getRow(this.kdtTightDegree.getSelectManager().getActiveRowIndex()).getCell("tightNumber").getValue() == null);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (e.getSource() instanceof KDWorkButton) {
            KDWorkButton bt = (KDWorkButton)e.getSource();
            this.panelName = bt.getParent().getParent().getParent().getName();
        }
        this.aqlRemoveEnded = false;
        List list = this.getAQLDatas(this.kdtAQL);
        super.actionRemoveLine_actionPerformed(e);
        if (!this.aqlRemoveEnded && this.panelName.equals("PanelAQL")) {
            this.removeAccTableLine(list);
            if (this.kdtAQL.getRow(0) != null) {
                this.kdtAQL.getSelectManager().select(0, 1);
                this.aqlRemoveEnded = true;
                this.kdtAQL.getSelectManager().select(0, 0);
            } else {
                this.curAQLRow = -1;
            }
        }
        this.aqlRemoveEnded = true;
        if (this.panelName.equals("PanelTightDegree")) {
            if (this.kdtTightDegree.getRow(0) != null) {
                this.kdtTightDegree.getSelectManager().select(0, 0);
                if ((SampleTableEnum)((Object)this.sampleTable.getSelectedItem()) == SampleTableEnum.TightDegreeAQL && this.kdtAQL.getRow(0) != null) {
                    this.kdtAQL.getSelectManager().select(0, 1);
                }
            } else {
                this.curTightDegreeRow = -1;
                this.curAQLRow = -1;
            }
        }
    }

    private List getAQLDatas(KDTable table) {
        int i;
        if (table == null) {
            return null;
        }
        if (table.getSelectManager().size() == 0) {
            return null;
        }
        KDTSelectManager selectManager = table.getSelectManager();
        int size = selectManager.size();
        KDTSelectBlock selectBlock = null;
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
            selectBlock = selectManager.get(blockIndex);
            int top = selectBlock.getBeginRow();
            int bottom = selectBlock.getEndRow();
            if (table.getRow(top) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                return null;
            }
            for (i = top; i <= bottom; ++i) {
                indexSet.add(new Integer(i));
            }
        }
        Object[] indexArr = new Integer[indexSet.size()];
        Object[] indexObj = indexSet.toArray();
        System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
        Arrays.sort(indexArr);
        if (indexArr == null) {
            return null;
        }
        ArrayList<IObjectValue> list = new ArrayList<IObjectValue>();
        for (i = indexArr.length - 1; i >= 0; --i) {
            int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
            IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
            list.add(detailData);
        }
        return list;
    }

    protected void reLoadAQLEntryTable() {
        if (this.kdtTightDegree.getRow(this.curTightDegreeRow) != null) {
            QCAQLDataCollection entryCollection = ((QCSamplingPlanTightDegreeEntryInfo)this.kdtTightDegree.getRow(this.curTightDegreeRow).getUserObject()).getAqlDataEntry();
            for (int i = 0; i < entryCollection.size(); ++i) {
                QCAQLDataInfo info = entryCollection.get(i);
                IRow row = this.kdtAQL.addRow();
                row.getStyleAttributes().setLocked(this.kdtAQL.getRow(0).getStyleAttributes().isLocked());
                this.loadLineFields(this.kdtAQL, row, (IObjectValue)info);
            }
            if (this.kdtAQL.getRowCount() > 0) {
                KDTableUtils.selectFirstRow((KDTable)this.kdtAQL);
            }
        }
    }

    protected void reLoadAcceptStandardEntryTable() {
        if (this.kdtTightDegree.getRow(this.curTightDegreeRow) != null) {
            QCPlanAcceptStandardCollection entryCollection = ((QCSamplingPlanTightDegreeEntryInfo)this.kdtTightDegree.getRow(this.curTightDegreeRow).getUserObject()).getAcceptStandard();
            for (int i = 0; i < entryCollection.size(); ++i) {
                BOSUuid curAqlSetID;
                BOSUuid infoID;
                QCPlanAcceptStandardInfo info = entryCollection.get(i);
                if (this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegreeAQL && info.getAqlData() != null && info.getAqlData().getAQLSet() != null ? !(infoID = info.getAqlData().getAQLSet().getId()).equals((Object)(curAqlSetID = ((QCAQLDataInfo)this.kdtAQL.getRow(this.curAQLRow).getUserObject()).getAQLSet().getId())) : this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegreeAQL && info.getAqlData() != null && info.getAqlData().getAQLSet() == null) continue;
                IRow row = this.kdtAcceptStandard.addRow();
                this.loadLineFields(this.kdtAcceptStandard, row, (IObjectValue)info);
            }
        }
    }

    private void removeTableLine(KDTable table, int rowIndex) {
        int tempindex;
        IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
        table.removeRow(rowIndex);
        IObjectCollection collection = (IObjectCollection)table.getUserObject();
        int index = this.getCollectionIndex(collection, detailData);
        if (index >= 0 && collection.size() > index) {
            collection.removeObject(index);
        }
        if (this.kdtTightDegree.equals(table) && (tempindex = this.getCollectionIndex((IObjectCollection)this.editData.getTightDegreeEntry(), detailData)) >= 0 && this.editData.getTightDegreeEntry().size() > tempindex) {
            this.editData.getTightDegreeEntry().removeObject(tempindex);
        }
        this.PaneCondition.setSelectedIndex(0);
    }

    private void removeAccTableLine(List list) {
        if (list == null) {
            return;
        }
        this.kdtAcceptStandard.removeRows();
        IObjectCollection collection = (IObjectCollection)this.kdtAcceptStandard.getUserObject();
        for (int i = 0; i < list.size(); ++i) {
            this.removeSubCollection(collection, (QCAQLDataInfo)list.get(i));
        }
        this.PaneCondition.setSelectedIndex(0);
    }

    @Override
    protected KDTable getDetailTable() {
        if (!this.panelName.equals("PanelAcceptStandard")) {
            KDPanel p = (KDPanel)this.PaneCondition.getSelectedComponent();
            KDTable t = (KDTable)p.getComponent(0);
            return t;
        }
        return this.kdtAcceptStandard;
    }

    private void sortData() {
        int i;
        QCSamplingPlanInfo spInfo = this.editData;
        QCSamplingPlanTightDegreeEntryCollection tdEntry = spInfo.getTightDegreeEntry();
        ArrayList<QCSamplingPlanTightDegreeEntryInfo> ltd = new ArrayList<QCSamplingPlanTightDegreeEntryInfo>();
        for (i = 0; i < tdEntry.size(); ++i) {
            ltd.add(tdEntry.get(i));
        }
        Collections.sort(ltd, new Comparator(){

            public int compare(Object o1, Object o2) {
                QCSamplingPlanTightDegreeEntryInfo r1 = (QCSamplingPlanTightDegreeEntryInfo)o1;
                QCSamplingPlanTightDegreeEntryInfo r2 = (QCSamplingPlanTightDegreeEntryInfo)o2;
                if (((String)r1.getTightDegreeSet().get("number")).compareTo((String)r2.getTightDegreeSet().get("number")) < 0) {
                    return -1;
                }
                if (((Comparable)r1.getTightDegreeSet().get("number")).compareTo((Comparable)r2.getTightDegreeSet().get("number")) == 0) {
                    return 0;
                }
                return 1;
            }
        });
        for (i = 0; i < ltd.size(); ++i) {
            QCAQLDataCollection aqlEntry = ((QCSamplingPlanTightDegreeEntryInfo)ltd.get(i)).getAqlDataEntry();
            ArrayList<QCAQLDataInfo> laql = new ArrayList<QCAQLDataInfo>();
            for (int j = 0; j < aqlEntry.size(); ++j) {
                laql.add(aqlEntry.get(j));
            }
            Collections.sort(laql, new Comparator(){

                public int compare(Object o1, Object o2) {
                    QCAQLDataInfo r1 = (QCAQLDataInfo)o1;
                    QCAQLDataInfo r2 = (QCAQLDataInfo)o2;
                    if (r1.getAQLSet().getAqlValue().compareTo(r2.getAQLSet().getAqlValue()) < 0) {
                        return -1;
                    }
                    if (r1.getAQLSet().getAqlValue().compareTo(r2.getAQLSet().getAqlValue()) == 0) {
                        return 0;
                    }
                    return 1;
                }
            });
            QCAQLDataCollection newAqlColl = new QCAQLDataCollection();
            for (int j = 0; j < laql.size(); ++j) {
                newAqlColl.addObject((IObjectValue)((QCAQLDataInfo)laql.get(j)));
            }
            ((QCSamplingPlanTightDegreeEntryInfo)ltd.get(i)).setAqlEntrys(newAqlColl);
            QCPlanAcceptStandardCollection asEntry = ((QCSamplingPlanTightDegreeEntryInfo)ltd.get(i)).getAcceptStandard();
            ArrayList<QCPlanAcceptStandardInfo> las = new ArrayList<QCPlanAcceptStandardInfo>();
            for (int j = 0; j < asEntry.size(); ++j) {
                las.add(asEntry.get(j));
            }
            Collections.sort(las, new Comparator(){

                public int compare(Object o1, Object o2) {
                    QCPlanAcceptStandardInfo r1 = (QCPlanAcceptStandardInfo)o1;
                    QCPlanAcceptStandardInfo r2 = (QCPlanAcceptStandardInfo)o2;
                    if (((Integer)r1.get("lotSize")).compareTo((Integer)r2.get("lotSize")) < 0) {
                        return -1;
                    }
                    if (((Integer)r1.get("lotSize")).compareTo((Integer)r2.get("lotSize")) == 0) {
                        return 0;
                    }
                    return 1;
                }
            });
            QCPlanAcceptStandardCollection newAsColl = new QCPlanAcceptStandardCollection();
            for (int j = 0; j < las.size(); ++j) {
                newAsColl.addObject((IObjectValue)((QCPlanAcceptStandardInfo)las.get(j)));
            }
            ((QCSamplingPlanTightDegreeEntryInfo)ltd.get(i)).setAsEntrys(newAsColl);
        }
        QCSamplingPlanTightDegreeEntryCollection newtdColl = new QCSamplingPlanTightDegreeEntryCollection();
        for (int j = 0; j < ltd.size(); ++j) {
            newtdColl.addObject((IObjectValue)((QCSamplingPlanTightDegreeEntryInfo)ltd.get(j)));
        }
        spInfo.setTdEntrys(newtdColl);
    }

    public SorterItemCollection getSorters() {
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo item = null;
        item = new SorterItemInfo("tightDegreeEntry.tightDegreeSet.number");
        item.setSortType(SortType.ASCEND);
        sorters.add(item);
        item = new SorterItemInfo("tightDegreeEntry.aqlDataEntry.AQLSet.aqlValue");
        item.setSortType(SortType.ASCEND);
        sorters.add(item);
        item = new SorterItemInfo("tightDegreeEntry.acceptStandard.lotSize");
        item.setSortType(SortType.ASCEND);
        sorters.add(item);
        return sorters;
    }

    private boolean checkNewLineRepeat(KDTable table, int rowIndex, String colName, String samplData, String itemName) {
        if (table.getRowCount() > 0 && !samplData.equals("0")) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                if (i == rowIndex || table.getRow(i).getCell(colName).getValue() == null || !samplData.equals(table.getRow(i).getCell(colName).getValue().toString())) continue;
                MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCSamplingPlanResource.TABLE_HASREPEAT"), itemName));
                return false;
            }
        }
        return true;
    }

    private void clearAqlAndAcc() {
        QCSamplingPlanTightDegreeEntryCollection qdColl;
        if (this.curSamTableItem != null && this.curSamTableItem != this.sampleTable.getSelectedItem() && this.getOprtState() != "VIEW" && (qdColl = this.editData.getTightDegreeEntry()).size() > 0) {
            int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)PROP_FILE, (String)"CLEAR_AQLACCTABLE"));
            if (result == 0) {
                for (int i = 0; i < qdColl.size(); ++i) {
                    qdColl.get(i).getAqlDataEntry().clear();
                    qdColl.get(i).getAcceptStandard().clear();
                }
                this.kdtAQL.refresh();
                this.kdtAcceptStandard.refresh();
                this.curAQLRow = -1;
                KDTableUtils.selectFirstRow((KDTable)this.kdtTightDegree);
                this.curSamTableItem = (SampleTableEnum)((Object)this.sampleTable.getSelectedItem());
            } else {
                this.sampleTable.setSelectedItem((Object)this.curSamTableItem);
            }
        }
    }

    private void removeSubCollection(IObjectCollection collection, QCAQLDataInfo obj) {
        if (collection == null) {
            return;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            QCPlanAcceptStandardInfo info = (QCPlanAcceptStandardInfo)collection.getObject(i);
            if (obj.getAQLSet() == null || info.getAqlSet() == null || obj.getAQLSet().getAqlValue() != info.getAqlSet().getAqlValue()) continue;
            collection.removeObject(i);
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        super.afterRemoveLine(table, lineData);
        if (this.panelName.equals("PanelTightDegree")) {
            IObjectCollection collection = (IObjectCollection)table.getUserObject();
            QCSamplingPlanInfo info = this.editData;
            if (info.getTightDegreeEntry().size() > collection.size()) {
                for (int i = 0; i < info.getTightDegreeEntry().size(); ++i) {
                    Object[] os = collection.toArray();
                    boolean b = true;
                    for (int j = 0; j < os.length; ++j) {
                        QCTightDegreeSetInfo right_set = ((QCSamplingPlanTightDegreeEntryInfo)os[j]).getTightDegreeSet();
                        QCTightDegreeSetInfo wrong_set = info.getTightDegreeEntry().get(i).getTightDegreeSet();
                        if (right_set == null || wrong_set == null || !right_set.getNumber().equals(wrong_set.getNumber())) continue;
                        b = false;
                        break;
                    }
                    if (!b) continue;
                    info.getTightDegreeEntry().remove(info.getTightDegreeEntry().get(i));
                }
            }
        }
    }

    private void setInitStatus(QCSamplingPlanInfo spInfo) {
        if (this.kdtTightDegree.getRowCount() > 0) {
            KDTableUtils.selectFirstRow((KDTable)this.kdtTightDegree);
        }
        if (spInfo.isIsSystemDefault()) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
        }
        this.curSamTableItem = (SampleTableEnum)((Object)this.sampleTable.getSelectedItem());
    }

    private void verifyAQLEmpty(QCSamplingPlanTightDegreeEntryCollection tdColl, int tdRowIndex, QCAQLDataCollection aqlColl, int aqlRowIndex) {
        if (aqlColl.get(aqlRowIndex).getAQLSet() == null) {
            this.setWarningTightDegreeRow(tdColl.get(tdRowIndex).getTightDegreeSet().getName());
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)PROP_FILE, (String)"AQL_LINE_ERROR"), tdColl.get(tdRowIndex).getTightDegreeSet().getName()));
            this.kdtAQL.getSelectManager().select(aqlRowIndex, 1);
            SysUtil.abort();
        }
    }

    private void verifyKdtTightDegree(QCSamplingPlanTightDegreeEntryCollection tdColl) {
        if (tdColl == null || tdColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PROP_FILE, (String)"TIGHTDEGREE_EMPTY_ERROR"));
            this.kdtTightDegree.requestFocus();
            SysUtil.abort();
        }
    }

    private void setWarningTightDegreeRow(String tdName) {
        if (this.kdtTightDegree.getUserObject() != null && this.kdtTightDegree.getRowCount() > 0) {
            for (int i = 0; i < this.kdtTightDegree.getRowCount(); ++i) {
                QCSamplingPlanTightDegreeEntryInfo tdInfo = (QCSamplingPlanTightDegreeEntryInfo)this.kdtTightDegree.getRow(i).getUserObject();
                if (tdInfo == null || !tdInfo.getTightDegreeSet().getName().equals(tdName)) continue;
                this.kdtTightDegree.getSelectManager().select(i, 0);
                break;
            }
        }
    }

    private void setWarningAqlRow(String aqlSetNumber, String tdName) {
        QCAQLDataCollection aqlColl;
        if (this.kdtAQL.getUserObject() != null && (aqlColl = (QCAQLDataCollection)((Object)this.kdtAQL.getUserObject())).size() > 0) {
            for (int i = 0; i < aqlColl.size(); ++i) {
                if (!aqlColl.get(0).getTightDegree().getTightDegreeSet().getName().equals(tdName) || !aqlColl.get(i).getAQLSet().getNumber().equals(aqlSetNumber)) continue;
                this.PaneCondition.setSelectedComponent((Component)this.PanelAQL);
                this.kdtAQL.getSelectManager().select(i, 0);
                break;
            }
        }
    }

    private void verifyAqlWithoutAccStandard(QCSamplingPlanTightDegreeEntryCollection tdColl, int tdRowIndex, Set aqlSet) {
        String emptyAccAql = "";
        QCAQLDataCollection aqlColl = tdColl.get(tdRowIndex).getAqlDataEntry();
        String splitSign = ",";
        for (int j = 0; j < aqlColl.size(); ++j) {
            if (aqlSet.contains(aqlColl.get(j).getAQLSet().getNumber())) continue;
            emptyAccAql = emptyAccAql + "(" + aqlColl.get(j).getAQLSet().getNumber().toString() + ")" + splitSign;
        }
        if (!emptyAccAql.equals("")) {
            this.setWarningTightDegreeRow(tdColl.get(tdRowIndex).getTightDegreeSet().getName());
            emptyAccAql = emptyAccAql.substring(0, emptyAccAql.length() - 1);
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)PROP_FILE, (String)"AQL_ACC_EMPTY"), tdColl.get(tdRowIndex).getTightDegreeSet().getName(), emptyAccAql));
            String firstAql = emptyAccAql.split(splitSign)[0].substring(1, emptyAccAql.length() - 1);
            this.setWarningAqlRow(firstAql, tdColl.get(tdRowIndex).getTightDegreeSet().getName());
            SysUtil.abort();
        }
    }

    private void focusErrItemInAccStandard(QCSamplingPlanTightDegreeEntryCollection tdColl, int tdRowIndex, QCPlanAcceptStandardCollection asColl, int asRowIndex, int colNum, String errMsgStr) {
        this.setWarningTightDegreeRow(tdColl.get(tdRowIndex).getTightDegreeSet().getName());
        if (this.editData.getSampleTable() == SampleTableEnum.TightDegreeAQL) {
            this.setWarningAqlRow(asColl.get(asRowIndex).getAqlData().getAQLSet().getNumber(), asColl.get(asRowIndex).getTightDegree().getTightDegreeSet().getName());
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PROP_FILE, (String)errMsgStr));
        this.kdtAcceptStandard.getSelectManager().select(asRowIndex, colNum);
        SysUtil.abort();
    }

    private void fillAqlSet(QCPlanAcceptStandardCollection asColl, Set aqlSet, int asRowIndex, QCAQLDataCollection aqlColl) {
        for (int j = 0; j < aqlColl.size(); ++j) {
            if (aqlSet.contains(aqlColl.get(j).getAQLSet().getNumber()) || !asColl.get(asRowIndex).getAqlData().getAQLSet().getNumber().equals(aqlColl.get(j).getAQLSet().getNumber())) continue;
            aqlSet.add(aqlColl.get(j).getAQLSet().getNumber());
        }
    }

    private void verifyAccStandardEmpty(QCSamplingPlanTightDegreeEntryCollection tdColl, int tdRowIndex, QCPlanAcceptStandardCollection asColl) {
        if (asColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)PROP_FILE, (String)"TIGHTDEGREE_ACC_EMPTY"), tdColl.get(tdRowIndex).getTightDegreeSet().getName()));
            SysUtil.abort();
        }
    }

    private void refreshTightDegree(QCTightDegreeSetInfo info) throws Exception {
        QCPlanAcceptStandardCollection scol;
        int i;
        if (this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegreeAQL) {
            QCAQLDataCollection acol = ((QCSamplingPlanTightDegreeEntryInfo)this.kdtTightDegree.getRow(this.curTightDegreeRow).getUserObject()).getAqlDataEntry();
            if (acol == null || acol.size() == 0) {
                return;
            }
            for (i = 0; i < acol.size(); ++i) {
                QCAQLDataInfo ainfo = acol.get(i);
                ainfo.getTightDegree().setTightDegreeSet(info);
            }
            this.kdtAQL.removeRows();
            this.reLoadAQLEntryTable();
        }
        if ((scol = ((QCSamplingPlanTightDegreeEntryInfo)this.kdtTightDegree.getRow(this.curTightDegreeRow).getUserObject()).getAcceptStandard()) == null || scol.size() == 0) {
            return;
        }
        for (i = 0; i < scol.size(); ++i) {
            QCPlanAcceptStandardInfo sinfo = scol.get(i);
            sinfo.getTightDegree().setTightDegreeSet(info);
            sinfo.setTightDegreeSet(info);
        }
        this.kdtAcceptStandard.removeRows();
        this.reLoadAcceptStandardEntryTable();
    }

    private void refreshAQL(QCAQLSetInfo oldInfo, QCAQLSetInfo newInfo) throws Exception {
        QCPlanAcceptStandardCollection scol = ((QCSamplingPlanTightDegreeEntryInfo)this.kdtTightDegree.getRow(this.curTightDegreeRow).getUserObject()).getAcceptStandard();
        if (scol == null || scol.size() == 0) {
            return;
        }
        for (int i = 0; i < scol.size(); ++i) {
            QCPlanAcceptStandardInfo sinfo = scol.get(i);
            if (this.sampleTable.getSelectedItem() == SampleTableEnum.TightDegreeAQL && sinfo.getAqlData() != null && sinfo.getAqlData().getAQLSet() != null) {
                BOSUuid infoID = sinfo.getAqlData().getAQLSet().getId();
                BOSUuid curAqlSetID = null;
                if (oldInfo != null) {
                    curAqlSetID = oldInfo.getId();
                }
                if (!infoID.equals((Object)curAqlSetID)) continue;
            }
            sinfo.getAqlData().setAQLSet(newInfo);
            sinfo.setAqlSet(newInfo);
        }
        QCAQLDataInfo ainfo = (QCAQLDataInfo)this.kdtAQL.getRow(this.curAQLRow).getUserObject();
        ainfo.setAQLSet(newInfo);
        this.kdtAcceptStandard.removeRows();
        this.reLoadAcceptStandardEntryTable();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("effectedStatus"));
        return sic;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
        super.setFieldsNull(arg0);
        QCSamplingPlanInfo info = (QCSamplingPlanInfo)arg0;
        info.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        info.setName(null);
    }

    protected boolean isSuportCancel() {
        return true;
    }

    protected boolean isSuportAudit() {
        return true;
    }
}

