/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.formula.builder.FormulaBuilderPanelBean;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.qm.basedata.EvaluateModeEnum;
import com.kingdee.eas.qm.basedata.IQCTightDegreeSet;
import com.kingdee.eas.qm.basedata.InspectionLevelEnum;
import com.kingdee.eas.qm.basedata.QCSamplingPgOfAcStaEntryInfo;
import com.kingdee.eas.qm.basedata.QCSamplingPlanInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCSamplingProgramExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramFactory;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramTreeInfo;
import com.kingdee.eas.qm.basedata.QCTightDegreeSetFactory;
import com.kingdee.eas.qm.basedata.QCTightDegreeSetInfo;
import com.kingdee.eas.qm.basedata.SampleTableEnum;
import com.kingdee.eas.qm.basedata.SampleTypeEnum;
import com.kingdee.eas.qm.basedata.client.AbstractQCSamplingProgramEditUI;
import com.kingdee.eas.qm.basedata.client.action.QCF7AQLValueAction;
import com.kingdee.eas.qm.basedata.client.action.QCF7SamplingPlanAction;
import com.kingdee.eas.qm.basedata.client.action.QCF7TightDegreeAction;
import com.kingdee.eas.qm.basedata.formula.client.QMFormulaPromptSelector;
import com.kingdee.eas.qm.basedata.formula.utils.QMFormulaUtils;
import com.kingdee.eas.qm.common.DBCheckedStatusEnum;
import com.kingdee.eas.qm.common.IQMCoreDataBase;
import com.kingdee.eas.qm.common.client.action.IUIContextAction;
import com.kingdee.eas.qm.common.client.action.IUIContextManager;
import com.kingdee.eas.qm.common.client.action.UIContextManager;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.qm.common.util.QMPrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class QCSamplingProgramEditUI
extends AbstractQCSamplingProgramEditUI {
    protected static final String PROP_FILE = "com.kingdee.eas.qm.basedata.QCSamplingProgramResource";
    protected static final String VALID_MIN_ONE = "MIN_ONE";
    protected static final String VALID_BATCHMUSTGREATERZONE = "BATCHMUSTGREATERZONE";
    protected static final String VALID_SAMPLECOUNTMUSTGREATERZONE = "SAMPLECOUNTMUSTGREATERZONE";
    protected static final String VALID_AC1MUSTGREATERZONE = "AC1MUSTGREATERZONE";
    protected static final String VALID_RE1MUSTGREATERZONE = "RE1MUSTGREATERZONE";
    protected static final String VALID_RE1MUSTGREATERAC1 = "RE1MUSTGREATERAC1";
    protected static final String VALID_CLEARINFO = "CLEARINFO";
    protected static final String VALID_BATCH_IS_DUB = "BATCH_IS_DUB";
    protected static final String VALID_CHECK_EDITFORMULA = "CHECK_EDITFORMULA";
    protected static final String VALID_SAMPLECOUNT_IS_NOT_NULL = "SAMPLECOUNT_IS_NOT_NULL";
    protected static final String VALID_AC1_IS_NOT_NULL = "AC1_IS_NOT_NULL";
    protected static final String VALID_RE1_IS_NOT_NULL = "RE1_IS_NOT_NULL";
    protected static final String VALID_AssignedCanNotUnAudit = "AssignedCanNotUnAudit";
    protected static final String VALID_AssignedCanNotAudit = "AssignedCanNotAudit";
    protected static final String VALID_AssignedCanNotDelete = "AssignedCanNotDelete";
    protected static final String VALID_AssignedCanNotEdit = "AssignedCanNotEdit";
    protected static final String VALID_AssignedCanNotCancel = "AssignedCanNotCancel";
    protected static final String VALID_AssignedCanNotCancelCancel = "AssignedCanNotCancelCancel";
    public static final String EDIT_Entry_SampleCode = "sampleCode";
    public static final String EDIT_Entry_Batch = "batch";
    public static final String EDIT_Entry_SampleCount = "sampleCount";
    public static final String EDIT_Entry_Ac1 = "ac1";
    public static final String EDIT_Entry_Re1 = "re1";
    public static final String EDIT_Entry_SampleCountExpression = "sampleCountExpress";
    public static final String EDIT_Entry_Ac1Expression = "ac1Express";
    public static final String EDIT_Entry_Re1Expression = "re1Express";
    public static final String EDIT_Entry_SampleCountExpressionAlias = "sampleCountExpressAlias";
    public static final String EDIT_Entry_Ac1ExpressionAlias = "ac1ExpressAlias";
    public static final String EDIT_Entry_Re1ExpressionAlias = "re1ExpressAlias";
    private static final String UICTX_SAMPLINGPLAN = "SAMPLINGPLAN";
    private static final String UICTX_TIGHTDEGREE = "TIGHTDEGREE";
    private static final String UICTX_AQLVALUE = "AQLVALUE";
    private ItemListener itemListener1 = null;
    private KDTMouseListener mouseListener = null;
    private QCTightDegreeSetInfo defaultTightDegreeSetInfo;
    private SampleTypeEnum curSampleTypeEnum = null;
    private Map uiContextManagers = new HashMap();
    private IUIContextManager uiContextManager = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionImportSamplingPlan.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_input"));
        this.actionEditFormula.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_editformula"));
    }

    protected void initKeyStroke() {
        super.initKeyStroke();
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("shift F8"), "cancel");
        actionMap.put("cancel", (Action)this.actionCancel);
        this.menuItemCancel.setAccelerator(KeyStroke.getKeyStroke("shift F8"));
        inputMap.put(KeyStroke.getKeyStroke("shift F9"), "cancelCancel");
        actionMap.put("cancelCancel", (Action)this.actionCancelCancel);
        this.menuItemCancelCancel.setAccelerator(KeyStroke.getKeyStroke("shift F9"));
    }

    public void onLoad() throws Exception {
        this.createListeners();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"10"));
        IQCTightDegreeSet isp = QCTightDegreeSetFactory.getRemoteInstance();
        this.defaultTightDegreeSetInfo = (QCTightDegreeSetInfo)isp.getValue(evi.encode());
        evi = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.EQUALS));
        evi.setFilter(filter);
        this.prmtgroup.setEntityViewInfo(evi);
        super.onLoad();
        this.initSamplingPlanF7();
        this.initUIContextManager();
        this.prmtgroup.setRequired(true);
        this.evaluationMode.setRequired(true);
        this.samplingType.setRequired(true);
        this.prmtqualityOrgUnit.setRequired(true);
        this.deletedStatus.setRequired(true);
        this.checkedStatus.setRequired(true);
        this.txtname.setRequired(true);
        this.txtNumber.setRequired(true);
        QMPrecisionUtil.setColNumberEditor((int)0, (KDTable)this.entrys, (String[])new String[]{EDIT_Entry_Batch, EDIT_Entry_SampleCount, EDIT_Entry_Ac1, EDIT_Entry_Re1}, null, (BigDecimal)new BigDecimal("0.0"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.menuBiz.setEnabled(true);
        this.menuBiz.setVisible(true);
        QCSamplingProgramInfo info = (QCSamplingProgramInfo)this.getDataObject();
        this.initEnabledBySamplingType(info.getSamplingType());
    }

    protected boolean isSuportAudit() {
        return true;
    }

    protected boolean isSuportCancel() {
        return true;
    }

    private void initAQLF7Filter() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
        this.prmtaqlValue.setEntityViewInfo(evi);
    }

    private void initTightDegreeF7Filter() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        this.prmtTightDegree.setEntityViewInfo(evi);
    }

    private void initSamplingPlanF7Filter() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        this.prmtsamplingPlan.setEntityViewInfo(evi);
    }

    private void initSamplingPlanF7() {
        this.initSamplingPlanF7Filter();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("sampleTable");
        selector.add("inspectionLevel");
        selector.add("sampleMode");
        selector.add("tightDegreeEntry.tightDegreeSet.id");
        selector.add("tightDegreeEntry.tightDegreeSet.number");
        selector.add("tightDegreeEntry.tightDegreeSet.name");
        selector.add("tightDegreeEntry.aqlDataEntry.AQLSet.id");
        selector.add("tightDegreeEntry.aqlDataEntry.AQLSet.number");
        selector.add("tightDegreeEntry.aqlDataEntry.AQLSet.aqlValue");
        selector.add("tightDegreeEntry.aqlDataEntry.AQLSet.checkedStatus");
        selector.add("tightDegreeEntry.acceptStandard.characterCode");
        selector.add("tightDegreeEntry.acceptStandard.lotSize");
        selector.add("tightDegreeEntry.acceptStandard.sampleSize");
        selector.add("tightDegreeEntry.acceptStandard.Ac1");
        selector.add("tightDegreeEntry.acceptStandard.Re1");
        selector.add("tightDegreeEntry.acceptStandard.samplingPlan");
        selector.add("tightDegreeEntry.acceptStandard.seq");
        selector.add("tightDegreeEntry.acceptStandard.tightDegreeSet.id");
        selector.add("tightDegreeEntry.acceptStandard.aqlSet.id");
        this.prmtsamplingPlan.setSelectorCollection(selector);
    }

    @Override
    public void loadFields() {
        this.removeListeners();
        super.loadFields();
        QCSamplingProgramExtendAttrCollection extAttr = this.editData.getExtendAttr();
        if (extAttr != null && extAttr.size() > 0) {
            QCSamplingProgramExtendAttrInfo info = extAttr.get(0);
            this.deletedStatus.setSelectedItem((Object)info.getDeletedStatus());
        } else {
            this.editData.getExtendAttr().add(this.getHeadExtInfo((QualityOrgUnitInfo)this.getMainOrgInfo()));
            this.deletedStatus.setSelectedItem((Object)DeletedStatusEnum.NORMAL);
        }
        this.addListeners();
        this.curSampleTypeEnum = (SampleTypeEnum)((Object)this.samplingType.getSelectedItem());
        this.initEnabledBySamplingType(this.curSampleTypeEnum);
        this.initFormalExpressAlias(this.curSampleTypeEnum);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getExtendAttr().size() == 0) {
            this.editData.getExtendAttr().add(this.getHeadExtInfo((QualityOrgUnitInfo)this.getMainOrgInfo()));
        } else {
            QCSamplingProgramExtendAttrInfo extendAttrInfo = this.editData.getExtendAttr().get(0);
            extendAttrInfo.setDeletedStatus((DeletedStatusEnum)this.deletedStatus.getSelectedItem());
        }
    }

    public void initFormalExpressAlias(SampleTypeEnum samplingTypeEnum) {
        if (SampleTypeEnum.formula.equals((Object)samplingTypeEnum)) {
            FormulaBuilderPanelBean formula = new FormulaBuilderPanelBean();
            for (int i = 0; i < this.entrys.getRowCount(); ++i) {
                if (this.entrys.getRow(i).getCell(EDIT_Entry_SampleCountExpression) != null) {
                    formula.setFormulaStr(this.entrys.getRow(i).getCell(EDIT_Entry_SampleCountExpression).getValue().toString());
                    this.entrys.getRow(i).getCell(EDIT_Entry_SampleCountExpressionAlias).setValue((Object)formula.getFormulaAliasStr());
                }
                if (this.entrys.getRow(i).getCell(EDIT_Entry_Ac1Expression) != null) {
                    formula.setFormulaStr(this.entrys.getRow(i).getCell(EDIT_Entry_Ac1Expression).getValue().toString());
                    this.entrys.getRow(i).getCell(EDIT_Entry_Ac1ExpressionAlias).setValue((Object)formula.getFormulaAliasStr());
                }
                if (this.entrys.getRow(i).getCell(EDIT_Entry_Re1Expression) == null) continue;
                formula.setFormulaStr(this.entrys.getRow(i).getCell(EDIT_Entry_Re1Expression).getValue().toString());
                this.entrys.getRow(i).getCell(EDIT_Entry_Re1ExpressionAlias).setValue((Object)formula.getFormulaAliasStr());
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BigDecimal zone = new BigDecimal("0.0");
        for (int i = 0; i < this.entrys.getRowCount(); ++i) {
            BigDecimal re1;
            BigDecimal ac1;
            BigDecimal batch = new BigDecimal(this.entrys.getRow(i).getCell(EDIT_Entry_Batch).getValue().toString());
            if (batch.compareTo(zone) <= 0) {
                MsgBox.showWarning((String)EASResource.getString((String)PROP_FILE, (String)VALID_BATCHMUSTGREATERZONE));
                SysUtil.abort();
            }
            if (SampleTypeEnum.formula.equals(this.samplingType.getSelectedItem())) {
                IRow row = this.entrys.getRow(i);
                if (row.getCell(EDIT_Entry_SampleCountExpression).getValue() == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)PROP_FILE, (String)VALID_SAMPLECOUNT_IS_NOT_NULL));
                    this.entrys.getSelectManager().select(i, this.entrys.getColumnIndex(EDIT_Entry_SampleCountExpression));
                    SysUtil.abort();
                }
                if (row.getCell(EDIT_Entry_Ac1Expression).getValue() == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)PROP_FILE, (String)VALID_AC1_IS_NOT_NULL));
                    this.entrys.getSelectManager().select(i, this.entrys.getColumnIndex(EDIT_Entry_Ac1Expression));
                    SysUtil.abort();
                }
                if (row.getCell(EDIT_Entry_Re1Expression).getValue() == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)PROP_FILE, (String)VALID_RE1_IS_NOT_NULL));
                    this.entrys.getSelectManager().select(i, this.entrys.getColumnIndex(EDIT_Entry_Re1Expression));
                    SysUtil.abort();
                }
                if (i == 0) {
                    this.verifyAcReWithFormula(i, new BigDecimal("1"));
                } else {
                    BigDecimal preBacth = new BigDecimal(this.entrys.getRow(i - 1).getCell(EDIT_Entry_Batch).getValue().toString());
                    this.verifyAcReWithFormula(i, preBacth.add(new BigDecimal("1")));
                }
                this.verifyAcReWithFormula(i, batch);
                continue;
            }
            BigDecimal sampleCount = new BigDecimal(this.entrys.getRow(i).getCell(EDIT_Entry_SampleCount).getValue().toString());
            if (sampleCount.compareTo(zone) <= 0) {
                MsgBox.showWarning((String)EASResource.getString((String)PROP_FILE, (String)VALID_SAMPLECOUNTMUSTGREATERZONE));
                SysUtil.abort();
            }
            if ((ac1 = new BigDecimal(this.entrys.getRow(i).getCell(EDIT_Entry_Ac1).getValue().toString())).compareTo(zone) < 0) {
                MsgBox.showWarning((String)EASResource.getString((String)PROP_FILE, (String)VALID_AC1MUSTGREATERZONE));
                SysUtil.abort();
            }
            if ((re1 = new BigDecimal(this.entrys.getRow(i).getCell(EDIT_Entry_Re1).getValue().toString())).compareTo(zone) <= 0) {
                MsgBox.showWarning((String)EASResource.getString((String)PROP_FILE, (String)VALID_RE1MUSTGREATERZONE));
                SysUtil.abort();
            }
            if (re1.compareTo(ac1) > 0) continue;
            MsgBox.showWarning((String)EASResource.getString((String)PROP_FILE, (String)VALID_RE1MUSTGREATERAC1));
            SysUtil.abort();
        }
        if (this.entrys.getRowCount() < 1) {
            MsgBox.showWarning((String)EASResource.getString((String)PROP_FILE, (String)VALID_MIN_ONE));
            SysUtil.abort();
        }
        this.checkDubBatch(this.entrys);
        if (SampleTypeEnum.userdefined.equals((Object)((SampleTypeEnum)((Object)this.samplingType.getSelectedItem())))) {
            this.editData.setSamplingPlan(null);
        }
    }

    private void verifyAcReWithFormula(int rowIndex, BigDecimal batch) throws Exception {
        String msg;
        IRow row = this.entrys.getRow(rowIndex);
        HashMap<String, BigDecimal> localCtx = new HashMap<String, BigDecimal>();
        localCtx.put("var_batch", batch);
        String sampleCountExp = row.getCell(EDIT_Entry_SampleCountExpression).getValue().toString();
        BigDecimal sampleCount = null;
        try {
            sampleCount = new BigDecimal(QMFormulaUtils.evalFormula(null, sampleCountExp, localCtx).toString());
        }
        catch (Exception e) {
            String msg2 = EASResource.getString((String)PROP_FILE, (String)"VerifySampleQtyFormula");
            MsgBox.showWarning((String)msg2);
            SysUtil.abort();
        }
        localCtx.put("var_sampleCount", sampleCount);
        String ac1Exp = row.getCell(EDIT_Entry_Ac1Expression).getValue().toString();
        BigDecimal ac1 = null;
        try {
            ac1 = new BigDecimal(QMFormulaUtils.evalFormula(null, ac1Exp, localCtx).toString());
        }
        catch (Exception e) {
            String msg3 = EASResource.getString((String)PROP_FILE, (String)"VerifyAc1Formula");
            MsgBox.showWarning((String)msg3);
            SysUtil.abort();
        }
        String re1Exp = row.getCell(EDIT_Entry_Re1Expression).getValue().toString();
        localCtx.put("var_ac1", ac1);
        BigDecimal re1 = null;
        try {
            re1 = new BigDecimal(QMFormulaUtils.evalFormula(null, re1Exp, localCtx).toString());
        }
        catch (Exception e) {
            String msg4 = EASResource.getString((String)PROP_FILE, (String)"VerifyRe1Formula");
            MsgBox.showWarning((String)msg4);
            SysUtil.abort();
        }
        ac1 = new BigDecimal(Math.ceil(ac1.doubleValue()));
        re1 = new BigDecimal(Math.ceil(re1.doubleValue()));
        if (sampleCount == null || sampleCount.compareTo(new BigDecimal("0")) != 1) {
            msg = EASResource.getString((String)PROP_FILE, (String)"VerifySampleQtyWithFormula");
            msg = MessageFormat.format(msg, rowIndex + 1 + "");
            MsgBox.showWarning((String)msg);
            SysUtil.abort();
        }
        if (ac1.compareTo(new BigDecimal("0")) == -1) {
            msg = EASResource.getString((String)PROP_FILE, (String)"VerifyAc1WithFormula");
            msg = MessageFormat.format(msg, rowIndex + 1 + "");
            MsgBox.showWarning((String)msg);
            SysUtil.abort();
        }
        if (re1.compareTo(new BigDecimal("0")) != 1) {
            msg = EASResource.getString((String)PROP_FILE, (String)"VerifyRe1WithFormula");
            msg = MessageFormat.format(msg, rowIndex + 1 + "");
            MsgBox.showWarning((String)msg);
            SysUtil.abort();
        }
        if (re1.compareTo(ac1) <= 0) {
            msg = EASResource.getString((String)PROP_FILE, (String)"VerifyAcReWithFormula");
            msg = MessageFormat.format(msg, rowIndex + 1 + "");
            MsgBox.showWarning((String)msg);
            SysUtil.abort();
        }
    }

    public void initUIContextManager() {
        if (this.uiContextManager == null) {
            this.uiContextManager = new UIContextManager((CoreUIObject)this);
            this.registerUIManager(this.uiContextManager);
        }
        this.initUIContextManager((JComponent)this.prmtsamplingPlan, UICTX_SAMPLINGPLAN);
        this.initUIContextManager((JComponent)this.prmtTightDegree, UICTX_TIGHTDEGREE);
        this.initUIContextManager((JComponent)this.prmtaqlValue, UICTX_AQLVALUE);
    }

    public void registerUIManager(IUIContextManager manager) {
        super.registerUIManager(manager);
        if (manager.getType().equals(UICTX_SAMPLINGPLAN)) {
            QCF7SamplingPlanAction samplingPlan_action = new QCF7SamplingPlanAction(this.samplingType, this.checkLevel, this.prmtsamplingPlan, this.prmtTightDegree);
            manager.registerAction((IUIContextAction)samplingPlan_action);
        }
        if (manager.getType().equals(UICTX_TIGHTDEGREE)) {
            QCF7TightDegreeAction tightDegree_action = new QCF7TightDegreeAction(this.samplingType, this.prmtsamplingPlan, this.prmtTightDegree, this.prmtaqlValue, this.entrys);
            manager.registerAction((IUIContextAction)tightDegree_action);
        }
        if (manager.getType().equals(UICTX_AQLVALUE)) {
            QCF7AQLValueAction aQLValue_action = new QCF7AQLValueAction(this, this.samplingType, this.prmtsamplingPlan, this.prmtTightDegree, this.prmtaqlValue, this.entrys);
            manager.registerAction((IUIContextAction)aQLValue_action);
        }
    }

    public void initUIContextManager(JComponent comp, String uictxReqOrgUnit) {
        IUIContextManager managers = this.initUIContextManager(uictxReqOrgUnit);
        managers.addChangeListener(comp);
    }

    protected IUIContextManager initUIContextManager(String key) {
        IUIContextManager uiContextManager = (IUIContextManager)this.uiContextManagers.get(key);
        if (uiContextManager == null) {
            uiContextManager = new UIContextManager((CoreUIObject)this);
            uiContextManager.setType(key);
            this.uiContextManagers.put(key, uiContextManager);
            this.registerUIManager(uiContextManager);
        }
        return uiContextManager;
    }

    protected void createListeners() {
        this.itemListener1 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QCSamplingProgramEditUI.this.changeSamplingType_itemStateChanged(e);
            }
        };
        this.mouseListener = new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getType() != 0) {
                    QCSamplingProgramEditUI.this.editFormula(e.getRowIndex(), e.getColIndex());
                }
            }
        };
    }

    protected void addListeners() {
        this.samplingType.addItemListener(this.itemListener1);
        this.entrys.addKDTMouseListener(this.mouseListener);
    }

    protected void removeListeners() {
        this.samplingType.removeItemListener(this.itemListener1);
        this.entrys.removeKDTMouseListener(this.mouseListener);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        QCSamplingPgOfAcStaEntryInfo qCSamplingProgramOfAcStaEntryInfo = new QCSamplingPgOfAcStaEntryInfo();
        if (SampleTypeEnum.fixation.equals(this.samplingType.getSelectedItem())) {
            qCSamplingProgramOfAcStaEntryInfo.setBatch(new BigDecimal("999999999"));
        } else {
            qCSamplingProgramOfAcStaEntryInfo.setBatch(new BigDecimal("0.0"));
        }
        if (!SampleTypeEnum.formula.equals(this.samplingType.getSelectedItem())) {
            qCSamplingProgramOfAcStaEntryInfo.setSampleCount(new BigDecimal("0.0"));
            qCSamplingProgramOfAcStaEntryInfo.setAc1(new BigDecimal("0.0"));
            qCSamplingProgramOfAcStaEntryInfo.setRe1(new BigDecimal("0.0"));
        }
        return qCSamplingProgramOfAcStaEntryInfo;
    }

    private void editFormula(int indexRow, int indexCol) {
        SampleTypeEnum samplingTypeEnum = (SampleTypeEnum)((Object)this.samplingType.getSelectedItem());
        if (this.entrys.getColumn(indexCol) == null) {
            return;
        }
        String key = this.entrys.getColumn(indexCol).getKey();
        if (samplingTypeEnum.equals((Object)SampleTypeEnum.formula) && (key.equals(EDIT_Entry_SampleCountExpressionAlias) || key.equals(EDIT_Entry_Ac1ExpressionAlias) || key.equals(EDIT_Entry_Re1ExpressionAlias))) {
            String[] columnNameArray = new String[]{};
            if (key.equals(EDIT_Entry_SampleCountExpressionAlias)) {
                columnNameArray = new String[]{EDIT_Entry_Batch};
            } else if (key.equals(EDIT_Entry_Ac1ExpressionAlias)) {
                columnNameArray = new String[]{EDIT_Entry_Batch, EDIT_Entry_SampleCount};
            } else if (key.equals(EDIT_Entry_Re1ExpressionAlias)) {
                columnNameArray = new String[]{EDIT_Entry_Batch, EDIT_Entry_SampleCount, EDIT_Entry_Ac1};
            }
            String initexp = QMFormulaUtils.getInitFormulaFromSelectReceiveStandard(this.entrys, columnNameArray);
            String exp = "";
            if (this.entrys.getRow(indexRow).getCell(indexCol - 1).getValue() != null) {
                exp = this.entrys.getRow(indexRow).getCell(indexCol - 1).getValue().toString();
            }
            String oldBody = this.filterFormulaExpression(exp);
            exp = initexp + oldBody;
            QMFormulaPromptSelector fs = new QMFormulaPromptSelector(null, null, exp);
            fs.show();
            if (!fs.isCanceled() && !"VIEW".equals(this.getOprtState())) {
                this.entrys.getRow(indexRow).getCell(indexCol).setValue(fs.getAlias());
                this.entrys.getRow(indexRow).getCell(indexCol - 1).setValue((Object)fs.getData().toString());
            }
        }
    }

    protected String filterFormulaExpression(String exp) {
        if (!StringUtils.isEmpty((String)exp)) {
            Pattern pt = Pattern.compile("(var )(.+)(})");
            Matcher matcher = pt.matcher(exp);
            int end = 0;
            while (matcher.find()) {
                end = matcher.end();
            }
            return exp.substring(end);
        }
        return "";
    }

    private void initEnabledBySamplingType(SampleTypeEnum samplingTypeEnum) {
        if (this.entrys.getRowCount() == 0) {
            IRow row = this.entrys.addRow();
            this.loadLineFields(this.entrys, row, this.createNewDetailData(this.entrys));
        }
        this.setEntrysStatus(samplingTypeEnum);
        this.initAQLF7Filter();
        this.initTightDegreeF7Filter();
        if (samplingTypeEnum.equals((Object)SampleTypeEnum.fixation)) {
            this.prmtsamplingPlan.setRequired(false);
            this.prmtsamplingPlan.setEnabled(false);
            this.prmtsamplingPlan.setValue(null);
            this.prmtsamplingPlan.setDisplayFormat("$name$");
            this.prmtTightDegree.setRequired(true);
            this.prmtTightDegree.setEnabled(true);
            this.checkLevel.setRequired(true);
            this.checkLevel.setEnabled(true);
            this.prmtaqlValue.setRequired(false);
            this.prmtaqlValue.setEnabled(true);
            this.entrys.setEnabled(true);
            this.entrys.getColumn(EDIT_Entry_Batch).getStyleAttributes().setLocked(true);
            this.entrys.getColumn(EDIT_Entry_SampleCount).getStyleAttributes().setLocked(false);
            this.entrys.getColumn(EDIT_Entry_Ac1).getStyleAttributes().setLocked(false);
            this.entrys.getColumn(EDIT_Entry_Re1).getStyleAttributes().setLocked(false);
            this.actionImportSamplingPlan.setEnabled(false);
            this.actionEditFormula.setEnabled(false);
            this.setTableActionLineStatus(false);
        } else if (samplingTypeEnum.equals((Object)SampleTypeEnum.userdefined)) {
            this.prmtsamplingPlan.setRequired(false);
            this.prmtsamplingPlan.setEnabled(false);
            this.prmtsamplingPlan.setValue(null);
            this.prmtsamplingPlan.setDisplayFormat("$simpleName$");
            this.prmtTightDegree.setRequired(true);
            this.prmtTightDegree.setEnabled(true);
            this.checkLevel.setRequired(true);
            this.checkLevel.setEnabled(true);
            this.prmtaqlValue.setRequired(false);
            this.prmtaqlValue.setEnabled(true);
            this.entrys.setEnabled(true);
            this.entrys.getColumn(EDIT_Entry_Batch).getStyleAttributes().setLocked(false);
            this.entrys.getColumn(EDIT_Entry_SampleCount).getStyleAttributes().setLocked(false);
            this.entrys.getColumn(EDIT_Entry_Ac1).getStyleAttributes().setLocked(false);
            this.entrys.getColumn(EDIT_Entry_Re1).getStyleAttributes().setLocked(false);
            this.actionImportSamplingPlan.setEnabled(true);
            this.actionEditFormula.setEnabled(false);
            this.setTableActionLineStatus(true);
        } else if (samplingTypeEnum.equals((Object)SampleTypeEnum.formula)) {
            this.prmtsamplingPlan.setRequired(false);
            this.prmtsamplingPlan.setValue(null);
            this.prmtsamplingPlan.setEnabled(false);
            this.prmtsamplingPlan.setDisplayFormat("$name$");
            this.prmtTightDegree.setRequired(true);
            this.prmtTightDegree.setEnabled(true);
            this.checkLevel.setRequired(true);
            this.checkLevel.setEnabled(true);
            this.prmtaqlValue.setRequired(false);
            this.prmtaqlValue.setEnabled(true);
            this.entrys.setEnabled(true);
            this.entrys.getColumn(EDIT_Entry_Batch).getStyleAttributes().setLocked(false);
            this.entrys.getColumn(EDIT_Entry_SampleCount).getStyleAttributes().setLocked(false);
            this.entrys.getColumn(EDIT_Entry_Ac1).getStyleAttributes().setLocked(false);
            this.entrys.getColumn(EDIT_Entry_Re1).getStyleAttributes().setLocked(false);
            this.entrys.getColumn(EDIT_Entry_SampleCountExpression).getStyleAttributes().setLocked(true);
            this.entrys.getColumn(EDIT_Entry_Ac1Expression).getStyleAttributes().setLocked(true);
            this.entrys.getColumn(EDIT_Entry_Re1Expression).getStyleAttributes().setLocked(true);
            this.entrys.getColumn(EDIT_Entry_SampleCountExpressionAlias).getStyleAttributes().setLocked(true);
            this.entrys.getColumn(EDIT_Entry_Ac1ExpressionAlias).getStyleAttributes().setLocked(true);
            this.entrys.getColumn(EDIT_Entry_Re1ExpressionAlias).getStyleAttributes().setLocked(true);
            this.actionImportSamplingPlan.setEnabled(false);
            this.actionEditFormula.setEnabled(true);
            this.setTableActionLineStatus(true);
        } else if (samplingTypeEnum.equals((Object)SampleTypeEnum.usersamplingplan)) {
            this.prmtsamplingPlan.setRequired(true);
            this.prmtsamplingPlan.setEnabled(true);
            this.prmtsamplingPlan.setDisplayFormat("$name$");
            this.prmtTightDegree.setRequired(true);
            this.prmtTightDegree.setEnabled(true);
            this.checkLevel.setRequired(true);
            this.checkLevel.setEnabled(false);
            this.prmtaqlValue.setRequired(false);
            this.prmtaqlValue.setEnabled(true);
            this.entrys.setEnabled(false);
            this.entrys.getColumn(EDIT_Entry_Batch).getStyleAttributes().setLocked(true);
            this.entrys.getColumn(EDIT_Entry_SampleCount).getStyleAttributes().setLocked(true);
            this.entrys.getColumn(EDIT_Entry_Ac1).getStyleAttributes().setLocked(true);
            this.entrys.getColumn(EDIT_Entry_Re1).getStyleAttributes().setLocked(true);
            this.actionImportSamplingPlan.setEnabled(false);
            this.actionEditFormula.setEnabled(false);
            this.setTableActionLineStatus(false);
            QCSamplingPlanInfo info = (QCSamplingPlanInfo)this.prmtsamplingPlan.getData();
            if (info != null) {
                QCF7SamplingPlanAction.addFilterForTightDegreeF7(this.prmtTightDegree, info.getTightDegreeEntry(), samplingTypeEnum);
                QCF7TightDegreeAction.addFilterForAQLSetF7(info.getTightDegreeEntry(), this.prmtTightDegree, this.prmtaqlValue, samplingTypeEnum);
                if (info.getSampleTable() != null && SampleTableEnum.TightDegree.equals((Object)info.getSampleTable())) {
                    this.prmtaqlValue.setEnabled(false);
                    this.prmtaqlValue.setRequired(false);
                    this.prmtaqlValue.setValue(null);
                } else {
                    this.prmtaqlValue.setEnabled(true);
                    this.prmtaqlValue.setRequired(true);
                }
            }
        }
        if ("VIEW".equals(this.getOprtState())) {
            this.setTableActionLineStatus(false);
            this.actionImportSamplingPlan.setEnabled(false);
            this.actionEditFormula.setEnabled(false);
        }
    }

    private void setTableActionLineStatus(boolean isEnable) {
        this.actionRemoveLine.setEnabled(isEnable);
        this.actionInsertLine.setEnabled(isEnable);
        this.actionAddLine.setEnabled(isEnable);
        this.actionCopyLine.setEnabled(isEnable);
        this.btnAddLine.setEnabled(isEnable);
        this.btnInsertLine.setEnabled(isEnable);
        this.btnRemoveLine.setEnabled(isEnable);
        this.btnCopyLine.setEnabled(isEnable);
    }

    protected void changeSamplingType_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        if (this.curSampleTypeEnum != null && this.curSampleTypeEnum != this.samplingType.getSelectedItem()) {
            int i = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)PROP_FILE, (String)VALID_CLEARINFO));
            if (i == 0) {
                this.clearData();
                if (!"VIEW".equals(this.getOprtState())) {
                    this.initEnabledBySamplingType((SampleTypeEnum)((Object)this.samplingType.getSelectedItem()));
                }
                this.curSampleTypeEnum = (SampleTypeEnum)((Object)this.samplingType.getSelectedItem());
            } else {
                this.samplingType.setSelectedItem((Object)this.curSampleTypeEnum);
            }
        }
    }

    private void clearData() {
        this.prmtsamplingPlan.setValue(null);
        this.checkLevel.setSelectedItem((Object)InspectionLevelEnum.II);
        this.prmtTightDegree.setData((Object)this.defaultTightDegreeSetInfo);
        this.prmtaqlValue.setValue(null);
        this.txtDescription.setText(null);
        this.entrys.removeRows();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return QCSamplingProgramFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        IObjectValue data = this.doCreateNewData(null);
        return data;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("group.id");
        sic.add("group.number");
        sic.add("group.name");
        sic.add("samplingPlan.id");
        sic.add("samplingPlan.number");
        sic.add("samplingPlan.name");
        sic.add("samplingPlan.sampleTable");
        sic.add("samplingPlan.inspectionLevel");
        sic.add("samplingPlan.sampleMode");
        sic.add("samplingPlan.tightDegreeEntry.tightDegreeSet.id");
        sic.add("samplingPlan.tightDegreeEntry.tightDegreeSet.number");
        sic.add("samplingPlan.tightDegreeEntry.tightDegreeSet.name");
        sic.add("samplingPlan.tightDegreeEntry.aqlDataEntry.AQLSet.id");
        sic.add("samplingPlan.tightDegreeEntry.aqlDataEntry.AQLSet.number");
        sic.add("samplingPlan.tightDegreeEntry.aqlDataEntry.AQLSet.aqlValue");
        sic.add("samplingPlan.tightDegreeEntry.aqlDataEntry.AQLSet.checkedStatus");
        sic.add("samplingPlan.tightDegreeEntry.acceptStandard.characterCode");
        sic.add("samplingPlan.tightDegreeEntry.acceptStandard.lotSize");
        sic.add("samplingPlan.tightDegreeEntry.acceptStandard.sampleSize");
        sic.add("samplingPlan.tightDegreeEntry.acceptStandard.Ac1");
        sic.add("samplingPlan.tightDegreeEntry.acceptStandard.Re1");
        sic.add("samplingPlan.tightDegreeEntry.acceptStandard.samplingPlan");
        sic.add("samplingPlan.tightDegreeEntry.acceptStandard.seq");
        sic.add("samplingPlan.tightDegreeEntry.acceptStandard.tightDegreeSet.id");
        sic.add("samplingPlan.tightDegreeEntry.acceptStandard.aqlSet.id");
        sic.add(new SelectorItemInfo("tightDegree.id"));
        sic.add(new SelectorItemInfo("tightDegree.number"));
        sic.add(new SelectorItemInfo("tightDegree.name"));
        sic.add(new SelectorItemInfo("aqlValue.id"));
        sic.add(new SelectorItemInfo("aqlValue.number"));
        sic.add(new SelectorItemInfo("aqlValue.aqlValue"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.id"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.number"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.name"));
        sic.add(new SelectorItemInfo("entrys.sampleCode"));
        sic.add(new SelectorItemInfo("entrys.batch"));
        sic.add(new SelectorItemInfo("entrys.sampleCount"));
        sic.add(new SelectorItemInfo("entrys.sampleCountExpress"));
        sic.add(new SelectorItemInfo("entrys.ac1"));
        sic.add(new SelectorItemInfo("entrys.ac1Express"));
        sic.add(new SelectorItemInfo("entrys.re1"));
        sic.add(new SelectorItemInfo("entrys.re1Express"));
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("entrys.seq"));
        sic.add(new SelectorItemInfo("checkLevel"));
        sic.add(new SelectorItemInfo("evaluationMode"));
        sic.add(new SelectorItemInfo("samplingType"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("extendAttr.*"));
        return sic;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
        super.setFieldsNull(arg0);
        QCSamplingProgramInfo info = (QCSamplingProgramInfo)arg0;
        info.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        info.setQualityOrgUnit((QualityOrgUnitInfo)this.getMainOrgInfo());
        info.setCheckedStatus(DBCheckedStatusEnum.UNAUDITED);
        info.setName(null);
    }

    protected IObjectValue newInstanceData() {
        QCSamplingProgramTreeInfo groupInfo;
        QCSamplingProgramInfo objectValue = new QCSamplingProgramInfo();
        objectValue.setEvaluationMode(EvaluateModeEnum.countdeterminebysys);
        objectValue.setSamplingType(SampleTypeEnum.fixation);
        objectValue.setTightDegree(this.defaultTightDegreeSetInfo);
        objectValue.setCheckLevel(InspectionLevelEnum.II);
        objectValue.setCheckedStatus(DBCheckedStatusEnum.UNAUDITED);
        objectValue.setDeletedStatus(DeletedStatusEnum.NORMAL);
        QualityOrgUnitInfo orgItem = (QualityOrgUnitInfo)this.getMainOrgInfo();
        objectValue.setQualityOrgUnit(orgItem);
        if (this.getUIContext().get("ParentNode") != null && this.getUIContext().get("ParentNode") instanceof QCSamplingProgramTreeInfo && (groupInfo = (QCSamplingProgramTreeInfo)this.getUIContext().get("ParentNode")).isIsLeaf()) {
            objectValue.setGroup(groupInfo);
        }
        objectValue.getExtendAttr().add(this.getHeadExtInfo(orgItem));
        return objectValue;
    }

    protected QCSamplingProgramExtendAttrInfo getHeadExtInfo(QualityOrgUnitInfo info) {
        QCSamplingProgramExtendAttrInfo item = new QCSamplingProgramExtendAttrInfo();
        item.setQualityOrgUnit(info);
        item.setDeletedStatus(DeletedStatusEnum.NORMAL);
        return item;
    }

    @Override
    public void actionImportSamplingPlan_actionPerformed(ActionEvent e) throws Exception {
        this.prmtsamplingPlan.setDataBySelector();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isDataBaseD()) {
            String info = EASResource.getString((String)PROP_FILE, (String)VALID_AssignedCanNotEdit);
            MsgBox.showInfo((Component)((Object)this), (String)info);
            return;
        }
        this.checkAuditedCanEdit();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isDataBaseD()) {
            String info = EASResource.getString((String)PROP_FILE, (String)VALID_AssignedCanNotDelete);
            MsgBox.showInfo((Component)((Object)this), (String)info);
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isDataBaseD()) {
            String info = EASResource.getString((String)PROP_FILE, (String)VALID_AssignedCanNotAudit);
            MsgBox.showInfo((Component)((Object)this), (String)info);
            return;
        }
        super.actionAudit_actionPerformed(e);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isDataBaseD()) {
            String info = EASResource.getString((String)PROP_FILE, (String)VALID_AssignedCanNotUnAudit);
            MsgBox.showInfo((Component)((Object)this), (String)info);
            return;
        }
        super.actionUnAudit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.isDataBaseD()) {
            String info = EASResource.getString((String)PROP_FILE, (String)VALID_AssignedCanNotCancel);
            MsgBox.showInfo((Component)((Object)this), (String)info);
            return;
        }
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreDataBase biz = (IQMCoreDataBase)this.getBizInterface();
        biz.cancel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(EASResource.getString((String)PROP_FILE, (String)"Cancel"), (IObjectPK)pk);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.isDataBaseD()) {
            String info = EASResource.getString((String)PROP_FILE, (String)VALID_AssignedCanNotCancelCancel);
            MsgBox.showInfo((Component)((Object)this), (String)info);
            return;
        }
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IQMCoreDataBase biz = (IQMCoreDataBase)this.getBizInterface();
        biz.cancelCancel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(EASResource.getString((String)PROP_FILE, (String)"CancelCancel"), (IObjectPK)pk);
    }

    private void afterDoAction(String btnText, IObjectPK pk) throws Exception {
        this.setMessageText(btnText + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"SUCCESS"));
        this.setShowMessagePolicy(0);
        this.showMessage();
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    protected void checkAuditedCanEdit() throws Exception {
        DBCheckedStatusEnum v;
        if (this.editData != null && (v = this.editData.getCheckedStatus()) != null && v == DBCheckedStatusEnum.AUDITED) {
            String info = EASResource.getString((String)"com.kingdee.eas.qm.basedata.client.BasedataResource", (String)"Msg_AuditedCannotEdit");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            SysUtil.abort();
        }
    }

    protected boolean isDataBaseD() {
        if (this.editData.getQualityOrgUnit() != null) {
            String authorORG = this.editData.getQualityOrgUnit().getId().toString();
            String currentORG = ((QualityOrgUnitInfo)this.getMainOrgInfo()).getId().toString();
            return !currentORG.equals(authorORG);
        }
        return true;
    }

    @Override
    public void actionEditFormula_actionPerformed(ActionEvent e) throws Exception {
        int indexRow = this.entrys.getSelectManager().getActiveRowIndex();
        int indexCol = this.entrys.getSelectManager().getActiveColumnIndex();
        if (indexRow < 0 || indexCol < 3) {
            MsgBox.showWarning((String)EASResource.getString((String)PROP_FILE, (String)VALID_CHECK_EDITFORMULA));
            SysUtil.abort();
        }
        this.editFormula(indexRow, indexCol);
    }

    private void setEntrysStatus(SampleTypeEnum samplingTypeEnum) {
        String[] columns_exp = new String[]{EDIT_Entry_SampleCountExpressionAlias, EDIT_Entry_Ac1ExpressionAlias, EDIT_Entry_Re1ExpressionAlias};
        String[] columns_noexp = new String[]{EDIT_Entry_SampleCount, EDIT_Entry_Ac1, EDIT_Entry_Re1};
        String[] columns_show = null;
        String[] columns_hide = null;
        boolean isFormula = true;
        int width = -1;
        if (SampleTypeEnum.formula.equals((Object)samplingTypeEnum)) {
            columns_show = columns_exp;
            columns_hide = columns_noexp;
            isFormula = true;
            width = 66;
        } else {
            columns_show = columns_noexp;
            columns_hide = columns_exp;
            isFormula = false;
            width = 48;
        }
        KDTableUtils.showColumns((KDTable)this.entrys, (String[])columns_show);
        KDTableUtils.hideColumns((KDTable)this.entrys, (String[])columns_hide);
        this.setColWidth(this.entrys, columns_show, width);
        this.setColWidth(this.entrys, columns_hide, -1);
        this.entrys.getColumn(EDIT_Entry_SampleCountExpression).setRequired(isFormula);
        this.entrys.getColumn(EDIT_Entry_Ac1Expression).setRequired(isFormula);
        this.entrys.getColumn(EDIT_Entry_Re1Expression).setRequired(isFormula);
        this.entrys.getColumn(EDIT_Entry_SampleCountExpressionAlias).setRequired(isFormula);
        this.entrys.getColumn(EDIT_Entry_Ac1ExpressionAlias).setRequired(isFormula);
        this.entrys.getColumn(EDIT_Entry_Re1ExpressionAlias).setRequired(isFormula);
        this.entrys.getColumn(EDIT_Entry_SampleCount).setRequired(!isFormula);
        this.entrys.getColumn(EDIT_Entry_Ac1).setRequired(!isFormula);
        this.entrys.getColumn(EDIT_Entry_Re1).setRequired(!isFormula);
    }

    private void checkDubBatch(KDTable e) {
        List tempList = KDTableUtils.getColumnValues((KDTable)e, (String)EDIT_Entry_Batch);
        BigDecimal temp = new BigDecimal("0.0");
        for (int i = 0; i < e.getRowCount(); ++i) {
            temp = new BigDecimal(e.getRow(i).getCell(EDIT_Entry_Batch).getValue().toString());
            int equalsCount = 0;
            for (int k = 0; k < tempList.size(); ++k) {
                if (temp.compareTo(new BigDecimal(tempList.get(k).toString())) != 0 || ++equalsCount != 2) continue;
                e.getEditManager().editCellAt(i, this.entrys.getColumnIndex(EDIT_Entry_Batch));
                MsgBox.showWarning((String)EASResource.getString((String)PROP_FILE, (String)VALID_BATCH_IS_DUB));
                SysUtil.abort();
            }
        }
    }

    private void setColWidth(KDTable e, String[] colNames, int width) {
        for (int i = 0; i < colNames.length; ++i) {
            e.getColumn(colNames[i]).setWidth(width);
        }
    }
}

