/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.qm.basedata.IQCSamplingProgram;
import com.kingdee.eas.qm.basedata.QCSamplingProgramCollection;
import com.kingdee.eas.qm.basedata.QCSamplingProgramFactory;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramTreeFactory;
import com.kingdee.eas.qm.basedata.client.AbstractQCSamplingProgramF7UI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JButton;

public class QCSamplingProgramF7UI
extends AbstractQCSamplingProgramF7UI {
    public static final String EV = "ev";
    private boolean isCanceled = false;
    private QCSamplingProgramInfo info;
    public static final String IS_ENABLED_MULTI_SELECTION = "isEnabledMultiSelection";
    private boolean isEnableMultiSelect = false;
    public static final String ISLEAF = "isLeaf";
    private Object rstData;
    boolean isLeaf = true;

    public void onLoad() throws Exception {
        Object isms = this.getUIContext().get(IS_ENABLED_MULTI_SELECTION);
        this.isEnableMultiSelect = isms != null && isms.equals(Boolean.TRUE);
        super.onLoad();
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionView.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionView.setEnabled(false);
        this.tblMain.checkParsed();
        this.btnConfirm.setEnabled(true);
        this.btnClose.setEnabled(true);
        this.chkShowAll.setEnabled(true);
        this.pnlMain.setFocusCycleRoot(false);
        this.pnlMain.setFocusTraversalPolicy(null);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{this.tblMain, this.btnConfirm, this.btnClose, this.cboKey, this.txtValue, this.btnFastQuery, this.chkLike, this.chkShowAll, this.treeMain}));
        this.setFocusCycleRoot(true);
        this.btnFastQuery.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                QCSamplingProgramF7UI.this.beforeActionPerformed(e);
                try {
                    QCSamplingProgramF7UI.this.btnFastQuery_actionPerformed(e);
                }
                catch (Exception exc) {
                    QCSamplingProgramF7UI.this.handUIException(exc);
                }
                finally {
                    QCSamplingProgramF7UI.this.afterActionPerformed(e);
                }
            }
        });
    }

    protected void buildTreeFilter() {
        super.buildTreeFilter();
        if (!this.chkShowAll.isSelected()) {
            FilterInfo filter = this.getCUFilter();
            try {
                if (this.mainQuery.getFilter() != null && this.mainQuery.getFilter().getFilterItems().size() > 0) {
                    this.mainQuery.getFilter().mergeFilter(filter, "AND");
                } else {
                    this.mainQuery.setFilter(filter);
                }
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    private FilterInfo getCUFilter() {
        String cuid = ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuid));
        return filter;
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCSamplingProgramResource", (String)"SamplingProgram");
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    protected EntityViewInfo getDefaultEntityViewInfo() {
        EntityViewInfo entityViewInfo = super.getDefaultEntityViewInfo();
        if (entityViewInfo == null) {
            entityViewInfo = new EntityViewInfo();
        }
        return entityViewInfo;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            this.buildRstValues();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    public Object getRstData() {
        return this.rstData;
    }

    private void buildRstValues() throws BOSException {
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowID.length < 1) {
            this.abort();
        }
        IQCSamplingProgram iProgram = QCSamplingProgramFactory.getRemoteInstance();
        if (this.isEnableMultiSelect) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < rowID.length; ++i) {
                String id = this.tblMain.getRow(rowID[i]).getCell(0).getValue().toString();
                idSet.add(id);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            QCSamplingProgramCollection programColl = iProgram.getQCSamplingProgramCollection(view);
            if (programColl != null && programColl.size() > 0) {
                this.rstData = programColl.toArray();
            }
        } else {
            if (this.tblMain.getRow(rowID[0]) == null) {
                this.abort();
            }
            String id = this.tblMain.getRow(rowID[0]).getCell(0).getValue().toString();
            try {
                this.rstData = iProgram.getQCSamplingProgramInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                this.info = (QCSamplingProgramInfo)this.rstData;
            }
            catch (Exception ex) {
                this.handUIException(ex);
                this.abort();
            }
        }
    }

    @Override
    public void actionShowAll_actionPerformed(ActionEvent e) throws Exception {
        this.treeMain_valueChanged(null);
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.buildRstValues();
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    protected void btnFastQuery_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        if (this.cboKey.getSelectedIndex() == 0) {
            if (this.chkLike.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + this.txtValue.getText().trim() + "%"), CompareType.LIKE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)this.txtValue.getText().trim()));
            }
        } else if (this.chkLike.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + this.txtValue.getText().trim() + "%"), CompareType.LIKE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.txtValue.getText().trim()));
        }
        if (this.getDefaultFilterForQuery() != null && this.getDefaultFilterForQuery().getFilterItems().size() > 0) {
            filterInfo.mergeFilter(this.getDefaultFilterForQuery(), "and");
        }
        this.mainQuery = new EntityViewInfo();
        this.mainQuery.setFilter(filterInfo);
        this.tblMain.removeRows();
        this.tblMain.requestFocusInWindow();
    }

    protected JButton getDefaultButton() {
        return this.btnConfirm;
    }

    protected void execQuery() {
        try {
            if (this.getDefaultEntityViewInfo() != null) {
                this.mainQuery.getFilter().mergeFilter(this.getDefaultEntityViewInfo().getFilter(), "AND");
            } else {
                FilterInfo cuFilter = this.getCUFilter();
                this.mainQuery.setFilter(cuFilter);
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        super.execQuery();
    }

    public QCSamplingProgramInfo getSamplingProgramInfo() {
        return this.info;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return QCSamplingProgramTreeFactory.getRemoteInstance();
    }

    protected boolean isIncludeAllChildren() {
        return true;
    }
}

