/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.qm.basedata.ItemTypeEnum;
import com.kingdee.eas.qm.basedata.MergeModeEnum;
import com.kingdee.eas.qm.basedata.QCAnalysisMethodEnum;
import com.kingdee.eas.qm.basedata.QCGroupInfo;
import com.kingdee.eas.qm.basedata.QCInstrumentGroupInfo;
import com.kingdee.eas.qm.basedata.QCInstrumentInfo;
import com.kingdee.eas.qm.basedata.QCItemAttributeEnum;
import com.kingdee.eas.qm.basedata.QCItemFacadeFactory;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryCollection;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCValueAcquisitionModeEnum;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.SampleHierarchyEnum;
import com.kingdee.eas.qm.basedata.client.AbstractQCStandardItemEntryEditUI;
import com.kingdee.eas.qm.basedata.client.util.F7BDRegUtils;
import com.kingdee.eas.qm.basedata.client.util.QCStandardEditUIF7FilterHelper;
import com.kingdee.eas.qm.basedata.formula.client.QMFormulaPromptSelector;
import com.kingdee.eas.qm.basedata.formula.utils.QMFormulaPromptHelper;
import com.kingdee.eas.qm.basedata.formula.utils.QMFormulaUtils;
import com.kingdee.eas.qm.basedata.util.QMDataBaseFilterUtils;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.util.QMUtils;
import com.kingdee.eas.qm.common.util.backup.QMHelper;
import com.kingdee.eas.qm.qc.client.util.QCUIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCStandardItemEntryEditUI
extends AbstractQCStandardItemEntryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(QCStandardItemEntryEditUI.class);
    DataChangeListener qcItemListener = null;
    DataChangeListener qcInstrumentListener = null;
    DataChangeListener delOrgListener = null;
    DataChangeListener dataPrecisionListener = null;
    DataChangeListener instrumentGroupListener = null;
    MouseListener defaultValueListener = null;
    private QCStandardInfo qcStdInfo;
    private QCStandardItemEntryInfo currItemEntryInfo;
    private QCStandardItemEntryCollection itemEntryList;
    private int itemEntrysSize;
    private int currIndex;
    private QMFormulaPromptHelper formulaHelper;

    public void onLoad() throws Exception {
        this.txtNumDefaultValue.setRemoveingZeroInDispaly(false);
        this.txtNumDefaultValue.setCommitsOnValidEdit(true);
        this.txtNumDefaultValue.setDataVerifierType(12);
        this.txtLower.setRemoveingZeroInDispaly(false);
        this.txtUpper.setRemoveingZeroInDispaly(false);
        KDFormattedTextField[] fields = new KDFormattedTextField[]{this.txtLower, this.txtUpper, this.txtDataPrecision};
        QCUIUtil.setCommitBeforeClose((KDFormattedTextField[])fields);
        this.setUIState();
        this.qcStdInfo = (QCStandardInfo)this.getUIContext().get("qcStdInfo");
        this.currItemEntryInfo = (QCStandardItemEntryInfo)this.getUIContext().get("InitDataObject");
        this.itemEntryList = this.qcStdInfo.getItemEntries();
        this.itemEntrysSize = null != this.itemEntryList ? this.itemEntryList.size() : 0;
        this.currIndex = null != this.itemEntryList ? this.itemEntryList.indexOf(this.currItemEntryInfo) : 0;
        this.formulaHelper = new QMFormulaPromptHelper((CoreUI)this);
        super.onLoad();
        this.regF7EntityView();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.setActionEnable();
        this.setDataStatusByQCItem(this.currItemEntryInfo.getQCItem());
        this.checkExtUpdate();
        this.setValueDataPrecision();
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.loadExtFields();
        this.addListener();
        this.loadDefaultValue();
        this.setValueDataPrecision();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeExtFields();
        this.storeDefaultValue();
    }

    protected void initListener() {
        super.initListener();
        this.qcItemListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    QCStandardItemEntryEditUI.this.qcItemDataChanged(e);
                }
                catch (Exception exp) {
                    QCStandardItemEntryEditUI.this.handUIException(exp);
                }
            }
        };
        this.qcInstrumentListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                QCStandardItemEntryEditUI.this.qcInstrumentDataChanged(event);
            }
        };
        this.delOrgListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                QCStandardItemEntryEditUI.this.delOrgDataChanged(event);
            }
        };
        this.dataPrecisionListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                QCStandardItemEntryEditUI.this.dataPrecisionChanged(event);
            }
        };
        this.defaultValueListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QCStandardItemEntryEditUI.this.doDVmouseClicked(e);
            }
        };
        this.instrumentGroupListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                QCStandardItemEntryEditUI.this.instrumentGroupDataChanged(eventObj);
            }
        };
        this.addListener();
    }

    protected void doDVmouseClicked(MouseEvent e) {
        QCItemInfo itemInfo = null;
        itemInfo = this.currItemEntryInfo.getQCItem() != null ? this.currItemEntryInfo.getQCItem() : (QCItemInfo)this.prmtQCItem.getData();
        if (itemInfo == null) {
            return;
        }
        QCValueTypeEnum valueType = itemInfo.getQCValueType();
        if (valueType != null && QCValueTypeEnum.formula.equals((Object)valueType)) {
            this.txtDefaultValueDoubleClicked(e);
        }
    }

    protected void instrumentGroupDataChanged(DataChangeEvent eventObj) {
        this.doQCInstrumentFilter(eventObj);
        if (!QMEqualsUtils.equals((Object)eventObj.getOldValue(), (Object)eventObj.getNewValue())) {
            this.prmtQCInstrument.setData(null);
        }
    }

    private void doQCInstrumentFilter(DataChangeEvent eventObj) {
        QCInstrumentGroupInfo groupInfo = (QCInstrumentGroupInfo)this.prmtQCInstrumentGroup.getData();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String groupID = "";
        if (groupInfo != null) {
            groupID = groupInfo.getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
        String orgID = "";
        QualityOrgUnitInfo delegateOrgInfo = (QualityOrgUnitInfo)this.prmtDelQualityOrg.getValue();
        if (delegateOrgInfo != null) {
            orgID = delegateOrgInfo.getId().toString();
        }
        BOSObjectType bosType = new QCInstrumentInfo().getBOSType();
        filter.getFilterItems().add(QMDataBaseFilterUtils.getQMDBAssignFilter("id", orgID, bosType));
        ev.setFilter(filter);
        this.prmtQCInstrument.setEntityViewInfo(ev);
    }

    private void addListener() {
        this.prmtQCItem.addDataChangeListener(this.qcItemListener);
        this.prmtQCInstrument.addDataChangeListener(this.qcInstrumentListener);
        this.prmtDelQualityOrg.addDataChangeListener(this.delOrgListener);
        this.txtDataPrecision.addDataChangeListener(this.dataPrecisionListener);
        this.txtDefaultValue.addMouseListener(this.defaultValueListener);
        this.prmtQCInstrumentGroup.addDataChangeListener(this.instrumentGroupListener);
    }

    private void removeListener() {
        this.prmtQCItem.removeDataChangeListener(this.qcItemListener);
        this.prmtQCInstrument.removeDataChangeListener(this.qcInstrumentListener);
        this.prmtDelQualityOrg.removeDataChangeListener(this.delOrgListener);
        this.txtDataPrecision.removeDataChangeListener(this.dataPrecisionListener);
        this.txtDefaultValue.removeMouseListener(this.defaultValueListener);
        this.prmtQCInstrumentGroup.removeDataChangeListener(this.instrumentGroupListener);
    }

    private void setActionEnable() {
        if ((this.oprtState.equals(OprtState.ADDNEW) || this.oprtState.equals(OprtState.EDIT)) && this.isCreateQualityOrg()) {
            this.actionAddNew.setEnabled(true);
        } else {
            this.actionAddNew.setEnabled(false);
        }
        this.actionSubmit.setEnabled(false);
    }

    private void setDataStatusByQCItem(QCItemInfo qcItem) {
        boolean isModifyModeRequired = false;
        boolean isJudgeTypeRequired = false;
        boolean isTxtDefaultValueVisible = true;
        boolean isEnumDefaultValueVisble = false;
        boolean isNumDefaultValueVisble = false;
        boolean canModifyDefaultValue = true;
        boolean canModifyMergeMode = true;
        boolean canModifyAcqMode = true;
        boolean canModifyLowerOrUpper = false;
        boolean canModifyDataPrecision = false;
        boolean canModifyJudgeType = true;
        Component[] compLowerOrUppers = new Component[]{this.cmbUpperLimit, this.cmbLowerLimit, this.txtUpper, this.txtLower};
        if (null != qcItem) {
            QCValueTypeEnum valueType = qcItem.getQCValueType();
            QCAnalysisMethodEnum aMethod = qcItem.getAnalysisMethod();
            QCItemAttributeEnum qciAttrValue = qcItem.getQCItemAttr();
            isJudgeTypeRequired = aMethod != null && QCAnalysisMethodEnum.quantitativeAnalysis.equals((Object)aMethod) && qciAttrValue != null && QCItemAttributeEnum.checkItem.equals((Object)qciAttrValue);
            if (QCValueTypeEnum.formula.equals((Object)valueType) || QCValueTypeEnum.number.equals((Object)valueType)) {
                canModifyLowerOrUpper = true;
            }
            if (QCValueTypeEnum.enumvalue.equals((Object)valueType) || QCValueTypeEnum.text.equals((Object)valueType)) {
                this.cmbMergeMode.setSelectedItem(null);
                canModifyMergeMode = false;
            }
            if (QCValueTypeEnum.formula.equals((Object)valueType)) {
                canModifyAcqMode = false;
                canModifyDefaultValue = false;
                canModifyDataPrecision = true;
            }
            if (QCValueTypeEnum.number.equals((Object)valueType)) {
                isTxtDefaultValueVisible = false;
                isNumDefaultValueVisble = true;
                isEnumDefaultValueVisble = false;
                canModifyDataPrecision = true;
            }
            if (QCValueTypeEnum.enumvalue.equals((Object)valueType)) {
                canModifyJudgeType = false;
                isTxtDefaultValueVisible = false;
                isNumDefaultValueVisble = false;
                isEnumDefaultValueVisble = true;
                Object[] list = QMHelper.parseEnumString((String)qcItem.getEnums());
                this.cmbDefaultValue.removeAllItems();
                this.cmbDefaultValue.addItems(list);
            }
            if (QCValueTypeEnum.formula.equals((Object)valueType) || QCValueTypeEnum.text.equals((Object)valueType)) {
                isTxtDefaultValueVisible = true;
                isNumDefaultValueVisble = false;
                isEnumDefaultValueVisble = false;
            }
            if (qcItem.isIsModify()) {
                isModifyModeRequired = true;
            }
        }
        this.cmbMergeMode.setEnabled(canModifyMergeMode);
        this.prmtModifyMode.setRequired(isModifyModeRequired);
        this.cmbJudgeType.setRequired(isJudgeTypeRequired);
        this.cmbQCValueAcqMode.setEnabled(canModifyAcqMode);
        this.contDefaultValue.setVisible(isTxtDefaultValueVisible);
        this.contNumDefaultValue.setVisible(isNumDefaultValueVisble);
        this.contEnumDefaultValue.setVisible(isEnumDefaultValueVisble);
        this.contDefaultValue.setVisible(isTxtDefaultValueVisible);
        this.txtDefaultValue.setEditable(canModifyDefaultValue);
        QMUtils.setComponentEnable((Component[])compLowerOrUppers, (boolean)canModifyLowerOrUpper);
        this.txtDataPrecision.setEnabled(canModifyDataPrecision);
        this.cmbJudgeType.setEnabled(canModifyJudgeType);
        if (this.qcStdInfo.getSampleHierarchy() != null && !SampleHierarchyEnum.step.equals((Object)this.qcStdInfo.getSampleHierarchy())) {
            this.txtCheckStep.setEnabled(false);
            this.txtCheckStep.setRequired(false);
        } else if (this.qcStdInfo.isIsStepByItemGroup() || this.qcStdInfo.isIsStepByQCGroup() || this.qcStdInfo.isIsStepByQOrgGroup()) {
            this.txtCheckStep.setEnabled(false);
            this.txtCheckStep.setRequired(false);
        } else {
            this.txtCheckStep.setEnabled(true);
            this.txtCheckStep.setRequired(true);
        }
    }

    private void setValueDataPrecision() {
        if (this.txtDataPrecision.getNumberValue() != null) {
            int precision = this.txtDataPrecision.getNumberValue().intValue();
            this.txtNumDefaultValue.setPrecision(precision);
            this.txtUpper.setPrecision(precision);
            this.txtLower.setPrecision(precision);
        }
    }

    private void setUIState() {
        String oprtState = (String)this.getUIContext().get("oprtState");
        this.setOprtState(oprtState);
    }

    private void loadExtFields() {
        QCStandardItemExtendAttrCollection itemExtCol = this.currItemEntryInfo.getItemExtendAttr();
        if (null != itemExtCol && itemExtCol.size() > 0) {
            QCStandardItemExtendAttrInfo extInfo = itemExtCol.get(0);
            this.prmtDelQualityOrg.setValue((Object)extInfo.getDelegOrgUnit());
            this.prmtQCGroup.setValue((Object)extInfo.getQCGroup());
            this.prmtQCInstrumentGroup.setValue((Object)extInfo.getQCInstrumentGroup());
            this.prmtQCInstrument.setValue((Object)extInfo.getQCInstrument());
        }
    }

    private void loadDefaultValue() {
        if (this.contDefaultValue.isVisible()) {
            this.txtDefaultValue.setText(this.currItemEntryInfo.getDefaultValue());
        }
        if (this.contNumDefaultValue.isVisible()) {
            BigDecimal numValue = null;
            if (!QMStringUtils.isEmpty((String)this.currItemEntryInfo.getDefaultValue())) {
                try {
                    numValue = new BigDecimal(this.currItemEntryInfo.getDefaultValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.txtNumDefaultValue.setValue(numValue);
        }
        if (this.contEnumDefaultValue.isVisible()) {
            this.cmbDefaultValue.setSelectedItem((Object)this.currItemEntryInfo.getDefaultValue());
        }
    }

    private void storeExtFields() {
        QCStandardItemExtendAttrCollection itemExtCol = this.currItemEntryInfo.getItemExtendAttr();
        if (itemExtCol == null) {
            itemExtCol = new QCStandardItemExtendAttrCollection();
        }
        if (itemExtCol.size() <= 0) {
            itemExtCol.add(new QCStandardItemExtendAttrInfo());
        }
        QCStandardItemExtendAttrInfo extInfo = itemExtCol.get(0);
        extInfo.setDelegOrgUnit((QualityOrgUnitInfo)this.prmtDelQualityOrg.getValue());
        extInfo.setQCGroup((QCGroupInfo)this.prmtQCGroup.getValue());
        extInfo.setQCInstrumentGroup((QCInstrumentGroupInfo)this.prmtQCInstrumentGroup.getValue());
        extInfo.setQCInstrument((QCInstrumentInfo)this.prmtQCInstrument.getValue());
    }

    private void storeDefaultValue() {
        if (this.contDefaultValue.isVisible()) {
            this.currItemEntryInfo.setDefaultValue(this.txtDefaultValue.getText());
        }
        if (this.contNumDefaultValue.isVisible() && this.txtNumDefaultValue.getNumberValue() != null) {
            this.currItemEntryInfo.setDefaultValue(this.txtNumDefaultValue.getNumberValue().toString());
        }
        if (this.contEnumDefaultValue.isVisible() && this.cmbDefaultValue.getSelectedItem() != null) {
            this.currItemEntryInfo.setDefaultValue(this.cmbDefaultValue.getSelectedItem().toString());
        }
    }

    private void checkExtUpdate() {
        Component[] enableComps = new Component[]{this.prmtDelQualityOrg, this.prmtQCGroup, this.prmtQCInstrument, this.prmtQCInstrumentGroup};
        Component[] disableComps = new Component[]{this.prmtQCItem, this.cmbQCValueAcqMode, this.txtCheckStep, this.chkIsCancel, this.cmbJudgeType, this.txtDefaultValue, this.txtNumDefaultValue, this.cmbLowerLimit, this.cmbUpperLimit, this.txtLower, this.txtUpper, this.prmtModifyMode, this.txtDataPrecision, this.cmbMergeMode, this.prmtQCFrequency, this.prmtQCMethod, this.chkIsMustCheck, this.chkIsKeyItem, this.chkIsVisibleForQCC, this.txtStandardRequirement, this.txtRemark, this.cmbDefaultValue, this.cmbQCItemType};
        if (!this.isCreateQualityOrg() && OprtState.EDIT.equals(this.oprtState)) {
            QMUtils.setComponentEnable((Component[])enableComps, (boolean)true);
            QMUtils.setComponentEnable((Component[])disableComps, (boolean)false);
        }
    }

    protected void initScrollButtons() {
        ItemAction[] preActions = new ItemAction[]{this.actionPre, this.actionFirst};
        ItemAction[] nextActions = new ItemAction[]{this.actionNext, this.actionLast};
        if (this.itemEntrysSize == 0) {
            this.setItemActionEnable(preActions, false);
            this.setItemActionEnable(nextActions, false);
            return;
        }
        if (this.itemEntrysSize == 1) {
            if ("ADDNEW".equals(this.getOprtState())) {
                this.setItemActionEnable(preActions, true);
                this.setItemActionEnable(nextActions, false);
            } else {
                this.setItemActionEnable(preActions, false);
                this.setItemActionEnable(nextActions, false);
            }
            return;
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setItemActionEnable(preActions, true);
            this.setItemActionEnable(nextActions, false);
        } else if (this.currIndex == 0) {
            this.setItemActionEnable(preActions, false);
            this.setItemActionEnable(nextActions, true);
        } else if (this.currIndex == this.itemEntrysSize - 1) {
            this.setItemActionEnable(preActions, true);
            this.setItemActionEnable(nextActions, false);
        } else {
            this.setItemActionEnable(preActions, true);
            this.setItemActionEnable(nextActions, true);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.beforeScrollAction();
        --this.currIndex;
        this.afterScrollAction(this.currIndex);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.beforeScrollAction();
        this.currIndex = 0;
        this.afterScrollAction(this.currIndex);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.beforeScrollAction();
        ++this.currIndex;
        this.afterScrollAction(this.currIndex);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.beforeScrollAction();
        this.currIndex = this.itemEntrysSize - 1;
        this.afterScrollAction(this.currIndex);
    }

    private void beforeScrollAction() {
        this.storeFields();
        this.itemEntryList.remove(this.currItemEntryInfo);
        this.itemEntryList.addObject(this.currIndex, (IObjectValue)this.editData);
    }

    private void afterScrollAction(int index) {
        this.currItemEntryInfo = this.itemEntryList.get(index);
        if ("VIEW".equals(this.oprtState)) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.currItemEntryInfo);
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.initScrollButtons();
    }

    private void regF7EntityView() {
        String orgUnitId = this.qcStdInfo.getQualityOrgUnit().getId().toString();
        this.setQCItemFilter(orgUnitId);
        this.setQCItemF7Sic();
        this.setInstrumentGrpFilter();
        this.prmtQCFrequency.setEntityViewInfo(F7BDRegUtils.getAuditedEntityView());
        this.prmtQCMethod.setEntityViewInfo(F7BDRegUtils.getAuditedEntityView());
        this.prmtModifyMode.setEntityViewInfo(F7BDRegUtils.getAuditedEntityView());
        this.setInstrumentSic();
        this.setDelQualityOrgFilter();
        this.setQCGroupFilter();
        this.doQCInstrumentFilter(null);
    }

    private void setQCItemFilter(String orgUnitId) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        BOSObjectType bosType = new QCItemInfo().getBOSType();
        filter.getFilterItems().add(QMDataBaseFilterUtils.getQMDBAssignFilter("id", orgUnitId, bosType));
        Integer auditValue = new Integer(2);
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)auditValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
        ev.setFilter(filter);
        this.prmtQCItem.setEntityViewInfo(ev);
    }

    private void setQCItemF7Sic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("group.*"));
        this.prmtQCItem.setSelectorCollection(sic);
    }

    private void setInstrumentGrpFilter() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.EQUALS));
        ev.setFilter(filter);
        this.prmtQCInstrumentGroup.setEntityViewInfo(ev);
    }

    private void setDelQualityOrgFilter() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo();
        filterItem = new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("isSealUp", (Object)Boolean.FALSE, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        ev.setFilter(filter);
        this.prmtDelQualityOrg.setEntityViewInfo(ev);
    }

    private void setQCGroupFilter() {
        QualityOrgUnitInfo orgUnit = (QualityOrgUnitInfo)this.prmtDelQualityOrg.getValue();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = QCStandardEditUIF7FilterHelper.getFilterWithQualityOrg(orgUnit, "qualityOrgUnit.id");
        ev.setFilter(filter);
        this.prmtQCGroup.setEntityViewInfo(ev);
    }

    private void setInstrumentSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("group.name"));
        sic.add(new SelectorItemInfo("group.number"));
        this.prmtQCInstrument.setSelectorCollection(sic);
    }

    private void qcItemDataChanged(DataChangeEvent e) throws EASBizException, BOSException {
        Object newValue;
        Object oldValue = e.getOldValue();
        if (QMEqualsUtils.equals((Object)oldValue, (Object)(newValue = e.getNewValue()))) {
            return;
        }
        QCItemInfo qcItem = (QCItemInfo)newValue;
        this.setDataStatusByQCItem(qcItem);
        this.setQCItemInfoToField(qcItem);
        this.setValueDataPrecision();
    }

    private void setQCItemInfoToField(QCItemInfo qcItem) throws EASBizException, BOSException {
        if (null == qcItem) {
            this.txtQCItemName.setText(null);
            this.txtDefaultValue.setText(null);
            this.prmtDelQualityOrg.setValue(null);
            this.prmtQCGroup.setValue(null);
            this.cmbValueType.setSelectedItem(null);
            this.txtDataPrecision.setText(null);
            this.chkIsVisibleForQCC.setSelected(false);
            this.cmbQCItemAttr.setSelectedItem(null);
            this.cmbQCValueAcqMode.setSelectedItem(null);
            this.cmbMergeMode.setSelectedItem(null);
            this.cmbMergeMode.setEnabled(true);
            return;
        }
        this.txtQCItemName.setText(qcItem.getName());
        this.currItemEntryInfo.setExpression(null);
        this.txtDefaultValue.setText(qcItem.getDefaultValue());
        this.cmbDefaultValue.setSelectedItem((Object)qcItem.getDefaultValue());
        String orgID = this.qcStdInfo.getQualityOrgUnit().getId().toString();
        Map map = QCItemFacadeFactory.getRemoteInstance().getDelegOrgUnitAndQCGroup(orgID, qcItem.getId().toString());
        this.prmtDelQualityOrg.setValue(map.get("ORG") != null ? map.get("ORG") : null);
        this.prmtQCGroup.setValue(map.get("GROUP") != null ? map.get("GROUP") : null);
        this.cmbValueType.setSelectedItem((Object)qcItem.getQCValueType());
        this.txtDataPrecision.setNumberValue((Number)new Integer(qcItem.getDataPrecision()));
        this.chkIsVisibleForQCC.setSelected(qcItem.isIsVisibleForQCC());
        this.cmbQCItemAttr.setSelectedItem((Object)qcItem.getQCItemAttr());
        this.cmbQCValueAcqMode.setSelectedItem((Object)qcItem.getQCValueAcquisitionMode());
        this.setDefaultMergeMode(qcItem);
    }

    private void setDefaultMergeMode(QCItemInfo qcItem) {
        if (null != qcItem && (QCValueTypeEnum.formula.equals((Object)qcItem.getQCValueType()) || QCValueTypeEnum.number.equals((Object)qcItem.getQCValueType()))) {
            this.cmbMergeMode.setSelectedItem((Object)MergeModeEnum.ARITHMETICMEAN);
        } else {
            this.cmbMergeMode.setSelectedItem(null);
        }
    }

    private void setDefaultAcqMode(QCItemInfo qcItem) {
        if (null != qcItem && QCValueTypeEnum.formula.equals((Object)qcItem.getQCValueType())) {
            this.cmbQCValueAcqMode.setSelectedItem((Object)QCValueAcquisitionModeEnum.BYQCITEM);
        }
    }

    private void qcInstrumentDataChanged(DataChangeEvent e) {
    }

    private void delOrgDataChanged(DataChangeEvent e) {
        Object newValue;
        Object oldValue = e.getOldValue();
        if (QMEqualsUtils.equals((Object)oldValue, (Object)(newValue = e.getNewValue()))) {
            return;
        }
        QualityOrgUnitInfo orgUnit = (QualityOrgUnitInfo)newValue;
        if (null == orgUnit) {
            this.prmtQCGroup.setValue(null);
        }
        this.setQCGroupFilter();
        this.doQCInstrumentFilter(null);
    }

    private void dataPrecisionChanged(DataChangeEvent e) {
        Object newValue;
        Object oldValue = e.getOldValue();
        if (QMEqualsUtils.equals((Object)oldValue, (Object)(newValue = e.getNewValue()))) {
            return;
        }
        this.setValueDataPrecision();
    }

    protected void txtDefaultValueDoubleClicked(MouseEvent e) {
        int clickCount = e.getClickCount();
        if (clickCount == 2 && e.getButton() == 1) {
            try {
                this.setupFormulaPrompt();
            }
            catch (Exception exp) {
                this.handUIException(exp);
            }
        }
    }

    protected void setupFormulaPrompt() throws Exception {
        String exp = this.currItemEntryInfo.getExpression();
        List allQCItems = this.getAllQCItems();
        List selectedQCItems = this.getSelectedQCItem(exp, allQCItems);
        this.formulaHelper.removeSelectedQCItemFromAllQCItemList(selectedQCItems, allQCItems);
        exp = this.formulaHelper.showQCItemSelectUI(selectedQCItems, allQCItems, exp);
        EntityObjectInfo entityObjectInfo = null;
        QMFormulaPromptSelector fs = new QMFormulaPromptSelector(null, entityObjectInfo, exp);
        fs.show();
        if (!fs.isCanceled()) {
            this.currItemEntryInfo.setExpression(fs.getData().toString());
        }
    }

    private List getAllQCItems() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.itemEntrysSize; ++i) {
            QCStandardItemEntryInfo entryInfo = this.itemEntryList.get(i);
            if (entryInfo.getQCItem() == null) continue;
            QCValueTypeEnum valueType = entryInfo.getQCItem().getQCValueType();
            QCItemAttributeEnum itemAttr = entryInfo.getQCItem().getQCItemAttr();
            if (!QCValueTypeEnum.number.equals((Object)valueType) || !QCItemAttributeEnum.checkItem.equals((Object)itemAttr) && !QCItemAttributeEnum.variableItem.equals((Object)itemAttr)) continue;
            ArrayList<Object> valueList = new ArrayList<Object>();
            valueList.add(entryInfo.getQCItem());
            valueList.add(entryInfo.getQCItem().getName());
            valueList.add((Object)entryInfo.getQCItem().getQCValueType());
            valueList.add(entryInfo.getDefaultValue());
            list.add(valueList);
        }
        return list;
    }

    private List getSelectedQCItem(String exp, List allQCItems) {
        ArrayList list = new ArrayList();
        if (QMStringUtils.isEmpty((String)exp) || allQCItems == null) {
            return list;
        }
        String[] selectedFormulaQCItemNumbers = QMFormulaUtils.parseQCItemNumber(exp);
        for (int i = 0; i < this.itemEntryList.size(); ++i) {
            QCStandardItemEntryInfo itemEntry = this.itemEntryList.get(i);
            QCItemInfo itemInfo = itemEntry.getQCItem();
            if (itemInfo == null) continue;
            for (int j = 0; j < selectedFormulaQCItemNumbers.length; ++j) {
                String selectedItemNumber = selectedFormulaQCItemNumbers[j];
                if (!this.formulaHelper.isQCItemNumberEquals(itemInfo.getNumber(), selectedItemNumber)) continue;
                ArrayList<Object> selectList = new ArrayList<Object>();
                selectList.add(itemInfo);
                selectList.add(itemInfo.getName());
                selectList.add((Object)itemInfo.getQCValueType());
                selectList.add(itemEntry.getDefaultValue());
                list.add(selectList);
            }
        }
        return list;
    }

    public void checkModified() throws Exception {
        this.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected IObjectValue createNewData() {
        QCStandardItemEntryInfo info = new QCStandardItemEntryInfo();
        info.setItemType(ItemTypeEnum.standard);
        QCStandardItemExtendAttrInfo extInfo = new QCStandardItemExtendAttrInfo();
        extInfo.setQualityOrgUnit((QualityOrgUnitInfo)this.getMainOrgInfo());
        info.getItemExtendAttr().add(extInfo);
        this.itemEntryList.add(info);
        ++this.itemEntrysSize;
        this.currIndex = this.itemEntryList.size() - 1;
        this.currItemEntryInfo = info;
        return info;
    }

    private void setItemActionEnable(ItemAction[] actions, boolean isEnable) {
        if (null == actions || actions.length <= 0) {
            return;
        }
        for (int i = 0; i < actions.length; ++i) {
            actions[i].setEnabled(isEnable);
        }
    }

    public boolean checkBeforeWindowClosing() {
        if (!OprtState.VIEW.equals(this.oprtState)) {
            this.storeFields();
        }
        this.getUIContext().put("qcStdItemEntryList", this.itemEntryList);
        return true;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Quality;
    }

    private boolean isCreateQualityOrg() {
        QualityOrgUnitInfo createOrg = this.qcStdInfo.getQualityOrgUnit();
        QualityOrgUnitInfo useOrg = (QualityOrgUnitInfo)this.getUIContext().get("uicxtMainOrg");
        return createOrg.getId().toString().equals(useOrg.getId().toString());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }
}

