/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.IQCItemFacade;
import com.kingdee.eas.qm.basedata.QCItemAttributeEnum;
import com.kingdee.eas.qm.basedata.QCItemFacadeFactory;
import com.kingdee.eas.qm.basedata.QCItemGroupInfo;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.client.EntrysDetailPanel;
import com.kingdee.eas.qm.basedata.client.QCItemGroupPanel;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JPanel;

public class QCItemDynamicGroupManager
implements Serializable {
    private static final long serialVersionUID = -6337442205524722850L;
    private JPanel entryPanel = null;
    private KDComboBox[] combos = null;
    private String[] colsNames = null;
    private QCItemGroupPanel groupPanel = null;
    private KDCheckBox chkIsNotShowFilterItem = null;
    private KDCheckBox chkIsShowAllItem = null;
    private KDTable kdtentrys = null;
    private String qcitemKeyName = "";
    private EntrysDetailPanel detailPanel = null;
    private String allItem = EASResource.getString((String)"com.kingdee.eas.qm.basedata.client.QCItemGroupPanelResource", (String)"All_Item");
    private Map itemGroupCache = new HashMap();

    private QCItemDynamicGroupManager(JPanel entryPanel, KDTable kdtentrys, String qcitemKeyName, String[] colsNames) {
        this.entryPanel = entryPanel;
        this.groupPanel = QCItemGroupPanel.createPanel();
        this.combos = this.groupPanel.getGroupCombos();
        this.chkIsNotShowFilterItem = this.groupPanel.getCheckBox();
        this.kdtentrys = kdtentrys;
        this.qcitemKeyName = qcitemKeyName;
        this.colsNames = colsNames;
        this.chkIsShowAllItem = this.groupPanel.getchkIsShowAllItemCheckBox();
        this.initGroupPanel();
    }

    public KDCheckBox getchkIsShowAllItemCheckBox() {
        return this.chkIsShowAllItem;
    }

    public static QCItemDynamicGroupManager getInstance(JPanel entryPanel, KDTable kdtentrys, String qcitemKeyName, String[] colsNames) {
        return new QCItemDynamicGroupManager(entryPanel, kdtentrys, qcitemKeyName, colsNames);
    }

    public void initGroupPanel() {
        this.entryPanel.add((Component)((Object)this.groupPanel), "North");
        KDComboBox[] combos = this.groupPanel.getGroupCombos();
        for (int i = 0; i < combos.length; ++i) {
            KDComboBox combo = combos[i];
            combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    QCItemDynamicGroupManager.this.modifyTableDisplay();
                }
            });
        }
        this.chkIsNotShowFilterItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QCItemDynamicGroupManager.this.modifyTableDisplay();
            }
        });
    }

    public void addEntrysPanelToGroupPanel(Action actionAddLine, Action actionInsertLine, Action actionRemoveLine) {
        this.addEntrysPanelToGroupPanel(actionAddLine, actionInsertLine, actionRemoveLine, null);
    }

    public void setBtnEnabled(boolean enabled) {
        this.detailPanel.getBtnAddnewLine().setEnabled(enabled);
        this.detailPanel.getBtnInsertLine().setEnabled(enabled);
        this.detailPanel.getBtnRemoveLines().setEnabled(enabled);
        this.detailPanel.getBtnCopyLine().setEnabled(enabled);
    }

    public void addEntrysPanelToGroupPanel(Action actionAddLine, Action actionInsertLine, Action actionRemoveLine, Action actionCopyLine) {
        this.detailPanel = new EntrysDetailPanel(actionAddLine, actionInsertLine, actionRemoveLine, actionCopyLine);
        this.groupPanel.add((Component)((Object)this.detailPanel), new KDLayout.Constraints(actionCopyLine != null ? 677 : 700, 1, actionCopyLine != null ? 289 : 266, 23, 9));
    }

    private void modifyTableDisplay() {
        int i;
        Object[] groups = new Object[this.combos.length];
        for (int i2 = 0; i2 < this.combos.length; ++i2) {
            groups[i2] = this.combos[i2].getSelectedItem();
        }
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        for (i = 0; i < groups.length; ++i) {
            if (groups[i] == null || this.allItem.equals(groups[i].toString())) continue;
            filterMap.put(this.colsNames[i], groups[i]);
        }
        for (i = 0; i < this.kdtentrys.getRowCount(); ++i) {
            IRow row = this.kdtentrys.getRow(i);
            this.modifyTableDisplay(filterMap, row);
        }
    }

    private void modifyTableDisplay(Map filterMap, IRow row) {
        Iterator it = filterMap.keySet().iterator();
        boolean isShow = true;
        if (this.chkIsNotShowFilterItem.isSelected()) {
            QCItemAttributeEnum qcitemAttr;
            QCItemInfo info = (QCItemInfo)row.getCell(this.qcitemKeyName).getValue();
            QCItemAttributeEnum qCItemAttributeEnum = qcitemAttr = info != null ? info.getQCItemAttr() : null;
            if (QCItemAttributeEnum.conditionItem == qcitemAttr) {
                isShow = false;
            }
        }
        while (it.hasNext() && isShow) {
            String key = it.next().toString();
            String obj = null;
            if (filterMap.get(key) != null) {
                obj = filterMap.get(key).toString();
            }
            if (row.getCell(key).getValue() != null) {
                String tempGroup = row.getCell(key).getValue().toString();
                if (tempGroup.equals(obj)) continue;
                isShow = false;
                continue;
            }
            isShow = false;
        }
        row.getStyleAttributes().setHided(!isShow);
    }

    public void fillQCItemGroup() throws Exception {
        IQCItemFacade iqcitem;
        Map groupInfoMap;
        int rowIndex;
        HashSet[] groupNames = new HashSet[this.combos.length];
        for (int i = 0; i < groupNames.length; ++i) {
            groupNames[i] = new HashSet();
        }
        HashMap<String, String[]> groupNumberMap = new HashMap<String, String[]>();
        for (rowIndex = 0; rowIndex < this.kdtentrys.getRowCount(); ++rowIndex) {
            int colIndex = this.kdtentrys.getColumnIndex(this.qcitemKeyName);
            QCItemInfo info = (QCItemInfo)this.kdtentrys.getCell(rowIndex, colIndex).getValue();
            if (info == null || info.getGroup() == null) continue;
            QCItemGroupInfo groupInfo = info.getGroup();
            String key = groupInfo.getId().toString();
            String longNumber = groupInfo.getLongNumber();
            if (longNumber == null) continue;
            String[] groupNumber = QCItemDynamicGroupManager.splitLongNumber(longNumber);
            if (this.itemGroupCache.containsKey(key)) continue;
            groupNumberMap.put(key, groupNumber);
        }
        if (groupNumberMap.size() > 0 && (groupInfoMap = (iqcitem = QCItemFacadeFactory.getRemoteInstance()).getQCItemGroupWithGroupNumber(groupNumberMap)) != null) {
            for (Map.Entry entry : groupInfoMap.entrySet()) {
                this.itemGroupCache.put(entry.getKey(), entry.getValue());
            }
        }
        for (rowIndex = 0; rowIndex < this.kdtentrys.getRowCount(); ++rowIndex) {
            this.fillQCItemGroup(groupNames, rowIndex);
        }
        this.setTableByGroupMaxSize();
        for (int i = 0; i < this.combos.length; ++i) {
            KDComboBox combo = this.combos[i];
            combo.removeAllItems();
            combo.addItem((Object)this.allItem);
            TreeSet tempSet = new TreeSet(groupNames[i]);
            Object[] objs = tempSet.toArray();
            combo.addItems(objs);
        }
    }

    private void fillQCItemGroup(HashSet[] groupNames, int rowIndex) throws BOSException, EASBizException {
        int i;
        QCItemGroupInfo[] groups;
        int colIndex = this.kdtentrys.getColumnIndex(this.qcitemKeyName);
        QCItemInfo info = (QCItemInfo)this.kdtentrys.getCell(rowIndex, colIndex).getValue();
        String key = null;
        if (info != null && info.getGroup() != null) {
            key = info.getGroup().getId().toString();
        }
        if ((groups = (QCItemGroupInfo[])this.itemGroupCache.get(key)) != null && groups.length > 0) {
            for (i = 0; i < this.combos.length; ++i) {
                if (i >= groups.length) {
                    this.kdtentrys.getCell(rowIndex, this.colsNames[i]).setValue(null);
                    continue;
                }
                this.kdtentrys.getCell(rowIndex, this.colsNames[i]).setValue((Object)groups[groups.length > 5 ? i + (groups.length - this.combos.length) : i]);
            }
        } else {
            for (i = 0; i < 5; ++i) {
                this.kdtentrys.getCell(rowIndex, this.colsNames[i]).setValue(null);
            }
        }
        IRow row = this.kdtentrys.getRow(rowIndex);
        for (int i2 = 0; i2 < groupNames.length; ++i2) {
            Object o = row.getCell(this.colsNames[i2]).getValue();
            if (o == null) continue;
            groupNames[i2].add(o.toString());
        }
    }

    private void setTableByGroupMaxSize() {
        int i;
        int maxSize = 0;
        for (i = 0; i < this.kdtentrys.getRowCount(); ++i) {
            String tempLongNumber;
            int currSize;
            IRow row = this.kdtentrys.getRow(i);
            QCItemInfo itemInfo = (QCItemInfo)row.getCell(this.qcitemKeyName).getValue();
            if (itemInfo == null || itemInfo.getGroup() == null || (currSize = (tempLongNumber = itemInfo.getGroup().getLongNumber()).split("!").length) <= maxSize) continue;
            maxSize = currSize;
        }
        if (maxSize > 5) {
            maxSize = 5;
        }
        for (i = 0; i < maxSize; ++i) {
            this.kdtentrys.getColumn(this.colsNames[i]).getStyleAttributes().setHided(false);
            this.combos[i].setVisible(true);
        }
        for (i = 0; i < this.combos.length - maxSize; ++i) {
            this.kdtentrys.getColumn(this.colsNames[i + maxSize]).getStyleAttributes().setHided(true);
            this.combos[i + maxSize].setVisible(false);
        }
    }

    public void unlockGroupPanel() {
        for (int i = 0; i < this.combos.length; ++i) {
            this.groupPanel.getParent().setEnabled(true);
            this.combos[i].setEnabled(true);
            this.combos[i].setAccessAuthority(0);
        }
        this.chkIsNotShowFilterItem.setEnabled(true);
        this.chkIsNotShowFilterItem.setAccessAuthority(0);
        this.chkIsShowAllItem.setEnabled(true);
        this.chkIsShowAllItem.setAccessAuthority(0);
    }

    public static String[] splitLongNumber(String longNumber) {
        if (QMStringUtils.isEmpty((String)longNumber)) {
            return new String[0];
        }
        String[] groupNumber = longNumber.split("!");
        int length = groupNumber.length;
        for (int i = 1; i < length; ++i) {
            groupNumber[i] = groupNumber[i - 1] + "!" + groupNumber[i];
        }
        return groupNumber;
    }
}

