/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client.util;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.qm.basedata.QCGroupInfo;
import com.kingdee.eas.qm.basedata.QCStandardFactory;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.client.util.QCStandardClientUtils;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMSelectorUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;

public class QCStandardEditUIHelper {
    public static final String resPath = "com.kingdee.eas.qm.basedata.QCStandardResource";
    public static final String KEY_OPRTSTATE = "oprtState";
    public static final String KEY_STANDARDINFO = "qcStdInfo";
    public static final String KEY_UICXTMAINORG = "uicxtMainOrg";
    public static final String KEY_STDITEMENTRYLIST = "qcStdItemEntryList";

    public static String getMsg(String key, Object[] objs) {
        String msg = EASResource.getString((String)resPath, (String)key);
        if (objs != null && objs.length > 0) {
            msg = MessageFormat.format(msg, objs);
        }
        return msg;
    }

    public static String getMsg(String resourcePath, String key, Object[] objs) {
        String msg = EASResource.getString((String)resourcePath, (String)key);
        if (objs != null && objs.length > 0) {
            msg = MessageFormat.format(msg, objs);
        }
        return msg;
    }

    public static MaterialGroupInfo getMaterialQMGroup(String materialID) throws Exception {
        return QCStandardFactory.getRemoteInstance().getMaterialQMGroup(materialID);
    }

    public static void setTablePaneShow(KDPanel[] tabs, KDTabbedPane bizPanel, ResourceBundleHelper resHelper) {
        int i;
        ArrayList<Component> cmpList = new ArrayList<Component>();
        for (int i2 = 0; i2 < bizPanel.getComponentCount(); ++i2) {
            Component cmpt = bizPanel.getComponent(i2);
            if (!(cmpt instanceof KDPanel)) continue;
            cmpList.add(cmpt);
        }
        ArrayList<KDPanel> tabsList = new ArrayList<KDPanel>();
        for (i = 0; i < tabs.length; ++i) {
            KDPanel tbl = tabs[i];
            tabsList.add(tbl);
            if (cmpList.contains(tbl)) continue;
            bizPanel.add((Component)tbl);
            bizPanel.add((Component)tbl, (Object)resHelper.getString("" + tbl.getName() + ".constraints"));
        }
        for (i = 0; i < cmpList.size(); ++i) {
            Component cmpt = (Component)cmpList.get(i);
            if (tabsList.contains(cmpt)) continue;
            bizPanel.remove(cmpt);
            KDPanel temp = (KDPanel)cmpt;
            for (int j = 0; j < temp.getComponentCount(); ++j) {
                Component tempCmpt = temp.getComponent(j);
                if (!(tempCmpt instanceof KDTable)) continue;
                ((KDTable)tempCmpt).removeRows();
            }
        }
    }

    public static String getKeyWithComputeStep(IRow row, boolean isByItemGroup, boolean isByQCGroupGroup, boolean isByQCOrgGroup) {
        StringBuffer key = new StringBuffer();
        if (isByItemGroup) {
            Object obj1 = row.getCell("group1").getValue();
            Object obj2 = row.getCell("group2").getValue();
            Object obj3 = row.getCell("group3").getValue();
            Object obj4 = row.getCell("group4").getValue();
            Object obj5 = row.getCell("group5").getValue();
            key.append("#" + (obj1 == null ? "NULL" : obj1.toString()));
            key.append("#" + (obj2 == null ? "NULL" : obj2.toString()));
            key.append("#" + (obj3 == null ? "NULL" : obj3.toString()));
            key.append("#" + (obj4 == null ? "NULL" : obj4.toString()));
            key.append("#" + (obj5 == null ? "NULL" : obj5.toString()));
        }
        if (isByQCGroupGroup) {
            QCGroupInfo groupInfo = (QCGroupInfo)row.getCell("qcGroup").getValue();
            if (groupInfo != null) {
                key.append("#" + groupInfo.getId().toString());
            } else {
                key.append("#NULL");
            }
        }
        if (isByQCOrgGroup) {
            QualityOrgUnitInfo orgInfo = (QualityOrgUnitInfo)row.getCell("delegateQualityOrg").getValue();
            if (orgInfo != null) {
                key.append("#" + orgInfo.getId().toString());
            } else {
                key.append("#NULL");
            }
        }
        return key.toString();
    }

    public static SelectorItemCollection getSelectorForQCstandard() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("billType.*"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String[])new String[]{"group", "qCCriterion", "billType.QCBOGroup", "qCModifyMode", "qualityOrgUnit", "lastUpdateUser", "creator", "auditor"});
        sic.add(new SelectorItemInfo("itemEntries.*"));
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String[])new String[]{"itemEntries.qCItem", "itemEntries.qCItem.group", "itemEntries.eachSampleUnit"}, (String[])new String[]{"*"});
        sic.add(new SelectorItemInfo("itemEntries.qCModifyMode.dataPrecision"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String[])new String[]{"itemEntries.unit", "itemEntries.qCFrequency", "itemEntries.qCMethod", "itemEntries.qCModifyMode"});
        sic.add(new SelectorItemInfo("materialEntries.*"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String[])new String[]{"materialEntries.material", "materialEntries.materialGroup"});
        sic.add(new SelectorItemInfo("technicsEntries.*"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String[])new String[]{"technicsEntries.WorkingProcedureGroup", "technicsEntries.material", "technicsEntries.technicsRoute", "technicsEntries.WorkingProcedure"});
        sic.add(new SelectorItemInfo("technicsEntries.Operation.*"));
        sic.add(new SelectorItemInfo("productLineEntries.*"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String[])new String[]{"productLineEntries.material", "productLineEntries.productLine", "productLineEntries.ProductLineWP"});
        sic.add(new SelectorItemInfo("bizObjectEntries.*"));
        QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String[])new String[]{"bizObjectEntries.qCBizObjectGroup", "bizObjectEntries.qCBizObject"});
        return sic;
    }

    public static void unlockTalbe(KDTable[] tabs) {
        for (int i = 0; i < tabs.length; ++i) {
            tabs[i].setAccessAuthority(0);
            tabs[i].getStyleAttributes().setLocked(false);
            tabs[i].setEditable(true);
        }
    }

    public static void lockHead(Component[] cmpts) {
        for (int i = 0; i < cmpts.length; ++i) {
            cmpts[i].setEnabled(false);
        }
    }

    public static void lockHeadCannotEdit(IKDTextComponent[] cmpts) {
        for (int i = 0; i < cmpts.length; ++i) {
            cmpts[i].setEditable(false);
            cmpts[i].setAccessAuthority(1);
        }
    }

    public static void lockHeadCanEdit(IKDTextComponent[] cmpts) {
        for (int i = 0; i < cmpts.length; ++i) {
            if (cmpts[i] instanceof KDTextField || cmpts[i] instanceof KDBizMultiLangBox) {
                cmpts[i].setEditable(true);
            }
            cmpts[i].setAccessAuthority(0);
        }
    }

    public static void unlockHead(Component[] cmpts) {
        for (int i = 0; i < cmpts.length; ++i) {
            cmpts[i].setEnabled(true);
        }
    }

    public static void controlItemInfoOnEntrys(KDTable kdtItemEntries, int rowIndex) {
        IRow row = kdtItemEntries.getRow(rowIndex);
        Object obj = row.getCell("isModify").getValue();
        boolean isModify = false;
        if (obj instanceof Boolean) {
            isModify = (Boolean)obj;
        }
        if (isModify) {
            row.getCell("qcModifyMode").getStyleAttributes().setLocked(false);
            row.getCell("qcModifyMode").getStyleAttributes().setBackground(QMConstant.Required_Color);
        } else {
            row.getCell("qcModifyMode").getStyleAttributes().setLocked(true);
            row.getCell("qcModifyMode").getStyleAttributes().setBackground(QMConstant.UnRequired_Color);
            row.getCell("qcModifyMode").setValue(null);
        }
        obj = row.getCell("analysisMethod").getValue();
        Object valueType = row.getCell("qcValueType").getValue();
        if (QCValueTypeEnum.number == valueType || QCValueTypeEnum.formula == valueType) {
            row.getCell("upper").getStyleAttributes().setLocked(false);
            row.getCell("upperLimit").getStyleAttributes().setLocked(false);
            row.getCell("lower").getStyleAttributes().setLocked(false);
            row.getCell("lowerLimit").getStyleAttributes().setLocked(false);
            row.getCell("judgeType").getStyleAttributes().setLocked(false);
        } else {
            row.getCell("upper").getStyleAttributes().setLocked(true);
            row.getCell("upperLimit").getStyleAttributes().setLocked(true);
            row.getCell("lower").getStyleAttributes().setLocked(true);
            row.getCell("lowerLimit").getStyleAttributes().setLocked(true);
            row.getCell("judgeType").getStyleAttributes().setLocked(true);
            row.getCell("judgeType").getStyleAttributes().setBackground(QMConstant.UnRequired_Color);
        }
        if (QCValueTypeEnum.text != row.getCell("qcValueType").getValue() && QCValueTypeEnum.enumvalue != row.getCell("qcValueType").getValue()) {
            row.getCell("unit").getStyleAttributes().setBackground(QMConstant.Required_Color);
            row.getCell("unit").getStyleAttributes().setLocked(false);
        } else {
            row.getCell("unit").getStyleAttributes().setBackground(QMConstant.UnRequired_Color);
            row.getCell("unit").getStyleAttributes().setLocked(false);
        }
        if (QCValueTypeEnum.text != row.getCell("qcValueType").getValue() && QCValueTypeEnum.enumvalue != row.getCell("qcValueType").getValue()) {
            row.getCell("dataPrecision").getStyleAttributes().setLocked(false);
        } else {
            row.getCell("dataPrecision").getStyleAttributes().setLocked(true);
            row.getCell("dataPrecision").setValue((Object)new Integer(0));
        }
        ArrayList<String> notUsedList = new ArrayList<String>();
        notUsedList.add("qcDefaultValue");
        int precision = 4;
        ICell cell = row.getCell("dataPrecision");
        if (cell != null && cell.getValue() != null) {
            Integer it = (Integer)cell.getValue();
            precision = it;
        }
        QCStandardClientUtils.setCheckValueAndDefaultValueByValueType(kdtItemEntries, rowIndex, "qcValueType", "enums", new String[]{"qcDefaultValue"}, notUsedList, precision);
        if (valueType != null && QCValueTypeEnum.formula.equals(valueType)) {
            row.getCell("qcDefaultValue").getStyleAttributes().setLocked(true);
        } else {
            row.getCell("qcDefaultValue").getStyleAttributes().setLocked(false);
        }
        ICell cellMergeMode = row.getCell("mergeMode");
        if (QCValueTypeEnum.number.equals(valueType) || QCValueTypeEnum.formula.equals(valueType)) {
            cellMergeMode.getStyleAttributes().setLocked(false);
        } else if (QCValueTypeEnum.enumvalue.equals(valueType) || QCValueTypeEnum.text.equals(valueType)) {
            cellMergeMode.getStyleAttributes().setLocked(true);
        }
        kdtItemEntries.getColumn("qCValueAcquisitionMode").getStyleAttributes().setLocked(true);
    }
}

