/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.JudgeTypeEnum;
import com.kingdee.eas.qm.basedata.MergeModeEnum;
import com.kingdee.eas.qm.basedata.QCAnalysisMethodEnum;
import com.kingdee.eas.qm.basedata.QCBizBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCItemAttributeEnum;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCStrategyEnum;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.SampleSolutionEnum;
import com.kingdee.eas.qm.basedata.client.QCStandardEditUI;
import com.kingdee.eas.qm.basedata.client.util.QCStandardEditUIHelper;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;

public class QCStandardVerifyItem
extends AbstractVerifyItem {
    private static final String resourceDir = "com.kingdee.eas.qm.basedata.BASEDATAAutoGenerateResource";
    private QCStandardEditUI _ui = null;
    private boolean isAudit = false;
    private Map params = null;

    public QCStandardVerifyItem(QCStandardEditUI _ui, boolean isAudit, Map params) {
        this._ui = _ui;
        this.isAudit = isAudit;
        this.params = params;
    }

    public boolean verify() throws EASBizException, BOSException {
        this.headVerify();
        this.qcStandardItemEntryVerify();
        KDTable itemTable = this._ui.getItemEntryTable();
        KDComboBox combox = (KDComboBox)this._ui.getComponentByName("comboQCStrategy");
        if (combox.getSelectedItem() == QCStrategyEnum.oneStepCheck) {
            HashSet<String> orgIDSet = new HashSet<String>();
            for (int j = 0; j < itemTable.getRowCount(); ++j) {
                IRow innerRow = itemTable.getRow(j);
                QualityOrgUnitInfo innerOrgInfo = (QualityOrgUnitInfo)innerRow.getCell("delegateQualityOrg").getValue();
                String innerOrgID = innerOrgInfo.getId().toString();
                orgIDSet.add(innerOrgID);
            }
            QualityOrgUnitInfo mainOrgInfo = (QualityOrgUnitInfo)this._ui.getMainOrgInfo();
            if (orgIDSet.size() > 1 || mainOrgInfo.isIsBizUnit() && !orgIDSet.contains(mainOrgInfo.getId().toString())) {
                MsgBox.showInfo((Component)((Object)this._ui), (String)QCStandardEditUIHelper.getMsg("OneStepCheck_OrgSame", null));
                SysUtil.abort();
            }
        }
        this.materialEntryVerify();
        this.technicsEntriesVerify();
        this.productLineEntriesVerify();
        this.bizObjectEntriesVerify();
        return true;
    }

    protected void headVerify() throws EASBizException, BOSException {
        KDFormattedTextField txtEachSampleQty;
        BigDecimal eq;
        KDComboBox combo = (KDComboBox)this.params.get("FA");
        KDComboBox stategy = (KDComboBox)this.params.get("CL");
        if (combo.getSelectedItem() == SampleSolutionEnum.takeOutCheck && stategy.getSelectedItem() == QCStrategyEnum.twoStepCheck) {
            MsgBox.showInfo((String)QCStandardEditUIHelper.getMsg("SampleSolutionSaveError", null));
            SysUtil.abort();
        }
        KDBizPromptBox prmt = (KDBizPromptBox)this.params.get("bizBillType");
        QCBizBillTypeInfo bizTypeInfo = (QCBizBillTypeInfo)prmt.getData();
        if (stategy.getSelectedItem() != QCStrategyEnum.oneStepCheck && bizTypeInfo.getQCBizType() == QCBizTypeEnum.otherCheck) {
            MsgBox.showInfo((String)QCStandardEditUIHelper.getMsg("OtherCheck", null));
            SysUtil.abort();
        }
        BigDecimal bigDecimal = eq = (txtEachSampleQty = (KDFormattedTextField)this.params.get("EQ")).getBigDecimalValue() == null ? new BigDecimal("0") : txtEachSampleQty.getBigDecimalValue();
        if (eq.compareTo(new BigDecimal("0")) == -1) {
            MsgBox.showInfo((String)QCStandardEditUIHelper.getMsg("EachSampleQtyVerify", null));
            txtEachSampleQty.requestFocus();
            SysUtil.abort();
        }
        KDBizPromptBox sampleUnit = (KDBizPromptBox)this.params.get("EU");
        if (eq.compareTo(new BigDecimal("0")) == 1 && sampleUnit.getData() == null) {
            MsgBox.showInfo((String)QCStandardEditUIHelper.getMsg("EachSampleUnitVerify", null));
            sampleUnit.requestFocus();
            SysUtil.abort();
        }
    }

    protected void qcStandardItemEntryVerify() throws EASBizException, BOSException {
        KDTable itemTable = this._ui.getItemEntryTable();
        KDTEditManager editManager = itemTable.getEditManager();
        if (itemTable.getRowCount() == 0) {
            String msg = QCStandardEditUIHelper.getMsg("ItemEntry_Empty", null);
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        for (int i = 0; i < itemTable.getRowCount(); ++i) {
            String msg23;
            MessageFormat mf;
            QCValueTypeEnum valueType;
            QCValueTypeEnum valueType2;
            Object obj;
            BigDecimal tempO;
            int dp;
            int colIndex;
            int colIndex2;
            IRow row = itemTable.getRow(i);
            String msg = "";
            if (KDTableUtils.isRowBlank((IRow)row, (String)"qcItemNumber")) {
                colIndex2 = itemTable.getColumnIndex("qcItemNumber");
                this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                editManager.editCellAt(i, colIndex2);
                msg = QCStandardEditUIHelper.getMsg("ItemEntry_QCItem_Empty", new String[]{String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (itemTable.getColumn("checkStep").isRequired() && KDTableUtils.isRowBlank((IRow)row, (String)"checkStep")) {
                colIndex2 = itemTable.getColumnIndex("checkStep");
                this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                editManager.editCellAt(i, colIndex2);
                msg = QCStandardEditUIHelper.getMsg("ItemEntry_CheckStep_Empty", new String[]{String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (QCValueTypeEnum.text != row.getCell("qcValueType").getValue() && QCValueTypeEnum.enumvalue != row.getCell("qcValueType").getValue() && KDTableUtils.isRowBlank((IRow)row, (String)"unit")) {
                colIndex2 = itemTable.getColumnIndex("unit");
                this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                editManager.editCellAt(i, colIndex2);
                msg = QCStandardEditUIHelper.getMsg("ItemEntry_Unit_Empty", new String[]{String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (QCAnalysisMethodEnum.quantitativeAnalysis.equals(row.getCell("analysisMethod").getValue()) && QCItemAttributeEnum.checkItem.equals(row.getCell("qcItemAttr").getValue()) && (KDTableUtils.isRowBlank((IRow)row, (String)"judgeType") || JudgeTypeEnum.NULL == row.getCell("judgeType").getValue())) {
                colIndex2 = itemTable.getColumnIndex("judgeType");
                this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                editManager.editCellAt(i, colIndex2);
                msg = QCStandardEditUIHelper.getMsg("ItemEntry_Judge_Empty", new String[]{String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if ((KDTableUtils.isRowBlank((IRow)row, (String)"lowerLimit") || row.getCell("lowerLimit").getValue() == QCLowerLimitEnum.isNull) && !KDTableUtils.isRowBlank((IRow)row, (String)"lower") || !KDTableUtils.isRowBlank((IRow)row, (String)"lowerLimit") && row.getCell("lowerLimit").getValue() != QCLowerLimitEnum.isNull && KDTableUtils.isRowBlank((IRow)row, (String)"lower")) {
                colIndex2 = itemTable.getColumnIndex("lowerLimit");
                this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                editManager.editCellAt(i, colIndex2);
                msg = QCStandardEditUIHelper.getMsg("ItemEntry_LowerLimit_Empty", new String[]{String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if ((KDTableUtils.isRowBlank((IRow)row, (String)"upperLimit") || row.getCell("upperLimit").getValue() == QCUpperLimitEnum.isNull) && !KDTableUtils.isRowBlank((IRow)row, (String)"upper") || !KDTableUtils.isRowBlank((IRow)row, (String)"upperLimit") && row.getCell("upperLimit").getValue() != QCUpperLimitEnum.isNull && KDTableUtils.isRowBlank((IRow)row, (String)"upper")) {
                colIndex2 = itemTable.getColumnIndex("upperLimit");
                this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                editManager.editCellAt(i, colIndex2);
                msg = QCStandardEditUIHelper.getMsg("ItemEntry_UpperLimit_Empty", new String[]{String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (!KDTableUtils.isRowBlank((IRow)row, (String)"judgeType") && row.getCell("judgeType").getValue() != JudgeTypeEnum.NULL && KDTableUtils.isRowBlank((IRow)row, (String)"lower") && KDTableUtils.isRowBlank((IRow)row, (String)"upper")) {
                colIndex2 = itemTable.getColumnIndex("judgeType");
                this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                editManager.editCellAt(i, colIndex2);
                msg = QCStandardEditUIHelper.getMsg("ItemEntry_JudgeTypeNotNULL", new String[]{String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            } else if (!(KDTableUtils.isRowBlank((IRow)row, (String)"judgeType") || row.getCell("judgeType").getValue() != JudgeTypeEnum.NULL || KDTableUtils.isRowBlank((IRow)row, (String)"lower") && KDTableUtils.isRowBlank((IRow)row, (String)"upper"))) {
                colIndex2 = itemTable.getColumnIndex("judgeType");
                this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                editManager.editCellAt(i, colIndex2);
                msg = QCStandardEditUIHelper.getMsg("ItemEntry_JudgeTypeNULL", new String[]{String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (this.isAudit) {
                if (KDTableUtils.isRowBlank((IRow)row, (String)"delegateQualityOrg")) {
                    colIndex2 = itemTable.getColumnIndex("delegateQualityOrg");
                    this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                    editManager.editCellAt(i, colIndex2);
                    msg = QCStandardEditUIHelper.getMsg("ItemEntry_DelegateQualityOrg_Empty", new String[]{String.valueOf(i + 1)});
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                } else {
                    QualityOrgUnitInfo oouInfo = (QualityOrgUnitInfo)row.getCell("delegateQualityOrg").getValue();
                    oouInfo = QualityOrgUnitFactory.getRemoteInstance().getQualityOrgUnitInfo((IObjectPK)new ObjectUuidPK(oouInfo.getId()));
                    if (!oouInfo.isIsBizUnit()) {
                        colIndex = itemTable.getColumnIndex("delegateQualityOrg");
                        this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                        editManager.editCellAt(i, colIndex);
                        msg = QCStandardEditUIHelper.getMsg(resourceDir, "17_QCStandardVerifyItem", new String[]{String.valueOf(i + 1)});
                        MsgBox.showInfo((String)msg);
                        SysUtil.abort();
                    }
                }
            }
            Object o = row.getCell("dataPrecision").getValue();
            boolean isError = false;
            if (o != null && ((dp = (tempO = new BigDecimal(o.toString())).intValue()) < -8 || dp > 8)) {
                isError = true;
            }
            if (!row.getCell("dataPrecision").getStyleAttributes().isLocked() && isError) {
                int colIndex3 = itemTable.getColumnIndex("dataPrecision");
                this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                editManager.editCellAt(i, colIndex3);
                msg = QCStandardEditUIHelper.getMsg("ItemEntry_DP_Empty", new String[]{String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if ((obj = row.getCell("isModify").getValue()) instanceof Boolean && ((Boolean)obj).booleanValue() && KDTableUtils.isRowBlank((IRow)row, (String)"qcModifyMode")) {
                colIndex = itemTable.getColumnIndex("qcModifyMode");
                this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                editManager.editCellAt(i, colIndex);
                msg = QCStandardEditUIHelper.getMsg("ItemEntry_Modify_Empty", new String[]{String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            QCItemInfo itemInfo = (QCItemInfo)row.getCell("qcItemNumber").getValue();
            String itemID = itemInfo.getId().toString();
            for (int j = 0; j < itemTable.getRowCount(); ++j) {
                QCItemInfo innerItemInfo;
                String innerItemID;
                IRow innerRow = itemTable.getRow(j);
                if (j == i || innerRow.getCell("qcItemNumber").getValue() == null || !itemID.equals(innerItemID = (innerItemInfo = (QCItemInfo)innerRow.getCell("qcItemNumber").getValue()).getId().toString())) continue;
                this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                msg = QCStandardEditUIHelper.getMsg("ItemEntry_QCItem_Repeat", new String[]{String.valueOf(j + 1), String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            MergeModeEnum mergeMode = (MergeModeEnum)((Object)row.getCell("mergeMode").getValue());
            if ((mergeMode == null || MergeModeEnum.NULL.equals((Object)mergeMode)) && (valueType2 = (QCValueTypeEnum)((Object)row.getCell("qcValueType").getValue())) != null && (QCValueTypeEnum.formula.equals((Object)valueType2) || QCValueTypeEnum.number.equals((Object)valueType2))) {
                int colIndex4 = itemTable.getColumnIndex("mergeMode");
                this._ui.getTableBizPanel().setSelectedComponent((Component)itemTable.getParent());
                editManager.editCellAt(i, colIndex4);
                msg = QCStandardEditUIHelper.getMsg("MergeModeVerify", new String[]{String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            JudgeTypeEnum judgeType = (JudgeTypeEnum)((Object)row.getCell("judgeType").getValue());
            Object lowerLimit = row.getCell("lowerLimit").getValue();
            Object lower = row.getCell("lower").getValue();
            Object upperLimit = row.getCell("upperLimit").getValue();
            Object upper = row.getCell("upper").getValue();
            int colIndex5 = itemTable.getColumnIndex("judgeType");
            if (judgeType.equals((Object)JudgeTypeEnum.NULL) && lowerLimit.equals((Object)QCLowerLimitEnum.isNull) && lower == null && upperLimit.equals((Object)QCUpperLimitEnum.isNull) && upper == null) continue;
            if (judgeType.equals((Object)JudgeTypeEnum.NULL) && (lowerLimit.equals((Object)QCLowerLimitEnum.isNull) && lower == null || upperLimit.equals((Object)QCUpperLimitEnum.isNull) && upper == null)) {
                editManager.editCellAt(i, colIndex5);
                String msg19 = EASResource.getString((String)resourceDir, (String)"19_QCStandardVerifyItem");
                MessageFormat mf2 = new MessageFormat(msg19);
                MsgBox.showInfo((String)mf2.format(new String[]{String.valueOf(i + 1)}));
                SysUtil.abort();
                continue;
            }
            if (judgeType.equals((Object)JudgeTypeEnum.NULL) || (valueType = (QCValueTypeEnum)((Object)row.getCell("qcValueType").getValue())) == null || !QCValueTypeEnum.formula.equals((Object)valueType) && !QCValueTypeEnum.number.equals((Object)valueType)) continue;
            if (lowerLimit.equals((Object)QCLowerLimitEnum.isNull) && upperLimit.equals((Object)QCUpperLimitEnum.isNull)) {
                editManager.editCellAt(i, colIndex5);
                String msg20 = EASResource.getString((String)resourceDir, (String)"20_QCStandardVerifyItem");
                MessageFormat mf3 = new MessageFormat(msg20);
                MsgBox.showInfo((String)mf3.format(new String[]{String.valueOf(i + 1)}));
                SysUtil.abort();
                continue;
            }
            if (lowerLimit.equals((Object)QCLowerLimitEnum.isNull) || lower == null || upperLimit.equals((Object)QCUpperLimitEnum.isNull) || upper == null) continue;
            BigDecimal biglower = (BigDecimal)lower;
            BigDecimal bigupper = (BigDecimal)upper;
            if (lowerLimit.equals((Object)QCLowerLimitEnum.equal) && upperLimit.equals((Object)QCUpperLimitEnum.equal)) {
                if (bigupper.compareTo(biglower) != 0) {
                    String msg21 = EASResource.getString((String)resourceDir, (String)"21_QCStandardVerifyItem");
                    mf = new MessageFormat(msg21);
                    MsgBox.showInfo((String)mf.format(new String[]{String.valueOf(i + 1)}));
                    SysUtil.abort();
                }
            } else if (lowerLimit.equals((Object)QCLowerLimitEnum.equal) || upperLimit.equals((Object)QCUpperLimitEnum.equal)) {
                String msg22 = EASResource.getString((String)resourceDir, (String)"22_QCStandardVerifyItem");
                mf = new MessageFormat(msg22);
                MsgBox.showInfo((String)mf.format(new String[]{String.valueOf(i + 1)}));
                SysUtil.abort();
            }
            if (lowerLimit.equals((Object)QCLowerLimitEnum.greater) || upperLimit.equals((Object)QCUpperLimitEnum.less)) {
                if (bigupper.compareTo(biglower) > 0) continue;
                editManager.editCellAt(i, colIndex5);
                msg23 = EASResource.getString((String)resourceDir, (String)"23_QCStandardVerifyItem");
                mf = new MessageFormat(msg23);
                MsgBox.showInfo((String)mf.format(new String[]{String.valueOf(i + 1)}));
                SysUtil.abort();
                continue;
            }
            if (bigupper.compareTo(biglower) >= 0) continue;
            editManager.editCellAt(i, colIndex5);
            msg23 = EASResource.getString((String)resourceDir, (String)"23_QCStandardVerifyItem");
            mf = new MessageFormat(msg23);
            MsgBox.showInfo((String)mf.format(new String[]{String.valueOf(i + 1)}));
            SysUtil.abort();
        }
    }

    protected void materialEntryVerify() throws EASBizException, BOSException {
        KDTable materialTable = this._ui.getMaterialEntryTable();
        KDTEditManager editManager = materialTable.getEditManager();
        for (int i = 0; i < materialTable.getRowCount(); ++i) {
            MaterialInfo materialInfo;
            IRow row = materialTable.getRow(i);
            String msg = "";
            if (KDTableUtils.isRowBlank((IRow)row, (String)"MaterialNumber") && KDTableUtils.isRowBlank((IRow)row, (String)"MaterialGroup")) {
                int colIndex = materialTable.getColumnIndex("MaterialNumber");
                this._ui.getTableBizPanel().setSelectedComponent((Component)materialTable.getParent());
                editManager.editCellAt(i, colIndex);
                msg = QCStandardEditUIHelper.getMsg("MaterialEntry_GroupAndMaterial_Empty", new String[]{String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if ((materialInfo = (MaterialInfo)row.getCell("MaterialNumber").getValue()) == null) continue;
            String materialID = materialInfo.getId().toString();
            for (int j = 0; j < materialTable.getRowCount(); ++j) {
                MaterialInfo innerMaterialInfo;
                String innerMaterialID;
                IRow innerRow = materialTable.getRow(j);
                if (j == i || KDTableUtils.isRowBlank((IRow)innerRow, (String)"MaterialNumber") || !materialID.equals(innerMaterialID = (innerMaterialInfo = (MaterialInfo)innerRow.getCell("MaterialNumber").getValue()).getId().toString())) continue;
                this._ui.getTableBizPanel().setSelectedComponent((Component)materialTable.getParent());
                msg = QCStandardEditUIHelper.getMsg("MaterialEntry_Material_Repeat", new String[]{String.valueOf(j + 1), String.valueOf(i + 1)});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
        }
    }

    protected void technicsEntriesVerify() throws EASBizException, BOSException {
        KDTable technicsTable = this._ui.getTechnicsEntriesTable();
        KDTEditManager editManager = technicsTable.getEditManager();
        for (int i = 0; i < technicsTable.getRowCount(); ++i) {
            IRow row = technicsTable.getRow(i);
            String msg = "";
            if (row.getCell("material").getValue() != null || row.getCell("OperationGroup").getValue() != null || row.getCell("OperationName").getValue() != null) continue;
            int colIndex = technicsTable.getColumnIndex("material");
            this._ui.getTableBizPanel().setSelectedComponent((Component)technicsTable.getParent());
            editManager.editCellAt(i, colIndex);
            msg = QCStandardEditUIHelper.getMsg("com.kingdee.eas.qm.basedata.QCStandardResource", "TechnicsEntry_GroupAndOperationAndMaterial_Empty", new String[]{String.valueOf(i + 1)});
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    protected void productLineEntriesVerify() throws EASBizException, BOSException {
        KDTable productLineTable = this._ui.getProductLineEntriesTable();
        KDTEditManager editManager = productLineTable.getEditManager();
        for (int i = 0; i < productLineTable.getRowCount(); ++i) {
            IRow row = productLineTable.getRow(i);
            String msg = "";
            if (!KDTableUtils.isRowBlank((IRow)row, (String)"material")) continue;
            int colIndex = productLineTable.getColumnIndex("material");
            this._ui.getTableBizPanel().setSelectedComponent((Component)productLineTable.getParent());
            editManager.editCellAt(i, colIndex);
            msg = QCStandardEditUIHelper.getMsg("ProductLineEntry_Material", new String[]{String.valueOf(i + 1)});
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    protected void bizObjectEntriesVerify() throws EASBizException, BOSException {
        KDTable boTable = this._ui.getBizObjectEntriesTable();
        KDTEditManager editManager = boTable.getEditManager();
        for (int i = 0; i < boTable.getRowCount(); ++i) {
            IRow row = boTable.getRow(i);
            String msg = "";
            if (!KDTableUtils.isRowBlank((IRow)row, (String)"QCBizObjectGroup")) continue;
            int colIndex = boTable.getColumnIndex("QCBizObjectGroup");
            this._ui.getTableBizPanel().setSelectedComponent((Component)boTable.getParent());
            editManager.editCellAt(i, colIndex);
            msg = QCStandardEditUIHelper.getMsg("BOEntry_GroupEmpty", new String[]{String.valueOf(i + 1)});
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }
}

