/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.qm.basedata.SampleSolutionEnum;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.qc.CheckResultEnum;
import com.kingdee.eas.qm.qc.HQHPCalBillFactory;
import com.kingdee.eas.qm.qc.HQHPCalBillInfo;
import com.kingdee.eas.qm.qc.HQHPCalBillQcReportEntryInfo;
import com.kingdee.eas.qm.qc.IHQHPCalBill;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.client.AbstractHQHPCalBillAddQCReportUI;
import com.kingdee.eas.qm.qc.client.QCPurReportEditUI;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class HQHPCalBillAddQCReportUI
extends AbstractHQHPCalBillAddQCReportUI {
    private static final Logger logger = CoreUIObject.getLogger(HQHPCalBillAddQCReportUI.class);
    private static final String COL_selected = "isSelected";
    private static final String COL_calQuantity = "calQuantity";
    private static final String COL_calUnitPrice = "calUnitPrice";
    private static final String COL_calMoney = "calMoney";
    private static final String COL_deliverQty = "deliverQty";
    private static final String COL_passQty = "passQty";
    private static final String COL_unPassQty = "unPassQty";
    List canAddList = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.configTable();
        this.loadReports();
    }

    protected String getKeyFieldName() {
        return "reportID";
    }

    private void configTable() {
        this.tblMain.checkParsed();
        this.tblCannotAdd.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COL_selected).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(COL_selected).setRenderer((IBasicRender)new CellCheckBoxRenderer());
        this.btnSelectAll.setEnabled(true);
        this.btnSelectNone.setEnabled(true);
        this.btnConfirm.setEnabled(true);
        this.tblMain.getColumn(COL_calQuantity).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblMain.getColumn(COL_calUnitPrice).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblMain.getColumn(COL_calMoney).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblMain.getColumn(COL_deliverQty).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblMain.getColumn(COL_passQty).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblMain.getColumn(COL_unPassQty).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblCannotAdd.getColumn(COL_calQuantity).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblCannotAdd.getColumn(COL_calUnitPrice).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblCannotAdd.getColumn(COL_calMoney).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblCannotAdd.getColumn(COL_deliverQty).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblCannotAdd.getColumn(COL_passQty).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblCannotAdd.getColumn(COL_unPassQty).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
    }

    private void loadReports() throws Exception {
        Map params = (Map)this.getUIContext().get("Add_Paras");
        IHQHPCalBill ibiz = (IHQHPCalBill)this.getBizInterface();
        Map resultMap = ibiz.getReportsToAdd(params);
        this.canAddList = (List)resultMap.get("ADD_SelectResult_CanAddList");
        List canNotAddList = (List)resultMap.get("ADD_SelectResult_CanNotAddList");
        this.fillTableWithList(this.tblMain, this.canAddList);
        this.fillTableWithList(this.tblCannotAdd, canNotAddList);
    }

    private void fillTableWithList(KDTable table, List list) {
        table.removeRows();
        table.checkParsed();
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            IRow row = table.addRow();
            for (int j = 0; j < table.getColumnCount(); ++j) {
                String key = table.getColumnKey(j);
                if (map.get(key) == null) continue;
                if ("recBillBizDate".equals(key)) {
                    row.getCell(key).setValue((Object)CtrlFormatUtilities.getDateFormat().format((Date)map.get(key)));
                    continue;
                }
                if ("billStatus".equals(key)) {
                    row.getCell(key).setValue((Object)QMBillBaseStatusEnum.getEnum((int)HQHPUtil.getInt(map.get(key))));
                    continue;
                }
                if ("sampleSolution".equals(key)) {
                    row.getCell(key).setValue((Object)SampleSolutionEnum.getEnum((int)HQHPUtil.getInt(map.get(key))));
                    continue;
                }
                if ("checkResult".equals(key)) {
                    row.getCell(key).setValue((Object)CheckResultEnum.getEnum(HQHPUtil.getInt(map.get(key))));
                    continue;
                }
                if ("isCalBalPrice".equals(key) || "isSubmitBalPrice".equals(key) || "isMRB".equals(key) || "submitResult".equals(key)) {
                    row.getCell(key).setValue((Object)HQHPUtil.getBoolean(map.get(key)));
                    continue;
                }
                row.getCell(key).setValue(map.get(key));
            }
            if (row.getCell(COL_selected) == null) continue;
            row.getCell(COL_selected).setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        List selectedList = this.getSelectedList();
        if (selectedList.size() == 0) {
            MsgBox.showInfo((String)HQHPUtil.getMsg("Check_AddReportSelected"));
            SysUtil.abort();
        }
        if (MsgBox.showConfirm2((String)HQHPUtil.getMsg("Verify_WillSave")) != 0) {
            SysUtil.abort();
        }
        HQHPCalBillInfo info = (HQHPCalBillInfo)this.getUIContext().get("Add_Para_Info");
        LinkedHashSet<String> relReportIdSet = new LinkedHashSet<String>();
        LinkedHashSet<String> relCalBillIdSet = new LinkedHashSet<String>();
        for (int i = 0; i < selectedList.size(); ++i) {
            Map reportRow = (Map)selectedList.get(i);
            String reportID = (String)reportRow.get("reportID");
            String calBillID = (String)reportRow.get("calBillID");
            String recBillID = (String)reportRow.get("recBillID");
            String recBillEntryID = (String)reportRow.get("recEntryID");
            String requsetID = (String)reportRow.get("requestID");
            String recBillNumber = (String)reportRow.get("recBillNumber");
            BigDecimal conPriceRec = (BigDecimal)reportRow.get("conPriceRec");
            if (HQHPUtil.isNotNullString(calBillID)) {
                relReportIdSet.add(reportID);
                relCalBillIdSet.add(calBillID);
            }
            HQHPCalBillQcReportEntryInfo entry = new HQHPCalBillQcReportEntryInfo();
            entry.setParent(info);
            QCReportInfo report = new QCReportInfo();
            report.setId(BOSUuid.read((String)reportID));
            report.setRequestID(requsetID);
            entry.setQcPurReport(report);
            PurReceivalBillInfo recBill = new PurReceivalBillInfo();
            recBill.setId(BOSUuid.read((String)recBillID));
            recBill.setNumber(recBillNumber);
            entry.setRecBill(recBill);
            PurReceivalEntryInfo recBillEntry = new PurReceivalEntryInfo();
            recBillEntry.setId(BOSUuid.read((String)recBillEntryID));
            entry.setRecBillEntry(recBillEntry);
            entry.setConPriceRec(conPriceRec);
            info.getQcReportEntry().add(entry);
        }
        HQHPUtil.clearAdjustInfo(info);
        info.setIsCaled(false);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("Add_Confirm_Info", info);
        params.put("Add_Confirm_RelReportIdSet", relReportIdSet);
        params.put("Add_Confirm_RelCalBillIdSet", relCalBillIdSet);
        IHQHPCalBill ibiz = (IHQHPCalBill)this.getBizInterface();
        ibiz.addReportsToCalBill(params);
        MsgBox.showInfo((String)HQHPUtil.getMsg("Msg_AddReportOK"));
        Map ownerCtx = (Map)this.getUIContext().get("UICTX_OwnerCtx");
        ownerCtx.put("UICTX_AddReport_IsCancel", Boolean.FALSE);
        this.uiWindow.close();
    }

    private List getSelectedList() {
        ArrayList selectedList = new ArrayList();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean selected = (Boolean)row.getCell(COL_selected).getValue();
            if (!selected.booleanValue()) continue;
            selectedList.add(this.canAddList.get(i));
        }
        return selectedList;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.loadReports();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((String)HQHPUtil.getMsg("Confirm_MustSelectReport"));
            SysUtil.abort();
        }
        IRow selectedRow = this.getSelectedRow();
        String reportID = selectedRow.getCell("reportID").getValue().toString();
        this.showReport(reportID);
    }

    private void showReport(String reportID) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"ID", (Object)reportID);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QCPurReportEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            CoreUI editUI = (CoreUI)uiWindow.getUIObject();
            editUI.getUIMenuBar().setVisible(false);
            editUI.getUIToolBar().setVisible(false);
            uiWindow.show();
        }
        catch (UIException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, COL_selected).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionSelctNone_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, COL_selected).setValue((Object)Boolean.FALSE);
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return HQHPCalBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }
}

