/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.qm.qc.HQHPCalBillFactory;
import com.kingdee.eas.qm.qc.IHQHPCalBill;
import com.kingdee.eas.qm.qc.client.AbstractHQHPCalBillAdjustUI;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class HQHPCalBillAdjustUI
extends AbstractHQHPCalBillAdjustUI {
    private static final Logger logger = CoreUIObject.getLogger(HQHPCalBillAdjustUI.class);
    private DataChangeListener priceSAListener = null;
    private DataChangeListener quanSAListener = null;
    private DataChangeListener moneyAListener = null;
    private DataChangeListener priceIAListener = null;
    private boolean isModify = super.isModify();
    private int priceScale;
    private int qtyScale;

    public IObjectValue getDataObject() {
        return super.getDataObject();
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        return super.getValue(pk);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    @Override
    public void loadFields() {
        this.beforLoadFields();
        super.loadFields();
        this.afterLoadFields();
        try {
            this.initQtyScale();
            this.initPriceScale(this.editData.getPurOrgUnit().getId().toString());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.setPrecision();
    }

    private void initQtyScale() throws EASBizException, BOSException {
        this.qtyScale = 2;
        if (this.editData != null) {
            MultiMeasureUnitInfo multiUnitInfo;
            if (this.editData.getPurOrgUnit() == null) {
                return;
            }
            String paramValue = HQHPUtil.getQtyParamValue(null, "HQHP001", this.editData.getPurOrgUnit().getId().toString());
            if (!StringUtils.isEmpty((String)paramValue) && !"DEFAULT".equals(paramValue)) {
                this.qtyScale = Integer.parseInt(paramValue);
            } else if (this.editData.getPurContractEntry() != null && this.editData.getPurContractEntry().getUnit() != null && this.editData.getPurContractEntry().getMaterial() != null && (multiUnitInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(this.editData.getPurContractEntry().getMaterial().getId().toString(), this.editData.getPurContractEntry().getUnit().getId().toString())) != null) {
                this.qtyScale = multiUnitInfo.getQtyPrecision();
            }
        }
    }

    private void initPriceScale(String purOrgUnitId) throws EASBizException, BOSException {
        this.priceScale = 4;
        String paramValue = HQHPUtil.getPriceParamValue(null, "HQHP002", purOrgUnitId);
        if (!StringUtils.isEmpty((String)paramValue) && !"DEFAULT".equals(paramValue)) {
            this.priceScale = Integer.parseInt(paramValue);
        }
    }

    public void beforLoadFields() {
        this.editData.setAdjustDate(new Date());
        String userName = "";
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (userInfo != null) {
            PersonInfo person = userInfo.getPerson();
            userName = person != null ? person.getName() : userInfo.getName();
        }
        this.editData.setAdjustPerson(userName);
        super.beforLoadFields();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((String)HQHPUtil.getMsg("Verify_WillSave")) != 0) {
            SysUtil.abort();
        }
        this.storeFields();
        Map ownerCtx = (Map)this.getUIContext().get("UICTX_OwnerCtx");
        ownerCtx.put("UICTX_Adjust_IsReturn", Boolean.FALSE);
        ownerCtx.put("AdjustDataObject", this.editData);
        IHQHPCalBill ibiz = (IHQHPCalBill)this.getBizInterface();
        ibiz.saveAdjust(this.editData);
        this.isModify = false;
        this.uiWindow.close();
    }

    @Override
    public void actionCancelAdjust_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((String)HQHPUtil.getMsg("Verify_WillSave")) != 0) {
            SysUtil.abort();
        }
        Map ownerCtx = (Map)this.getUIContext().get("UICTX_OwnerCtx");
        ownerCtx.put("UICTX_Adjust_IsReturn", Boolean.FALSE);
        HQHPUtil.clearAdjustInfo(this.editData);
        ownerCtx.put("editData", this.editData);
        IHQHPCalBill ibiz = (IHQHPCalBill)this.getBizInterface();
        ibiz.saveAdjust(this.editData);
        this.isModify = false;
        this.uiWindow.close();
    }

    @Override
    public void actionReturn_actionPerformed(ActionEvent e) throws Exception {
        this.isModify = false;
        Map ownerCtx = (Map)this.getUIContext().get("UICTX_OwnerCtx");
        ownerCtx.put("UICTX_Adjust_IsReturn", Boolean.TRUE);
        this.uiWindow.close();
    }

    public boolean isModify() {
        return this.isModify;
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (state == null || "".equals(state)) {
            return null;
        }
        if (state.equals(OprtState.ADDNEW)) {
            return this.getAddNewPermItemName();
        }
        return this.getViewPermItemName();
    }

    public String getOprtState() {
        return super.getOprtState();
    }

    public void onLoad() throws Exception {
        this.removeListeners();
        super.onLoad();
        this.toolBar.setVisible(false);
        this.toolBar.setEnabled(false);
        this.btnConfirm.setEnabled(true);
        this.btnReturn.setEnabled(true);
        this.btnCancelAdjust.setEnabled(true);
        this.txtSettleUnitPriceSA.setEnabled(true);
        this.txtSettleQuanSA.setEnabled(true);
        this.txtSettleMoneySA.setEnabled(true);
        this.txtSettleUnitPriceIA.setEnabled(true);
        this.txtAdjustReason.setEnabled(true);
        this.txtAdjustReason.setMaxLength(80);
        this.addListeners();
    }

    private void setPrecision() {
        int i;
        KDFormattedTextField[] qtys = new KDFormattedTextField[]{this.txtSettleQuanSA, this.txtSettleQuanS, this.txtSettleQuanSDiff, this.txtSettleQuanI};
        KDFormattedTextField[] prices = new KDFormattedTextField[]{this.txtSettleUnitPriceSA, this.txtSettleUnitPriceS, this.txtSettleUnitPriceDiff, this.txtSettleUnitPriceIA, this.txtSettleUnitPriceI, this.txtSettleUnitPriceIDiff};
        KDFormattedTextField[] moneys = new KDFormattedTextField[]{this.txtSettleMoneySA, this.txtSettleMoneyS, this.txtSettleMoneySDiff};
        int size = qtys.length;
        for (i = 0; i < size; ++i) {
            qtys[i].setHorizontalAlignment(4);
            qtys[i].setRemoveingZeroInDispaly(false);
            qtys[i].setPrecision(this.qtyScale);
        }
        size = prices.length;
        for (i = 0; i < size; ++i) {
            prices[i].setHorizontalAlignment(4);
            prices[i].setRemoveingZeroInDispaly(false);
            prices[i].setPrecision(this.priceScale);
        }
        size = moneys.length;
        for (i = 0; i < size; ++i) {
            moneys[i].setHorizontalAlignment(4);
            moneys[i].setRemoveingZeroInDispaly(false);
            moneys[i].setPrecision(2);
        }
        this.txtSettleUnitPriceSA.setMinimumValue((Comparable)HQHPUtil.BigDecimal_Zero);
        this.txtSettleQuanSA.setMinimumValue((Comparable)HQHPUtil.BigDecimal_Zero);
        this.txtSettleMoneySA.setMinimumValue((Comparable)HQHPUtil.BigDecimal_Zero);
        this.txtSettleUnitPriceIA.setMinimumValue((Comparable)HQHPUtil.BigDecimal_Zero);
    }

    private void addListeners() {
        this.priceSAListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (HQHPCalBillAdjustUI.this.changeToNull(e)) {
                    Object oldValue = e.getOldValue();
                    if (oldValue == null) {
                        oldValue = HQHPUtil.BigDecimal_Zero;
                    }
                    HQHPCalBillAdjustUI.this.txtSettleUnitPriceSA.setValue(oldValue, false);
                }
                HQHPCalBillAdjustUI.this.priceSAChanged();
            }
        };
        this.quanSAListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (HQHPCalBillAdjustUI.this.changeToNull(e)) {
                    Object oldValue = e.getOldValue();
                    if (oldValue == null) {
                        oldValue = HQHPUtil.BigDecimal_Zero;
                    }
                    HQHPCalBillAdjustUI.this.txtSettleQuanSA.setValue(oldValue, false);
                }
                HQHPCalBillAdjustUI.this.quanSAChanged();
            }
        };
        this.moneyAListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (HQHPCalBillAdjustUI.this.changeToNull(e)) {
                    Object oldValue = e.getOldValue();
                    if (oldValue == null) {
                        oldValue = HQHPUtil.BigDecimal_Zero;
                    }
                    HQHPCalBillAdjustUI.this.txtSettleMoneySA.setValue(oldValue, false);
                }
                HQHPCalBillAdjustUI.this.moneyAChanged();
            }
        };
        this.priceIAListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (HQHPCalBillAdjustUI.this.changeToNull(e)) {
                    Object oldValue = e.getOldValue();
                    if (oldValue == null) {
                        oldValue = HQHPUtil.BigDecimal_Zero;
                    }
                    HQHPCalBillAdjustUI.this.txtSettleUnitPriceIA.setValue(oldValue, false);
                }
                HQHPCalBillAdjustUI.this.priceIAChanged();
            }
        };
        this.txtSettleUnitPriceSA.addDataChangeListener(this.priceSAListener);
        this.txtSettleQuanSA.addDataChangeListener(this.quanSAListener);
        this.txtSettleMoneySA.addDataChangeListener(this.moneyAListener);
        this.txtSettleUnitPriceIA.addDataChangeListener(this.priceIAListener);
    }

    private void removeListeners() {
        if (this.priceSAListener != null) {
            this.txtSettleUnitPriceSA.removeDataChangeListener(this.priceSAListener);
        }
        if (this.quanSAListener != null) {
            this.txtSettleQuanSA.addDataChangeListener(this.quanSAListener);
        }
        if (this.moneyAListener != null) {
            this.txtSettleMoneySA.addDataChangeListener(this.moneyAListener);
        }
        if (this.priceIAListener != null) {
            this.txtSettleUnitPriceIA.addDataChangeListener(this.priceIAListener);
        }
    }

    private boolean changeToNull(DataChangeEvent e) {
        return e.getNewValue() == null || HQHPUtil.isZero(new BigDecimal(e.getNewValue().toString()));
    }

    protected void priceSAChanged() {
        BigDecimal quanSA;
        BigDecimal priceSA = this.txtSettleUnitPriceSA.getBigDecimalValue();
        BigDecimal priceS = this.txtSettleUnitPriceS.getBigDecimalValue();
        if (priceS != null) {
            this.txtSettleUnitPriceDiff.setValue((Object)HQHPUtil.getPriceInScale(priceSA.subtract(priceS), this.priceScale));
        }
        if ((quanSA = this.txtSettleQuanSA.getBigDecimalValue()) == null) {
            return;
        }
        BigDecimal moneyA = HQHPUtil.multiply(priceSA, quanSA, 2);
        this.txtSettleMoneySA.setNumberValue((Number)moneyA, false);
        BigDecimal money = this.txtSettleMoneyS.getBigDecimalValue();
        if (money != null) {
            this.txtSettleMoneySDiff.setValue((Object)moneyA.subtract(money));
        }
        this.setPriceIA(moneyA);
    }

    protected void quanSAChanged() {
        BigDecimal priceSA;
        BigDecimal quanSA = this.txtSettleQuanSA.getBigDecimalValue();
        BigDecimal quanS = this.txtSettleQuanS.getBigDecimalValue();
        if (quanS != null) {
            this.txtSettleQuanSDiff.setValue((Object)quanSA.subtract(quanS));
        }
        if ((priceSA = this.txtSettleUnitPriceSA.getBigDecimalValue()) == null) {
            return;
        }
        BigDecimal moneyA = HQHPUtil.multiply(priceSA, quanSA, 2);
        this.txtSettleMoneySA.setNumberValue((Number)moneyA, false);
        BigDecimal money = this.txtSettleMoneyS.getBigDecimalValue();
        if (money != null) {
            this.txtSettleMoneySDiff.setValue((Object)moneyA.subtract(money));
        }
        this.setPriceIA(moneyA);
    }

    protected void moneyAChanged() {
        BigDecimal moneyA = this.txtSettleMoneySA.getBigDecimalValue();
        BigDecimal money = this.txtSettleMoneyS.getBigDecimalValue();
        if (money != null) {
            this.txtSettleMoneySDiff.setValue((Object)moneyA.subtract(money));
        }
        this.setPriceSA(moneyA);
        this.setPriceIA(moneyA);
    }

    private void setPriceIA(BigDecimal moneyA) {
        BigDecimal quanI = this.txtSettleQuanI.getBigDecimalValue();
        if (quanI == null || HQHPUtil.isZero(quanI)) {
            return;
        }
        BigDecimal priceIA = moneyA.divide(quanI, this.priceScale, 4);
        this.txtSettleUnitPriceIA.setNumberValue((Number)priceIA, false);
        BigDecimal priceI = this.txtSettleUnitPriceI.getBigDecimalValue();
        if (priceI != null) {
            this.txtSettleUnitPriceIDiff.setValue((Object)priceIA.subtract(priceI));
        }
    }

    protected void priceIAChanged() {
        BigDecimal quanI;
        BigDecimal priceIA = this.txtSettleUnitPriceIA.getBigDecimalValue();
        BigDecimal priceI = this.txtSettleUnitPriceI.getBigDecimalValue();
        if (priceI != null) {
            this.txtSettleUnitPriceIDiff.setValue((Object)HQHPUtil.getPriceInScale(priceIA.subtract(priceI), this.priceScale));
        }
        if ((quanI = this.txtSettleQuanI.getBigDecimalValue()) == null) {
            return;
        }
        BigDecimal moneyA = HQHPUtil.multiply(priceIA, quanI, 2);
        this.txtSettleMoneySA.setNumberValue((Number)moneyA, false);
        BigDecimal money = this.txtSettleMoneyS.getBigDecimalValue();
        if (money != null) {
            this.txtSettleMoneySDiff.setValue((Object)moneyA.subtract(money));
        }
        this.setPriceSA(moneyA);
    }

    private void setPriceSA(BigDecimal moneyA) {
        BigDecimal quanSA = this.txtSettleQuanSA.getBigDecimalValue();
        if (quanSA == null || HQHPUtil.isZero(quanSA)) {
            return;
        }
        BigDecimal priceSA = moneyA.divide(quanSA, this.priceScale, 4);
        this.txtSettleUnitPriceSA.setNumberValue((Number)priceSA, false);
        BigDecimal priceS = this.txtSettleUnitPriceS.getBigDecimalValue();
        if (priceS != null) {
            this.txtSettleUnitPriceDiff.setValue((Object)HQHPUtil.getPriceInScale(priceSA.subtract(priceS), this.priceScale));
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return HQHPCalBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    public KDTextField getNumTextField() {
        return null;
    }

    protected IObjectValue createNewDetailData(KDTable table, IRow srcrow) {
        return null;
    }

    protected IObjectValue newInstanceData() {
        return null;
    }
}

