/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.qm.common.filter.CompositeFilterElement;
import com.kingdee.eas.qm.common.filter.IFilterElement;
import com.kingdee.eas.qm.common.filter.IQueryFilterManager;
import com.kingdee.eas.qm.common.filter.RangeFilterElement;
import com.kingdee.eas.qm.common.filter.SingleFilterElement;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.qc.BalanceCalPatternEnum;
import com.kingdee.eas.qm.qc.client.AbstractHQHPCalBillCreateFilterUI;
import com.kingdee.eas.qm.qc.client.verify.HQHPCreateFilterNotNullVerifyItem;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HQHPCalBillCreateFilterUI
extends AbstractHQHPCalBillCreateFilterUI {
    private String selectedPurOrgUnitIDs = "";
    private Set purOrgCUIDs = null;
    public static final String PurContractDateBeginName = "pkPurConDateBegin";
    public static final String PurContractDateEndName = "pkPurConDateEnd";
    public static final String WeighDateBeginName = "pkWeighDateFrom";
    public static final String WeighDateEndName = "pkWeighDateTo";

    public String getViewPermItemName() {
        return "qm_HQHPCalBill_addnew";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.configUI();
        this.initValue();
    }

    private void configUI() {
        this.radioGroup.add((AbstractButton)this.radioIsWeigh);
        this.radioGroup.add((AbstractButton)this.radioIsNotWeigh);
    }

    protected void setDefaultValue() {
        this.initValue();
    }

    private void initValue() {
        this.radioIsWeigh.setSelected(true);
        Calendar c = Calendar.getInstance();
        this.pkPurConDateEnd.setValue((Object)c.getTime());
        c.add(1, -1);
        this.pkPurConDateBegin.setValue((Object)c.getTime());
        this.cmbCalPattern.setSelectedIndex(0);
        this.initWeighDate();
        this.initRecDate();
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        this.getFilterManager().getRootElement().getVerifyManager().addVerifyItem((IVerifyItem)new HQHPCreateFilterNotNullVerifyItem((CoreUIObject)this));
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        SingleFilterElement calPatternElement = new SingleFilterElement("calPattern", (Component)this.cmbCalPattern);
        rootElement.add((IFilterElement)calPatternElement);
        RangeFilterElement purConDateElement = new RangeFilterElement("purConDate", (Component)this.pkPurConDateBegin, (Component)this.pkPurConDateEnd);
        rootElement.add((IFilterElement)purConDateElement);
        RangeFilterElement recDateElement = new RangeFilterElement("recDate", (Component)this.pkRecBillDateFrom, (Component)this.pkRecBillDateEnd);
        rootElement.add((IFilterElement)recDateElement);
        SingleFilterElement supplierElement = new SingleFilterElement("supplier.id", (Component)this.prmtSupplier);
        rootElement.add((IFilterElement)supplierElement);
        SingleFilterElement purContractElement = new SingleFilterElement("purContract.id", (Component)this.prmtPurContract);
        rootElement.add((IFilterElement)purContractElement);
        SingleFilterElement materialElement = new SingleFilterElement("material.id", (Component)this.prmtMaterial);
        rootElement.add((IFilterElement)materialElement);
        rootElement.add((IFilterElement)new SingleFilterElement(WeighDateBeginName, (Component)this.pkWeighDateFrom){

            public FilterInfo getFilterInfo() {
                return null;
            }
        });
        rootElement.add((IFilterElement)new SingleFilterElement(WeighDateEndName, (Component)this.pkWeighDateTo){

            public FilterInfo getFilterInfo() {
                return null;
            }
        });
        rootElement.add((IFilterElement)new SingleFilterElement("radioIsWeigh", (Component)this.radioIsWeigh){

            public FilterInfo getFilterInfo() {
                return null;
            }
        });
        rootElement.add((IFilterElement)new SingleFilterElement("radioIsNotWeigh", (Component)this.radioIsNotWeigh){

            public FilterInfo getFilterInfo() {
                return null;
            }
        });
    }

    protected void initListener() {
        super.initListener();
        ActionListener calPatternListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HQHPCalBillCreateFilterUI.this.calPatternChanged(e);
            }
        };
        this.cmbCalPattern.addActionListener(calPatternListener);
        this.prmtPurOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                HQHPCalBillCreateFilterUI.this.purOrgChanged(eventObj);
            }
        });
        this.radioIsWeigh.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HQHPCalBillCreateFilterUI.this.isWeighChanged();
            }
        });
        this.radioIsNotWeigh.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HQHPCalBillCreateFilterUI.this.isWeighChanged();
            }
        });
    }

    protected void isWeighChanged() {
        this.initWeighDate();
        this.initRecDate();
    }

    private void initWeighDate() {
        if (this.radioIsWeigh.isSelected()) {
            this.initWeighDateWhenEnable();
        } else {
            this.pkWeighDateFrom.setValue(null);
            this.pkWeighDateTo.setValue(null);
            this.pkWeighDateFrom.setEnabled(false);
            this.pkWeighDateTo.setEnabled(false);
            this.pkWeighDateFrom.setRequired(false);
            this.pkWeighDateTo.setRequired(false);
        }
    }

    private void initRecDate() {
        if (this.isGenByAverage() && this.radioIsNotWeigh.isSelected()) {
            this.initRecDateWhenEnable();
        } else {
            this.setDisable(new KDDatePicker[]{this.pkRecBillDateFrom, this.pkRecBillDateEnd});
        }
    }

    private boolean isGenByAverage() {
        return 20 == ((BalanceCalPatternEnum)((Object)this.cmbCalPattern.getSelectedItem())).getValue();
    }

    private void initRecDateWhenEnable() {
        Calendar c = Calendar.getInstance();
        this.pkRecBillDateEnd.setValue((Object)c.getTime());
        c.add(2, -1);
        this.pkRecBillDateFrom.setValue((Object)c.getTime());
        this.pkRecBillDateFrom.setEnabled(true);
        this.pkRecBillDateEnd.setEnabled(true);
    }

    private void initWeighDateWhenEnable() {
        Calendar c = Calendar.getInstance();
        this.pkWeighDateFrom.setValue((Object)c.getTime());
        this.pkWeighDateTo.setValue((Object)c.getTime());
        this.pkWeighDateFrom.setEnabled(true);
        this.pkWeighDateTo.setEnabled(true);
        this.pkWeighDateFrom.setRequired(true);
        this.pkWeighDateTo.setRequired(true);
    }

    private void calPatternChanged(ActionEvent e) {
        this.initRecDate();
    }

    private void setDisable(KDDatePicker[] pickers) {
        for (int i = 0; i < pickers.length; ++i) {
            KDDatePicker datePicker = pickers[i];
            datePicker.setValue(null);
            datePicker.setEnabled(false);
        }
    }

    private void purOrgChanged(DataChangeEvent e) {
        Object[] newValue = (Object[])e.getNewValue();
        if (newValue == null || newValue.equals(e.getOldValue())) {
            return;
        }
        this.changeF7Filter(newValue);
    }

    private void changeF7Filter(Object[] org) {
        StringBuffer purOrgUnitIDs = new StringBuffer("(");
        HashSet<String> purOrgs = new HashSet<String>();
        this.purOrgCUIDs = new HashSet();
        for (int i = 0; i < org.length; ++i) {
            OrgUnitInfo o = (OrgUnitInfo)org[i];
            purOrgUnitIDs.append("'" + o.getId().toString() + "'");
            purOrgs.add(o.getId().toString());
            this.purOrgCUIDs.add(o.getCU().getId().toString());
            if (i == org.length - 1) continue;
            purOrgUnitIDs.append(",");
        }
        purOrgUnitIDs.append(")");
        this.selectedPurOrgUnitIDs = purOrgUnitIDs.toString();
        EntityViewInfo supplierEV = this.prmtSupplier.getEntityViewInfo();
        if (supplierEV == null) {
            supplierEV = new EntityViewInfo();
        }
        FilterInfo supplierFilter = new FilterInfo();
        supplierFilter.getFilterItems().add(new FilterItemInfo("purChaseOrgUnit.id", purOrgs, CompareType.INCLUDE));
        supplierEV.setFilter(supplierFilter);
        this.prmtSupplier.setEntityViewInfo(supplierEV);
        CtrlUnitInfo cu = (CtrlUnitInfo)this.getMainOrgContext().get((Object)OrgType.ControlUnit);
        this.prmtSupplier.setCurrentCtrlUnit(cu);
        this.setEntityView4Material();
        this.prmtMaterial.setCurrentCtrlUnit(cu);
        EntityViewInfo ev = this.prmtPurContract.getEntityViewInfo();
        if (ev == null) {
            ev = new EntityViewInfo();
        }
        FilterInfo purConFilter = new FilterInfo();
        HashSet<Integer> purConBillStatusExclude = new HashSet<Integer>();
        purConBillStatusExclude.add(new Integer(0));
        purConBillStatusExclude.add(new Integer(1));
        purConBillStatusExclude.add(new Integer(2));
        purConFilter.getFilterItems().add(new FilterItemInfo("baseStatus", purConBillStatusExclude, CompareType.NOTINCLUDE));
        purConFilter.getFilterItems().add(new FilterItemInfo("purOrgUnit.id", purOrgs, CompareType.INCLUDE));
        ev.setFilter(purConFilter);
        this.prmtPurContract.setEntityViewInfo(ev);
    }

    private void setEntityView4Material() {
        EntityViewInfo materialEV = new EntityViewInfo();
        FilterInfo materialFilter = new FilterInfo();
        if (this.purOrgCUIDs != null) {
            materialFilter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.purOrgCUIDs, CompareType.INCLUDE));
        }
        materialFilter.getFilterItems().add(new FilterItemInfo("isWeighted", (Object)new Boolean(this.radioIsWeigh.isSelected())));
        materialEV.setFilter(materialFilter);
        this.prmtMaterial.setEntityViewInfo(materialEV);
    }

    public boolean verify() {
        boolean v = super.verify();
        if (this.isGenByAverage() && this.radioIsNotWeigh.isSelected()) {
            Date recBillBeginDate = (Date)this.pkRecBillDateFrom.getValue();
            Date recBillEndDate = (Date)this.pkRecBillDateEnd.getValue();
            if (recBillBeginDate == null && recBillEndDate == null) {
                if (recBillBeginDate == null) {
                    this.pkRecBillDateFrom.requestFocus();
                }
                if (recBillEndDate == null) {
                    this.pkRecBillDateEnd.requestFocus();
                }
                MsgBox.showInfo((String)HQHPUtil.getMsg("Verify_RecDateMustInput"));
                SysUtil.abort();
            }
            if (recBillBeginDate != null && recBillEndDate != null && recBillBeginDate.after(recBillEndDate)) {
                this.pkRecBillDateFrom.requestFocus();
                MsgBox.showInfo((String)HQHPUtil.getMsg("Verify_RecBillDateError"));
                SysUtil.abort();
            }
        }
        Date purConBeginDate = (Date)this.pkPurConDateBegin.getValue();
        Date purConEndDate = (Date)this.pkPurConDateEnd.getValue();
        if (purConBeginDate != null && purConEndDate != null && purConBeginDate.after(purConEndDate)) {
            this.pkPurConDateBegin.requestFocus();
            MsgBox.showInfo((String)HQHPUtil.getMsg("Verify_PurContractDateError"));
            SysUtil.abort();
        }
        this.verifyWeighDate();
        return v;
    }

    private void verifyWeighDate() {
        Date weighDateFrom = (Date)this.pkWeighDateFrom.getValue();
        Date weighDateTo = (Date)this.pkWeighDateTo.getValue();
        if (weighDateFrom != null && weighDateTo != null && weighDateFrom.after(weighDateTo)) {
            this.pkWeighDateFrom.requestFocus();
            MsgBox.showInfo((String)HQHPUtil.getMsg("Verify_WeighDateError"));
            SysUtil.abort();
        }
    }

    public Map getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("purOrgID", this.selectedPurOrgUnitIDs);
        params.put("calPattern", new Integer(((BalanceCalPatternEnum)((Object)this.cmbCalPattern.getSelectedItem())).getValue()));
        params.put("recBillDateBegin", this.pkRecBillDateFrom.getValue());
        params.put("recBillDateEnd", this.pkRecBillDateEnd.getValue());
        params.put("purDateBegin", this.pkPurConDateBegin.getValue());
        params.put("purDateEnd", this.pkPurConDateEnd.getValue());
        if ((CoreBaseInfo)this.prmtSupplier.getValue() != null) {
            params.put("supplierID", ((CoreBaseInfo)this.prmtSupplier.getValue()).getId().toString());
        }
        if ((CoreBaseInfo)this.prmtPurContract.getValue() != null) {
            params.put("purContractID", ((CoreBaseInfo)this.prmtPurContract.getValue()).getId().toString());
        }
        if ((CoreBaseInfo)this.prmtMaterial.getValue() != null) {
            params.put("paraMaterialID", ((CoreBaseInfo)this.prmtMaterial.getValue()).getId().toString());
        }
        params.put("Para_IsWeigh", new Boolean(this.radioIsWeigh.isSelected()));
        params.put("Para_WeighDateBegin", this.pkWeighDateFrom.getValue());
        params.put("Para_WeighDateEnd", this.pkWeighDateTo.getValue());
        return params;
    }

    public OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    public KDBizPromptBox getMainBizOrg() {
        return this.prmtPurOrg;
    }

    public String getMainBizOrgField() {
        return "PurchaseOrgUnit.id";
    }
}

